/*******************************************************************************
 *
 * FILE:          gst_backend_player.h
 *
 * SW-COMPONENT:  Beep file player application
 *
 * DESCRIPTION:   Beep file player backend implementation with gstreamer
 *
 * AUTHOR:        pmh7kor
 *
 * COPYRIGHT:    (c) 2015 RBEI, Bangalore
 *
 *******************************************************************************/


#ifndef _GST_BACKEND_PLAYER_H_IF_INCLUDE_
#define _GST_BACKEND_PLAYER_H_IF_INCLUDE_
//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#define OSAL_S_IMPORT_INTERFACE_TYPES
//#include "osal_if.h"
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include <glib.h>
#include <gst/gst.h>
#include <pthread.h>

//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#include <stl_pif.h>



#include <string>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#include "beep_playback_backend_IF.h"
#include "../fc_audiomanager_trace_input.h"
#include "Beep_playback_status_IF.h"

class gst_backend_player : public beep_player_backend_IF
{
public:
  gst_backend_player(Beep_playback_status_IF* m_ptrController);
  virtual ~gst_backend_player();
  //tBool bPrepare(const char *p_filePath, const char *p_deviceName);
  tBool bPause();
  tBool bResume(); //check for static

  //Initialize player... once at startup
  virtual bool     bInitializePlayer();
  //Function to be used to play single files
  virtual bool    bPrepare(const char *p_filePath, const char *p_deviceName, bool bRepeat ,unsigned int recurrence);
  //Function to update file during an active playback. If not supported or error encountered, return error
  virtual bool     bUpdateActiveFile(const char* active_file);
  //Function to update recurrence during an acitve playback
  virtual bool     bUpdateRecurrence(int recurrence);
  //Tears down the current playback setup, frees resources
  virtual void     vTearDown();
  //Deinitialize player .. once at shutdown
  virtual bool     bDeinitPlayer();

  //-----------------------------PLAYBACK CONTROL FUNCTIONS---------------------
  //To start playing
  virtual bool     bPlay();
  //To stop playing
  virtual bool     bStop(beep_player_stop_mode eMode);

#if 0
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
#endif
    //static gboolean TimerCallback(gpointer data);
private:
  //Explicit privates
  gst_backend_player();
  gst_backend_player(const gst_backend_player&);

  /** Static functions for various callbacks **/
  //Thread entry function
  static tVoid* vThreadEntry(tVoid* pVarg);
  //Callback function for pad added handler
  static void pad_added_handler(GstElement *src, GstPad *new_pad, gpointer data);
  //Callback updates related to bus
  static gboolean bus_callback(GstBus *bus, GstMessage *msg, gpointer data);

     //Handler functions to process the bus callback message
  tVoid  vProcessBusCallBack(GstMessage *msg);
  tVoid  vHandleErrorMsg(GstMessage *msg);
  tVoid  vHandleWarningMsg(GstMessage *msg);
  tVoid  vHandleGstStateChanged(GstMessage *msg);

  //Helper function to process loopback message
  tVoid vTriggerPlayStsUpdate(tU8 sts);

  tBool bCheckFile_Device(const char *p_filePath, const char *p_deviceName);
    tBool createBus(GstElement* m_pipeline);


  tBool set_element_state(GstElement* m_pipeline,GstState gst_state);

  tU8 playStatus;
    GstState gst_state;
  GstElement* m_pipeline;
  GstElement* m_source;
  GstElement* m_decoder;
  GstElement* m_converter;
  GstElement* m_audiosink;
  GMainLoop* loop;
    GstBus* m_Bus;
  Beep_playback_status_IF* m_poController;

  pthread_t m_thread;
  tBool m_bLinkComplete;

  guint m_uiBusWatchId;//Required to remove g_source from mainloop
};
#endif //#define _GST_BACKEND_PLAYER_H_IF_INCLUDE_


