/*******************************************************************************
 *
 * FILE:          Beep_file_Player.cpp
 *
 * SW-COMPONENT:  Beep file player application
 *
 * DESCRIPTION:   Beep file player class implementation
 *
 * AUTHOR:        pmh7kor
 *
 * COPYRIGHT:    (c) 2015 RBEI, Bangalore
 *
 *******************************************************************************/


#ifndef _BEEP_FILE_PLAYER_
#define _BEEP_FILE_PLAYER_
//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#define OSAL_S_IMPORT_INTERFACE_TYPES
//#include "osal_if.h"
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include <alsa/asoundlib.h>
#include <sndfile.h>
#include "beep_player_alsahw.h"
#include "beep_file_reader.h"
#include <pthread.h>

//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>



#include <string>
#include <map>
#include <vector>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#include "../fc_audiomanager_trace_input.h"
#include "Beep_playback_status_IF.h"
#include "beep_playback_backend_IF.h"


class Beep_file_Player
{
public:
  //-----------------------------CTOR and DTORs------------------------------
  Beep_file_Player(Beep_playback_status_IF* m_ptrController);//Constructor
  virtual ~Beep_file_Player();//Destructor

  //----------------------------PLAYER SETUP------------------------------------

  bool         bInitializePlayer();            //Initialize player... once at startup
  bool         bPrepare(const char *p_filePath, const char *p_deviceName, bool bRepeat =false,unsigned int recurrence=RECURRENCE_PERIOD_MAX);//Function to be used to play single files
  bool         bUpdateActiveFile(const char* active_file);  //Function to update file during an active playback. Only files with same sampling rates are allowed
  bool         bUpdateRecurrence(int recurrence);      //Function to update recurrence during an acitve playback
  void         vTearDown();                //Tears down the current playback setup, frees resources
  bool         bDeinitPlayer();              //Deinitialize player .. once at shutdown

  //-----------------------------PLAYBACK CONTROL FUNCTIONS---------------------

  bool         bPlay();                                    //To start playing
  bool         bStop(beep_player_stop_mode eMode= STOP_AFTER_EOF);          //To stop playing

private:
  //----------------------------------Explicit privates-------------------------------------
  Beep_file_Player();
  Beep_file_Player(const Beep_file_Player&);
  //-----------------------------------MEMBER VARIABLES-------------------------------------

  Beep_playback_status_IF*         m_poController;//Pointer to the controller
  std::vector<beep_player_backend_IF*>      m_supported_backend_list;//List of supported backends
  beep_player_backend_IF*          m_active_backend;//Active backend being used for playback

};
#endif //#define _BEEP_FILE_PLAYER_


