
/*******************************************************************************
*
* FILE:          Beep_VolumeOffsets.h
*
* SW - COMPONENT:  Beep application
*
* PROJECT :
*
* DESCRIPTION : Beep volume offsets Class.
*
* AUTHOR : pmh7kor
*
* COPYRIGHT : (c)2017 RBEI, Bangalore
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

//#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
//#include "etrace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/Beep_VolumeOffsets.cpp.trc.h"
#endif

#include "Beep_VolumeOffsets.h"

#include "fc_audiomanager_main.h"
#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"
//included to read KDS value(Speaker Configuration)
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#include "../vd_adr3/vd_adr3Msg_If.h"

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

Beep_VolumeOffsets::Beep_VolumeOffsets(void) : IF_MessageObserver<PO_MessageConfig::enID>("Beep_VolumeOffsets Observer")
{
    m_soundConfig = 0x0;
    m_poAudio_Function = NULL;
  m_enAudioState=EN_AUDIO_STATE_OFF;
    m_ChannelOffsetMap.clear();
    m_channelErrorStatusMap.clear();
    m_ErrorSiteCodeMap.clear();
  tu8AudioAvailibility=AUDIO_AVIALIBILITY_UNDEFINED;
}
/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::Beep_VolumeOffsets()
*
* DESCRIPTION: Constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/

Beep_VolumeOffsets::Beep_VolumeOffsets(fc_audiomanager_tclApp* poMainAppl) : IF_MessageObserver<PO_MessageConfig::enID>("Beep_VolumeOffsets Observer")
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::Beep_VolumeOffsets(fc_audiomanager_tclApp* ) called"));
    m_soundConfig = 0x0;
    m_poAudio_Function = poMainAppl->pGetAudioFunctionptr();
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
    _poMyCSMInterface = new CSMInterface();
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    m_soundConfig = m_poAudio_Function->bCheckFaderAvailability();
#endif
    VInitErrorSiteCodeMap();
    vInitChannelOffsetMap();

    InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_AudioState);

    ETG_TRACE_USR4(("Beep_VolumeOffsets::ChannelErrorStatusMap contents, LF: %d, RF : %d, LR : %d, RR : %d", m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_LF], m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_RF], m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_LR], m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_RR]));
    m_enAudioState=EN_AUDIO_STATE_OFF;
  tu8AudioAvailibility=AUDIO_AVIALIBILITY_UNDEFINED;
}

/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::~Beep_VolumeOffsets()
*
* DESCRIPTION: Constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
Beep_VolumeOffsets::~Beep_VolumeOffsets()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
    m_soundConfig = 0x0;
    m_poAudio_Function = NULL;
    m_ChannelOffsetMap.clear();
    m_ErrorSiteCodeMap.clear();

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
    if(_poMyCSMInterface != NULL)
    {
        delete _poMyCSMInterface;
        _poMyCSMInterface = NULL;
    }
#endif

}

/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::vInitChannelOffsetMap()
*
* DESCRIPTION: Initailzes the channel offsets map.
* m_ChannelOffsetMap contains is a map containing channel Id and a vector of channel Id, Volume offsets.
The below sequence is followed based on requirement.
for Example, if speaker test Error is reported in LF speaker, volume offset has to be remaped to RF speaker if no error in RF, else to LR, else to RR
similarly, if speaker test error is reported in LR speaker, volume offset of LR to be remapped to RR if no error in RR, else to LF,else to RF.
If Error is reported in Front speakers,based on amplifier configuration i.e for 4-channel, volume offset will be remapped to Rear speakers.
For 2-channel, Rear Speakers will be muted and no adas sound will be heard

  CHANNELID ----- vector[CHANNELID, VOLOFFSET]
  [LF]    ----- [LF,CHANNEL_MUTE],[RF,CHANNEL_MUTE], [LR,CHANNEL_MUTE], [RR,CHANNEL_MUTE]
  [RF]    ----- [RF,CHANNEL_MUTE],[LF,CHANNEL_MUTE], [LR,CHANNEL_MUTE], [RR,CHANNEL_MUTE]
  [LR]    ----- [LR,CHANNEL_MUTE],[RR,CHANNEL_MUTE], [LF,CHANNEL_MUTE], [RF,CHANNEL_MUTE]
  [RR]    ----- [RR,CHANNEL_MUTE],[RF,CHANNEL_MUTE], [LR,CHANNEL_MUTE], [LF,CHANNEL_MUTE]
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid Beep_VolumeOffsets::vInitChannelOffsetMap()
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::vInitChannelOffsetMap() called"));

    if (!m_channelErrorStatusMap.empty())
        m_channelErrorStatusMap.clear();
    m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_LF] = EN_AUDIO_DIAG_ERRVAL_NO_ERROR;
    m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_RF] = EN_AUDIO_DIAG_ERRVAL_NO_ERROR;
    m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_LR] = EN_AUDIO_DIAG_ERRVAL_NO_ERROR;
    m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_RR] = EN_AUDIO_DIAG_ERRVAL_NO_ERROR;

    if (!m_ChannelOffsetMap.empty())
        m_ChannelOffsetMap.clear();
    m_ChannelOffsetMap[EN_AUDIO_DIAG_SPEAKER_LF] = channelremapoffsetList(EN_AUDIO_DIAG_SPEAKER_LF, EN_AUDIO_DIAG_SPEAKER_RF, EN_AUDIO_DIAG_SPEAKER_LR, EN_AUDIO_DIAG_SPEAKER_RR);
    m_ChannelOffsetMap[EN_AUDIO_DIAG_SPEAKER_RF] = channelremapoffsetList(EN_AUDIO_DIAG_SPEAKER_RF, EN_AUDIO_DIAG_SPEAKER_LF, EN_AUDIO_DIAG_SPEAKER_RR, EN_AUDIO_DIAG_SPEAKER_LR);
    m_ChannelOffsetMap[EN_AUDIO_DIAG_SPEAKER_LR] = channelremapoffsetList(EN_AUDIO_DIAG_SPEAKER_LR, EN_AUDIO_DIAG_SPEAKER_RR, EN_AUDIO_DIAG_SPEAKER_LF, EN_AUDIO_DIAG_SPEAKER_RF);
    m_ChannelOffsetMap[EN_AUDIO_DIAG_SPEAKER_RR] = channelremapoffsetList(EN_AUDIO_DIAG_SPEAKER_RR, EN_AUDIO_DIAG_SPEAKER_LR, EN_AUDIO_DIAG_SPEAKER_RF, EN_AUDIO_DIAG_SPEAKER_LF);

}
/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::VInitErrorSiteCodeMap()
*
* DESCRIPTION: Initailzes the ErrorSiteCode map.
* ErrorSite code Map contains Channel Id and a vector of Error codes of a channel and Error value

CHANNEL_ID ------ vector[ERROR_CODE,ERROR_VALUE]
Below are the Error codes:
EN_AUDIO_DIAG_ERR_OPEN_WOOFER, EN_AUDIO_DIAG_ERR_SHORT_GND, EN_AUDIO_DIAG_ERR_SHORT_VCC,EN_AUDIO_DIAG_ERR_SHORT_WIRE,EN_AUDIO_DIAG_ERR_OPEN_TWEETER,EN_AUDIO_DIAG_ERR_THERMAL_WARNING

Error Values :
EN_AUDIO_DIAG_ERRVAL_NO_ERROR,EN_AUDIO_DIAG_ERRVAL_ERROR,EN_AUDIO_DIAG_ERRVAL_CONDITION,EN_AUDIO_DIAG_ERRVAL_SMALL,EN_AUDIO_DIAG_ERRVAL_MID,EN_AUDIO_DIAG_ERRVAL_HIGH,EN_AUDIO_DIAG_ERRVAL_UNDEF
CHANNEL_ID ------ vector[ERROR_CODE,ERROR_VALUE]
        LF     ------ [woofer,noError],[shortGnd,noError],[ShortVcc,noError],[ShortWire,noError],[openTweeter,noError],[Thermalwarn,noError]
        RF     ------ [woofer,noError],[shortGnd,noError],[ShortVcc,noError],[ShortWire,noError],[openTweeter,noError],[Thermalwarn,noError]
        LR     ------ [woofer,noError],[shortGnd,noError],[ShortVcc,noError],[ShortWire,noError],[openTweeter,noError],[Thermalwarn,noError]
        RR     ------ [woofer,noError],[shortGnd,noError],[ShortVcc,noError],[ShortWire,noError],[openTweeter,noError],[Thermalwarn,noError]

The above map will be updated for Error values for each speaker based on speaker test results before remapping the Channel offsets
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid Beep_VolumeOffsets::VInitErrorSiteCodeMap()
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::VInitErrorSiteCodeMap()"));

    if (!m_ErrorSiteCodeMap.empty())
        m_ErrorSiteCodeMap.clear();
    for (tU8 i = EN_AUDIO_DIAG_SPEAKER_LF; i <= EN_AUDIO_DIAG_SPEAKER_RR; i++)
    {
        m_ErrorSiteCodeMap[i] = ErrorCodeValueList(EN_AUDIO_DIAG_ERR_OPEN_WOOFER, EN_AUDIO_DIAG_ERR_SHORT_GND, EN_AUDIO_DIAG_ERR_SHORT_VCC, EN_AUDIO_DIAG_ERR_SHORT_WIRE, EN_AUDIO_DIAG_ERR_OPEN_TWEETER, EN_AUDIO_DIAG_ERR_THERMAL_WARNING);
    }
}
/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::vRemapVolumeOffsets(VolumeOffsetData&)
*
* DESCRIPTION: vRemapVolumeOffsets().
* Initializing the channel offset and ErrorSiteCode Maps before remapping the channel offsets based on the Speaker Test Results
  Remap offsets consists of 2 parts, Updating the channel offset Map and retrieving the final offsets for all channels.
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid Beep_VolumeOffsets::vRemapVolumeOffsets(VolumeOffsetData& VolumeOffsetDataset)
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::vRemapVolumeOffsets() called, sound configuration : %d", m_soundConfig));


    // initialize the channel offset map before doing remap
    vInitChannelOffsetMap();

    //Updating error status Map before remapping channel offsets
    for (tU8 tErrSite = EN_AUDIO_DIAG_SPEAKER_LF; tErrSite <= EN_AUDIO_DIAG_SPEAKER_RR; tErrSite++)
        vUpdateChannelErrorStatusMap(tErrSite);
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  // Updating Error Value for in ErrorStatusMap for 2-channel configuration
  if ((m_soundConfig == INTERNALAMP_2SPEAKER) || (m_soundConfig == EXTERNAL_DAIMLER_2))
  {
    m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_LR] = EN_AUDIO_DIAG_ERRVAL_ERROR;
    m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_RR] = EN_AUDIO_DIAG_ERRVAL_ERROR;
  }
#endif

    ETG_TRACE_USR4(("Beep_VolumeOffsets::Error status Map contents, LF: %d, RF : %d, LR : %d, RR : %d", m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_LF], m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_RF], m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_LR], m_channelErrorStatusMap[EN_AUDIO_DIAG_SPEAKER_RR]));

    ETG_TRACE_USR4(("Beep_VolumeOffsets:: before Remap, offsets are LF : %d, RF : %d, LR : %d, RR : %d", VolumeOffsetDataset.s16Offset_LF, VolumeOffsetDataset.s16Offset_RF, VolumeOffsetDataset.s16Offset_LR, VolumeOffsetDataset.s16Offset_RR));
    //Remap the offsets
    vRemapChanneloffset(EN_AUDIO_DIAG_SPEAKER_LF, VolumeOffsetDataset.s16Offset_LF);
    vRemapChanneloffset(EN_AUDIO_DIAG_SPEAKER_RF, VolumeOffsetDataset.s16Offset_RF);
    vRemapChanneloffset(EN_AUDIO_DIAG_SPEAKER_LR, VolumeOffsetDataset.s16Offset_LR);
    vRemapChanneloffset(EN_AUDIO_DIAG_SPEAKER_RR, VolumeOffsetDataset.s16Offset_RR);


    // retrieve and update the offsets
    VolumeOffsetDataset.s16Offset_LF = sGetFinalVolumeOffsets(EN_AUDIO_DIAG_SPEAKER_LF);
    VolumeOffsetDataset.s16Offset_RF = sGetFinalVolumeOffsets(EN_AUDIO_DIAG_SPEAKER_RF);
    VolumeOffsetDataset.s16Offset_LR = sGetFinalVolumeOffsets(EN_AUDIO_DIAG_SPEAKER_LR);
    VolumeOffsetDataset.s16Offset_RR = sGetFinalVolumeOffsets(EN_AUDIO_DIAG_SPEAKER_RR);
    ETG_TRACE_USR4(("Beep_VolumeOffsets:: after Remap, offsets are LF : %d, RF : %d, LR : %d, RR : %d", VolumeOffsetDataset.s16Offset_LF, VolumeOffsetDataset.s16Offset_RF, VolumeOffsetDataset.s16Offset_LR, VolumeOffsetDataset.s16Offset_RR));
}

/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::vRemapChanneloffset(tU8 ChannelId, tS16 tVolOffsets)
*
* DESCRIPTION: vRemapChanneloffset().
* This function updates the Volume offsets for the specified channel by checking for Error in a channel sequence.
* Example : for LF as channel Id, checks if error exists in LF. Updates its offset if no error with the passed tVolOffsets, else updates the passed offset to RF, if no error exists in it, else to LR, else to RR.
* basically the sequence in vInitChannelOffsetMap() will be followed in updating the vol offset for a specified channel.
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid Beep_VolumeOffsets::vRemapChanneloffset(tU8 ChannelId, tS16 tVolOffsets)
{
    map<tU8, channelremapoffsetList>::iterator channelMapItr = m_ChannelOffsetMap.find(ChannelId);

    if (channelMapItr != m_ChannelOffsetMap.end())
    {
        channelremapoffsetList& tchanneloffObj = channelMapItr->second;
        tchanneloffObj.vRemapchannelOffsetonError(m_channelErrorStatusMap,tVolOffsets);
    }
}
/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::MessageNotification(PO_MessageConfig::enID MsgId)
*
* DESCRIPTION: This function is called when any of the post office messsages addressed to Beep_Controller is posted
* Updates the m_ErrorSiteCodeMap[] with ErrorCodes and Error Values for each Error Site(i.e Channel Id) based on the ADR Speaker Test Results received in PO Msg
*
* PARAMETER:PO_MessageConfig::enID MsgId
*
* RETURN TYPE : void
*
*******************************************************************************/
void Beep_VolumeOffsets::MessageNotification(PO_MessageConfig::enID MsgId)
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::MessageNotification(%i) entered. ", ETG_CENUM(PO_MessageConfig::enID, MsgId)));

    switch (MsgId)
    {
    case (PO_MessageConfig:: ID_AudioState) :
    {   ETG_TRACE_USR4(("Beep_VolumeOffsets::MessageNotification: ID_AudioState"));
        const ID_AudioState*  pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_AudioState>(MsgId);
        ETG_TRACE_USR4(("AudioState status: %d", pMsg->AudioState));
        if(pMsg!=NULL)
        {
      m_enAudioState = pMsg->AudioState;

            for (tU8 tErrSite = EN_AUDIO_DIAG_SPEAKER_LF; tErrSite <= EN_AUDIO_DIAG_SPEAKER_RR; tErrSite++)
            {
                vUpdateChannelErrorStatusMap(tErrSite);
            }
            WriteToCanSignal( IsDiagtestPerformed() ,m_enAudioState);
        }
    }
        break;

    default:
        break;
    }
}
/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::vUpdateErrorSiteCodeMap(tU8 ErrorSite, tU8 ErrorCode, tU8 ErrorValue)
*
* DESCRIPTION: vUpdateErrorSiteCodeMap().
* Updates the error code and Error value for each Channel in m_ErrorSiteCodeMap map.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid Beep_VolumeOffsets::vUpdateErrorSiteCodeMap(tU8 ErrorSite, tU8 ErrorCode, tU8 ErrorValue)
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::UpdateErrorSiteCodeMap() called"));

    map<tU8, ErrorCodeValueList>::iterator ErrorMapIterator = m_ErrorSiteCodeMap.find(ErrorSite);

    if (ErrorMapIterator != m_ErrorSiteCodeMap.end())
    {
        ETG_TRACE_USR4(("Error Code Found, updating Error Value, ErrorCode : %d, ErrorValue : %d", ErrorCode, ErrorValue));
        ErrorMapIterator->second.vSetErrorCodenValue(ErrorCode, ErrorValue);
    }
    else
        ETG_TRACE_ERR(("Error Code not Found"));

  for (tU8 tErrSite = EN_AUDIO_DIAG_SPEAKER_LF; tErrSite <= EN_AUDIO_DIAG_SPEAKER_RR; tErrSite++)
    {
        vUpdateChannelErrorStatusMap(tErrSite);
    }
    WriteToCanSignal( IsDiagtestPerformed() ,m_enAudioState);
}
/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::vUpdateChannelErrorStatusMap(tU8 ErrorSite)
*
* DESCRIPTION: vUpdateChannelErrorStatusMap().
* Updates the m_channelErrorStatusMap with Error Values for each channel on receiving ADR test results
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid Beep_VolumeOffsets::vUpdateChannelErrorStatusMap(tU8 ErrorSite)
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::vUpdateChannelErrorStatusMap()"));
    tU8 tErrorValue;
    map<tU8, ErrorCodeValueList>::iterator ErrorMapIterator = m_ErrorSiteCodeMap.find(ErrorSite);

    if (ErrorMapIterator != m_ErrorSiteCodeMap.end())
    {
        //ETG_TRACE_USR4(("Error Code Found, updating Error Value, ErrorValue : %d", ErrorValue));
        tErrorValue = ErrorMapIterator->second.u8GetErrorValue();
        m_channelErrorStatusMap[ErrorSite] = tErrorValue;
    }
    else
        ETG_TRACE_ERR(("Error Site not Found"));
}
/*******************************************************************************
*
* FUNCTION: Beep_VolumeOffsets::sGetFinalVolumeOffsets(tU8 ErrorSite)
*
* DESCRIPTION: sGetFinalVolumeOffsets().
* Used to calculate the final offset for each channel by reading offsets of a particular channel from the m_ChannelOffsetMap map.
*
 Example :
CHANNELID ----- vector[CHANNELID, VOLOFFSET]
[LF]    ----- [LF,CHANNEL_MUTE],[RF,CHANNEL_MUTE], [LR,CHANNEL_MUTE], [RR,CHANNEL_MUTE]
[RF]    ----- [RF,CHANNEL_MUTE],[LF,CHANNEL_MUTE], [LR,CHANNEL_MUTE], [RR,CHANNEL_MUTE]
[LR]    ----- [LR,CHANNEL_MUTE],[RR,CHANNEL_MUTE], [LF,CHANNEL_MUTE], [RF,CHANNEL_MUTE]
[RR]    ----- [RR,CHANNEL_MUTE],[RF,CHANNEL_MUTE], [LR,CHANNEL_MUTE], [LF,CHANNEL_MUTE]

[LF]    ----- [LF,CHANNEL_MUTE]
[RF]    -----          [LF,CHANNEL_MUTE]
[LR]    -----                     [LF,CHANNEL_MUTE]
[RR]    -----                             [LF,CHANNEL_MUTE]

All LF offsets for each channel Id m_ChannelOffsetMap will be read and which ever is highest will be the final offset of that channel

* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tS16 Beep_VolumeOffsets::sGetFinalVolumeOffsets(tU8 channelId)
{
    ETG_TRACE_USR4(("Beep_VolumeOffsets::sGetFinalVolumeOffsets() called"));

    tS16 offset = CHANNEL_MUTE;
    map<tU8, channelremapoffsetList>::iterator channelMapItr;

    for (channelMapItr = m_ChannelOffsetMap.begin(); channelMapItr != m_ChannelOffsetMap.end(); channelMapItr++)
    {
        tS16 tempoffset = (channelMapItr->second).sGetchannelOffset(channelId);
        if (tempoffset > offset)
            offset = tempoffset;
    }

    return offset;
}


/*
 * FUNCTION:Beep_VolumeOffsets::GetChannelErrorStatus()
 *
 * DESCRIPTION: This function checks if there is any error detected in error site(speakers)
 *
 * PARAMETER:none
 *
 * RETURNVALUE: bool data ( false if error found in speakers, true if no error found)
 *
 */

bool Beep_VolumeOffsets::GetChannelErrorStatus()
{
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM

    ETG_TRACE_USR4(("Beep_VolumeOffsets::GetChannelErrorStatus entered"));

    tU8 u8AmpConfig;

    if (DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation",&u8AmpConfig, 1))
    {

        if(u8AmpConfig == INTERNALAMP_4SPEAKER)
        {   ETG_TRACE_USR4(("Beep_VolumeOffsets::GetChannelErrorStatus  In four speaker configuation"));
            for (tU8 tErrSite = EN_AUDIO_DIAG_SPEAKER_LF; tErrSite <= EN_AUDIO_DIAG_SPEAKER_RR ; tErrSite++)
            {
                if((m_channelErrorStatusMap[tErrSite] != EN_AUDIO_DIAG_ERRVAL_NO_ERROR)&& (m_channelErrorStatusMap[tErrSite] != EN_AUDIO_DIAG_ERRVAL_UNDEF))
                {
                    return false;
                }
            }
            return true;
        }
        else if(u8AmpConfig == INTERNALAMP_2SPEAKER)
        {    ETG_TRACE_USR4(("Beep_VolumeOffsets::GetChannelErrorStatus In two speaker configuation"));
            for (tU8 tErrSite = EN_AUDIO_DIAG_SPEAKER_LF; tErrSite <= EN_AUDIO_DIAG_SPEAKER_RF; tErrSite++)
            {
                if((m_channelErrorStatusMap[tErrSite] != EN_AUDIO_DIAG_ERRVAL_NO_ERROR) && (m_channelErrorStatusMap[tErrSite] != EN_AUDIO_DIAG_ERRVAL_UNDEF))
                {
                    return false;
                }
            }
            return true;
        }
        else
        {   //not a possibility
            ETG_TRACE_USR4(("Beep_VolumeOffsets::GetChannelErrorStatus External amplifier configuation"));
            return true;
        }
    }
    else
    {
        ETG_TRACE_USR4(("Beep_VolumeOffsets::GetChannelErrorStatus ERROR recieved  from  DP_s32GetConfigItem "));
        return true;
    }
#endif
return true;
}

/*
 * FUNCTION: Beep_VolumeOffsets::IsDiagtestPerformed()
 *
 * DESCRIPTION: This function checks if the diag Test is performed. Method used is we check if the error value in the signal signal is set to default ie.EN_AUDIO_DIAG_ERRVAL_UNDEF
 * if all the error value is set to default it means test is not performed.
 *
 * PARAMETER:none
 *
 * RETURNVALUE: bool
 *
 */

bool Beep_VolumeOffsets::IsDiagtestPerformed()
{

    ETG_TRACE_USR4(("Beep_VolumeOffsets:isDiagtestPerformed entered"));

    for (tU8 tErrSite = EN_AUDIO_DIAG_SPEAKER_LF; tErrSite <= EN_AUDIO_DIAG_SPEAKER_RR; tErrSite++)
    {
        if(m_channelErrorStatusMap[tErrSite] !=EN_AUDIO_DIAG_ERRVAL_UNDEF)
        {
            return true;
        }

    }
    return false;
}


/*
  * FUNCTION: Beep_VolumeOffsets::WriteToCanSignal
  *
  * DESCRIPTION: This function checks about audio Availability depending on data Audiostate and Diagnosis test.
  *
  * PARAMETER: bool bDiagTestPerformed and tenAudioState  AudioState
  *
  * RETURNVALUE: void
  *
  */

void Beep_VolumeOffsets::WriteToCanSignal (bool tDiagTestPerformed , tenAudioState tenAudioState  )
{

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM

    ETG_TRACE_USR4(("Beep_VolumeOffsets::WriteToCanSignal entered"));
  if(tenAudioState == EN_AUDIO_STATE_ON)
  {
    if(tDiagTestPerformed)
    {
      for (tU8 tErrSite = EN_AUDIO_DIAG_SPEAKER_LF; tErrSite <= EN_AUDIO_DIAG_SPEAKER_RR; tErrSite++)
      {
        vUpdateChannelErrorStatusMap(tErrSite);
      }

      tBool IsSpeakersOk=GetChannelErrorStatus();

      if( IsSpeakersOk)
      { ETG_TRACE_USR4(("Beep_VolumeOffsets::WriteToCanSignal  AUDIO STATE IS ON and Daig test PASSED  sending AVAILABLE"));
        vSendCsmBroadcastSignal(AUDIOAVAILABLE,1, CSM_C_ASIG_TX_AudioAvailability ,CSM_C_TX_IMMEDIATELY );
      }
      else
      {
        ETG_TRACE_USR4(("Beep_VolumeOffsets::WriteToCanSignal  Error found in speaker  sending UNAVAILABLE"));
        vSendCsmBroadcastSignal(AUDIOUNAVAILABLE,1, CSM_C_ASIG_TX_AudioAvailability ,CSM_C_TX_IMMEDIATELY );
      }
    }
    else // diag test not performed for external amplifier config, so sending audio available directly
    {
      ETG_TRACE_USR4(("Beep_VolumeOffsets::WriteToCanSignal Diagtest not Performed  and  AudioState is  ON  sending AVAILABLE"));
      vSendCsmBroadcastSignal(AUDIOAVAILABLE,1, CSM_C_ASIG_TX_AudioAvailability ,CSM_C_TX_IMMEDIATELY );
    }
  }
    else //sending audio unavailable on audio state off
    {
        ETG_TRACE_USR4(("Beep_VolumeOffsets::WriteToCanSignal error  detected sending  UNAVAILABLE"));
        vSendCsmBroadcastSignal(AUDIOUNAVAILABLE,1, CSM_C_ASIG_TX_AudioAvailability ,CSM_C_TX_IMMEDIATELY );
    }

#endif
   (void)tDiagTestPerformed;
   (void)tenAudioState;
}
/*
  * FUNCTION: Beep_VolumeOffsets::vSendCsmBroadcastSignal
  *
  * DESCRIPTION: This function is used to write to CAN signal about audio availability .
  *
  * PARAMETER: Audio availability data pabData, size of data , signal name  u32CsmSignal, type of transmission u8TxType
  *
  * RETURNVALUE: void
  *
  */



tVoid Beep_VolumeOffsets::vSendCsmBroadcastSignal(tU8 pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType)
{
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM

    ETG_TRACE_USR4(("Beep_VolumeOffsets::vSendCsmBroadcastSignal entered"));


    if(pabData!=tu8AudioAvailibility)
 {
    tu8AudioAvailibility=pabData;
    tU32 u32CsmHandle;
    tS32 s32Ret;

    if(_poMyCSMInterface!=NULL){

        s32Ret = _poMyCSMInterface->CSM_lSignalWrite((tVoid *)&u32CsmHandle,u32CsmSignal,
                                                     &pabData,
                                                     u8Len,
                                                     u8TxType);

        if(CSM_C_NO_ERROR > s32Ret) {
            ETG_TRACE_ERR(("Beep_VolumeOffsets::vSendCsmBroadcastSignal(): !!!!!! Error detected !!!!!!"));
        }
        else {
            ETG_TRACE_USR4(("Beep_VolumeOffsets::vSendCsmBroadcastSignal(): No error "));
        }

    }
    return;
 }
 else
 {

    ETG_TRACE_USR4(("Beep_VolumeOffsets::vSendCsmBroadcastSignal No change in Audio Availability status , hence not written to can"));


 }
#endif
#endif
    (void)pabData;
    (void)u8Len;
    (void)u32CsmSignal;
    (void)u8TxType;
}
























