/*******************************************************************************
*
* FILE:          Beep_ExtAmpHandlerMain.cpp
*
* SW-COMPONENT:  Beep Handler for external amplifier
*
* PROJECT:
*
* DESCRIPTION:   Beep Adas Class.
*
* AUTHOR:       ahd9kor(Sandesh)
*
* COPYRIGHT:    (c) 2018 RBEI, Bangalore
*
*******************************************************************************/



#ifndef _BEEP_EXTAMP_HANDLERMAIN_
#define _BEEP_EXTAMP_HANDLERMAIN_

#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "../config/dp/AudioUserDpIfSelect.h"
//#include "config/dp/AudioUserDpIfSelect.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3Settings.h"
#include "../InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeOffsetData.h"
#include "Beep_defines.h"
#include "Beep_playback_status_IF.h"
#include "beep_file_player/Beep_file_Player.h"


#include "../fc_audiomanager_service_Audio_Function.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"
#include "../PostOffice/PostOffice.hpp"
#include "../PostOffice/BaseMessage.h"



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"

class Beep_file_Player;
class Beep_ExtAmpHandlerMain: public IF_MessageObserver<PO_MessageConfig::enID>,public Beep_playback_status_IF //, public StreamMuteNotify_IF
{
  InternalCommunicationAdapter* pPO;

public:
  Beep_ExtAmpHandlerMain(fc_audiomanager_tclService_Audio_Function*);
   ~ Beep_ExtAmpHandlerMain();
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  virtual tVoid InitialiseBeepViaFilepath(const std::string File_Path,const BeepFile_Config& Config,const tU32& u32token);
  tVoid PlayBeepFile();
  void  SendStatus(tenSettingType,  tS8);
  tBool bSendCCAStatusMessage(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg ) const;
  void NotifyBeepState(tU8 tBeepState);
  virtual void vOnPlaybackStatus(tU8 sts);//Playback status updates from beep player
  tU8 u8BeepState;
  tBool m_bEntStreamMuted;
  tBool m_sourceActive;
  tU8 m_playerstatus;
  AudioUserDpIf*    pAudUsrDpIf;
  Beep_file_Player*    m_player;
  tBool m_MuteAmpResponse;
  fc_audiomanager_tclService_Audio_Function*  pFc_audio_manager ;
  std::string File_Path;
  tBool m_bwcsound_played;
};


#endif
