/*******************************************************************************
*
* FILE:          Beep_ExtAmpHandlerMain.h
*
* SW-COMPONENT:  Beep Handler for external amplifier
*
* PROJECT:
*
* DESCRIPTION:   Beep Adas Class.
*
* AUTHOR:       ahd9kor(Sandesh)
*
* COPYRIGHT:    (c) 2018 RBEI, Bangalore
*
*******************************************************************************/
#include "Beep_ExtAmpHandlerMain.h"
#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_ExtAmpSettingsStatus.h"
#include "../InternalComponentCommunication/Messages/vd_AmpResponses/IDAmpResponse_Mute.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAStartBeepFile.h"
#include "../InternalComponentCommunication/Messages/Volume/IDSetVolumeOffset.h"
#include "InternalComponentCommunication/Messages/mute/IDNotifyMute.h"
#include "InternalComponentCommunication/Messages/Volume/ID_AmpVolumeListStatus.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "../../InternalComponentCommunication/Messages/Source/IDSetSource.h"
#include "../InternalComponentCommunication/Messages/Source/IDCCAStartAmpDeviceAudioRoute.h"
#include "../../InternalComponentCommunication/Messages/mute/IDSetMute.h"
#include "../mute/stream/StreamMute_IF.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#include "Beep_defines.h"

#define BEEP_STREAM_MUTE    0x01
#define BEEP_STREAM_DEMUTE    0x02

#define BEEP_MUTE_REASON_SRC_SEL     0x10
#define BEEP_RESOURCE_TYPE_LS    0x01
#define SET_WELCOMESOUND_UPADTE_STATUS 1
#define EN_AUDIO_MUTE_MUTERESULT_DEMUTE 0x00  // for amplifier 0:Demute and 1:Mute

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/Beep_ExtAmpHandlerMain.cpp.trc.h"
#endif


Beep_ExtAmpHandlerMain :: Beep_ExtAmpHandlerMain (fc_audiomanager_tclService_Audio_Function* m_poAudio_Func ): IF_MessageObserver<PO_MessageConfig::enID>("Beep_ExtAmpHandlerMain  Constructor")

{
  pFc_audio_manager =m_poAudio_Func;

  u8BeepState=BEEP_STATE_UNDEFINED;
  m_bEntStreamMuted=true;
  m_sourceActive=false;
  m_player = NULL;
  m_bwcsound_played = false;
  File_Path = std::string();
  m_MuteAmpResponse = false; 
  m_playerstatus = TRC::enFileStopped;
  pAudUsrDpIf   = AudioUserDpIfSelect::pGetAudUsrDpIf();
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poAudio_Func);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->POMessages);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ExtAmpSettingsStatus);
  pPO->POMessages->AddObserver(this,PO_MessageConfig::ID_CCAStart_BeepFile);
  pPO->POMessages->AddObserver(this,PO_MessageConfig::ID_NotifyMute);
  pPO->POMessages->AddObserver(this,PO_MessageConfig::ID_CCAStart_AmpDeviceAudioRoute);
  pPO->POMessages->AddObserver(this,PO_MessageConfig::ID_AmpVolumeListStatus);
  pPO->POMessages->AddObserver(this,PO_MessageConfig::ID_AmpResponseMute);

}
Beep_ExtAmpHandlerMain :: ~ Beep_ExtAmpHandlerMain()
{
  pPO->POMessages->DeRegisterObserver(this);
  pFc_audio_manager=NULL;
  pAudUsrDpIf=NULL;
  pPO=NULL;

}

void Beep_ExtAmpHandlerMain::MessageNotification(PO_MessageConfig::enID MsgId)
{
  switch(MsgId)
  {
  case PO_MessageConfig::ID_ExtAmpSettingsStatus:
  {

    {
      const ID_ExtAmpSettingsStatus* pExtAmpConnState = pPO->POMessages->QueryMessage<ID_ExtAmpSettingsStatus>(MsgId);
      SendStatus((tenSettingType)pExtAmpConnState->u8SettingType, pExtAmpConnState->s8Value);
    }
    break;
  }
  case PO_MessageConfig::ID_AmpVolumeListStatus:
  {
  if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME) != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_USR3(("CHECK:: Beep_ExtAmpHandlerMain::Updating clients for Park_assist_volume status"));
      }
  break;
  }
  case PO_MessageConfig::ID_CCAStart_BeepFile:
  {
    const ID_CCAStart_BeepFile* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage < ID_CCAStart_BeepFile > (MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    ETG_TRACE_USR2(("Beep_ExtAmpHandlerMain: MessageNotification(ID_CCAStart_BeepFile)"));
    //if((!m_sourceActive) || (m_bEntStreamMuted))
     // {
    File_Path = pMsg->File_Path;
    m_player = new Beep_file_Player(this); // check if iMx cobfigured not done
    m_bwcsound_played = false;
    if(m_player != NULL)
        {
          NORMAL_M_ASSERT(m_player->bInitializePlayer());//Assert, if player initialization fails
        }
    InitialiseBeepViaFilepath(pMsg->File_Path,pMsg->oConfig,pMsg->m_u32Token);
      //}
    break;
  }
  case PO_MessageConfig::ID_NotifyMute:
  {
   const ID_NotifyMute* pMsg = pPO->POMessages->QueryMessage<ID_NotifyMute>(MsgId);
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
     ETG_TRACE_USR4(("Beep_ExtAmpHandlerMain :: ADR mute notification received  with action: %x and Stream: %x ."
       , pMsg->enMuteResult, pMsg->enStream));
     if(pMsg->enStream == EN_AUDIO_SOURCE_STREAM_MAIN)
         {
           if(pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_MUTE)
             m_bEntStreamMuted = true;
           else
             m_bEntStreamMuted = false;
         }
     break;
  }
  case PO_MessageConfig::ID_CCAStart_AmpDeviceAudioRoute:
  {
    const ID_CCAStart_AmpDeviceAudioRoute* pMsg = pPO->POMessages->QueryMessage<ID_CCAStart_AmpDeviceAudioRoute>(MsgId);
       ETG_TRACE_USR4(("Beep_ExtAmpHandlerMain :: ID_CCAStart_AmpDeviceAudioRoute received  with resource :%d source: %d."
         , pMsg->Resource, pMsg->Source));
       if(pMsg->Source>0 && pMsg->Source<69)
       {
         m_sourceActive = true;
    }
    break;
  }
  case PO_MessageConfig::ID_AmpResponseMute:
  {
    ETG_TRACE_USR4(("ID_AmpResponseMute PO received "));
    const ID_AmpResponseMute* pMsg = pPO->POMessages->QueryMessage<ID_AmpResponseMute>(MsgId);
    ETG_TRACE_USR4(("ID_AmpResponseMute PO received with stream : %d, mute result:%d",pMsg->enStream, pMsg->enMuteResult ));
    if((pMsg->enStream == EN_AUDIO_SOURCE_STREAM_MAIN) && (pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_DEMUTE))
    {
      m_MuteAmpResponse = true;
      ETG_TRACE_USR4(("Amplifier response : %d",m_MuteAmpResponse));
      if(!m_bwcsound_played)
      {
      PlayBeepFile();
      }
    }
    ETG_TRACE_USR4(("Amplifier response : %d",m_MuteAmpResponse));
    break;
  }
  default:
    ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::MessageNotification unknown Message %x",MsgId));
    break;

  }
}


/*******************************************************************************
 *
 * FUNCTION: Beep_ExtAmpHandlerMain::SendStatus(tenSettingType u8SettingType, tS8 s8Value)
 *
 * DESCRIPTION: Fucntion is called to update clients about change in property parameters
 *
 * PARAMETER: amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg.
 *
 * RETURNVALUE: void.
 *

 *******************************************************************************/

void Beep_ExtAmpHandlerMain::SendStatus(tenSettingType u8SettingType, tS8 s8Value)
{
  switch(u8SettingType)
  {
  case EN_AUDIO_SETTINGS_UPA_TEMP_MUTE: {
    if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_ADAS_UPAMUTE) != AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::Updating clients for ADAS_UPA_MUTE status"));
    }
    break;
  }
  case EN_AUDIO_SETTINGS_SR_SOUNDACTIVATION_STATE : {
    tS32 s32Res = 0;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAudUsrDpIf);
    s32Res =pAudUsrDpIf->s32SetSRSoundState(s8Value);
    ETG_TRACE_USR4(("s32Res : %d",s32Res));
    if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE) != AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::Updating clients for SR_Sound_notification status"));
    }

    break;
  }

  case EN_AUDIO_SETTINGS_PARK_ASSIST_VOLUME :
  {  tS32 s32Res = 0;
    dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
    s32Res = odpParkAssitVol.s32SetData(s8Value);
    ETG_TRACE_USR4(("Persistent Memory storage Result for park assist volume = %x", s32Res));
    if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME) != AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR3(("CHECK:: Beep_ExtAmpHandlerMain::Updating clients for Park_assist_volume status"));
    }
    break;
  }

  case EN_AUDIO_SETTINGS_LDW_USER_VOLUME :
  {   tS32 s32Res = 0;
  dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWUserVol;
  s32Res = odpLDWUserVol.s32SetData(s8Value);
  ETG_TRACE_USR4(("Persistent Memory storage Result for odpLDWUserVol = %x", s32Res));
  if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME) != AIL_EN_N_NO_ERROR)
  {
    ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::Updating clients for ADAS_LDWUserVOLUME status"));
  }
  break;
  }

  case EN_AUDIO_SETTINGS_UPA_SOUND_COLLECTION :
  {
    tS32 s32Res = 0;
    s32Res =  pAudUsrDpIf->s32SetUPASoundtype(s8Value);
    (tVoid)s32Res;
    if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE) != AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::Updating clients for Upa_sound_collection status"));

    }
    break;
  }

  case EN_AUDIO_SETTINGS_BEEP_PLAY :
  {   ETG_TRACE_ERR(("Beep_ExtAmpHandlerMain::Updating clients for BEEP_PLAY status"));
       NotifyBeepState(BEEP_STOPPED);
  break;
  }

  default:
  {
    ETG_TRACE_ERR(("Beep_ExtAmpHandlerMain::Invalid case"));
    break;
  }
  }
}

/*******************************************************************************
 *
 * FUNCTION: Beep_ExtAmpHandlerMain::bSendCCAStatusMessage(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg ) const
{
 *
 * DESCRIPTION:This  Called from status message factory of fc_audiomanager in case the system is configured to premium2 ampliflier
 *
 * PARAMETER: amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg.
 *
 * RETURNVALUE: Boolean.
 *

 *******************************************************************************/


tBool Beep_ExtAmpHandlerMain::bSendCCAStatusMessage(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg ) const
{

  ETG_TRACE_ERR(("Beep_ExtAmpHandlerMain:bSendCCAStatusMessage entered"));
  (tVoid)poInMsg;
  (tVoid)roOutMsg;

  midw_mascffi_tclMsgBeepStatusStatus oBeepStatus;
  tBool bRetVal = false;

  oBeepStatus.BeepStatus.enType = (midw_fi_tcl_e8_AudioBeepStatus::tenType)u8BeepState;
  oBeepStatus.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)0x01;
  oBeepStatus.u32Token = 0;
  fi_tclVisitorMessage oCCaMsg(oBeepStatus);

  oBeepStatus.vDestroy();
  bRetVal = oCCaMsg.bHandOver(&roOutMsg);
  return bRetVal;
}

/*******************************************************************************
 *
 * FUNCTION:Beep_ExtAmpHandlerMain::NotifyBeepState(tU8 tBeepState)
{
 *
 * DESCRIPTION:This fucntion is called to update the beepstate in Premium 2 configuration
 *
 * PARAMETER:tU8 tBeepState
 *
 * RETURNVALUE: void
 *

 *******************************************************************************/

void Beep_ExtAmpHandlerMain::NotifyBeepState(tU8 tBeepState)
{

  ETG_TRACE_ERR(("Beep_ExtAmpHandlerMain:NotifyBeepState entered"));
  if(tBeepState == BEEP_START_IP)
  {
    tBeepState = midw_fi_tcl_e8_AudioBeepStatus::FI_EN_AUDIO_BEEP_STATUS_ON;
  }
  else
  {
    tBeepState = midw_fi_tcl_e8_AudioBeepStatus::FI_EN_AUDIO_BEEP_STATUS_OFF;
  }
  u8BeepState = tBeepState;
  if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_BEEPSTATUS) != AIL_EN_N_NO_ERROR)
  {
    ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::Updating clients for BEEP_PLAY status"));

  }
}





void Beep_ExtAmpHandlerMain::vOnPlaybackStatus(tU8 sts)
{
  tU8 u8Status = SET_WELCOMESOUND_UPADTE_STATUS;
  ETG_TRACE_USR4(("Beep_ExtAmpHandlerMain Notification. Status : %d",sts));
  switch(sts)
  {
  case TRC::enFileStopped:
  case TRC::enFilePlaying:
    break;
  default:
    return;
  }
  m_playerstatus = sts;//Update locally
  if((m_player != NULL)&& (m_playerstatus == TRC::enFileStopped ))
  {
  ETG_TRACE_USR4(("Beep_ExtAmpHandlerMain m_player tearing down..."));
    m_player->vTearDown();
    if(pFc_audio_manager->IsOEMRenault())
    {
    pFc_audio_manager->vSetRemoveWelcomeSound(u8Status);
    if (pFc_audio_manager->updateClients(MIDW_MASCFFI_C_U16_REMOVEWELCOMESOUND) != AIL_EN_N_NO_ERROR)
              {
              ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::Updating clients for removeWelcomeSound status"));
              }
    }
    ID_SetMute setMute(EN_AUDIO_SOURCE_STREAM_MAIN,EN_AUDIO_MUTE_MUTEACTION_On,8,800,0);
    pPO->POMessages->DeliverMsg(&setMute);
  }
}
tVoid Beep_ExtAmpHandlerMain::InitialiseBeepViaFilepath(const std::string File_Path,const BeepFile_Config& rfConfig,const tU32& u32token)
{
  //u8BeepName = EN_AUDIO_BEEP_GST_INTERNAL;
  //m_u8Source = BEEP_GST_PLAYER;
  //m_s16Gain = rfConfig.Volume;
    ETG_TRACE_USR4(("InitialiseBeepViaFilepath > Path=%s ",File_Path.c_str()));
    ID_CCAStart_AmpDeviceAudioRoute oAmpDeviceAudioRoute(BEEP_RESOURCE_TYPE_LS, EN_AUDIO_SOURCE_SOURCETYPE_CUE, EN_AUDIO_SOURCE_STREAM_MIX3);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAmpDeviceAudioRoute);
    MSG_SetSource setSource(EN_AUDIO_SOURCE_STREAM_MIX3, EN_AUDIO_SOURCE_SOURCETYPE_CUE, midw_fi_tcl_e8_AudSource::FI_EN_CUE, 1); //pMsg->Resource is the sink. Fully confusing with above Resource which is used for the stream.
    pPO->POMessages->DeliverMsg(&setSource);
    ID_SetMute setMute(EN_AUDIO_SOURCE_STREAM_MAIN,EN_AUDIO_MUTE_MUTEACTION_Off,8,800,0);
    pPO->POMessages->DeliverMsg(&setMute);
    (void)rfConfig;
    (void)u32token;
}
tVoid Beep_ExtAmpHandlerMain::PlayBeepFile()
{
        if(!File_Path.empty())
        {
          bool bRepeat = false;
            string alsadev = "AdevAudioSampler3Out";
              ID_SetMute setMute(EN_AUDIO_SOURCE_STREAM_MIX3,EN_AUDIO_MUTE_MUTEACTION_Off,8,800,1);
            InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setMute);
              ETG_TRACE_USR3(("Beep_ExtAmpHandlerMain::Welcome sound played in mix3 stream"));
              m_bwcsound_played = true;
          if(m_player->bPrepare(File_Path.c_str(),alsadev.c_str(),bRepeat,100))
          {
            if(!m_player->bPlay())
            {
              ETG_TRACE_ERR(("SetAndTriggerBeep: Failed to set pipeline to playing ! ! !, file: %s",File_Path.c_str()));
            }
          }
          else
          {
            ETG_TRACE_ERR(("SetAndTriggerBeep: Prepare failed ! ! !"));
          }
        }
        else
        {
          ETG_TRACE_ERR(("SetAndTriggerBeep: File path is empty ! ! !"));
        }
}
