/*******************************************************************************
 *
 * FILE:          Beep_Adas.h
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep Adas Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef _BEEP_ADAS_H_
#define _BEEP_ADAS_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "BeepController_IF.h"
#include "BeepParameter_IF.h"
#include "BeepNotification_IF.h"
#include "Beep_defines.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_DataStore.h"
#include "Beep_Main.h"

#include "AdasNotification_IF.h"
//#include <stl_pif.h>



#include <string>
#include <exception>
#include <map>
#include <vector>
#include <algorithm>
#include <list>
#include <iterator>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"




#include "../Volume/VolumeManager.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "config/dp/AudioUserDpIfSelect.h"


using namespace std;
namespace VolumeManager  { class VolumeManager; }

#define MAX_BEEPS_SUPPORTED    EN_AUDIO_BEEP_ACTUATOR_HMI
#define FC_AUDIO_SOURCE_STREAM_BEEP  EN_AUDIO_SOURCE_STREAM_MIX3


//class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;
class StreamMute_IF;
class BeepPrioHandler_IF;
class Beep_CSMSignalInterface;

class Beep_Adas : public IF_MessageObserver<PO_MessageConfig::enID>, public BeepNotification_IF, public BeepParameter_IF
{
public:
  Beep_Adas(void);
  Beep_Adas(Beep_Main* poMainAppl, BeepPrioHandler_IF* poBeepPrioHandler,VolumeManager::VolumeManager* poVolumeMgr);
  virtual ~Beep_Adas(tVoid);

  /**************************************************************************
   *  methods.
   **************************************************************************/
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);


  virtual tVoid GetSignalTonePara(tU8 tUBeepName, BeepControlData::BeepPara *BeepParameter);
  virtual tVoid GetSignalChimePara(tU8 tUBeepName, BeepControlData::ChimePara *ChimeParameter);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tU32 GetRequestToken();
  tVoid StopAdasBeep(tU8 tBeepName=0);
  virtual tS16 GetIncrementalVolumeStep()
  {
    return 0; // Beep Volume is always constant. Thus, returning 0.
  }


  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);

  virtual tVoid NotifyBeepState(tU8 tUBeepName,tU8 tBeepID, tU8 tBeepState, tU32 u32ResponseToken);
  virtual tU8 GetBeepSource(tU8 tUBeepName);
  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tBool bIsBeepIdValid(tU8 tUBeepName);
  virtual tU8 GetSoundSystemConfig();

  tBool bSendCCAStatusMessage(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg ) const;

  virtual tVoid u8UpdateBeepMainData(tU8 tBeepName);

    fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;

  Beep_Main* m_poBeepMainAppl;

  BeepPrioHandler_IF  *m_poBeepPrioHandler;
  BeepController_IF* m_poBeepController;
    StreamMute_IF* m_pStreamMute;
  AdasNotification_IF* m_poAdasNotificationIF;
    tU8 u8BeepName;
    tU8 u8BeepId;
  tU8 m_u8SoundSystemconfig;
  tU8 u8BeepState;
  tU8 u8RunningBeepName;

  //Internal data to hold the data of the requested beep.
  BeepControlData::ChimePara m_req_beep_ChimePara;
  BeepControlData::BeepPara  m_req_beep_BeepPara;
  std::string         m_req_beep_path;
  tS16             m_req_beep_volume;
  tU32             m_req_beep_token;
  tU32             m_rsp_beep_token;

  tVoid setAdasBeep(tU8 BeepType,AdasNotification_IF* poAdasNotification);
  tS16 s16GetAdasVolumeOffset(tU8 parkAssistVolLevel);
  virtual tU16 GetRecurrencePeriod(tU8 tBeepName);

  virtual bool bIsAdasSoundActive(tU8 /*tBeepName*/);
  virtual tVoid SetAdasNotificationPointer(tU8 tBeepName);
  virtual tVoid SetBeepIdnStatus(tU8 tBeepName, tU8 tBeepId);
  tS16 s16GetDBValue(tU8 s16Volume,tenStream enStream = EN_AUDIO_SOURCE_STREAM_DEFAULT);
  tU8 GetClusterSoundLvlForAttenuation();
private:
  tVoid vClearAdasSoundStatus(tU8 tBeepName);
  Beep_CSMSignalInterface* m_poBeep_CSMSignalInterface;

  aud_CCAMsg m_CCATransport;


  tVoid vResetInternalData();
  tBool bUpdateInternalData(const BeepFile_Config* ptrConfig=NULL, tU32 token=0);

  typedef map<tU8,AdasNotification_IF* > _AdasNotificationMap; //parameters are signal Id, Signal Value
  _AdasNotificationMap m_AdasNotificationMap;

  AdasNotification_IF* GetAdasNotificationPtr(tU8 tBeepName);
  VolumeManager::VolumeManager* m_poVolumeMgr;

  AudioUserDpIf*    pAudUsrDpIf;

};



#endif //_BEEP_ADAS_H_

