/*******************************************************************************
 *
 * FILE:          Beep_Actuator.h
 *
 * SW-COMPONENT:  Beep Actuator application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep Actuator Class.
 *
 * AUTHOR:       Ramesh Babu .K
 *
 * COPYRIGHT:    (c) 2012 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef _BEEP_ACTUATOR_H_
#define _BEEP_ACTUATOR_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "BeepNotification_IF.h"
#include "BeepParameter_IF.h"
#include "BeepController_IF.h"
#include "Priority/BeepPrioHandler_IF.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_DataStore.h"

//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#include <stl_pif.h>

#include <string>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"




#include "../Volume/VolumeManager.h"

namespace VolumeManager  { class VolumeManager; }

class Beep_Actuator : public IF_MessageObserver<PO_MessageConfig::enID>, public BeepParameter_IF, public BeepNotification_IF
{
public:
  Beep_Actuator(void);
  Beep_Actuator(BeepPrioHandler_IF* poBeepPrioHandler, BeepController_IF* poBeepController, VolumeManager::VolumeManager* poVolumeMgr);
  virtual ~Beep_Actuator(tVoid);


  /**************************************************************************
   *  methods.
   **************************************************************************/
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);

    tVoid setActuatorBeep(tU8 tChannelSelect, tU32 tFrequency, tU8 tVolType, tS16 tVolume, tU8 tRequester);

    virtual tVoid GetSignalTonePara(tU8 tUBeepName, BeepControlData::BeepPara *BeepParameter);
  virtual tVoid GetSignalChimePara(tU8 tUBeepName, BeepControlData::ChimePara *ChimeParameter)
  {
    (tVoid)tUBeepName; //Lint
    (tVoid)ChimeParameter;
  };
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  virtual tVoid NotifyBeepState(tU8 tUBeepName,tU8 tBeepID, tU8 tBeepState,tU32 u32ResponseToken);
  virtual tU8 GetBeepSource(tU8 tUBeepName);
  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tU32 GetRequestToken();
  virtual tBool bIsBeepIdValid(tU8 tUBeepName)
  {
    (tVoid)tUBeepName; //Lint
    return true;
  }

  virtual tU16 GetRecurrencePeriod(tU8 /*tBeepName*/)
  {
    return 0; // recurrence period to be used only for UPA obstacle sounds
  }

  virtual tVoid vClearAdasSoundStatus(tU8 /*tBeepName*/)
  {
    //to be used only for ADAS sounds
  }

  virtual bool bIsAdasSoundActive(tU8 /*tBeepName*/)
  {
    return false;   //to be used only for ADAS sounds
  }
  virtual tVoid SetAdasNotificationPointer(tU8 /*tBeepName*/)
  {
  // to be used only for ADAS
  }
  virtual tVoid SetBeepIdnStatus(tU8 /*tBeepName*/, tU8 tBeepId);

  virtual tVoid u8UpdateBeepMainData(tU8 /*tBeepName*/)
  {
  }
  tVoid setActuatorBeepState(tU8 tBeepState,tU8 tBeepId);
  tS16 GetIncrementalVolumeStep();
  virtual tU8 GetSoundSystemConfig();

    BeepPrioHandler_IF* m_poBeepPrioHandler;
    BeepController_IF* m_poBeepController;


  tU8 u8ChannelSelect;
  tU32 u32Frequency;
  tU8 u8VolType;
  tS16 s16Volume;
  tU8 u8TestToneType;
  tU8 u8Requester;
  tU8 u8State;
  tU8 u8BeepId;


private:
  aud_CCAMsg m_CCATransport;
  VolumeManager::VolumeManager* m_poVolumeMgr;



};

#endif //_BEEP_ACTUATOR_H_

