/*******************************************************************************
 *
 * FILE:          ADAS_UPASound.h
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   ADAS UPA Sound Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef _ADAS_UPA_H_
#define _ADAS_UPA_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "AdasNotification_IF.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_Adas.h"

#include "../../LoopBack/aud_loopback_if.h"
#define AUD_BEEP_TIMER_ID_ADASUPA_SETTINGSOUND 1

#define AUD_BEEP_TIMER_ADASUPA_SETTINGSOUND_INTERVAL                  3000 // UPA Setting sound should be stopped after 3 secs when it is triggered

class ADAS_UPASound : public IF_MessageObserver<PO_MessageConfig::enID>, public AdasNotification_IF
{
public:
  ADAS_UPASound(void);
  ADAS_UPASound(Beep_Adas* poAdasInstance);
  virtual ~ADAS_UPASound();

  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tS16 GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName=0);
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  //virtual tU8 GetBeepSource(tU8 tUBeepName);
  virtual tU16 GetRecurrencePeriod(tU8 tUBeepName);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);


  void vSetandTriggerAdasActivationSound(tU8 tUPAActivationSound);

  void vSetandTriggerAdasErrorSound(tU8 tUPAErrorSound);

  void vSetandTriggerUPAObstacleSound(tU8 tUPAObstacleSound);


  void vSetUPAObstacleZoneRecurrencePeriod(tU8 tUPARecurrencePeriod);
  void vSetUPAObstacleZoneRecurrenceType(tU8 tUPARecurrenceType);

  tVoid vTriggerStopBeep(tU8 tBeepName=0);
  tVoid vClearAdasSoundStatus(tU8 tBeepName);
  virtual bool bIsAdasSoundActive(tU8 tBeepName=0);
  virtual tVoid SetAdasSoundStatus(tU8 tBeepName);
  tVoid vSetUPA_Status_DisplayRequest(tU8 Status_DisplayRequest );
  tVoid vResetUPAData();
private:
  static ADAS_UPASound* _poThisInterface;
  tBool m_bUPASettingSndTmrRunning;
  Beep_Adas* m_poBeepAdasInstance;
  tU8 u8AmpConnectionState;
  OSAL_tTimerHandle m_hUPASettingSndTimer;
  aud_async_call_handler*  m_asynccall;
  AudioUserDpIf*    pAudUsrDpIf;


  fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
  tU8   m_u8AdasUPARecurrenceType;
    tU16   m_u8AdasUPARecurrenceFrequency;
    tU8   m_u8ObstacleZone;
  tBool m_bAdasUPAErrorSoundStatus;
  tBool m_bAdasUPAActivationSoundStatus;
  tBool m_bAdasUPAObstacleSoundStatus;
  tBool m_bAdasUPASettingSound;
  tBool m_bCANAttenuationStatus;
  tBool m_UPA_Status_DisplayRequest;

  tVoid vInitUPASettingSndTimer(tVoid);
  tVoid vStartUPASettingSndTimer(tU16 uwTimerID, tU16 uwTime);
  tVoid vStopUPASettingSndTimer(tU16 uwTimerID);

  tVoid vTriggerNewObstacleZoneSound();
  static tVoid vUPASettingSndTimerCallback(tVoid* pArg);
  std::string sGetUPAActivationFile(tU8 soundType);
  std::string sGetUPAErrorFile(tU8 soundType);
  std::string sGetUPAObstacleZoneFile(tU8 soundType);
  std::string sGetUPADiscontObstacleZoneSound(tU8 soundType);
  std::string sGetUPAContObstacleZoneSound(tU8 soundType);
  std::string sGetUPASettingSound(tU8 soundType);

  tBool bIsUPAUserMuteActive();
  tBool bIsSonarConfiguredAvailable();

  tBool bIsUPAConfiguredAvailable();

  tBool bIsParkAssistlevelValid();
  tBool bIs_UPA_Status_DisplayRequest_state_valid();
  tVoid GetUPAEOLLevelOffset( tS16& ts16UPAEOLLevelOffset);



};


#endif
