/*******************************************************************************
 *
 * FILE:          ADAS_PSMSound.h
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep Adas Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/ADAS_PSMSound.cpp.trc.h"
#endif
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "../fc_audiomanager_service_Audio_Function.h"
#include "ADAS_PSMSound.h"
#include "Beep_defines.h"
#include "../fc_audiomanager_trace.h"

#include "../InternalComponentCommunication/Messages/Beep/IDCCAStartADASBeep.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
ADAS_PSMSound::ADAS_PSMSound(void) :IF_MessageObserver<PO_MessageConfig::enID>("ADAS_PSMSound Constructor")
{
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
  vResetPSMData();
}
/*******************************************************************************
 *
 * FUNCTION: ADAS_PSMSound::ADAS_PSMSound()
 *
 * DESCRIPTION: Constructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
ADAS_PSMSound::ADAS_PSMSound(Beep_Adas* poAdasInstance) :IF_MessageObserver<PO_MessageConfig::enID>("ADAS_PSMSound Constructor")
{
  ETG_TRACE_USR2(("ADAS_PSMSound::ADAS_PSMSound() constructor called"));
  m_poBeepAdasInstance = poAdasInstance;
  m_poAudio_Function = poAdasInstance->m_poAudio_Function;
  vResetPSMData();
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_ADASBeep);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
}
/*******************************************************************************
 *
 * FUNCTION: ADAS_PSMSound::~ADAS_PSMSound()
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
ADAS_PSMSound::~ADAS_PSMSound()
{
  ETG_TRACE_USR4(("~ADAS_PSMSound() entered."));
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
}


/*******************************************************************************
*
* FUNCTION: ADAS_PSMSound::vResetPSMData()
* Resets the flags to defaults
*******************************************************************************/
tVoid ADAS_PSMSound::vResetPSMData()
{
  ETG_TRACE_USR4(("vResetPSMData"));
  m_bPSMSoundStatus = false;
  u8SlotDisplay = No_DISPLAY;
}

/*******************************************************************************
 *
 * FUNCTION: ADAS_PSMSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
 *
 * DESCRIPTION: Interface function to get volume offsets for Beep
 *
 * PARAMETER: tU8 tUBeepName
 *
 * RETURNVALUE: tVoid
 *
 *******************************************************************************/
tVoid ADAS_PSMSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
{
  ETG_TRACE_USR4(("ADAS_PSMSound::GetBeepVolumeOffsets()  BeepName:%d, u8SlotDisplay : %d", tUBeepName, u8SlotDisplay));
  VolOffsets->LF = CHANNEL_MUTE;
  VolOffsets->RF = CHANNEL_MUTE;
  switch (u8SlotDisplay)
  {
  case LEFT_DISPLAY:
    VolOffsets->LF = 0;
    break;
  case RIGHT_DISPLAY:
    VolOffsets->RF = 0;
    break;
  case LEFT_RIGHT_DISPLAY:
    VolOffsets->LF = 0;
    VolOffsets->RF = 0;
    break;
  case No_DISPLAY:
  default:
    break;
  }

  VolOffsets->LR       =  CHANNEL_MUTE;
  VolOffsets->RR       =  CHANNEL_MUTE;
  VolOffsets->RampLin  =   0x08;   //Very Fast Mute for UPA beeps, need to be checked
  VolOffsets->RampDB   =  0x320; //Very Fast Mute for UPA beeps, need to be checked


  VolOffsets->CE       =  CHANNEL_MUTE;
  VolOffsets->SUB      =  CHANNEL_MUTE;
}

/*******************************************************************************
 *
 * FUNCTION: ADAS_PSMSound::vSetandTriggerHFPSound(tU8 tUPAErrorSound)
 *******************************************************************************/

void ADAS_PSMSound::vSetandTriggerPSMSound(tU8 tPSMSound)
{
  tBool Ret = (bIsPSMConfiguredAvailable() && bIsParkAssistlevelValid());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if(Ret)
  {
    ETG_TRACE_USR4(("ADAS_PSMSound::vSetandTriggerPSMSound() called "));
    if((tPSMSound == 0x01) &&(u8SlotDisplay != No_DISPLAY))
      m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_PSM_PHASE1,/*_poThisInterface*/this);
    else
      ETG_TRACE_USR4(("ADAS_PSMSound::Slot is not set"));

  }
  else
    ETG_TRACE_USR4(("ADAS_PSMSound:: Cannot trigger PSM Sound"));
}


/*******************************************************************************
*
* FUNCTION: ADAS_PSMSound::vSetLeftSlotSuitableDisplay(tU8 SlotDisplay)
*******************************************************************************/

void ADAS_PSMSound::vSetLeftSlotSuitableDisplay(tU8 SlotDisplay)
{
  ETG_TRACE_USR4(("ADAS_PSMSound::vSetLeftSlotSuitableDisplay() called : %d", SlotDisplay));
    if (SlotDisplay) // setting Slot Display if it is set
      u8SlotDisplay |= LEFT_DISPLAY;
    else
      u8SlotDisplay = tU8(u8SlotDisplay &(~LEFT_DISPLAY)); //resetting it if it is unset
}


/*******************************************************************************
*
* FUNCTION: ADAS_PSMSound::vSetRightSlotSuitableDisplay(tU8 SlotDisplay)
*******************************************************************************/

void ADAS_PSMSound::vSetRightSlotSuitableDisplay(tU8 SlotDisplay)
{
  ETG_TRACE_USR4(("ADAS_PSMSound::vSetRightSlotSuitableDisplay() called : %d", SlotDisplay));
  if (SlotDisplay) // setting Slot Display if it is set
    u8SlotDisplay |= RIGHT_DISPLAY;
  else
    u8SlotDisplay = tU8(u8SlotDisplay & (~RIGHT_DISPLAY)); //resetting it if it is unset
}

/*******************************************************************************
 *
 * FUNCTION: ADAS_PSMSound::GetRecurrencePeriod()
 *******************************************************************************/
tU16 ADAS_PSMSound::GetRecurrencePeriod(tU8 /*tBeepName*/)
{
  return RECURRENCE_PERIOD_MAX; // will not be used for HFP
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_PSMSound::GetBeepFilePath(tU8 tUBeepName)

 *******************************************************************************/
std::string ADAS_PSMSound::GetBeepFilePath(tU8 /*tUBeepName*/)
{
  //PSM is an ADR Beep, so no Beep file for it
  return std::string();
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_PSMSound::GetBeepVolume(tU8 tUBeepName)

 *******************************************************************************/

tS16 ADAS_PSMSound::GetBeepVolume(tU8 /*tUBeepName*/)
{
  return GetBeepVolume_withoutCANAttenuation();
};


tS16 ADAS_PSMSound::GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName)
{  tS16 VolumeDB;
  ETG_TRACE_USR4(("ADAS_PSMSound::GetBeepVolume"));
  AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);

  tS16 s16PSMObsoluteLevelOffset = -28 * VOLOFFSET_RESOLUTION; //base offset level
  tU8 u8PSMEOLLevelOffset = 0; //EOL Offset Level
  tS16 ts16PSMEOLLevelOffset;
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig","ParkingAidsPSMGain", &u8PSMEOLLevelOffset, 1)))
  {
    ETG_TRACE_USR4((" ADAS_PSM_EOL Offset level: %d",u8PSMEOLLevelOffset));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter"));
  }

  //ParkingAidsPSMGain is a 5-bit value in CANoe MSB bits of Byte6, so converting it to 8-bit value and shifting it by 3 bits to check if 5th bit is set or not for sign
  if ((u8PSMEOLLevelOffset << 3) & (0x80))
  {
    ts16PSMEOLLevelOffset = tS16(((tS16)u8PSMEOLLevelOffset + 0xFFE0) * (tS16)VOLOFFSET_RESOLUTION);
  }
  else
    ts16PSMEOLLevelOffset = tS16((tS16)(u8PSMEOLLevelOffset) * (tS16)VOLOFFSET_RESOLUTION);

  ETG_TRACE_USR4((" ADAS_PSM EOL offset : %x", ts16PSMEOLLevelOffset));
  //Park assist Volume Offset

  tU8 u8ParkAssistVol = 0;
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  odpParkAssitVol.s32GetData(u8ParkAssistVol);

  tS16 s16ParkAssistVolumeLevelOffset = m_poBeepAdasInstance->s16GetAdasVolumeOffset(u8ParkAssistVol);

  VolumeDB = tS16(ts16PSMEOLLevelOffset + s16PSMObsoluteLevelOffset + s16ParkAssistVolumeLevelOffset);

  (void)tUBeepName;
  return VolumeDB;


}

/*******************************************************************************
 *
 * FUNCTION: ADAS_PSMSound::bIsHFPConfiguredAvailable()
 *******************************************************************************/

tBool ADAS_PSMSound::bIsPSMConfiguredAvailable()
{
  tU8 u8PSMConfig = PSM_NOT_PRESENT;

  //read item from the KDS key's bytes- stream
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("HMIConfig","ADASPSM", &u8PSMConfig, 1)))
  {
    ETG_TRACE_USR4((" ADASPSM value configured in EOL: %d",u8PSMConfig));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter,returning PSM Config as NOT Present "));
  }
  if(PSM_NOT_PRESENT != u8PSMConfig)
    return TRUE;

  return FALSE;
}


/*******************************************************************************
 *
 * FUNCTION: ADAS_PSMSound::bIsParkAssistlevelValid()
 *******************************************************************************/
tBool ADAS_PSMSound::bIsParkAssistlevelValid()
{
  tU8 u8ParkAssistVol = 0;
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  odpParkAssitVol.s32GetData(u8ParkAssistVol);

  ETG_TRACE_USR4(("ADAS_PSMSound::bIsParkAssistlevelValid() called ,u8ParkAssistVol :%d", u8ParkAssistVol));

  if(VOLUME_LEVEL_0 < u8ParkAssistVol)
    return TRUE;
  return FALSE;
}



/*******************************************************************************
*
* FUNCTION:  ADAS_PSMSound::vTriggerStopBeep()

*******************************************************************************/


tVoid ADAS_PSMSound::vTriggerStopBeep(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_PSMSound::vTriggerStopBeep() called : %d",tBeepName));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if(bIsAdasSoundActive(tBeepName))
    m_poBeepAdasInstance->StopAdasBeep(tBeepName);
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_PSMSound::vClearAdasSoundStatus()

 *******************************************************************************/
tVoid ADAS_PSMSound::vClearAdasSoundStatus(tU8 /*tBeepName*/)
{
  ETG_TRACE_USR4(("ADAS_PSMSound::vClearAdasSoundStatus() called"));
  m_bPSMSoundStatus = false;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_PSMSound::bIsAdasSoundActive()

*******************************************************************************/

bool ADAS_PSMSound::bIsAdasSoundActive(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_PSMSound::bIsAdasSoundActive : %d",tBeepName));
  (tVoid)tBeepName;
  if(m_bPSMSoundStatus)
    return true;
  return false;
}

/*******************************************************************************
*
* FUNCTION:  ADAS_PSMSound::SetAdasSoundStatus()

*******************************************************************************/
void ADAS_PSMSound::SetAdasSoundStatus(tU8 tBeepName)
{
  (tVoid)tBeepName;
  ETG_TRACE_USR4(("ADAS_PSMSound::SetAdasSoundStatus() called"));
  m_bPSMSoundStatus = true;
}


/*******************************************************************************
*
* FUNCTION: ADAS_HFPSound::MessageNotification(PO_MessageConfig::enID MsgId)
*******************************************************************************/
// This function is called by post office on new incoming messages.
void ADAS_PSMSound::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR2(("ADAS_PSMSound::MessageNotification() called MsgId = %d", MsgId));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  switch (MsgId)
  {
  case (PO_MessageConfig::ID_CCAStart_ADASBeep) :
  {
    ETG_TRACE_USR2(("ID_CCAStart_ADASBeep received"));
    const ID_CCAStart_ADASBeep* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CCAStart_ADASBeep>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

    if ((pMsg->m_u8BeepType == EN_AUDIO_BEEP_PSM_PHASE1) || (pMsg->m_u8BeepType == EN_AUDIO_BEEP_PSM_PHASE2))
    {
      if((pMsg->m_u8ChannelZone == LEFT_DISPLAY) ||(pMsg->m_u8ChannelZone == RIGHT_DISPLAY)||(pMsg->m_u8ChannelZone == LEFT_RIGHT_DISPLAY))
      {
        u8SlotDisplay = pMsg->m_u8ChannelZone;
        m_poBeepAdasInstance->setAdasBeep(pMsg->m_u8BeepType, this);
      }
    }
    break;
  }
  case PO_MessageConfig::ID_DiagDefSet:
  {
    // Obtaining the Diag DefSet
    const ID_DiagDefSet* pMsgDefSet = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
    ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgDefSet);
    tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
    tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;
    if (((enDefSetType == EN_DEFSET_HMI) || (enDefSetType == EN_DEFSET_TEF)) && (enDefSetPhase == EN_DEFSET_FINISH))
    {
      if (!bIsPSMConfiguredAvailable())
        vTriggerStopBeep(); // should stop any running PSM Beep
    }
    break;
  }
  default:
    break;
  }
}
