/*******************************************************************************
 *
 * FILE:          ADAS_HFPSound.h
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   ADAS HFP Sound Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/

#ifndef _ADAS_HFP_H_
#define _ADAS_HFP_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#include "AdasNotification_IF.h"
#include "MessageConfig.h"
#include "InternalCommunicationAdapter.h"
#include "Beep_Adas.h"

class ADAS_HFPSound : public IF_MessageObserver<PO_MessageConfig::enID>, public AdasNotification_IF
{
public:
  ADAS_HFPSound(void);
  ADAS_HFPSound(Beep_Adas* poAdasInstance);
  virtual ~ADAS_HFPSound();

  virtual std::string GetBeepFilePath(tU8 tUBeepName);
  virtual tS16 GetBeepVolume(tU8 tUBeepName);
  virtual tS16 GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName=0);
  virtual tVoid GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff  *VolOffsets);
  //virtual tU8 GetBeepSource(tU8 tUBeepName);
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);

  tVoid vSetandTriggerHFPSound(tU8 tHFPSound);

  tVoid vTriggerStopBeep(tU8 tBeepName=0);
  virtual bool bIsAdasSoundActive(tU8 tBeepName=0);
  virtual tVoid SetAdasSoundStatus(tU8 tBeepName);
  tVoid vClearAdasSoundStatus(tU8 tBeepName);
  virtual tU16 GetRecurrencePeriod(tU8 tBeepName);

  tVoid vSetScanningSideForHFP(tU8 scanningSide);
  tVoid vTriggerHFP_Display(tU8 HFPDisplay);
  tVoid vResetHFPData();
private:
  Beep_Adas* m_poBeepAdasInstance;

  fc_audiomanager_tclService_Audio_Function *m_poAudio_Function;
    bool m_bHFPL1SoundStatus;
  bool m_bHFPL2SoundStatus;
  tU8 m_u8ScanningSide;


  tBool bIsHFPConfiguredAvailable();
  tBool bIsParkAssistlevelValid();


};


#endif
