/*******************************************************************************
 *
 * FILE:          ADAS_HFPSound.h
 *
 * SW-COMPONENT:  Beep Adas application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Beep Adas Class.
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/ADAS_HFPSound.cpp.trc.h"
#endif
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "../fc_audiomanager_service_Audio_Function.h"
#include "ADAS_HFPSound.h"
#include "Beep_defines.h"
#include "fc_audiomanager_trace.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAStartADASBeep.h"
#include "InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
ADAS_HFPSound::ADAS_HFPSound(void) : IF_MessageObserver<PO_MessageConfig::enID>("ADAS_HFPSound Constructor")
{
  ETG_TRACE_USR2(("ADAS_HFPSound::ADAS_HFPSound() constructor called"));
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;

  vResetHFPData();
}
/*******************************************************************************
 *
 * FUNCTION: ADAS_HFPSound::ADAS_HFPSound()
 *
 * DESCRIPTION: Constructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
ADAS_HFPSound::ADAS_HFPSound(Beep_Adas* poAdasInstance) : IF_MessageObserver<PO_MessageConfig::enID>("ADAS_HFPSound Constructor")
{
  ETG_TRACE_USR2(("ADAS_HFPSound::ADAS_HFPSound(Beep_Adas*) constructor called"));
  m_poBeepAdasInstance = poAdasInstance;
  m_poAudio_Function = poAdasInstance->m_poAudio_Function;

  vResetHFPData();
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_ADASBeep);
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
}
/*******************************************************************************
 *
 * FUNCTION: ADAS_HFPSound::~ADAS_HFPSound()
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
ADAS_HFPSound::~ADAS_HFPSound()
{
  ETG_TRACE_USR4(("~ADAS_HFPSound() entered."));
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  m_poBeepAdasInstance = NULL;
  m_poAudio_Function = NULL;
}


/*******************************************************************************
*
* FUNCTION: ADAS_HFPSound::~vResetHFPData()
* Resets the flags to defaults
*******************************************************************************/
tVoid ADAS_HFPSound::vResetHFPData()
{
  ETG_TRACE_USR4(("vResetHFPData"));
  m_bHFPL1SoundStatus = false;
  m_bHFPL2SoundStatus = false;
  m_u8ScanningSide = NO_SCANNING_SIDE;
}
/*******************************************************************************
 *
 * FUNCTION: ADAS_HFPSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
 *
 * DESCRIPTION: Interface function to get volume offsets for Beep
 *
 * PARAMETER: tU8 tUBeepName
 *
 * RETURNVALUE: tVoid
 *
 *******************************************************************************/
tVoid ADAS_HFPSound::GetBeepVolumeOffsets(tU8 tUBeepName, BeepControlData::ChVolOff *VolOffsets)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::GetBeepVolumeOffsets()  BeepName:%d", tUBeepName));

  VolOffsets->LF = CHANNEL_MUTE;
  VolOffsets->RF = CHANNEL_MUTE;
  if ((tUBeepName == EN_AUDIO_BEEP_HFP_LVL2_PHASE1) || (tUBeepName == EN_AUDIO_BEEP_HFP_LVL2_PHASE2))
  {
    switch (m_u8ScanningSide)
    {
      case LEFT_SIDE:
        VolOffsets->LF = 0;
        break;
      case RIGHT_SIDE:
        VolOffsets->RF = 0;
        break;
      default:
        break;
    }
  }
  else
  {
    VolOffsets->LF = 0;
    VolOffsets->RF = 0;
  }
  VolOffsets->LR       =  CHANNEL_MUTE;
  VolOffsets->RR       =  CHANNEL_MUTE;
  VolOffsets->RampLin  =   0x08;   //Very Fast Mute for UPA beeps, need to be checked
  VolOffsets->RampDB   =  0x320; //Very Fast Mute for UPA beeps, need to be checked


  VolOffsets->CE       =  CHANNEL_MUTE;
  VolOffsets->SUB      =  CHANNEL_MUTE;
}

/*******************************************************************************
 *
 * FUNCTION: ADAS_HFPSound::vSetandTriggerHFPSound(tU8 tUPAErrorSound)
 *******************************************************************************/

void ADAS_HFPSound::vSetandTriggerHFPSound(tU8 tHFPSound)
{
  tBool Ret = (bIsHFPConfiguredAvailable() && bIsParkAssistlevelValid());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if(Ret)
  {
    ETG_TRACE_USR4(("ADAS_HFPSound::vSetandTriggerHFPSound() called : %d, Scanning side : %d", tHFPSound,m_u8ScanningSide));
    if(tHFPSound == 0x01) //Level1 HFP Sound
      m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_HFP_LVL1_PHASE1,/*_poThisInterface*/this);
    else if((tHFPSound == 0x02)&((m_u8ScanningSide == LEFT_SIDE)||(m_u8ScanningSide == RIGHT_SIDE))) //level2 HFP Sound
      m_poBeepAdasInstance->setAdasBeep(EN_AUDIO_BEEP_HFP_LVL2_PHASE1,/*_poThisInterface*/this);
    else
    {

    }

  }
  else
    ETG_TRACE_USR4(("ADAS_HFPSound:: Cannot trigger HFP Sound"));
}

/*******************************************************************************
 *
 * FUNCTION: ADAS_HFPSound::GetRecurrencePeriod()
 *******************************************************************************/
tU16 ADAS_HFPSound::GetRecurrencePeriod(tU8 /*tBeepName*/)
{
  return RECURRENCE_PERIOD_MAX; // will not be used for HFP
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_HFPSound::GetBeepFilePath(tU8 tUBeepName)

 *******************************************************************************/
std::string ADAS_HFPSound::GetBeepFilePath(tU8 /*tUBeepName*/)
{
  //HFP is an ADR Beep, so no Beep file for it
  return std::string();
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_HFPSound::GetBeepVolume(tU8 tUBeepName)

 *******************************************************************************/

tS16 ADAS_HFPSound::GetBeepVolume(tU8 /*tUBeepName*/)
{
  return GetBeepVolume_withoutCANAttenuation();
};


tS16 ADAS_HFPSound::GetBeepVolume_withoutCANAttenuation(tU8 tUBeepName)
{

  tS16 VolumeDB;
  ETG_TRACE_USR4(("ADAS_HFPSound::GetBeepVolume"));
  AUD_POINTER_CHECK_CALL(m_poBeepAdasInstance);

  tS16 s16HFPObsoluteLevelOffset = -28 * VOLOFFSET_RESOLUTION; //base offset level
  tU8 u8HFPEOLLevelOffset = 0; //EOL Offset Level
  tS16 ts16HFPEOLLevelOffset;
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig","ParkingAidsHFPGain", &u8HFPEOLLevelOffset, 1)))
  {
    ETG_TRACE_USR4((" ADAS_HFP_EOL Offset level: %d",u8HFPEOLLevelOffset));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter"));
  }

  //ParkingAidsHFPGain is a 5-bit value in CANoe MSB bits of Byte6, so converting it to 8-bit value and shifting it by 3 bits to check if 5th bit is set or not for sign
  if ((u8HFPEOLLevelOffset << 3) & (0x80))
  {
    ts16HFPEOLLevelOffset = tS16(((tS16)u8HFPEOLLevelOffset + 0xFFE0) * (tS16)VOLOFFSET_RESOLUTION);
  }
  else
    ts16HFPEOLLevelOffset = tS16((tS16)(u8HFPEOLLevelOffset)* (tS16)VOLOFFSET_RESOLUTION);

  ETG_TRACE_USR4((" ADAS_HFP EOL offset : %x", ts16HFPEOLLevelOffset));
  //Park assist Volume Offset

  tU8 u8ParkAssistVol = 0;
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  odpParkAssitVol.s32GetData(u8ParkAssistVol);

  tS16 s16ParkAssistVolumeLevelOffset = m_poBeepAdasInstance->s16GetAdasVolumeOffset(u8ParkAssistVol);

  VolumeDB = tS16(ts16HFPEOLLevelOffset + s16HFPObsoluteLevelOffset + s16ParkAssistVolumeLevelOffset);

  (void)tUBeepName;
  return VolumeDB;

}

/*******************************************************************************
 *
 * FUNCTION: ADAS_HFPSound::bIsHFPConfiguredAvailable()
 *******************************************************************************/

tBool ADAS_HFPSound::bIsHFPConfiguredAvailable()
{
  tU8 u8HFPConfig = HFP_NOT_PRESENT;

  //read item from the KDS key's bytes- stream
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("HMIConfig","CFGADASAPA", &u8HFPConfig, 1)))
  {
    ETG_TRACE_USR4((" ADASHFP value configured in EOL: %d",u8HFPConfig));
  }
  else
  {
    ETG_TRACE_ERR(("Error in reading EOL Parameter,returning HFP Config as NOT Present "));
  }
  if(HFP_NOT_PRESENT != u8HFPConfig)
    return TRUE;

  return FALSE;
}


/*******************************************************************************
 *
 * FUNCTION: ADAS_HFPSound::bIsParkAssistlevelValid()
 *******************************************************************************/
tBool ADAS_HFPSound::bIsParkAssistlevelValid()
{
  tU8 u8ParkAssistVol = 0;
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  odpParkAssitVol.s32GetData(u8ParkAssistVol);

  ETG_TRACE_USR4(("ADAS_HFPSound::bIsParkAssistlevelValid() called ,u8ParkAssistVol :%d", u8ParkAssistVol));

  if(VOLUME_LEVEL_0 < u8ParkAssistVol)
    return TRUE;
  return FALSE;
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_HFPSound::vTriggerStopBeep()

 *******************************************************************************/


tVoid ADAS_HFPSound::vTriggerStopBeep(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::vTriggerStopBeep() called"));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  if(bIsAdasSoundActive(tBeepName))
    m_poBeepAdasInstance->StopAdasBeep(tBeepName);
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_HFPSound::vClearAdasSoundStatus()

 *******************************************************************************/
tVoid ADAS_HFPSound::vClearAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::vClearAdasSoundStatus() called"));
  if(tBeepName == EN_AUDIO_BEEP_HFP_LVL1_PHASE1)
    m_bHFPL1SoundStatus = false;
  else if (tBeepName == EN_AUDIO_BEEP_HFP_LVL2_PHASE1)
    m_bHFPL2SoundStatus = false;
  else
  {/*do nothing*/  }
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_HFPSound::bIsAdasSoundActive()

 *******************************************************************************/

bool ADAS_HFPSound::bIsAdasSoundActive(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::bIsAdasSoundActive() : %d",tBeepName));
  return ((tBeepName == EN_AUDIO_BEEP_HFP_LVL1_PHASE1)?m_bHFPL1SoundStatus:((tBeepName == EN_AUDIO_BEEP_HFP_LVL2_PHASE1)?m_bHFPL2SoundStatus:(m_bHFPL1SoundStatus||m_bHFPL2SoundStatus)));
}

/*******************************************************************************
 *
 * FUNCTION:  ADAS_HFPSound::SetAdasSoundStatus()

 *******************************************************************************/
void ADAS_HFPSound::SetAdasSoundStatus(tU8 tBeepName)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::SetAdasSoundStatus() called : %d",tBeepName));
  if(tBeepName == EN_AUDIO_BEEP_HFP_LVL1_PHASE1)
    m_bHFPL1SoundStatus = true;
  else if (tBeepName == EN_AUDIO_BEEP_HFP_LVL2_PHASE1)
    m_bHFPL2SoundStatus = true;
  else
  {/*do nothing*/  }
}

/*******************************************************************************
*
* FUNCTION: ADAS_HFPSound::MessageNotification(PO_MessageConfig::enID MsgId)
*******************************************************************************/
// This function is called by post office on new incoming messages.
void ADAS_HFPSound::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR2(("ADAS_HFPSound::MessageNotification() called MsgId = %d", MsgId));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poBeepAdasInstance->m_poBeepController);
  switch (MsgId)
  {
    case (PO_MessageConfig::ID_CCAStart_ADASBeep):
    {
      ETG_TRACE_USR2(("ID_CCAStart_ADASBeep received"));
      const ID_CCAStart_ADASBeep* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CCAStart_ADASBeep>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      // considering obstacle zone front left and front right received from TTFis for scanning side
      if ((pMsg->m_u8BeepType == EN_AUDIO_BEEP_HFP_LVL1_PHASE1) || (pMsg->m_u8BeepType == EN_AUDIO_BEEP_HFP_LVL2_PHASE1))
      {
        if((pMsg->m_u8ChannelZone == LEFT_SIDE)||(pMsg->m_u8ChannelZone == RIGHT_SIDE))
        {
          vSetScanningSideForHFP(pMsg->m_u8ChannelZone);
          m_poBeepAdasInstance->setAdasBeep(pMsg->m_u8BeepType, this);
        }
      }
      break;
    }
    case PO_MessageConfig::ID_DiagDefSet:
    {
      // Obtaining the Diag DefSet
      const ID_DiagDefSet* pMsgDefSet = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
      ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgDefSet);
      tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
      tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;
      if (((enDefSetType == EN_DEFSET_HMI) || (enDefSetType == EN_DEFSET_TEF)) && (enDefSetPhase == EN_DEFSET_FINISH))
      {
        if (!bIsHFPConfiguredAvailable() && bIsAdasSoundActive())
          vTriggerStopBeep();
      }
      break;
    }
    default:
      break;
  }
}

/*******************************************************************************
*
* FUNCTION: ADAS_HFPSound::vSetScanningSideForHFP(tU8 scanningSide)
*******************************************************************************/
tVoid ADAS_HFPSound::vSetScanningSideForHFP(tU8 scanningSide)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::vSetScanningSideForHFP() called"));
  m_u8ScanningSide = scanningSide;
}
tVoid ADAS_HFPSound::vTriggerHFP_Display(tU8 HFPDisplay)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::vTriggerHFP_Display() called with current value %d",HFPDisplay));
  if((HFPDisplay==1) || (HFPDisplay==2) || (HFPDisplay==3))
  {
    if(!(m_poAudio_Function->bIsHFPActive()))
  {
    ETG_TRACE_USR4(("Received HFP value is: %d",HFPDisplay));
    m_poAudio_Function->HFPDisplay_Active(true);
  }
  }
  else
  {
    ETG_TRACE_USR4(("Received HFP value is: %d",HFPDisplay));
    m_poAudio_Function->HFPDisplay_Active(false);
  }
}
