/*
 * aud_gio_dbus_audproc_proxy.cpp
 *
 *  Created on: Apr 5, 2016
 *      Author: rjk2kor
 */


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUDIOMANAGER_AUDPROCPROXY
#include "trcGenProj/Header/aud_gio_dbus_audproc_proxy.cpp.trc.h"
#endif

#include "aud_gio_dbus_audproc_proxy.h"
using namespace std;

#define AUDIO_PROCESS_BUS_NAME     "org.bosch.audproc.service"
#define AUDIO_PROCESS_OBJECT_PATH  "/"

#define DATA_OFFSET_MSG_SIZE 3
#define COMMAND_DATA_RESERVED 0
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Startup/ID_NotifyAudioProcess.h"
/**
 * Constructor
 */
aud_gio_dbus_audproc_proxy::aud_gio_dbus_audproc_proxy(aud_gio_dbus_bus_watcher* pWatcher,GBusType bus_type)
:
m_poProxy(NULL)
,m_pWatcher(pWatcher)
,m_busname(AUDIO_PROCESS_BUS_NAME)
,m_objpath(AUDIO_PROCESS_OBJECT_PATH)
,m_bus_type(bus_type)
{
  if(m_pWatcher)
  {
    //Register for notifications with bus name watcher
    if(!m_pWatcher->bRegisterNotifyBusName(m_busname.c_str(),this))
      NORMAL_M_ASSERT_ALWAYS();
  }
  fc_audiomanager_tclApp::theServer()->vRegisterTraceInputs(TRC::enAudioProcessProxy, this);//for sync with arkamys
}

/**
 * Destructor
 */
aud_gio_dbus_audproc_proxy::~aud_gio_dbus_audproc_proxy()
{
  if(m_pWatcher)
  {
    //Unregister for notifications
    m_pWatcher->vUnRegisterNotifyBusName(m_busname.c_str());
    m_pWatcher = NULL;
  }
  //Delete proxy object
  if(m_poProxy)
  {
    g_object_unref (m_poProxy);//Drop the reference to proxy
    m_poProxy = NULL;
  }
}
/**
 * Function triggered by the watcher when the server becomes available
 */
void aud_gio_dbus_audproc_proxy::vOnServerAvailable(string sBusName)
{
  ETG_TRACE_USR4(("Server is available now : %s",sBusName.c_str()));

  GError *error = NULL;
  m_poProxy = org_bosch_audproc_service_proxy_new_for_bus_sync(
                m_bus_type,
                G_DBUS_PROXY_FLAGS_NONE,//G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIESNot loading properties at startup as requested by patrick
                m_busname.c_str(),
                m_objpath.c_str(),
                NULL,&error);
  if(m_poProxy == NULL)
  {
    ETG_TRACE_FATAL(("Failed to create a proxy : %s",error->message));
    //Free error
    g_error_free(error);
  }
  else
  {
    ETG_TRACE_USR4(("Proxy to Audio Process created successfully"));

    tU32 msgSize = DATA_OFFSET_MSG_SIZE;
    tPU8 pu8Message = OSAL_NEW tU8[msgSize];

    if (pu8Message == OSAL_NULL) // Lint wants a check
    {
      ETG_TRACE_FATAL(("Could not allocate %i bytes.", msgSize));
      return;
    }
    pu8Message[0] = (tU8)TRC::enAudioProcessProxy;
    pu8Message[1] = pu8Message[2] =  COMMAND_DATA_RESERVED;//needed for loopback msg


    ETG_TRACE_USR4(("Message to 'other thread': Size=%i, Data=%02x", msgSize, ETG_LIST_LEN(msgSize), ETG_LIST_PTR_T8(pu8Message)));
    // Can be called from different threads, so bring to Audio CCA thread
    fc_audiomanager_tclApp::vRxFromOtherThreads(msgSize, pu8Message);
    OSAL_DELETE []pu8Message;

  }
}
/**
 * Function triggered by the watcher when the server becomes unavailable
 */
void aud_gio_dbus_audproc_proxy::vOnServerUnAvailable(string sBusName)
{
  ETG_TRACE_USR4(("Server is not available now : %s",sBusName.c_str()));
  if(m_poProxy)
  {
    ETG_TRACE_USR4(("Dropped reference to proxy"));
    g_object_unref (m_poProxy);//Drop the reference to proxy
    m_poProxy = NULL;
  }
}
/**
 * Internal helper function to register for signals and property notifications
 */
void aud_gio_dbus_audproc_proxy::vRegisterNotifications()
{
}
/**
 * Internal helper function to unregister for signals and property notifications
 */
void aud_gio_dbus_audproc_proxy::vUnRegisterNotifications()
{
}

// loopback function to send the notification about audio process proxy to arkamys
tVoid aud_gio_dbus_audproc_proxy::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("aud_gio_dbus_audproc_proxy::vTraceRx()"));

  // if no data is available do nothing
  if((size < DATA_OFFSET_MSG_SIZE) || (pcu8Data == OSAL_NULL))
  {
    ETG_TRACE_USR4(("aud_gio_dbus_audproc_proxy::vTraceRx() No data available to send"));
    return;
  }
  //Post message to Arkamys for synchronisation
  ID_NotifyAudioProcess oNotifyAudioProcess;
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyAudioProcess);
}
/****************************************************************************************************
                SYNCHRONOUS METHOD CALLS
******************************************************************************************************/
/**
* Synchronous method call  : get_version_sync
*/
bool aud_gio_dbus_audproc_proxy::get_version_sync(std::vector<tU32>& rfOutVersion,std::string& rfOutVersionString, std::string& rfOutVersionComment)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::get_version"));
  bool bretval = false;
  if(m_poProxy)
  {
    GVariant* version = NULL;

    gchar* versionstring = NULL;
    gchar* versioncomment = NULL;
    GError* error = NULL;
    if(org_bosch_audproc_service_call_audproc_get_version_sync(m_poProxy,&version,&versionstring,&versioncomment,NULL,&error))
    {
      if(versionstring != NULL)
      {
        rfOutVersionString = versionstring;
      }
      if(versioncomment)
      {
        rfOutVersionComment = versioncomment;
      }
      if(version)
      {
        GVariantIter *iter= NULL;
        g_variant_get(version, "au", &iter);
        tU32 val;
        while(g_variant_iter_loop(iter,"u",&val))
        {
          rfOutVersion.push_back(val);
        }
        g_variant_iter_free(iter);
      }
      bretval= true;
      ETG_TRACE_USR4(("aud_gio_dbus_audproc_proxy::get_version_sync VersionString  : %s", rfOutVersionString.c_str()));
      ETG_TRACE_USR4(("aud_gio_dbus_audproc_proxy::get_version_sync VersionComment : %s", rfOutVersionComment.c_str()));
    }
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
    g_free(versionstring);
    g_free(versioncomment);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }
  return bretval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocGetStatus_sync()
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocGetStatus"));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_get_status_sync(m_poProxy,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocTerminate_sync()
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocTerminate"));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_terminate_sync(m_poProxy,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocSetupDebug(tU8 u8AudprocSelectMode)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocSetupDebug, AudprocSelectMode : %d", u8AudprocSelectMode));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_setup_debug_sync(m_poProxy,u8AudprocSelectMode,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocCreate_sync()
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocCreate"));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_create_sync(m_poProxy,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocInitialize_sync(tU8 u8AudprocSourceId,const char* AudprocConfigurationFile)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocInitialize, SourceID : %d, Config File : %s ", u8AudprocSourceId,AudprocConfigurationFile));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_initialize_sync(m_poProxy,u8AudprocSourceId,AudprocConfigurationFile,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocSetConfiguration_sync(tU8 u8AudprocSourceId,const char* AudprocConfigurationFile)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocSetConfiguration, SourceID : %d, Config File : %s ", u8AudprocSourceId,AudprocConfigurationFile));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_set_configuration_sync(m_poProxy,u8AudprocSourceId,AudprocConfigurationFile,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocDestroy_sync(tU8 u8AudprocSourceId)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocDestroy, SourceID : %d", u8AudprocSourceId));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_destroy_sync(m_poProxy,u8AudprocSourceId,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocSetParam_sync(tU8 u8AudprocSourceId,
                            tU32 ParameterId,
                            tU8 ParamType,
                            tU32 uParameter,
                            tS32 sParameter)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocSetParam, SourceID : %d, Param ID : %d, Param Type : %d, Param :%d, Param Signed : %d", u8AudprocSourceId,ParameterId,ParamType,uParameter,sParameter));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_set_param_sync(m_poProxy,u8AudprocSourceId,ParameterId,ParamType,uParameter,sParameter,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
AudProc_Error_e aud_gio_dbus_audproc_proxy::AudprocWriteData_sync(tU8 u8AudprocSourceId,tU32 ParameterId,const tU8* ptrdata, tU32 datalength, tU8*& rfOutdata)
{
  AudProc_Error_e retval = AUDPROC_ERR_UNKNOWN;
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocWriteData, SourceID : %d, Param ID: %d , Length : %d", u8AudprocSourceId,ParameterId,datalength));
  tU32 outdata_len = 0;
  if(m_poProxy && ptrdata && datalength)
  {
    GVariant *value = g_variant_new_fixed_array(G_VARIANT_TYPE_BYTE, ptrdata,datalength,sizeof(tU8));
    GError *error = NULL;
    GVariant *response;

    org_bosch_audproc_service_call_audproc_write_data_sync(m_poProxy,u8AudprocSourceId,ParameterId,value,&response,NULL,&error);
    if(error)
    {
      retval = (AudProc_Error_e) error->code;
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
    else
    {
      retval = AUDPROC_ERR_OK;
      //Copy the data from the variant and write it to rf out parameters
      GVariantIter *iter = NULL;
      g_variant_get(response, "ay", &iter);//Initialize the iterator
      while(g_variant_iter_loop(iter,"y",&rfOutdata[outdata_len++]))
      {
      }
      g_variant_iter_free(iter);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }
  return retval;
}
/**
*
*/
AudProc_Error_e aud_gio_dbus_audproc_proxy::AudprocReadData_sync(
                                  tU8 u8AudprocSourceId,
                                  tU32 ParameterId,
                                  const tU8* ReadInfos,
                                  tU32 readinfo_len,
                                  tU8*& rfOutdata,
                                  tU32& outdata_len)
{
  AudProc_Error_e retval = AUDPROC_ERR_UNKNOWN;
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocReadData, SourceID : %d, Param ID: %d", u8AudprocSourceId,ParameterId));

  outdata_len = 0;

  if(m_poProxy)
  {
    //Create a gvariant with the input data
    GVariant *value = g_variant_new_fixed_array(G_VARIANT_TYPE_BYTE, ReadInfos,readinfo_len,sizeof(tU8));
    GVariant *response;
    GError *error = NULL;

    //Make the call
    org_bosch_audproc_service_call_audproc_read_data_sync (
      m_poProxy,
      u8AudprocSourceId,
      ParameterId,
      value,
      &response,
      NULL,
      &error);

    if(error)
    {
      retval = (AudProc_Error_e) error->code;
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
    else
    {
      retval = AUDPROC_ERR_OK;
      //Copy the data from the variant and write it to rf out parameters
      GVariantIter *iter = NULL;
      g_variant_get(response, "ay", &iter);//Initialize the iterator
      while(g_variant_iter_loop(iter,"y",&rfOutdata[outdata_len++]))
      {
      }
      g_variant_iter_free(iter);
    }

    if(outdata_len)//TODO: remove this workaround once the reset issue is fixed
      outdata_len = outdata_len - 1 ;
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocGetAudprocConfiguration_sync(std::string& rfOutDatasetName, std::vector<tU32>& rfOutAudprocProperties)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocGetAudprocConfiguration"));
  bool retval = false;
  if(m_poProxy)
  {
    gchar* datasetname=NULL;
  #if 0
    GVariant* audprocproperties= NULL;
  #else
    guint  audprocproperties= 0;
  #endif
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_get_audproc_configuration_sync(m_poProxy,&datasetname,&audprocproperties,NULL,&error);
    if(datasetname)
    {
      rfOutDatasetName = datasetname;
      g_free(datasetname);
    }
  #if 0
    if(audprocproperties)
    {
      GVariantIter *iter= NULL;
      g_variant_get(audprocproperties, "au", &iter);
      tU32 val;
      while(g_variant_iter_loop(iter,"u",&val))
      {
        rfOutAudprocProperties.push_back(val);
      }
      g_variant_iter_free(iter);
    }
  #else
    rfOutAudprocProperties.push_back(audprocproperties);
  #endif
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocStartAudio_sync(tU8 u8AudprocSourceId)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocStartAudio, Source ID : %d", u8AudprocSourceId));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_start_audio_sync(m_poProxy,u8AudprocSourceId,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocStopAudio_sync(tU8 u8AudprocSourceId)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocStopAudio, Source ID : %d", u8AudprocSourceId));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_stop_audio_sync(m_poProxy,u8AudprocSourceId,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocMute_sync()
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocMute_sync"));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_mute_sync(m_poProxy,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocSourceActivity_sync(tU8 AudprocSourceMapId,tU8 u8AudprocSourceActivity)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::u8AudprocSourceActivity, SourceMap ID : %d, Source Activity :%d",AudprocSourceMapId,u8AudprocSourceActivity));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_source_activity_sync(m_poProxy,AudprocSourceMapId,u8AudprocSourceActivity,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::AudprocSourceSelect(tU8 u8AudprocSourceSelectMode, tU8 u8AudprocSourceId, const char* AudprocAlsaDev)
{
  ETG_TRACE_USR4(("Invoke Sync Call ::AudprocSourceSelect, Select Mode : %d, Source ID :%d, AlsaDev : %s",u8AudprocSourceSelectMode,u8AudprocSourceId,AudprocAlsaDev));
  bool retval = false;
  if(m_poProxy)
  {
    GError* error = NULL;
    retval = org_bosch_audproc_service_call_audproc_source_select_sync(m_poProxy,u8AudprocSourceSelectMode,u8AudprocSourceId,AudprocAlsaDev,NULL,&error);
    if(error)
    {
      ETG_TRACE_USR3(("Error invoking method call : %s ", error->message));
      g_error_free(error);
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**********************************************************************************
*                                PROPERTY SETTERS
***********************************************************************************/
/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysAvcActivate(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_avc_activate(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysByPassActivate(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_by_pass_activate(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysInputLevelDeviation(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_input_level_deviation(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysCurrentSpeed(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_current_speed(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysCurrentVolumeStep(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_current_volume_step(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysAmbienceSelect(tS32 value)
{
  bool retval = false;

  if(m_poProxy)
  {
    retval = true;

    /*GVariant *send_value;
    //Creating a variant builder to add the data
    GVariantBuilder builder;
    g_variant_builder_init(&builder,G_VARIANT_TYPE_ARRAY);

    for(std::vector<tS32>::iterator it = value.begin(); it != value.end();it++)
    {
      g_variant_builder_add_value(&builder,g_variant_new_int32(*it));//Add values to the builder
    }
    send_value = g_variant_builder_end(&builder);//Get the data from the builder, unref not necessary*/

    org_bosch_audproc_service_set_apl_arkamys_ambience_select(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }


  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysLevelLoss(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_level_loss(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplArkamysLibraryVersion(std::vector<tS32> value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    GVariant *send_value;
    //Creating a variant builder to add the data
    GVariantBuilder builder;
    g_variant_builder_init(&builder,G_VARIANT_TYPE_ARRAY);

    for(std::vector<tS32>::iterator it = value.begin(); it != value.end();it++)
    {
      g_variant_builder_add_value(&builder,g_variant_new_int32(*it));//Add values to the builder
    }
    send_value = g_variant_builder_end(&builder);
    org_bosch_audproc_service_set_apl_arkamys_library_version(m_poProxy,send_value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
* Setter for property : aplArkamysCurrentVolumeAttenuation
*/
bool  aud_gio_dbus_audproc_proxy::set_aplArkamysCurrentVolumeAttenuation(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_curr_vol_attenuation(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
bool aud_gio_dbus_audproc_proxy::set_aplMicLvlWatchRefInt(tU32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_mic_lvl_watch_ref_int(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
* Setter for property : aplArkamysCurrentVolumeAttenuation
*/
bool  aud_gio_dbus_audproc_proxy::set_aplMicLvl(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_mic_lvl(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
* Setter for property : aplAudioMode
*/
bool  aud_gio_dbus_audproc_proxy::set_aplAudioMode(tU32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_audio_mode(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
* Setter for property : set_aplArkamysFlush
*/
bool  aud_gio_dbus_audproc_proxy::set_aplArkamysFlush(tS32 value)
{
  bool retval = false;
  if(m_poProxy)
  {
    retval = true;
    org_bosch_audproc_service_set_apl_arkamys_flush(m_poProxy,value);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**********************************************************************************
*                                PROPERTY GETTERS
***********************************************************************************/
/**
*
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysAvcActivate()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_avc_activate(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysByPassActivate()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_by_pass_activate(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
*
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysInputLevelDeviation()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_input_level_deviation(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysCurrentSpeed()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_current_speed(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
*
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysCurrentVolumeStep()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_current_volume_step(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
* Getter for Property : aplArkamysAmbienceSelect
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysAmbienceSelect()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    /*GVariant *value,*child;
    child = NULL;
    GVariantIter iter;*/
    retval = org_bosch_audproc_service_get_apl_arkamys_ambience_select(m_poProxy);
    //Intialize the iterator
    /*g_variant_iter_init(&iter,value);
    //Read elements
    while((child == g_variant_iter_next_value (&iter)))//When reaching the end of the container, g_variant_iter_next_value returns NULL
    {
      if(g_variant_is_of_type(child,G_VARIANT_TYPE_INT32))
      {
        retval.push_back(g_variant_get_int32(child));
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
    }*/
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }
  return retval;
}

/**
* Getter for property : aplArkamysLevelLoss
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysLevelLoss()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_level_loss(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
* Getter for property : aplArkamysLibraryVersion
*/
std::vector<tS32>  aud_gio_dbus_audproc_proxy::get_aplArkamysLibraryVersion()
{

  std::vector<tS32> retval;
  if(m_poProxy)
  {
    GVariant *value,*child;
    child = NULL;
    GVariantIter iter;
    value = org_bosch_audproc_service_get_apl_arkamys_library_version(m_poProxy);

    if(value != NULL)
    {
      //Intialize the iterator
      g_variant_iter_init(&iter,value);
      //Read elements
      while((child = g_variant_iter_next_value (&iter)))//When reaching the end of the container, g_variant_iter_next_value returns NULL
      {
        if(g_variant_is_of_type(child,G_VARIANT_TYPE_INT32))
        {
          retval.push_back(g_variant_get_int32(child));
        }
        else
        {
          NORMAL_M_ASSERT_ALWAYS();
        }
      }
    }
    else
    {
    NORMAL_M_ASSERT_ALWAYS();
    }
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}

/**
* Getter for property : aplArkamysCurrentVolumeAttenuation
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysCurrentVolumeAttenuation()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_curr_vol_attenuation(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }
  return retval;
}
/**
* Getter for property : aplMicLvlWatchRefInt
*/
tU32  aud_gio_dbus_audproc_proxy::get_aplMicLvlWatchRefInt()
{
  tU32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_mic_lvl_watch_ref_int(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
* Getter for property : aplMicLvl
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplMicLvl()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_mic_lvl(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }
  return retval;
}

/**
* Getter for property : aplAudioMode
*/
tU32  aud_gio_dbus_audproc_proxy::get_aplAudioMode()
{
  tU32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_audio_mode(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }

  return retval;
}
/**
* Getter for property : aplArkamysFlush
*/
tS32  aud_gio_dbus_audproc_proxy::get_aplArkamysFlush()
{
  tS32 retval = ~0;
  if(m_poProxy)
  {
    retval = org_bosch_audproc_service_get_apl_arkamys_flush(m_poProxy);
  }
  else
  {
    ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
  }
  return retval;
}
