/**
 * @file ArkamysStateCalculatorRNAIVI2.cpp
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#include "ArkamysStateCalculatorRNAIVI2.h"


tU8 ArkamysStateCalculatorRNAIVI2::u8CalculateVirtualSubwooferState(tBool bEngineeringMode, ArkamysConfigRNAIVI2::tenSrcSetting enSource, tBool bRequestedMode)
{
  if(enSource == ArkamysConfigRNAIVI2::ARKAMYS_SOURCE_INVALID)
      return ArkamysConfigRNAIVI2::STATE_UNKNOWN;
  else if (bEngineeringMode || enSource == ArkamysConfigRNAIVI2::ARKAMYS_SOURCE_OTHER)
      return ArkamysConfigRNAIVI2::STATE_LINEAR;
  else if(!bRequestedMode)
    return ArkamysConfigRNAIVI2::STATE_OFF;

  return ArkamysConfigRNAIVI2::STATE_ON;


}


tenArkamysMode ArkamysStateCalculatorRNAIVI2::enCalculateArkamysMode(
                        ArkamysConfigRNAIVI2::tenArkamysAmplifier enAmplifier,
                        ArkamysConfigRNAIVI2::tenArkamysEOLLib enLibType,
                        tBool bLibraryMatch,
                        ArkamysConfigRNAIVI2::tenArkamysDeviceVariant enDevice,
                        tBool bValidEOL)
{

    if(!bValidEOL || !bLibraryMatch || enLibType == ArkamysConfigRNAIVI2::ARKAMYS_EOL_INVALID
            || enDevice == ArkamysConfigRNAIVI2::ARKAMYS_DEV_INVALID
            || enAmplifier != ArkamysConfigRNAIVI2::ARKAMYS_AMP_INTERNAL_AMPLIFIER)
      return EN_ARKAMYS_BYPASS;

    return EN_ARKAMYS_CLASSIC;

}

