/**
 * @file ArkamysFeatureHandlerRNAIVI2.h
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSFEATUREHANDLER_RNAIVI2_H_
#define ARKAMYSFEATUREHANDLER_RNAIVI2_H_

#include "Arkamys/ArkamysADRInterface.h"
#include "ArkamysEolInterfaceRNAIVI2.h"
#include "ArkamysConfigRNAIVI2.h"
#include "Arkamys/ArkamysCommInterface.h"
#include "AkActionQueueRNAIVI2.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysParameter.h"
#include "InternalComponentCommunication/Messages/mute/IDSetMute.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "fc_audiomanager_main.h"
#include "mute/stream/StreamMuteNotify_IF.h"
#include "InternalComponentCommunication/Messages/Diag/ID_CCA_GetDiagResult.h"

class ArkamysFeatureHandlerRNAIVI2: public StreamMuteNotify_IF, public IF_MessageObserver<PO_MessageConfig::enID>
{
   friend class AkActionRNAIVI2;
   friend class AkActionQueueRNAIVI2;
   friend class ArkamysEolInterfaceRNAIVI2;
   friend class ArkamysTuningHandlerRNAIVI2;
public:
   static ArkamysFeatureHandlerRNAIVI2* getInstance();
   ~ArkamysFeatureHandlerRNAIVI2();

   tBool bStartup(fc_audiomanager_tclApp* poMainAppl);

   void setLinearMode(tBool bLinearModeEnable);
   void setSource(ArkamysConfigRNAIVI2::tenSrcSetting enSource);

   void setVirtualSubwoofer(tBool bOn);

   void Mute();
   void Demute();

   void MessageNotification(PO_MessageConfig::enID MsgId);
   void AsppMessageRx(ID_ArkamysParameter arkamysParameter);

   static void vTimerCallback(tPVoid pvArg);
   void timerExpired(tPVoid pvArg);
   void vAsppOkCallback();
   void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);

   void TraceStatus();
   void SetArkamysCommInterface(ArkamysCommInterface *pArkamysCommInterface);
   void SetArkamysADRInterface(ArkamysADRInterface *pArkamysADRInterface);

   tenArkamysMode enGetAudioMode();

private:
#ifdef __AUDIO_UNIT_TESTING__
   FRIEND_TEST(ArkamysTestsRNAIVI2, Startup);
   FRIEND_TEST(ArkamysTestsRNAIVI2, EOLInterface);
   FRIEND_TEST(ArkamysTestsRNAIVI2, BassExciter);
   FRIEND_TEST(ArkamysTestsRNAIVI2, DiagLinearMode);
   FRIEND_TEST(ArkamysTestsRNAIVI2, DiagAudioMode);
   FRIEND_TEST(ArkamysTestsRNAIVI2, OtherSources);
   FRIEND_TEST(ArkamysTestsRNAIVI2, StatesCheck_PrimarySource);
   FRIEND_TEST(ArkamysTestsRNAIVI2, StatesCheck_SecondarySource);
   FRIEND_TEST(ArkamysTestsRNAIVI2, StatesCheck_OtherSource);
   FRIEND_TEST(ArkamysTestsRNAIVI2, MuteStatus);
   FRIEND_TEST(ArkamysTestsRNAIVI2, SBRAck);
   FRIEND_TEST(ArkamysTestsRNAIVI2, Others);
   FRIEND_TEST(ArkamysTestsRNAIVI2, ArkamysSourceGrps);
   FRIEND_TEST(ArkamysTestsRNAIVI2, EOLVersionCheck);
#endif
   ArkamysFeatureHandlerRNAIVI2();
   ArkamysFeatureHandlerRNAIVI2(const ArkamysFeatureHandlerRNAIVI2&);              // Prohibit use of copy constructor    (Rule of three)
   ArkamysFeatureHandlerRNAIVI2& operator =(const ArkamysFeatureHandlerRNAIVI2&);  // Prohibit use of assignment operator (Rule of three)

   /*
    * Busy state
    */
   typedef enum {
      ARKAMYS_FEATURE_STATE_INIT,
      ARKAMYS_FEATURE_STATE_IDLE,
      ARKAMYS_FEATURE_STATE_BUSY
   } tenArkamysHandlerState;
   tenArkamysHandlerState m_enState;

   /*
    * Pointers
    */

   InternalCommunicationAdapter  *m_pPO; // Pointer for post office access
   fc_audiomanager_tclApp        *m_poMainAppl;
   ArkamysCommInterface          *m_pArkamysCommInterface;
   tBool                         m_bDeleteArkamysCommInterface;
   ArkamysEolInterfaceRNAIVI2     *m_pEolInterface;
   ArkamysADRInterface           *m_pADRInterface;
   tBool                         m_bDeleteArkamysADRInterface;
   AkActionQueueRNAIVI2           m_ActionQueue;
   IF_DiagResultHandler*         m_poResultHandler;

   /*
    * System Settings
    */
   tU32  m_u32ReportedArkamysLib;      // Library version reported by ADR
   tU8   m_u8MuteRegId;
   tenArkamysMode   m_enArkamysMode;              //update to HMI -> Audio mode
   /*
    * Feature State relevant settings
    */
   tBool m_bEngModeActive;
   ArkamysConfigRNAIVI2::tenSrcSetting       m_enCurSourceSetting;
   ArkamysConfigRNAIVI2::tenSrcGrpSetting    m_enArkamysSourcrGrp;
   /*
    * Current Feature Settings
    */
   tU8    m_u8VirtualSubEnabled;
   tBool  m_bVirtualSubAvailable;

   void addVirtualSubwooferToActionQueue(tBool bOn);

   OSAL_tTimerHandle m_hTimer;
   void vStartTimer(OSAL_tMSecond milliseconds);
   void vStopTimer();

   tBool bUpdateVirtualSubwooferState();

   void vUpdateStatesAndApply();

   void vResetArkamysSettingsFlags();
   void vSetArkamysMode();
   void vSendArkamysSrcGrp(tenInternalSource enIntSource);

   ArkamysConfigRNAIVI2::tenArkamysAmplifier enGetKDSAmplifierInformation();
   ArkamysConfigRNAIVI2::tenArkamysDeviceVariant enGetKDSLibInformation();
   ArkamysConfigRNAIVI2::tenArkamysEOLLib enGetArkamysEOLLibType();
   tVoid vGetEOLVersionFormat(tU32 &u32Version);
   tBool m_bEntStreamMuted;

   //Diaglog Related
   void vHandleGetDiagResult();
};

#endif /* ARKAMYSFEATUREHANDLER_RNAIVI2_H_ */
