/**
 * @file ArkamysEolInterfaceRNAIVI2.cpp
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ARKAMYS
#include "trcGenProj/Header/ArkamysEolInterfaceRNAIVI2.cpp.trc.h"
#endif

#include "util/Macro.h"
#include "ArkamysEolInterfaceRNAIVI2.h"
#include "ArkamysFeatureHandlerRNAIVI2.h"
#include <netinet/in.h>

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#include "dp_diagdebug_if.h" // For Arkamys EOL Datapool

#include <queue>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#include "vd_adr3Msg_If.h"

#define ARKAMYS_USED_EOL_DATA_SIZE_CLASSIC (6600)

#define STATIC_ASSERT(_t, _msg) {typedef char (_msg)[(_t) ? 1 : -1]; _msg a; (void)a;} // Some lint maneuvers

// Number of elements
#define NELT(_array) (sizeof(_array) / sizeof(_array[0]))

ArkamysEolInterfaceRNAIVI2::ArkamysEolInterfaceRNAIVI2()
{
   m_enArkamysMode   = EN_ARKAMYS_BYPASS;

   m_pEolData = m_u8EolData;
   memset(m_pEolData, 0, sizeof(m_u8EolData));
   STATIC_ASSERT(sizeof(m_u8EolData) == ARKAMYS_EOL_MAX_DP_SIZE, Check_EolSizes);
   STATIC_ASSERT(sizeof(m_u8EolData) >= sizeof(ArkamysConfigRNAIVI2::tArkamysEolHeader), CheckHeaderAndEolSize);

   m_bDataLoadedFromDatapool = false;

 //  ASSERT_STATIC(sizeof(cArrayArkamysEolDefaultData) == ARKAMYS_EOL_DATA_SIZE_BYTE);

}

ArkamysEolInterfaceRNAIVI2::~ArkamysEolInterfaceRNAIVI2()
{
   m_pEolData = NULL;
}

ArkamysEolInterfaceRNAIVI2 *ArkamysEolInterfaceRNAIVI2::getInstance()
{
   static ArkamysEolInterfaceRNAIVI2 theInstance;
   return &theInstance;
}

tBool ArkamysEolInterfaceRNAIVI2::bLoadEOLDataFromFile(tS32 &s32Size)
{
   ETG_TRACE_USR4(("bLoadEOLDataFromFile() called."));

   tBool bRetVal = false;
   const char* D_EOL_FILE = "/var/opt/bosch/dynamic/audiomanager/AIVI2_EOL_DATA.bin";

   FILE* eolfile = NULL;

   eolfile = fopen(D_EOL_FILE, "rb");

   if(NULL == eolfile)
   {
     ETG_TRACE_ERR(("bLoadEOLDataFromFile::fail to open the arkamys eol file:  %s", D_EOL_FILE));
   }
   else
   {
     /* find out the length of the file
      */
     fseek(eolfile, 0L, SEEK_END);
     s32Size = (tS32)ftell(eolfile);
     fseek(eolfile, 0L, SEEK_SET); /* go back to the beginning */
     ETG_TRACE_USR2(("bLoadEOLDataFromFile:: size of arkamys EOL file %d", s32Size));
     if((s32Size > 0) && (s32Size <= ARKAMYS_EOL_MAX_DP_SIZE))
     {
       if(s32Size != (tS32)fread((void*)m_pEolData, 1, s32Size, eolfile))
       {
         ETG_TRACE_USR2(("bLoadEOLDataFromFile:: fail to read arkamys eol file"));
       }
       else
       {
         ETG_TRACE_USR2(("bLoadEOLDataFromFile:: reading of arkamys EOL file success"));
         bRetVal = true;
       }
     }

     fclose(eolfile);
   }

   return bRetVal;
}
tBool ArkamysEolInterfaceRNAIVI2::loadEolData()
{
   ETG_TRACE_USR4(("loadEolData() called."));
   tS32 dataSize = 0;

   // Fill m_pEolData with data from file
   tBool bIsLoadedFromFile = false;
   bIsLoadedFromFile = bLoadEOLDataFromFile(dataSize);
   ETG_TRACE_USR4(("EOL data loaded from file(%s)", bIsLoadedFromFile?"yes":"no"));

   //if file not exists then load from datapool
   if(!bIsLoadedFromFile)
   {
     // Fill m_pEolData with data from datapool
     dp_tclArkamysDPArkamys_Eol oDpEol;
     dataSize = oDpEol.s32GetData(m_pEolData, ARKAMYS_EOL_MAX_DP_SIZE);
     ETG_TRACE_USR4(("EOL data loaded from datapool"));
   }

   ETG_TRACE_USR4(("EOL data size() %d", dataSize));
   ETG_TRACE_USR4(("EOL data: %04x", ETG_LIST_LEN(ARKAMYS_USED_EOL_DATA_SIZE_CLASSIC), ETG_LIST_PTR_T8(m_pEolData)));

   // Check EOL contents read from datapool
   if(!checkEOLContent(dataSize))
   {
      m_bDataLoadedFromDatapool = false;
   }
   else
   {
      ETG_TRACE_USR4(("EOL data from datapool ok. Loading %i bytes.", getEOLFileSize()));
      NORMAL_M_ASSERT(m_pEolData == reinterpret_cast<tU8*>(m_u8EolData));
      m_bDataLoadedFromDatapool = true;
   }

   const char* SET_EOL_FILE = "/tmp/audiomanager/Arkamys_KDS_Set.txt";

   FILE* eolfile = NULL;

   eolfile = fopen(SET_EOL_FILE, "w");

   if(NULL == eolfile)
   {
     ETG_TRACE_ERR(("bLoadEOLDataFromFile::fail to open the arkamys eol file:  %s", SET_EOL_FILE));
   }
   else
   {
    tS32 s32Size = (tS32)fwrite(m_pEolData, sizeof(tU8), ARKAMYS_EOL_MAX_DP_SIZE, eolfile);
    ETG_TRACE_USR2(("size of arkamys set file %d", s32Size));
    fclose(eolfile);
   }

   ETG_TRACE_USR4(("EOL data loaded. Version: %i ", ntohl(getEOLArkamysLibVersion())));

   return true;
}

tBool ArkamysEolInterfaceRNAIVI2::checkEOLContent(tS32 s32FileSize)
{
  if(s32FileSize <= (tS32)ARKAMYS_EOL_HEADER_SIZE_BYTE_IVI2)
  {
    ETG_TRACE_ERR(("ArkamysEolInterfaceRNAIVI2::checkEOLContent(): Invalid file size (%i)", s32FileSize));
    return false;
  }

  if(ntohl(this->getEOLFileSize()) < (tU32)(ARKAMYS_USED_EOL_DATA_SIZE_CLASSIC - ARKAMYS_EOL_HEADER_SIZE_BYTE_IVI2))
  {
    ETG_TRACE_ERR(("ArkamysEolInterfaceRNAIVI2::checkEOLContent(): Invalid data size (%i) excluding header", ntohl(this->getEOLFileSize())));
    return false;
  }

  if(
     ((ntohl(this->getEOLLibType()) != ARKAMYS_LIBTYPE_CLASSIC) || (s32FileSize < ARKAMYS_USED_EOL_DATA_SIZE_CLASSIC))
    )
  {
    ETG_TRACE_ERR(("ArkamysEolInterfaceRNAIVI2::checkEOLContent(): Invalid file size (%i) for library type (%x)", s32FileSize, ntohl(this->getEOLLibType())));
    return false;
  }

  if ( (ntohl(this->getEOLArkamysLibVersion()) < ARKAMYS_LIB_MIN_VERSION) ||
      (ntohl(this->getEOLArkamysLibVersion()) > ARKAMYS_LIB_MAX_VERSION) )
  {
     ETG_TRACE_ERR(("ArkamysEolInterfaceRNAIVI2::checkEOLContent(): Arkamys Version %i not supported.", ntohl(this->getEOLArkamysLibVersion())));
     return false;
  }

  return true;
}

void ArkamysEolInterfaceRNAIVI2::setArkamysAudioMode(tenArkamysMode enArkamysMode)
{
   m_enArkamysMode = enArkamysMode;
   ETG_TRACE_USR4(("ArkamysEolInterfaceRNAIVI2::Arkamys audio mode set to %i.", ETG_CENUM(tenArkamysMode, m_enArkamysMode)));
   if((m_bDataLoadedFromDatapool) && (m_enArkamysMode == EN_ARKAMYS_CLASSIC))
   {
       tU8 u8Data[5];
       u8Data[0] = 0;//EOL load
       tU32 u32FileSize = (tU32)((this->getEOLFileSize()) + (ARKAMYS_EOL_HEADER_SIZE_BYTE_IVI2));
       u32FileSize = htonl(u32FileSize);//conversion to big-endian formart
       memcpy(&u8Data[1], &u32FileSize, sizeof(tU32));
       vd_adr3Msg_If::vSendMsg(VD_ADR3_INST_ID_LS_1, VD_ADR3_FKT_ID_ARKAMYS_CONFIG_DATA, VD_ADR3_OPTYPE_SET
               , sizeof(u8Data), u8Data, ARKAMYS_CONFIG_DATA);//send data to ADR3
   }
}

tU32 ArkamysEolInterfaceRNAIVI2::getEOLArkamysLibVersion()
{
   return reinterpret_cast<ArkamysConfigRNAIVI2::tArkamysEolHeader*>(m_pEolData) -> ArkamysLibVersion;
}

tBool ArkamysEolInterfaceRNAIVI2::isDataFromDatapool()
{
   return m_bDataLoadedFromDatapool;
}


tU32 ArkamysEolInterfaceRNAIVI2::getEolFileGenerationDate()
{
   return reinterpret_cast<ArkamysConfigRNAIVI2::tArkamysEolHeader*>(m_pEolData) -> EolFileGenerationDate;
}

tU32 ArkamysEolInterfaceRNAIVI2::getEOLLibType()
{
   return reinterpret_cast<ArkamysConfigRNAIVI2::tArkamysEolHeader*>(m_pEolData) -> LibType;
}

tU32 ArkamysEolInterfaceRNAIVI2::getEOLSteeringConfigurationType()
{
   return reinterpret_cast<ArkamysConfigRNAIVI2::tArkamysEolHeader*>(m_pEolData) -> ConfigurationType;
}


tU32 ArkamysEolInterfaceRNAIVI2::getEOLFileSize()
{
   return reinterpret_cast<ArkamysConfigRNAIVI2::tArkamysEolHeader*>(m_pEolData) -> DataSize;
}


void ArkamysEolInterfaceRNAIVI2::vSendDataToASPP(tU16 u16BlockID, tU16 u16ParamID, tU32 u32length, tU32 u32Data)
{

#define DATA_OFFSET 4
    ETG_TRACE_USR4(("vSendDataToASPP(0x%X, 0x%X, 0x%X, 0x%X) entered.", u16BlockID, u16ParamID, u32length, u32Data));

    tU32 u32address;
    u32address = (tU32)(u16BlockID);
    u32address = (tU32)(u32address << 2);
    u32address = (tU32)(u32address | u16ParamID);

    const tU32 headerSize  = 2 * sizeof(tU32); // Address + Length (both 4 byte)
    const tU32 messageSize = (tU32)(u32length + headerSize);
    ArkamysStaticMessage oArkamysStaticMessage;

    oArkamysStaticMessage.command = ArkamysStaticMessage::ArkamysOpTypeSet;
    oArkamysStaticMessage.size = messageSize;
    tU32 u32NtwAddr = htonl(u32address);
    tU32 u32NtwLen  = htonl(u32length);
    tU32 u32NtwData  = htonl(u32Data);
    tU32 u32DataOffSet = 0;
    memcpy(&oArkamysStaticMessage.data[0], &u32NtwAddr, sizeof(tU32)); // Address
    u32DataOffSet = (tU32)u32DataOffSet + DATA_OFFSET;
    memcpy(&oArkamysStaticMessage.data[u32DataOffSet], &u32NtwLen, sizeof(tU32)); // Length
    u32DataOffSet = (tU32)u32DataOffSet + DATA_OFFSET;
    memcpy(&oArkamysStaticMessage.data[u32DataOffSet], &u32NtwData, sizeof(tU32)); // Length

    if (ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pADRInterface != NULL)
    {
        ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pADRInterface->SendToADR(oArkamysStaticMessage);
    }
    else
    {
        ETG_TRACE_ERR(("ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pArkamysADRInterface == NULL"));
    }
}
/*
 * Send an ArkamysParameter "Get" request to SBR.
 */
void ArkamysEolInterfaceRNAIVI2::RequestDataFromASPP(tU32 address, tU32 length)
{
   ETG_TRACE_USR4(("RequestDataFromADR(0x%X, %i) entered.", address, length));
   ArkamysStaticMessage oArkamysStaticMessage;

   oArkamysStaticMessage.command = ArkamysStaticMessage::ArkamysOpTypeGet;
   oArkamysStaticMessage.size = 2 * sizeof(tU32);
   tU32 u32NtwAddr = htonl(address);
   tU32 u32NtwLen  = htonl(length);
   memcpy(&oArkamysStaticMessage.data[0], &u32NtwAddr, sizeof(tU32)); // Address
   memcpy(&oArkamysStaticMessage.data[sizeof(tU32)], &u32NtwLen, sizeof(tU32)); // Length

   if (ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pADRInterface != NULL)
   {
      ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pADRInterface->SendToADR(oArkamysStaticMessage);
   }
   else
   {
      ETG_TRACE_ERR(("ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pArkamysADRInterface == OSAL_NULL"));
   }
}


tBool ArkamysEolInterfaceRNAIVI2::setVirtualSubwoofer(tU8 u8State)
{
  ETG_TRACE_USR4(("ArkamysEolInterfaceRNAIVI2:setVirtualSubwoofer received with state %d", u8State));
  tBool bSuccess = false;
  ArkamysConfigRNAIVI2::tArkParamList *pArkLibParams = ArkamysConfigRNAIVI2::getArkamysParamConfig(ArkamysConfigRNAIVI2::ARK_BASS_ENHANCER);
  if(pArkLibParams == NULL)
    return bSuccess;

   if (u8State == (tU8)ArkamysConfigRNAIVI2::STATE_ON)
   {
       vSendDataToASPP((pArkLibParams->arkblockid), pArkLibParams->arkparamid, pArkLibParams->size, (tU32)u8State);
       bSuccess = true;
   }

   else
   {
       vSendDataToASPP(pArkLibParams->arkblockid, pArkLibParams->arkparamid, pArkLibParams->size, (tU32)u8State);
       bSuccess = true;
   }
   return bSuccess;

}


tBool ArkamysEolInterfaceRNAIVI2::SendFlush()
{
   tBool bSuccess = true;
   ETG_TRACE_USR4(("ArkamysEolInterfaceRNAIVI2::SendFlush()"));

   ArkamysConfigRNAIVI2::tArkParamList *pArkLibParams = ArkamysConfigRNAIVI2::getArkamysParamConfig(ArkamysConfigRNAIVI2::ARK_LIB_FLUSH);
   if(pArkLibParams == NULL)
     return bSuccess;

   vSendDataToASPP(pArkLibParams->arkblockid, pArkLibParams->arkparamid, pArkLibParams->size, (tU32)ArkamysConfigRNAIVI2::STATE_ON);

   return bSuccess;
}


tBool ArkamysEolInterfaceRNAIVI2::setArkamysMode(tU8 u8ArkamysMode)
{
   tBool bSuccess = true;
   ETG_TRACE_USR4(("ArkamysEolInterfaceRNAIVI2::setArkamysMode to %i", ETG_CENUM(tenArkamysMode, u8ArkamysMode)));

   if(u8ArkamysMode == EN_ARKAMYS_BYPASS || u8ArkamysMode == EN_ARKAMYS_OFF)
       u8ArkamysMode = EN_ARKAMYS_OFF;
   else
     u8ArkamysMode = EN_ARKAMYS_CLASSIC;

   ArkamysConfigRNAIVI2::tArkParamList *pArkLibParams = ArkamysConfigRNAIVI2::getArkamysParamConfig(ArkamysConfigRNAIVI2::ARK_LIB_BYPASS);
   if(pArkLibParams == NULL)
     return bSuccess;

   //1 - arkamys bypass, 0 - arkamys classic as per Arkamys msg catalogue
   vSendDataToASPP(pArkLibParams->arkblockid, pArkLibParams->arkparamid, pArkLibParams->size, (tU32)(!u8ArkamysMode));

   return bSuccess;
}


tBool ArkamysEolInterfaceRNAIVI2::requestLibVersion()
{
   ArkamysConfigRNAIVI2::tArkParamList *pArkLibParams = ArkamysConfigRNAIVI2::getArkamysParamConfig(ArkamysConfigRNAIVI2::ARK_LIB_VERSION);
   if(pArkLibParams != NULL)
   {
       tU32 u32ArkLibVersion;
       u32ArkLibVersion = pArkLibParams->arkblockid;
       u32ArkLibVersion = (tU32)(u32ArkLibVersion << 2);
       u32ArkLibVersion = (tU32)(u32ArkLibVersion | pArkLibParams->arkparamid);
       RequestDataFromASPP(u32ArkLibVersion, pArkLibParams->size);
   }
   return true;
}

tBool ArkamysEolInterfaceRNAIVI2::setArkamysSrcGrp(tU8 u8ArkamysSrcGrp)
{
   tBool bSuccess = true;
   ETG_TRACE_USR4(("ArkamysEolInterfaceRNAIVI2::setArkamysSrcGrp called with source grp %i", ETG_CENUM(ArkamysConfigRNAIVI2::tenSrcGrpSetting, u8ArkamysSrcGrp)));

   ArkamysConfigRNAIVI2::tArkParamList *pArkLibParams = ArkamysConfigRNAIVI2::getArkamysParamConfig(ArkamysConfigRNAIVI2::ARK_LIB_SOURCE);
   if(pArkLibParams == NULL)
     return bSuccess;

   //0 - analog tuner
   //1 - digital tuner
   //2 - analog other
   //3 - digital other
   vSendDataToASPP(pArkLibParams->arkblockid, pArkLibParams->arkparamid, pArkLibParams->size, (tU32)(u8ArkamysSrcGrp));

   return bSuccess;
}

void ArkamysEolInterfaceRNAIVI2::DebugWriteEol()
{
   FILE *f;
   f = fopen("/tmp/EOL.bin", "w");
   if (f == NULL)
   {
      ETG_TRACE_SYS_MIN(("ArkamysEolInterfaceRNAIVI2::DebugWriteEol(): could not open file /tmp/EOL.bin for writing."));
   }
   else
   {
      size_t written = fwrite(m_u8EolData, 1, sizeof(m_u8EolData), f);
      ETG_TRACE_SYS_MIN(("ArkamysEolInterfaceRNAIVI2::DebugWriteEol(): %i/%i bytes written to /tmp/EOL.bin", written, sizeof(m_u8EolData)));
      fclose(f);
   }
}

