/**
 * @file ArkamysConfigRNAIVI2.cpp
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ArkamysFeatureHandlerRNAIVI2.h"
#include "ArkamysConfigRNAIVI2.h"

ArkamysConfigRNAIVI2::tArkParamList ArkamysConfigRNAIVI2::oArkamysParamList[] =
{       //identifier        ,block ID  ,param ID,  size
        { ARK_LIB_BYPASS     ,0x100     ,0x00      ,4   },
        { ARK_LIB_VERSION    ,0x100     ,0x01      ,4   },
        { ARK_EOL_DATA       ,0x100     ,0x02      ,0   },
        { ARK_BASS_ENHANCER  ,0x100     ,0x03      ,4   },
        { ARK_LIB_SOURCE     ,0x100     ,0x08      ,4   },
        { ARK_LIB_FLUSH      ,0x100     ,0x0A      ,4   }
};


ArkamysConfigRNAIVI2::ArkamysConfigRNAIVI2()
{
   ASSERT_STATIC(sizeof(ArkamysConfigRNAIVI2::tArkamysEolHeader) == ARKAMYS_EOL_HEADER_SIZE_BYTE_IVI2);
}

ArkamysConfigRNAIVI2::~ArkamysConfigRNAIVI2()
{
}

void ArkamysConfigRNAIVI2::ArkamysInit()
{
}

ArkamysConfigRNAIVI2::tenSrcSetting ArkamysConfigRNAIVI2::getArkamysSource(tenStream enStream, tenSourceType enSourceType)
{
   if(enStream != EN_AUDIO_SOURCE_STREAM_MAIN)
    return ARKAMYS_SOURCE_INVALID;

   //to differentiate between source types for Arkamys functionalities Primary, secondary and other defines are used
   switch (enSourceType)
   {
   case EN_AUDIO_SOURCE_SOURCETYPE_FM:
   case EN_AUDIO_SOURCE_SOURCETYPE_AM:
   case EN_AUDIO_SOURCE_SOURCETYPE_DAB:
   case EN_AUDIO_SOURCE_SOURCETYPE_HD:
      return ARKAMYS_SOURCE_PRIMARY;

   case EN_AUDIO_SOURCE_SOURCETYPE_CDA:
   case EN_AUDIO_SOURCE_SOURCETYPE_MEDIA:
   case EN_AUDIO_SOURCE_SOURCETYPE_AUX:
   case EN_AUDIO_SOURCE_SOURCETYPE_AUX2:
   case EN_AUDIO_SOURCE_SOURCETYPE_AUX3:
   case EN_AUDIO_SOURCE_SOURCETYPE_BT_AUDIO:
   case EN_AUDIO_SOURCE_SOURCETYPE_TV:
   case EN_AUDIO_SOURCE_SOURCETYPE_DVD:
   case EN_AUDIO_SOURCE_SOURCETYPE_REARSEATAUDIO_IN1:
   case EN_AUDIO_SOURCE_SOURCETYPE_EXT_MEDIA1:
   case EN_AUDIO_SOURCE_SOURCETYPE_XM:
   default:
      return ARKAMYS_SOURCE_SECONDARY;

   case EN_AUDIO_SOURCE_SOURCETYPE_MIC1:
   case EN_AUDIO_SOURCE_SOURCETYPE_MIC2:
   case EN_AUDIO_SOURCE_SOURCETYPE_PHONENARROWBAND:
   case EN_AUDIO_SOURCE_SOURCETYPE_PHONEBROADBAND:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE2:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE3:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE4:
   case EN_AUDIO_SOURCE_SOURCETYPE_PHONE3:
   case EN_AUDIO_SOURCE_SOURCETYPE_PHONE4:
   case EN_AUDIO_SOURCE_SOURCETYPE_NAVI:
   case EN_AUDIO_SOURCE_SOURCETYPE_SOUNDGENERATOR1:
   case EN_AUDIO_SOURCE_SOURCETYPE_SOUNDGENERATOR2:
   case EN_AUDIO_SOURCE_SOURCETYPE_SOUNDSAMPLEPLAYER:
   case EN_AUDIO_SOURCE_SOURCETYPE_SOUNDNOISE:
   case EN_AUDIO_SOURCE_SOURCETYPE_FM_TA:
   case EN_AUDIO_SOURCE_SOURCETYPE_DAB_TA:
   case EN_AUDIO_SOURCE_SOURCETYPE_IPA1:
      return ARKAMYS_SOURCE_OTHER;

   case EN_AUDIO_SOURCE_SOURCETYPE_NOSOURCE:
    return ARKAMYS_SOURCE_INVALID;
   }
}

ArkamysConfigRNAIVI2::tArkParamList* ArkamysConfigRNAIVI2::getArkamysParamConfig(tenArkamysParam enArkamysParam)
{
    ArkamysConfigRNAIVI2::tArkParamList *pArkParamList = (ArkamysConfigRNAIVI2::tArkParamList*)NULL;

    tU8 i;
    for(i = 0, pArkParamList = ArkamysConfigRNAIVI2::oArkamysParamList;  i <  ARK_PARAM_MAX ; i++, pArkParamList++)
    {
        if(pArkParamList->arkIdentifier == enArkamysParam)
          return (ArkamysConfigRNAIVI2::tArkParamList*)pArkParamList;
    }

    return (ArkamysConfigRNAIVI2::tArkParamList*)NULL;
}

ArkamysConfigRNAIVI2::tenSrcGrpSetting ArkamysConfigRNAIVI2::getArkamysSourceGrp(tenInternalSource enIntSource)
{
    //to differentiate between source types for Arkamys
    switch (enIntSource)
    {
    case AUD_INT_SRC_FM:
    case AUD_INT_SRC_AM:
    //case AUD_INT_SRC_FM_TA://announcement
    case AUD_INT_SRC_AM_TI:
        return ARKAMYS_GRP_ANALOG_TUNER;

    case AUD_INT_SRC_DAB:
    case AUD_INT_SRC_XM:
    case AUD_INT_SRC_DRM:
    //case AUD_INT_SRC_DAB_TA://announcement
    //case AUD_INT_SRC_SXM_NEWS:
        return ARKAMYS_GRP_DIGITAL_TUNER;

    case AUD_INT_SRC_CPRA:
    case AUD_INT_SRC_CDDA:
    case AUD_INT_SRC_BT_AUDIO:
    case AUD_INT_SRC_CPRA2:
    case AUD_INT_SRC_SPI_MAIN:
    case AUD_INT_SRC_WEB_ENT:
    case AUD_INT_SRC_BLU_RAY:
    case AUD_INT_SRC_EXTERNAL_CD:
    case AUD_INT_SRC_DTV:
    case AUD_INT_SRC_RSE_IN:
    case AUD_INT_SRC_VPA_MAIN:
    case AUD_INT_SRC_EXT_MEDIA1:

    //NA due to non-entertainment sources
/*  case AUD_INT_SRC_WEB_INFO_SYSTEM:
    case AUD_INT_SRC_WEB_INFO_USR:
    case AUD_INT_SRC_WEB_TTS:
    case AUD_INT_SRC_SXM_TTS:*/
        return ARKAMYS_GRP_DIGITAL_OTHER;

    case AUD_INT_SRC_AUX:
    case AUD_INT_SRC_AUX2:
    case AUD_INT_SRC_AUX3:
    case AUD_INT_SRC_SPARE_CD:
        return ARKAMYS_GRP_ANALOG_OTHER;

     //NA due to non-entertainment sources
    case AUD_INT_SRC_FM_TA:

    case AUD_INT_SRC_DAB_TA:
    case AUD_INT_SRC_SXM_NEWS:

    case AUD_INT_SRC_WEB_INFO_SYSTEM:
    case AUD_INT_SRC_WEB_INFO_USR:
    case AUD_INT_SRC_WEB_TTS:
    case AUD_INT_SRC_SXM_TTS:

    case AUD_INT_SRC_PHONE:
    case AUD_INT_SRC_VRU:
    case AUD_INT_SRC_MIC:
    case AUD_INT_SRC_PHONE2:
    case AUD_INT_SRC_SPI_PHONE:
    case AUD_INT_SRC_SPI_VR:
    case AUD_INT_SRC_PHONE_ANALOG_EXT:
    case AUD_INT_SRC_PHONE_ECALL:
    case AUD_INT_SRC_PHONE_OUTBAND_RING:
    case AUD_INT_SRC_PHONE_VR:
    case AUD_INT_SRC_PHONE_WAIT:
    case AUD_INT_SRC_MIC2:
    case AUD_INT_SRC_VPA_SDS:

    case AUD_INT_SRC_TCU_TTS:
    case AUD_INT_SRC_SMS:
    case AUD_INT_SRC_SPI_ALERT:
    case AUD_INT_SRC_SPI_VR_STEREO:
    case AUD_INT_SRC_TCU_ECALL:
    case AUD_INT_SRC_TCU_SERVICE_CALL:
    case AUD_INT_SRC_WEB_SDS:
    case AUD_INT_SRC_ECO_TTS:
        return ARKAMYS_GRP_ANNOUNCEMENT;

    //mix sources - will not be used
    /*case AUD_INT_SRC_NAVI:
    case AUD_INT_SRC_CUE:
    case AUD_INT_SRC_SPI_MIX:
    case AUD_INT_SRC_SPI_TRANSIENT:
    case AUD_INT_SRC_SPI_ML_INFO:
    case AUD_INT_SRC_IPA_TTS:
    case AUD_INT_SRC_WEB_MIX:
    case AUD_INT_SRC_VPA_TTS:
    case AUD_INT_SRC_AUTO_DRIVE:
    case AUD_INT_SRC_DRVASS_VIDEO:
    case AUD_INT_SRC_EXT_NAVI:*/

    //todo - determine correct source group
    case AUD_INT_SRC_PANDORA:
    case AUD_INT_SRC_IAPPS:
    case AUD_INT_SRC_MCS_AUDIO:
    case AUD_INT_SRC_MCS_VIDEO:
    case AUD_INT_SRC_WX:
    case AUD_INT_SRC_INTERCOM:
    case AUD_INT_SRC_NOSOURCE:
    case AUD_INT_SRC_UNDEFINED:
    default:
        return ARKAMYS_GRP_UNDEFINED;

    }
}

