#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#include "../fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ARKAMYS
#include "trcGenProj/Header/AkActionRNAIVI2.cpp.trc.h"
#endif

#include "ArkamysFeatureHandlerRNAIVI2.h"
#include "Arkamys/ArkamysADRInterface.h"
#include "AkActionRNAIVI2.h"

bool AkActionRNAIVI2::m_bError = false;

AkActionRNAIVI2::AkActionRNAIVI2(tenAkAction action, tU32 param)
{
  m_Action = action;
  m_Parameter = param;
}

bool AkActionRNAIVI2::Perform()
{
   if (m_Action != ARKAMYS_ACTION_WAIT_EVENT)
   {
      m_bError = false;
   }
   ETG_TRACE_USR4(("AkActionRNAIVI2::Perform %i Param: %i", ETG_CENUM(AkActionRNAIVI2::tenAkAction, m_Action), m_Parameter));
    switch (m_Action)
    {
      case ARKAMYS_ACTION_WAIT_EVENT:
         if (!m_bError)
         {
            // start timeout timer
            ArkamysFeatureHandlerRNAIVI2::getInstance() -> vStartTimer(m_waitTimeoutMs);
            return false; // wait
         }
         else
         {
            ETG_TRACE_ERR(("Previous action returned error. Will continue without wait."));
            m_bError = false;
            return true; // continue on error
         }

      case ARKAMYS_ACTION_MUTE:
         ArkamysFeatureHandlerRNAIVI2::getInstance() -> Mute();
         return true; // continue

      case ARKAMYS_ACTION_DEMUTE:
         ArkamysFeatureHandlerRNAIVI2::getInstance() -> Demute();
         return true; // continue

      case ARKAMYS_ACTION_WAIT_TIMEOUT:
         ArkamysFeatureHandlerRNAIVI2::getInstance() -> vStartTimer(static_cast<OSAL_tMSecond>(m_Parameter));
         return false; // wait

      case ARKAMYS_ACTION_SET_VIRTUAL_SUB:
      {
         tU16 u16enMode = (tU16)(m_Parameter >> 16);
         tU16 u16Part = (m_Parameter & 0xFFFF);
         ETG_TRACE_USR4(("ARKAMYS_ACTION_SET_VIRTUAL_SUB::u16enMode %i u16Part: %i", u16enMode, u16Part));
         m_bError = !ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pEolInterface -> setVirtualSubwoofer((tU8)m_Parameter);
         return true; // continue
      }

      case ARKAMYS_ACTION_GET_LIBVERSION:
         m_bError = !ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_pEolInterface -> requestLibVersion();
         return true; // continue

      case ARKAMYS_ACTION_SET_SM_STATE:
         ETG_TRACE_USR4(("AkActionRNAIVI2: Set State: %i", ETG_CENUM(ArkamysFeatureHandlerRNAIVI2::tenArkamysHandlerState, m_Parameter)));
         ArkamysFeatureHandlerRNAIVI2::getInstance() -> m_enState = static_cast<ArkamysFeatureHandlerRNAIVI2::tenArkamysHandlerState>(m_Parameter);
         return true; // continue

      case ARKAMYS_ACTION_SEND_FLUSH_CMD:
        m_bError = !ArkamysEolInterfaceRNAIVI2::getInstance() -> SendFlush();
         return true;

      case ARKAMYS_ACTION_SET_MODE:
        m_bError = !ArkamysEolInterfaceRNAIVI2::getInstance() -> setArkamysMode((tU8)m_Parameter);
         return true;

      case ARKAMYS_ACTION_SET_SOURCE_GRP:
          m_bError = !ArkamysEolInterfaceRNAIVI2::getInstance() -> setArkamysSrcGrp((tU8)m_Parameter);
          return true;
      default:
         return true; // continue
    }
    return true; // continue
}

bool AkActionRNAIVI2::IsEventValid(tenAkEvent akEvent)
{
   if (m_Action == ARKAMYS_ACTION_WAIT_EVENT && m_Parameter == akEvent)
   {
      return true;
   }

   if (m_Action == ARKAMYS_ACTION_WAIT_TIMEOUT && akEvent == ARKAMYS_EVENT_TIMEOUT)
   {
      return true;
   }

  return false;
}
