/**
 * @file ArkamysStateCalculatorRNAIVI.cpp
 * @author pau4kor
 * @copyright (c) 2015 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#include "ArkamysStateCalculatorRNAIVI.h"



tU8 ArkamysStateCalculatorRNAIVI::u8CalculateSSS4State(tBool bEngineeringMode, ArkamysConfigRNAIVI::tenSrcSetting enSource, tenArkamysMode enArkamysMode)
{
   if (bEngineeringMode || enSource == ArkamysConfigRNAIVI::ARKAMYS_SOURCE_OTHER || enArkamysMode != EN_ARKAMYS_CLASSIC)
   {
     if(enArkamysMode == EN_ARKAMYS_AUDITORIUM || enArkamysMode == EN_ARKAMYS_BYPASS)
       return ArkamysConfigRNAIVI::STATE_UNKNOWN;
     else
       return ArkamysConfigRNAIVI::STATE_OFF;
   }

   return ArkamysConfigRNAIVI::STATE_ON;
}

tU8 ArkamysStateCalculatorRNAIVI::u8CalculateVirtualSubwooferState(tBool bEngineeringMode, ArkamysConfigRNAIVI::tenSrcSetting enSource, tBool bRequestedMode, tenArkamysMode enArkamysMode)
{

  if (bEngineeringMode || enSource == ArkamysConfigRNAIVI::ARKAMYS_SOURCE_OTHER || enArkamysMode != EN_ARKAMYS_CLASSIC)
  {
       if(enArkamysMode == EN_ARKAMYS_AUDITORIUM || enArkamysMode == EN_ARKAMYS_BYPASS)
         return ArkamysConfigRNAIVI::STATE_UNKNOWN;
       else
         return ArkamysConfigRNAIVI::STATE_LINEAR;
  }
  else if(!bRequestedMode)
    return ArkamysConfigRNAIVI::STATE_OFF;

  return ArkamysConfigRNAIVI::STATE_ON;


}

tU8 ArkamysStateCalculatorRNAIVI::u8CalculateFMEnhancerState(tBool bEngineeringMode, ArkamysConfigRNAIVI::tenSrcSetting enSource, tBool bDiagAudMode, tenArkamysMode enArkamysMode)
{

  if( enSource != ArkamysConfigRNAIVI::ARKAMYS_SOURCE_PRIMARY || bEngineeringMode || !bDiagAudMode || enArkamysMode == EN_ARKAMYS_PREMIUM2 || enArkamysMode == EN_ARKAMYS_BYPASS)
  {
    return ArkamysConfigRNAIVI::STATE_OFF;
  }
  return ArkamysConfigRNAIVI::STATE_ON;

}


tenArkamysMode ArkamysStateCalculatorRNAIVI::enCalculateArkamysMode(ArkamysConfigRNAIVI::tenArkamysAmplifier enAmplifier,
                                            ArkamysConfigRNAIVI::tenArkamysEOLLib enLibType,
                        tBool bLibraryMatch,
                        ArkamysConfigRNAIVI::tenArkamysDeviceVariant enDevice)
{

    if( !bLibraryMatch || enLibType == ArkamysConfigRNAIVI::ARKAMYS_EOL_INVALID ||
        (enLibType == ArkamysConfigRNAIVI::ARKAMYS_EOL_AUDITORIUM && enDevice == ArkamysConfigRNAIVI::ARKAMYS_DEV_CLASSIC_ONLY))
      return EN_ARKAMYS_BYPASS;

    switch(enAmplifier)
    {
    case ArkamysConfigRNAIVI::ARKAMYS_AMP_PREMIUM_1:
      return EN_ARKAMYS_PREMIUM1;
    case ArkamysConfigRNAIVI::ARKAMYS_AMP_PREMIUM_2:
      return EN_ARKAMYS_PREMIUM2;
    case ArkamysConfigRNAIVI::ARKAMYS_AMP_INTERNAL_AMPLIFIER:
    {
      if(enLibType == ArkamysConfigRNAIVI::ARKAMYS_EOL_AUDITORIUM)
        return EN_ARKAMYS_AUDITORIUM;
    }
    break;
    default:
      return EN_ARKAMYS_BYPASS;
    }

    return EN_ARKAMYS_CLASSIC;

}


/*
 * Auditorium related settings
 */
ArkamysConfigRNAIVI::tenAuditoriumAmbiance ArkamysStateCalculatorRNAIVI::enCalculateAmbianceState(tBool bEngineeringMode, ArkamysConfigRNAIVI::tenAuditoriumAmbiance enUserSetting,
                                                                                              ArkamysConfigRNAIVI::tenSrcSetting enSource, tenArkamysMode enArkamysMode)
{
   if (bEngineeringMode || enSource == ArkamysConfigRNAIVI::ARKAMYS_SOURCE_OTHER  || enArkamysMode != EN_ARKAMYS_AUDITORIUM)
   {
      return ArkamysConfigRNAIVI::ARKAMYS_AMBIANCE_FLAT;
   }

   return enUserSetting;
}


tU8 ArkamysStateCalculatorRNAIVI::u8CalculateFMEnhancer2State(tBool bEngineeringMode, tBool bRequestedMode, tBool bDiagAudMode, tenArkamysMode enArkamysMode)
{
  if(enArkamysMode != EN_ARKAMYS_AUDITORIUM)
    return ArkamysConfigRNAIVI::STATE_UNKNOWN;

  if (bEngineeringMode || !bRequestedMode || !bDiagAudMode)
  {
    return ArkamysConfigRNAIVI::STATE_OFF;
  }

  return ArkamysConfigRNAIVI::STATE_ON;
}

tU8 ArkamysStateCalculatorRNAIVI::u8CalculateAGCState(tBool bEngineeringMode, tBool bRequestedMode, tenArkamysMode enArkamysMode)
{
  if(enArkamysMode != EN_ARKAMYS_AUDITORIUM)
    return ArkamysConfigRNAIVI::STATE_UNKNOWN;

  if (bEngineeringMode || !bRequestedMode)
  {
    return ArkamysConfigRNAIVI::STATE_OFF;
  }

  return ArkamysConfigRNAIVI::STATE_ON;
}

