/**
 * @file ArkamysConfigRNAIVI.h
 * @author pau4kor
 * @copyright (c) 2015 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSCONFIG_RNAIVI_H_
#define ARKAMYSCONFIG_RNAIVI_H_

#include "system_types.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3SourceType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3ArkamysDefines.h"
#include "Arkamys/ArkamysDefines.h"

#ifndef ASSERT_STATIC
#define ASSERT_STATIC(_b) { switch(1){ default: case false:break; case (_b):break; }; }
#endif


#define ARKAMYS_ADR3_LIB_MIN_VERSION   (0x00010500)
#define ARKAMYS_ADR3_LIB_MAX_VERSION   (0x00020000)

#define ARKAMYS_IMX_LIB_MIN_VERSION   (0x00020000)
#define ARKAMYS_IMX_LIB_MAX_VERSION   (0x00020400)//v2.4.0

//#define ARKAMYS_IMX_LIB_VERSION   (0x00000000)

#define ARKAMYS_LIBTYPE_CLASSIC 0x434C4153
#define ARKAMYS_LIBTYPE_AUDITORIUM 0x41554449

#define ARKAMYS_LHD_STEERING_CONFIG 0x4C484400
#define ARKAMYS_RHD_STEERING_CONFIG 0x52484400


// This is the boundary address to distinguish FPR from emerald addresses (FPR is < threshold, Emerald is >= threshold)
#define  ARKAMYS_FPR_ADDRESS_THRESHOLD 0xA0000000

// ARM-Address where the Library version is stored on the ADR 0xA0082F40 --> 0xA0082F00
#define ARKAMYS_LIB_VERSION_ARM_ADR  0xA0082F00

class ArkamysConfigRNAIVI
{
private:
   //lint --e{1704} Constructor 'ArkamysConfigRNAIVI::ArkamysConfigRNAIVI(void)' has private access specification
   ArkamysConfigRNAIVI();
#ifdef __AUDIO_UNIT_TESTING__
   FRIEND_TEST(ArkamysTests, ConfigCheck);
#endif
public:
   virtual ~ArkamysConfigRNAIVI();

   static void ArkamysInit();

   typedef struct {
      tU32 BassExciterOnOffsets      [4];
      tU32 BassExciterOffOffsets     [4];
      tU32 SoundStagingOffsets       [5];
      tU32 FMEnhancerOnOffsets          ; //for FM/AM/DAB sources
      tU32 FMEnhancerOffOffsets         ; //for other sources
      tU32 SoundStageLiveOffsets     [8];
      tU32 SoundStageNaturalOffsets  [8];
      tU32 SoundStageClubOffsets     [8];
      tU32 SoundStageLoungeOffsets   [8];
      tU32 FMEnhancer2Offsets        [2];
      tU32 SDEQHPOffsets                ;
   } tArkamysEolOffsets;
   static const tArkamysEolOffsets oArkamys_sEolOffsets;


//ToDO : adapt to latest EOL format
   typedef struct {
    tU32 EolFileGenerationDate;
    tU32 CarManufacturer;
    tU32 RadioManufacturer;
    tU32 RadioProject[2];
    tU32 VehicleID[5];
    tU32 TuningDate;
    tU32 TuningPlace;
    tU32 TuningVersion;
    tU32 TuningTargetVersion;
    tU32 SpeakerConfiguration;
    tU32 LibType;
    tU32 ADR3LibVersion;
    tU32 IMXLibVersion;
      tU32 ArkamysSATVersion;
      tU32 RadioSWVersion[2];
      tU32 ConfigurationType;
      tU32 DataSize;
      tU32 GlobalCRC;
      tU32 reserved;
   } tArkamysEolHeader;

   typedef enum
   {
      ARKAMYS_SOURCE_PRIMARY,
      ARKAMYS_SOURCE_SECONDARY,
      ARKAMYS_SOURCE_OTHER,
      ARKAMYS_SOURCE_INVALID = 0xFF
   } tenSrcSetting;


   typedef enum
   {
      ARKAMYS_FEATURE_SSS4,
      ARKAMYS_FEATURE_VIRTUAL_SUBWOOFER,
      ARKAMYS_FEATURE_FM_ENHANCER,
      ARKAMYS_FEATURE_INVALID = 0xFF
   } tenArkamysFeature;


   typedef enum
   {
      ARKAMYS_AMP_INTERNAL_AMPLIFIER,
      ARKAMYS_AMP_PREMIUM_1,
    ARKAMYS_AMP_PREMIUM_2,
      ARKAMYS_AMP_INVALID = 0xFF
   } tenArkamysAmplifier;

   typedef enum
   {
      ARKAMYS_DEV_CLASSIC_ONLY,
      ARKAMYS_DEV_ALL_OTHER,
      ARKAMYS_DEV_INVALID = 0xFF
   } tenArkamysDeviceVariant;


   typedef enum
   {
      ARKAMYS_EOL_CLASSIC = 1,
      ARKAMYS_EOL_AUDITORIUM,
      ARKAMYS_EOL_INVALID = 0xFF
   } tenArkamysEOLLib;

   typedef enum
    {
      ARKAMYS_AMBIANCE_NATURAL = 0,
     ARKAMYS_AMBIANCE_LIVE,
     ARKAMYS_AMBIANCE_CLUB,
     ARKAMYS_AMBIANCE_LOUNGE,
     ARKAMYS_AMBIANCE_FLAT,
      ARKAMYS_AMBIANCE_INVALID = 0xFF
    } tenAuditoriumAmbiance;

    typedef enum
    {
      STATE_OFF = 0,
    STATE_ON = 1,
  STATE_LINEAR = 2,
    STATE_UNKNOWN = 0xFF
    }tenArkamysFeatureState;

   static tenSrcSetting getArkamysSource(tenStream stream, tenSourceType sourceType);
};

#endif /* ARKAMYSCONFIG_RNAIVI_H_ */
