/**
 * @file ArkamysConfigRNAIVI.cpp
 * @author pau4kor
 * @copyright (c) 2015 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//#include "ArkamysFeature.h"
#include "ArkamysFeatureHandlerRNAIVI.h"

#include "ArkamysConfigRNAIVI.h"

const ArkamysConfigRNAIVI::tArkamysEolOffsets ArkamysConfigRNAIVI::oArkamys_sEolOffsets =
   {
         //classic offsets
     /* BassExciter On Offset        */  {  100, 396, 425, 946  },
         /* BassExciter Off Offset       */  {  957, 1253, 1282, 1803 },
         /* Sound Staging Offset         */  {  1814, 2878, 2898, 2924, 2950 },
         /* FMEnhancer Offset for FM/AM/DAB      */     2970  ,
     /* FMEnhancer Offset for other sources  */     2999  ,
     //auditorium offsets - order -> FPR, other filters, compensation gain
         /* Sound Stage Live Offset      */  {   100, 1164, 1184, 1210, 1236, 1300, 1404, 1256 },
         /* Sound Stage Natural Offset   */  {  1814, 2878, 2898, 2924, 2950, 1508, 1612, 1267 },
         /* Sound Stage Club Offset      */  {  3028, 4092, 4112, 4138, 4164, 5661, 5765, 1278 },
         /* Sound Stage Lounge Offset    */  {  4184, 5248, 5268, 5294, 5320, 5869, 5973, 1289 },
     /* FMEnhancer2 Offset           */  {  5340, 5540  },
         /* SDEQ HP Offset               */     5581
   };


ArkamysConfigRNAIVI::ArkamysConfigRNAIVI()
{
   ASSERT_STATIC(sizeof(ArkamysConfigRNAIVI::tArkamysEolHeader) == ARKAMYS_EOL_HEADER_SIZE_BYTE);
}

ArkamysConfigRNAIVI::~ArkamysConfigRNAIVI()
{
}

void ArkamysConfigRNAIVI::ArkamysInit()
{
}

ArkamysConfigRNAIVI::tenSrcSetting ArkamysConfigRNAIVI::getArkamysSource(tenStream enStream, tenSourceType enSourceType)
{
   if(enStream != EN_AUDIO_SOURCE_STREAM_MAIN)
    return ARKAMYS_SOURCE_INVALID;

   //to differentiate between source types for Arkamys functionalities Primary, secondary and other defines are used
   switch (enSourceType)
   {
   case EN_AUDIO_SOURCE_SOURCETYPE_FM:
   case EN_AUDIO_SOURCE_SOURCETYPE_AM:
   case EN_AUDIO_SOURCE_SOURCETYPE_DAB:
   case EN_AUDIO_SOURCE_SOURCETYPE_HD:
      return ARKAMYS_SOURCE_PRIMARY;

   case EN_AUDIO_SOURCE_SOURCETYPE_CDA:
   case EN_AUDIO_SOURCE_SOURCETYPE_MEDIA:
   case EN_AUDIO_SOURCE_SOURCETYPE_AUX:
   case EN_AUDIO_SOURCE_SOURCETYPE_AUX2:
   case EN_AUDIO_SOURCE_SOURCETYPE_BT_AUDIO:
   case EN_AUDIO_SOURCE_SOURCETYPE_TV:
   case EN_AUDIO_SOURCE_SOURCETYPE_DVD:
   case EN_AUDIO_SOURCE_SOURCETYPE_REARSEATAUDIO_IN1:
   case EN_AUDIO_SOURCE_SOURCETYPE_MIC1:
   case EN_AUDIO_SOURCE_SOURCETYPE_MIC2:
   default:
      return ARKAMYS_SOURCE_SECONDARY;

   case EN_AUDIO_SOURCE_SOURCETYPE_PHONENARROWBAND:
   case EN_AUDIO_SOURCE_SOURCETYPE_PHONEBROADBAND:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE2:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE3:
   case EN_AUDIO_SOURCE_SOURCETYPE_CUE4:
   case EN_AUDIO_SOURCE_SOURCETYPE_PHONE3:
   case EN_AUDIO_SOURCE_SOURCETYPE_PHONE4:
   case EN_AUDIO_SOURCE_SOURCETYPE_NAVI:
   case EN_AUDIO_SOURCE_SOURCETYPE_SOUNDGENERATOR1:
   case EN_AUDIO_SOURCE_SOURCETYPE_SOUNDGENERATOR2:
   case EN_AUDIO_SOURCE_SOURCETYPE_SOUNDSAMPLEPLAYER:
   case EN_AUDIO_SOURCE_SOURCETYPE_FM_TA:
   case EN_AUDIO_SOURCE_SOURCETYPE_DAB_TA:
      return ARKAMYS_SOURCE_OTHER;

   case EN_AUDIO_SOURCE_SOURCETYPE_NOSOURCE:
    return ARKAMYS_SOURCE_INVALID;
   }
}
