/* **** Note on AkActionQueueRNAIVI ****
 * With AkActionQueueRNAIVI.Add, a new Action is added to the Action Queue.
 * Actions will be performed in the order they were added.
 * When a "Wait" Action is reached, the queue stops until the designated event occurs (i.e. Muted/Demuted, ...)
 * To start the Queue, the "Continue" event is sent.
 * The queue automatically sets the ArkamysFeatureHandlerRNAIVI state to busy as first item and to idle when all items are ready
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ARKAMYS
#include "trcGenProj/Header/AkActionQueueRNAIVI.cpp.trc.h"
#endif
#include "AkActionQueueRNAIVI.h"
#include "ArkamysFeatureHandlerRNAIVI.h"

void AkActionQueueRNAIVI::Event(AkActionRNAIVI::tenAkEvent akEvent)
{
   if (m_qActions.empty())
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI::Event(%i): Queue empty. Nothing to do.", ETG_CENUM(AkActionRNAIVI::tenAkEvent, akEvent)));
      AkActionRNAIVI(AkActionRNAIVI::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI::ARKAMYS_FEATURE_STATE_IDLE).Perform();
      return;
   }
   if (akEvent == AkActionRNAIVI::ARKAMYS_EVENT_CONTINUE || m_qActions.front().IsEventValid(akEvent))
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI::Event(%i)", ETG_CENUM(AkActionRNAIVI::tenAkEvent, akEvent)));
      if (m_qActions.front().IsEventValid(akEvent)) // wait or timeout event
      {
         m_qActions.pop();
         ArkamysFeatureHandlerRNAIVI::getInstance() -> vStopTimer();
      }
      bool cont = true;
      while (cont && !m_qActions.empty())
      {
         cont = m_qActions.front().Perform();
         if (cont)
         {
            m_qActions.pop();
         }
      }

      if (!m_qActions.empty())
      {
         ETG_TRACE_USR4(("Queue stopped. Items left: %i", m_qActions.size()));
      } else
      {
         AkActionRNAIVI(AkActionRNAIVI::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI::ARKAMYS_FEATURE_STATE_IDLE).Perform();
         ETG_TRACE_USR4(("Queue empty."));
      }
   }
   else if (akEvent == AkActionRNAIVI::ARKAMYS_EVENT_TIMEOUT)
   {
      ETG_TRACE_ERR(("AkActionQueueRNAIVI received timeout. Cancelling queue."));
      Cancel();
   }
   else
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI::Nothing to do for Event(%i).", ETG_CENUM(AkActionRNAIVI::tenAkEvent, akEvent)));
   }
}

void AkActionQueueRNAIVI::Cancel()
{
   queue<AkActionRNAIVI>::size_type itemCount = Size();
   queue<AkActionRNAIVI> empty;
   swap(m_qActions, empty);
   //demute added to prevent system getting stuck in mute state
   AkActionRNAIVI(AkActionRNAIVI::ARKAMYS_ACTION_DEMUTE, ArkamysFeatureHandlerRNAIVI::ARKAMYS_FEATURE_STATE_INIT).Perform();
   AkActionRNAIVI(AkActionRNAIVI::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI::ARKAMYS_FEATURE_STATE_IDLE).Perform();
   ETG_TRACE_USR4(("AkActionQueueRNAIVI::Cancel() - %i items removed.", itemCount));
}

queue<AkActionRNAIVI>::size_type AkActionQueueRNAIVI::Size()
{
   return m_qActions.size();
}

bool AkActionQueueRNAIVI::IsEmpty()
{
   return m_qActions.empty();
}

void AkActionQueueRNAIVI::Add(AkActionRNAIVI a)
{
   if (IsEmpty())
   {
      m_qActions.push(AkActionRNAIVI(AkActionRNAIVI::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI::ARKAMYS_FEATURE_STATE_BUSY));
   }
   if (a.m_Action == AkActionRNAIVI::ARKAMYS_ACTION_WAIT_EVENT)
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI::Add(%i, %i)", ETG_CENUM(AkActionRNAIVI::tenAkAction, a.m_Action), ETG_CENUM(AkActionRNAIVI::tenAkEvent, a.m_Parameter)));
   } else
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI::Add(%i, %i)", ETG_CENUM(AkActionRNAIVI::tenAkAction, a.m_Action), a.m_Parameter));
   }
   m_qActions.push(a);
}


