/**
 * @file ArkamysEOLConverter.cpp
 * @author CM-AI wie1hi
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 * @{
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#include "../fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ARKAMYS
#include "trcGenProj/Header/ArkamysEOLConverter.cpp.trc.h"
#endif

#include "ArkamysEOLConverter.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA

tU32 ArkamysEOLConverter::GetInflatedDatasetSize(const tU8 *pDataset, tU32 command)
{
   AUD_POINTER_CHECK_CALL(pDataset);
      tU32 u32LAdr;
      tU32 u32Size;
      memcpy(&u32LAdr, pDataset, sizeof(u32LAdr));
      memcpy(&u32Size, &pDataset[2 * sizeof(u32LAdr)], sizeof(u32Size));


   if (u32LAdr == command) // command (32-bit)
   {
      return ((tU32)(3 * sizeof(tU32) + u32Size));
   }
   else if (u32LAdr < ARKAMYS_FPR_ADDRESS_THRESHOLD) // FPR (16-bit)
   {
      return ((tU32)(3 * sizeof(tU32) + (u32Size * 2)));
   }
   else //(u32LAdr >= ARKAMYS_FPR_ADDRESS_THRESHOLD) // Emerald (24-bit)
   {
      return ((tU32)(3 * sizeof(tU32) + (u32Size / 3) * 4));
   }
}

tU32 ArkamysEOLConverter::InflateDataset(const tU8 *pDataset, tU8 *pTargetBuffer, tU32 targetBufferSize, tU32 command)
{
   AUD_POINTER_CHECK_CALL(pDataset);
   AUD_POINTER_CHECK_CALL(pTargetBuffer);

   if (GetInflatedDatasetSize(pDataset, command) > targetBufferSize)
   {
      ETG_TRACE_ERR(("ArkamysEOLConverter::InflateDataset(): Size of target buffer does not fit."));
      return 0;
   }

   tU32 cwpTarget = 0; // current working pointer for target buffer
   tU32 cwpSource = 0; // current working pointer for source buffer

   //copy header to target buffer (LAdr, RAdr)
   memcpy(&pTargetBuffer[cwpTarget], pDataset, 2 * sizeof(tU32));
   cwpTarget = (tU32)(cwpTarget + 2 * sizeof(tU32));
   cwpSource = (tU32)(cwpSource + 2 * sizeof(tU32));

   // copy data, dependend of data type
   tU32 u32LAdr;
   tU32 u32Size;
   memcpy(&u32LAdr, pDataset, sizeof(u32LAdr));
   memcpy(&u32Size, &pDataset[2 * sizeof(u32LAdr)], sizeof(u32Size));


   if (u32Size > (targetBufferSize - cwpTarget))
   {
      ETG_TRACE_ERR(("ArkamysEOLConverter::InflateDataset(): Size %i does not fit in target buffer.", u32Size));
      return 0;
   }

   if (u32LAdr == command) // command (32-bit)
   {
      // copy size to target buffer
     tU32 u32SizeInWords = u32Size / 4;
     memcpy(&pTargetBuffer[cwpTarget], &u32SizeInWords, sizeof(u32SizeInWords));


      cwpTarget = (tU32) (cwpTarget + sizeof(tU32));
      cwpSource = (tU32) (cwpSource + sizeof(tU32));

      if (cwpTarget + 4 > targetBufferSize)

      {
         NORMAL_M_ASSERT(false);
      }
      NORMAL_M_ASSERT(u32Size == sizeof(tU32)); // Because commands are always one 32-bit word
      memcpy(&pTargetBuffer[cwpTarget], &pDataset[cwpSource], sizeof(tU32));
      cwpTarget =(tU32)(cwpTarget + u32Size);
      cwpSource =(tU32)(cwpSource + u32Size);
   }
   else if (u32LAdr < ARKAMYS_FPR_ADDRESS_THRESHOLD) // FPR (16-bit)
   {
      // copy size to target buffer
     tU32 u32SizeInWords = u32Size / 2;
     memcpy(&pTargetBuffer[cwpTarget], &u32SizeInWords, sizeof(u32SizeInWords));

     cwpTarget = (tU32) (cwpTarget + sizeof(tU32));
     cwpSource = (tU32) (cwpSource + sizeof(tU32));

      for (tU32 n=0; n < u32Size / 2; n++)
      {
         if (cwpTarget + 4 > targetBufferSize)
         {
            break;
         }
       tU32 thisData = (pDataset[cwpSource] << 16) + (pDataset[cwpSource + 1] << 24);
       memcpy(&pTargetBuffer[cwpTarget], &thisData, sizeof(tU32));

         memcpy(&pTargetBuffer[cwpTarget], &thisData, sizeof(tU32));
         cwpSource += 2;
         cwpTarget += 4;
      }
   }
   else //(u32LAdr >= ARKAMYS_FPR_ADDRESS_THRESHOLD) // Emerald (24-bit)
   {
      // copy size to target buffer
     tU32 u32SizeInWords = u32Size / 3;
     memcpy(&pTargetBuffer[cwpTarget], &u32SizeInWords, sizeof(u32SizeInWords));

     cwpTarget = (tU32) (cwpTarget + sizeof(tU32));
     cwpSource = (tU32) (cwpSource + sizeof(tU32));

      for (tU32 n=0; n < u32Size / 3; n++)
      {
         if (cwpTarget + 4 > targetBufferSize)
         {
            break;
         }
         tU32 thisData = pDataset[cwpSource];
         thisData |= pDataset[cwpSource + 1] <<  8;
         thisData |= pDataset[cwpSource + 2] << 16;
         memcpy(&pTargetBuffer[cwpTarget], &thisData, sizeof(tU32));
         cwpSource += 3;
         cwpTarget += 4;
      }
   }

   return cwpTarget;
}
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
tU32 ArkamysEOLConverter::GetInflatedDatasetSizeRNAIVI(const tU8 *pDataset)
{
   AUD_POINTER_CHECK_CALL(pDataset);
   tU32 u32LAdr;
   tU32 u32Size;
   memcpy(&u32LAdr, pDataset, sizeof(u32LAdr));
   memcpy(&u32Size, &pDataset[sizeof(u32LAdr)], sizeof(u32Size));


    if (u32LAdr < ARKAMYS_FPR_ADDRESS_THRESHOLD) // FPR (16-bit)
     {
        return ((tU32)(2 * sizeof(tU32) + (u32Size * 2)));
     }
  else //(u32LAdr >= ARKAMYS_FPR_ADDRESS_THRESHOLD) // Emerald (24-bit)
     {
        return ((tU32)(2 * sizeof(tU32) + (u32Size / 3) * 4));
     }

}



tU32 ArkamysEOLConverter::InflateDatasetRNAIVI(const tU8 *pDataset, tU8 *pTargetBuffer, tU32 targetBufferSize)
{
   AUD_POINTER_CHECK_CALL(pDataset);
   AUD_POINTER_CHECK_CALL(pTargetBuffer);

   if (GetInflatedDatasetSizeRNAIVI(pDataset) > targetBufferSize)
   {
      ETG_TRACE_ERR(("ArkamysEOLConverter::InflateDatasetClassic(): Size of target buffer does not fit."));
      return 0;
   }

   tU32 cwpTarget = 0; // current working pointer for target buffer
   tU32 cwpSource = 0; // current working pointer for source buffer

   //copy header to target buffer (address)
   memcpy(&pTargetBuffer[cwpTarget], pDataset, sizeof(tU32));
   cwpTarget = (tU32) (cwpTarget + sizeof(tU32));
   cwpSource = (tU32) (cwpSource + sizeof(tU32));

   // copy data, dependend of data type
   tU32 u32LAdr;
   tU32 u32Size;
   memcpy(&u32LAdr, pDataset, sizeof(u32LAdr));
   memcpy(&u32Size, &pDataset[sizeof(u32LAdr)], sizeof(u32Size));


   if (u32Size > (targetBufferSize - cwpTarget))
   {
      ETG_TRACE_ERR(("ArkamysEOLConverter::InflateDataset(): Size %i does not fit in target buffer.", u32Size));
      return 0;
   }


   if (u32LAdr < ARKAMYS_FPR_ADDRESS_THRESHOLD) // FPR (16-bit)
   {
      // copy size to target buffer
     tU32 u32SizeInWords = u32Size / 2;
     memcpy(&pTargetBuffer[cwpTarget], &u32SizeInWords, sizeof(u32SizeInWords));

     cwpTarget = (tU32) (cwpTarget + sizeof(tU32));
     cwpSource = (tU32) (cwpSource + sizeof(tU32));

      for (tU32 n=0; n < u32Size / 2; n++)
      {
         if (cwpTarget + 4 > targetBufferSize)
         {
            break;
         }
       tU32 thisData = (pDataset[cwpSource] << 16) + (pDataset[cwpSource + 1] << 24);
       memcpy(&pTargetBuffer[cwpTarget], &thisData, sizeof(tU32));

         memcpy(&pTargetBuffer[cwpTarget], &thisData, sizeof(tU32));
         cwpSource += 2;
         cwpTarget += 4;
      }
   }
   else //(u32LAdr >= ARKAMYS_FPR_ADDRESS_THRESHOLD) // Emerald (24-bit)
   {
      // copy size to target buffer
     tU32 u32SizeInWords = u32Size / 3;
     memcpy(&pTargetBuffer[cwpTarget], &u32SizeInWords, sizeof(u32SizeInWords));

     cwpTarget = (tU32) (cwpTarget + sizeof(tU32));
     cwpSource = (tU32) (cwpSource + sizeof(tU32));

      for (tU32 n=0; n < u32Size / 3; n++)
      {
         if (cwpTarget + 4 > targetBufferSize)
         {
            break;
         }
         tU32 thisData = pDataset[cwpSource];
         thisData |= pDataset[cwpSource + 1] <<  8;
         thisData |= pDataset[cwpSource + 2] << 16;
         memcpy(&pTargetBuffer[cwpTarget], &thisData, sizeof(tU32));
         cwpSource += 3;
         cwpTarget += 4;
      }
   }

   return cwpTarget;
}
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC

ArkamysEOLConverter::ArkamysEOLConverter()
{
}

ArkamysEOLConverter::~ArkamysEOLConverter()
{
}

