/**
 * @file ArkamysADRInterface.h
 * @author CM-AI wie1hi
 * @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 * @{
 */

#ifndef ARKAMYSADRINTERFACE_H_
#define ARKAMYSADRINTERFACE_H_

//#define SYSTEM_S_IMPORT_INTERFACE_QUEUE
//#include <stl_pif.h>


#include <queue>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#include <pthread.h>

#define ARKAMYS_ADR_MAX_MESSAGE_SIZE_BYTES (1004) // max. 1k

#pragma pack(push,1)
/**
 * @description Use Network byte order (MSB first) for Address, Length and Data fields!
 */
class ArkamysStaticMessage
{
public:
   enum tenAdrOpType {
      ArkamysOpTypeSet, ArkamysOpTypeGet, ArkamysOpTypeStatus, ArkamysOpTypeError, ArkamysOpTypeInvalid = 0xFF
   };

   // return the command value that fits to the ADR3 mapping found in the function catalog
   tU8 getADRCommand();

   // return the Arkamys command value that maps to the given ADR command value, 0xFF if unknown
   static tenAdrOpType ADRToArkamysCommand(tU8 adrCommand);

   // command from: ArkamysOpTypeSet, ArkamysOpTypeGet, ArkamysOpTypeStatus, ArkamysOpTypeError
   tU8   command;
   //tU32  address;
   tU32  size;
   tU8   data[ARKAMYS_ADR_MAX_MESSAGE_SIZE_BYTES];
};
#pragma pack(pop)

class ArkamysADRInterface
{
public:
   ArkamysADRInterface();
   virtual ~ArkamysADRInterface();
   virtual void SendToADR(ArkamysStaticMessage msg);
   virtual void SetBalance(tS16 steps);
   virtual void SetFader(tS16 steps);
   virtual void vAdrOkCallback();
   virtual tBool bExistMsgToSend();
private:
   pthread_mutex_t m_Mutex;
   tBool m_bMutexInitialized;
   tBool m_bAdrBusy;
   std::queue<ArkamysStaticMessage> m_ArkamysMessageQueue;
   void vProcessQueue();
};

#endif /* ARKAMYSADRINTERFACE_H_ */
