/*
 * vdamp-plugin-types.h
 *
 *  Created on: Nov 16, 2013
 *      Author: rjk2kor
 * *****************************************************************************************
 * Version History
 * Date      Modified by    Change Description
 * *****************************************************************************************
 * 11/26/2013  Ranjit K    Added enumerations
 * *****************************************************************************************
 */

#ifndef VDAMP_PLUGIN_TYPES_H_
#define VDAMP_PLUGIN_TYPES_H_

#include <stdint.h>
//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#include <stl_pif.h>


#include <map>
#include <string>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#ifndef NULL
   #define NULL 0
#endif

/*****************************************************************
* Enumerations
* ****************************************************************/

/*!
* \enum amp_tenPowerState
* Enumeration for Power State
*/
enum amp_tenPowerState
{
  EN_AMP_PWR_OFF = 0x00,
  EN_AMP_PWR_STANDBY = 0x01,
  EN_AMP_PWR_ON = 0x02
};
/*!
* \enum amp_tenPowerState
* Enumeration for Power State
*/
enum amp_tenPowerStatus
{
  EN_AMP_PWR_STS_OFF = 0x00,
  EN_AMP_PWR_STS_STANDBY = 0x01,
  EN_AMP_PWR_STS_ON = 0x02,
  EN_AMP_PWR_STS_INITIALIZING = 0x03,
  EN_AMP_PWR_STS_UNKNOWN = 0xFF
};
/*!
* \enum amp_tenVolumeState
* Enumeration for volume set State
*/
enum amp_tenVolumeState
{
  EN_AMP_VOL_STATE_RAMP_READY = 0x00,
  EN_AMP_VOL_STATE_RAMP_UP  = 0x01,
  EN_AMP_VOL_STATE_RAMP_DOWN  = 0x02,
  EN_AMP_VOL_STATE_UNKNOWN = 0xFF
};

/*!
* \enum amp_tenVolumeState
* Enumeration for volume type
*/
enum amp_tenVolumeType
{
  EN_AMP_VOL_TYPE_NOT_DEF = 0xFF,
  EN_AMP_VOL_TYPE_ABS = 0x01,
  EN_AMP_VOL_TYPE_INC = 0x02,
  EN_AMP_VOL_TYPE_DEC = 0x03
};

/*!
* \enum amp_tenVolumeOffsetStatus
* Enumeration for volume offset status
*/
enum amp_tenVolumeOffsetStatus
{
  EN_AMP_VOL_OFFSET_STATUS_RAMP_READY = 0x00,
  EN_AMP_VOL_OFFSET_STATUS_RAMP_RUNNING = 0x01,
  EN_AMP_VOL_OFFSET_STATUS_UNKNOWN = 0xFF
};

/*!
* \enum amp_tenStream
* Enumeration for stream
*/
enum amp_tenStream
{
  EN_AMP_SOURCE_STREAM_UNKNOWN = 0x00,
  EN_AMP_SOURCE_STREAM_ENTERTAIN1 = 0x01,
  EN_AMP_SOURCE_STREAM_INFOTAIN1 = 0x02,
  EN_AMP_SOURCE_STREAM_INFOTAIN2 = 0x03,
  EN_AMP_SOURCE_STREAM_INFOTAIN3 = 0x04,
  EN_AMP_SOURCE_STREAM_INFOTAIN4 = 0x05,
  EN_AMP_SOURCE_STREAM_INFOTAIN5 = 0x06,
  EN_AMP_SOURCE_STREAM_ENTERTAIN2  = 0x07,
  /*!
  * Not supported by all functions
  */
  EN_AMP_SOURCE_STREAM_ALLSTREAMS = 0xFF
};
/*!
* \enum amp_tenSource
* Enumeration for Source Type
*/
enum amp_tenSource
{
  /**
  * Muted
  */
  EN_AMP_SOURCE_SOURCETYPE_NOSOURCE = 0x00,
  EN_AMP_SOURCE_SOURCETYPE_FM = 0x01,
  EN_AMP_SOURCE_SOURCETYPE_AM = 0x02,
  EN_AMP_SOURCE_SOURCETYPE_MEDIA = 0x03,
  EN_AMP_SOURCE_SOURCETYPE_CDA = 0x04,
  EN_AMP_SOURCE_SOURCETYPE_AUX = 0x05,
  EN_AMP_SOURCE_SOURCETYPE_DAB = 0x06,
  EN_AMP_SOURCE_SOURCETYPE_PHONE1 = 0x07,
  EN_AMP_SOURCE_SOURCETYPE_PHONE2 = 0x08,
  EN_AMP_SOURCE_SOURCETYPE_AUX2 = 0x09,
  EN_AMP_SOURCE_SOURCETYPE_XM = 0x0A,
  EN_AMP_SOURCE_SOURCETYPE_FM_TA = 0x0E,
  EN_AMP_SOURCE_SOURCETYPE_DAB_TA = 0x0F,
  /**
  * Ex: Navi
  */
  EN_AMP_SOURCE_SOURCETYPE_SPEECH = 0x10,
  EN_AMP_SOURCE_SOURCETYPE_CUE1 = 0x11,
  EN_AMP_SOURCE_SOURCETYPE_CUE2 = 0x12,
  EN_AMP_SOURCE_SOURCETYPE_CUE3 = 0x13,
  EN_AMP_SOURCE_SOURCETYPE_CUE4 = 0x14,
  /**
  * used for Beep and Chime
  */
  EN_AMP_SOURCE_SOURCETYPE_SOUNDGENERATOR1 = 0x20,
  /**
  * used for Chime
  */
  EN_AMP_SOURCE_SOURCETYPE_SOUNDGENERATOR2 = 0x21,
  /**
  * Used for click sample
  */
  EN_AMP_SOURCE_SOURCETYPE_SOUNDSAMPLEPLAYER = 0x22,
  EN_AMP_SOURCE_SOURCETYPE_BTAUDIO = 0x32,
  EN_AMP_SOURCE_SOURCETYPE_PHONE3 = 0x33,
  EN_AMP_SOURCE_SOURCETYPE_PHONE4 = 0x34
};

/*!
* \enum amp_tenSource_unmapped
* Enumeration for Unmapped list of sources obtained from CCA
*/
enum amp_tenSource_unmapped
{
    EN_AMP_SOURCE_NONE = 0UL,
    EN_AMP_SOURCE_FM = 1UL,
    EN_AMP_SOURCE_FM_TA = 2UL,
    EN_AMP_SOURCE_AM = 3UL,
    EN_AMP_SOURCE_DAB = 4UL,
    EN_AMP_SOURCE_DAB_TA = 5UL,
    EN_AMP_SOURCE_XMTUN = 6UL,
    EN_AMP_SOURCE_CPRA = 7UL,
    EN_AMP_SOURCE_CDDA = 8UL,
    EN_AMP_SOURCE_AUX = 9UL,
    EN_AMP_SOURCE_SPI_BT_AUDIO = 10UL,
    EN_AMP_SOURCE_SPI_USB = 11UL,
    EN_AMP_SOURCE_SPI_VR_USB = 12UL,
    EN_AMP_SOURCE_SPI_VR_BT_AUDIO = 13UL,
    EN_AMP_SOURCE_SPI_TTS = 14UL,
    EN_AMP_SOURCE_BT_AUDIO = 15UL,
    EN_AMP_SOURCE_PHONE = 16UL,
    EN_AMP_SOURCE_AUX2 = 17UL,
    EN_AMP_SOURCE_VRU = 18UL,
    EN_AMP_SOURCE_SMS = 19UL,
  /**
  * Ex: Navi
  */
    EN_AMP_SOURCE_NAVI = 20UL,
    EN_AMP_SOURCE_CUE = 21UL,
    EN_AMP_SOURCE_MIC = 22UL,
    EN_AMP_SOURCE_PHONE2 = 23UL,
    EN_AMP_SOURCE_CPRA2 = 24UL,
    EN_AMP_SOURCE_IAPPS = 25UL,
    EN_AMP_SOURCE_SPI_MAIN = 26UL,
    EN_AMP_SOURCE_SPI_PHONE = 27UL,
    EN_AMP_SOURCE_SPI_VR = 28UL,
    EN_AMP_SOURCE_SPI_MIX = 29UL,
    EN_AMP_SOURCE_PHONE_ANALOG_EXT = 30UL,
    EN_AMP_SOURCE_PHONE_ECALL = 31UL,
    EN_AMP_SOURCE_PHONE_OUTBAND_RING = 32UL,
    EN_AMP_SOURCE_PHONE_VR = 33UL,
    EN_AMP_SOURCE_SPI_ALERT = 34UL,
    EN_AMP_SOURCE_DRM = 35UL,
  EN_AMP_SOURCE_PHONE_WAIT = 36UL,
    EN_AMP_SOURCE_TCU_ECALL = 37UL,
    EN_AMP_SOURCE_TCU_SERVICECALL = 38UL,
    EN_AMP_SOURCE_TCU_TTS = 39UL,
    EN_AMP_SOURCE_SPI_TRANSIENT = 40UL,
    EN_AMP_SOURCE_WEB_ENT = 41UL,
    EN_AMP_SOURCE_WEB_INFO_USR = 42UL,
    EN_AMP_SOURCE_SXM_TTS = 43UL,
    EN_AMP_SOURCE_SPI_ML_INFO = 44UL,
    EN_AMP_SOURCE_SPI_VR_STEREO = 45UL,
    EN_AMP_SOURCE_BLU_RAY = 46UL,
    EN_AMP_SOURCE_EXTERNAL_CD = 47UL,
    EN_AMP_SOURCE_AUX3 = 48UL,
    EN_AMP_SOURCE_SXM_NEWS = 49UL,
    EN_AMP_SOURCE_IPA_TTS = 50UL,
    EN_AMP_SOURCE_DTV = 51UL,
    EN_AMP_SOURCE_MIC2 = 52UL,
    EN_AMP_SOURCE_AM_TI = 53UL,
    EN_AMP_SOURCE_WEB_INFO_SYSTEM = 54UL,
    EN_AMP_SOURCE_WEB_MIX = 55UL,
    EN_AMP_SOURCE_WEB_TTS = 56UL,
    EN_AMP_SOURCE_AUX2_DIAG = 57UL,
    EN_AMP_SOURCE_VPA_MAIN = 58UL,
    EN_AMP_SOURCE_VPA_SDS = 59UL,
    EN_AMP_SOURCE_VPA_TTS = 60UL,
    EN_AMP_SOURCE_RSE_IN = 61UL,
    EN_AMP_SOURCE_NAVI_BY_SDS = 62UL,
    EN_AMP_SOURCE_USB_VIDEO = 63UL,
    EN_AMP_SOURCE_AUTO_DRIVE = 64UL,
    EN_AMP_SOURCE_DRVASS_VIDEO = 65UL,
    EN_AMP_SOURCE_EXT_MEDIA1 = 66UL,
    EN_AMP_SOURCE_SPARE_CD = 67UL,
  EN_AMP_SOURCE_ECO_TTS = 68UL,
  EN_AMP_SOURCE_EXT_NAVI = 69UL,
    EN_AMP_SOURCE_SRC_MAX = 70UL
};
/**
* \enum amp_tenSettingType
* Enumeration for settings
*/
enum amp_tenSettingType
{
  EN_AMP_SETTINGS_BASS      = 0x00,
  EN_AMP_SETTINGS_MID       = 0x01,
  EN_AMP_SETTINGS_TREBLE    = 0x02,
  EN_AMP_SETTINGS_LOUDNESS  = 0x03,
  EN_AMP_SETTINGS_BALANCE   = 0x04,
  EN_AMP_SETTINGS_FADER     = 0x05,
  EN_AMP_SETTINGS_SDVC      = 0x06,
  EN_AMP_SETTINGS_STAGING   = 0x07,
  EN_AMP_SETTINGS_EQUPRESET = 0x08,
  EN_AMP_SETTINGS_SDDC    = 0x09,
  EN_AMP_SETTINGS_SDFC    = 0x0a,
  EN_AMP_SETTINGS_ROOM_EFFECT    = 0x20,
  EN_AMP_SETTINGS_FM_ENHANCER    = 0x21,
  EN_AMP_SETTINGS_VIRTUAL_SUB_WOOFER  = 0x22,
  EN_AMP_SETTINGS_AUTO_GAIN_CONTROL   = 0x23,
  EN_AMP_SETTINGS_ESE_SOUNDTYPE       = 0x24, //Value here shall match with tenSettingType in ADR3Settings.h
  EN_AMP_SETTINGS_ESE_SOUNDVOLUME     = 0x25, //Value here shall match with tenSettingType in ADR3Settings.h
  EN_AMP_SETTINGS_AUDIO_PILOT_MODE     = 0x26, //Not a setting to ADR3. Change in value here shall be updated in amp_tenSettingType!!!
  EN_AMP_SETTINGS_AUDIO_PILOT_INTENSITY= 0x27,  //Not a setting to ADR3. Change in value here shall be updated in amp_tenSettingType!!!
  EN_AMP_SETTINGS_UPA_TEMP_MUTE        = 0x28,
  EN_AMP_SETTINGS_SR_SOUNDACTIVATION_STATE= 0x29,
  EN_AMP_SETTINGS_UPA_SOUND_COLLECTION =0x2A,
  EN_AMP_SETTINGS_PARK_ASSIST_VOLUME =0x2B,
  EN_AMP_SETTINGS_LDW_USER_VOLUME =0x2C,
  EN_AMP_SETTINGS_BEEP_PLAY  =0x2D,
  EN_AMP_SETTINGS_UNKNOWN             = 0xFF
};
/**
* \enum amp_tenParamFilterChar
* Enumeration for Param Filter
*/
enum amp_tenParamFilterChar
{
  EN_AMP_FILTERCHAR_PEAKING    = 0x00,
  EN_AMP_FILTERCHAR_LOWSHELVING1  = 0x01,
  EN_AMP_FILTERCHAR_HIGHSHELVING1 = 0x02,
  EN_AMP_FILTERCHAR_LOWSHELVING2  = 0x03,
  EN_AMP_FILTERCHAR_HIGHSHELVING2  = 0x04,
  EN_AMP_FILTERCHAR_HIGHPASS    = 0x05,
  EN_AMP_FILTERCHAR_LOWPASS    = 0x06,
  EN_AMP_FILTERCHAR_BANDPASS    = 0x07,
  EN_AMP_FILTERCHAR_ALLPASS    = 0x08,
  EN_AMP_FILTERCHAR_UNKNOWN    = 0xFF
};

/**
* \enum amp_tenMuteAction
Enum for mute action
*/
enum amp_tenMuteAction
{
  EN_AMP_MUTE_MUTEACTION_OFF = 0x00,
  EN_AMP_MUTE_MUTEACTION_ON = 0x01
};
/**
* \enum amp_tenMuteStatus
Enum for mute status
*/
enum amp_tenMuteStatus
{
  EN_AMP_MUTE_MUTED = 0x00,
  EN_AMP_MUTE_DEMUTED = 0x01,
  EN_AMP_MUTE_DEMUTE_IN_PROGRESS = 0x02,
  EN_AMP_MUTE_STATUS_UNKNOWN = 0xFF
};

/**
* \enum amp_tenBeepID
* Enumeration for Beep ID
*/
enum amp_tenBeepID
{
/*  EN_AMP_BEEP_ERROR        = 0x01,
  EN_AMP_BEEP_WARNING        = 0x02,
  EN_AMP_BEEP_ROGGER        = 0x03,
  EN_AMP_BEEP_PDC_FRONT      = 0x04,
  EN_AMP_BEEP_PDC_REAR      = 0x05,
  EN_AMP_BEEP_INDICATOR_LEFT    = 0x06,
  EN_AMP_BEEP_INDICATOR_RIGHT    = 0x07*/

  EN_AMP_BEEP_DUMMY,
  EN_AMP_BEEP_ERROR,
  EN_AMP_BEEP_ROGER,
  EN_AMP_BEEP_WARN,
  EN_AMP_BEEP_CLICK,
  EN_AMP_BEEP_POI,
  EN_AMP_BEEP_SDS_END,
  EN_AMP_BEEP_SMS_INCOMING,
  EN_AMP_BEEP_SMS_SEND,
  EN_AMP_BEEP_URGENT,
  EN_AMP_BEEP_SPEED_WARN,
  EN_AMP_BEEP_CURVE_WARN,
  EN_AMP_BEEP_AVM_OPERATION,
  EN_AMP_BEEP_AVM_ERROR,
  EN_AMP_BEEP_SPEED_HINT,
  EN_AMP_BEEP_CURVE_HINT,
  EN_AMP_BEEP_IPA_NOSOUND,
  EN_AMP_BEEP_IPA_3,
  EN_AMP_BEEP_IPA_7,
  EN_AMP_BEEP_IPA_8,
  EN_AMP_BEEP_IPA_9,
  EN_AMP_BEEP_IPA_10,
  EN_AMP_BEEP_IPA_11,
  EN_AMP_BEEP_IPA_STOP_SOUND,
  EN_AMP_BEEP_SDS_START,
  EN_AMP_BEEP_IPA_4,
  EN_AMP_BEEP_IPA_5,
  EN_AMP_BEEP_IPA_6,
  EN_AMP_BEEP_SPEED_HINT2,
  EN_AMP_BEEP_SPEED_HINT3,
  EN_AMP_BEEP_CURVE_HINT2,
  EN_AMP_BEEP_CURVE_HINT3,
  EN_AMP_BEEP_SDS_END2,
  EN_AMP_BEEP_SMS_INCOMING2,
  EN_AMP_BEEP_IPA_7_2,
  EN_AMP_BEEP_IPA_8_2,
  EN_AMP_BEEP_IPA_8_3,
  EN_AMP_BEEP_IPA_8_4,
  EN_AMP_BEEP_IPA_8_5,
  EN_AMP_BEEP_IPA_11_2,
  EN_AMP_BEEP_ACTUATOR_HMI,
  EN_AMP_BEEP_ACTUATOR_DIAGNOSIS,
  EN_AMP_BEEP_HFP_LVL1_PHASE1,
  EN_AMP_BEEP_HFP_LVL1_PHASE2,
  EN_AMP_BEEP_HFP_LVL1_PHASE3,
  EN_AMP_BEEP_HFP_LVL1_PHASE4,
  EN_AMP_BEEP_HFP_LVL2_PHASE1,
  EN_AMP_BEEP_HFP_LVL2_PHASE2,
  EN_AMP_BEEP_PSM_PHASE1,
  EN_AMP_BEEP_PSM_PHASE2,
  EN_AMP_BEEP_AUTOMATIC_SR,
  EN_AMP_BEEP_USER_SR_PHASE1,
  EN_AMP_BEEP_USER_SR_PHASE2,
  EN_AMP_BEEP_GST_INTERNAL,
  EN_AMP_BEEP_UPA_ERROR_SND,
  EN_AMP_BEEP_UPA_ACTIVATION_SND,
  EN_AMP_BEEP_UPA_OBSTACLE_ZONE,
  EN_AMP_BEEP_UPA_SETTING_SND,
  EN_AMP_BEEP_LDW_SOUND_ALERT,
  EN_AMP_BEEP_LDW_SETTING_SND,
  EN_AMP_BEEP_STOP_ADAS_SETTING_SND,
  EN_AMP_BEEP_MAX
};
/**
* \enum amp_tenBeepState
* Enumeration for Beep state
*/
enum amp_tenBeepState
{
  /** signal tone is not running (stopped or ready) */
  EN_AMP_BEEP_STATE_SIGNAL_TONE_STOP    = 0x00,
  /** signal tone is active */
  EN_AMP_BEEP_STATE_SIGNAL_TONE_RUNNING  = 0x01,
  EN_AMP_BEEP_STATE_UNKNOWN        = 0xFF
};

/**
* \enum amp_tenExtAmpVolumeType
* Enumeration for Ext Amp Volume types
*/
enum amp_tenExtAmpVolumeType
{
   EN_EXTAMP_VOLTYPE_NONE          = 0,
   EN_EXTAMP_VOLTYPE_ENTERTAIN     = 1,
   EN_EXTAMP_VOLTYPE_TELEPHONE     = 2,
   EN_EXTAMP_VOLTYPE_OFFBOARDSDS   = 3,
   EN_EXTAMP_VOLTYPE_TELRINGTONE   = 4,
   EN_EXTAMP_VOLTYPE_PHONECARPLAY  = 6,
   EN_EXTAMP_VOLTYPE_ALERTCARPLAY  = 7,
   EN_EXTAMP_VOLTYPE_ECALL         = 8,
   EN_EXTAMP_VOLTYPE_SERVICECALL   = 9,
   EN_EXTAMP_VOLTYPE_TCUTTS        = 10,
   EN_EXTAMP_VOLTYPE_SDS           = 11,
   EN_EXTAMP_VOLTYPE_DAN           = 12,
   EN_EXTAMP_VOLTYPE_SPIINFO       = 13,
   EN_EXTAMP_VOLTYPE_NAVIGATION    = 14,
   EN_EXTAMP_VOLTYPE_PARKASSIST    = 15,
   EN_EXTAMP_VOLTYPE_LATERALASSIST = 16
};

/**
* \enum amp_tenSignalToneAction
* Enumeration for Signal tone action
*/
enum amp_tenSignalToneAction
{
  /**
  * set only new parameter, without start of signal tone
  */
  EN_AMP_SIG_TONE_NO_ACTION = 0x00,
  EN_AMP_SIG_TONE_ACTION_STOP_IMMEDIATELY = 0x01,
  EN_AMP_SIG_TONE_ACTION_STOP_AFTER_PULSE = 0x02,
  EN_AMP_SIG_TONE_ACTION_STOP_CURRENT_START_NEW = 0x03,
  /**
  * If no beep is running, beep statrs immediatly
  */
  EN_AMP_SIG_TONE_ACTION_START_AFTER_CURRENT_BEEP = 0x04
};
/**
* \enum amp_tenCarSettingType
* Enumeration for Car Setting Type
*/
enum amp_tenCarSettingType
{
  EN_AMP_CAR_SETTING_CARSPEEDID    = 0x00,
  EN_AMP_CAR_SETTING_CARREVOLUTIONID  = 0x01
};

/**
* \enum amp_tenFrequencyIndex
* Enumeration for frequency index
*/
enum amp_tenFrequencyIndex
{
  EN_AMP_FREQINDEX_20_0HZ  =0x00,
  EN_AMP_FREQINDEX_20_6HZ  =0x01,
  EN_AMP_FREQINDEX_21_2HZ  =0x02,
  EN_AMP_FREQINDEX_21_8HZ  =0x03,
  EN_AMP_FREQINDEX_22_4HZ  =0x04,
  EN_AMP_FREQINDEX_23_1HZ  =0x05,
  EN_AMP_FREQINDEX_23_8HZ  =0x06,
  EN_AMP_FREQINDEX_24_5HZ  =0x07,
  EN_AMP_FREQINDEX_25_2HZ  =0x08,
  EN_AMP_FREQINDEX_25_9HZ  =0x09,
  EN_AMP_FREQINDEX_26_7HZ  =0x0A,
  EN_AMP_FREQINDEX_27_5HZ  =0x0B,
  EN_AMP_FREQINDEX_28_3HZ  =0x0C,
  EN_AMP_FREQINDEX_29_1HZ  =0x0D,
  EN_AMP_FREQINDEX_30_0HZ  =0x0E,
  EN_AMP_FREQINDEX_30_8HZ  =0x0F,
  EN_AMP_FREQINDEX_31_7HZ  =0x10,
  EN_AMP_FREQINDEX_32_7HZ  =0x11,
  EN_AMP_FREQINDEX_33_6HZ  =0x12,
  EN_AMP_FREQINDEX_34_6HZ  =0x13,
  EN_AMP_FREQINDEX_35_6HZ  =0x14,
  EN_AMP_FREQINDEX_36_7HZ  =0x15,
  EN_AMP_FREQINDEX_37_8HZ  =0x16,
  EN_AMP_FREQINDEX_38_9HZ  =0x17,
  EN_AMP_FREQINDEX_40_0HZ  =0x18,
  EN_AMP_FREQINDEX_41_2HZ  =0x19,
  EN_AMP_FREQINDEX_42_4HZ  =0x1A,
  EN_AMP_FREQINDEX_43_6HZ  =0x1B,
  EN_AMP_FREQINDEX_44_9HZ  =0x1C,
  EN_AMP_FREQINDEX_46_2HZ  =0x1D,
  EN_AMP_FREQINDEX_47_6HZ  =0x1E,
  EN_AMP_FREQINDEX_49_0HZ  =0x1F,
  EN_AMP_FREQINDEX_50_4HZ  =0x20,
  EN_AMP_FREQINDEX_51_9HZ  =0x21,
  EN_AMP_FREQINDEX_53_4HZ  =0x22,
  EN_AMP_FREQINDEX_55_0HZ  =0x23,
  EN_AMP_FREQINDEX_56_6HZ  =0x24,
  EN_AMP_FREQINDEX_58_2HZ  =0x25,
  EN_AMP_FREQINDEX_59_9HZ  =0x26,
  EN_AMP_FREQINDEX_61_7HZ  =0x27,
  EN_AMP_FREQINDEX_63_5HZ  =0x28,
  EN_AMP_FREQINDEX_65_4HZ  =0x29,
  EN_AMP_FREQINDEX_67_3HZ  =0x2A,
  EN_AMP_FREQINDEX_69_2HZ  =0x2B,
  EN_AMP_FREQINDEX_71_3HZ  =0x2C,
  EN_AMP_FREQINDEX_73_4HZ  =0x2D,
  EN_AMP_FREQINDEX_75_5HZ  =0x2E,
  EN_AMP_FREQINDEX_77_7HZ  =0x2F,
  EN_AMP_FREQINDEX_80_0HZ  =0x30,
  EN_AMP_FREQINDEX_82_3HZ  =0x31,
  EN_AMP_FREQINDEX_84_8HZ  =0x32,
  EN_AMP_FREQINDEX_87_2HZ  =0x33,
  EN_AMP_FREQINDEX_89_8HZ  =0x34,
  EN_AMP_FREQINDEX_92_4HZ  =0x35,
  EN_AMP_FREQINDEX_95_1HZ  =0x36,
  EN_AMP_FREQINDEX_97_9HZ  =0x37,
  EN_AMP_FREQINDEX_101_HZ  =0x38,
  EN_AMP_FREQINDEX_104_HZ  =0x39,
  EN_AMP_FREQINDEX_107_HZ  =0x3A,
  EN_AMP_FREQINDEX_110_HZ  =0x3B,
  EN_AMP_FREQINDEX_113_HZ  =0x3C,
  EN_AMP_FREQINDEX_116_HZ  =0x3D,
  EN_AMP_FREQINDEX_120_HZ  =0x3E,
  EN_AMP_FREQINDEX_123_HZ  =0x3F,
  EN_AMP_FREQINDEX_127_HZ  =0x40,
  EN_AMP_FREQINDEX_131_HZ  =0x41,
  EN_AMP_FREQINDEX_135_HZ  =0x42,
  EN_AMP_FREQINDEX_138_HZ  =0x43,
  EN_AMP_FREQINDEX_143_HZ  =0x44,
  EN_AMP_FREQINDEX_147_HZ  =0x45,
  EN_AMP_FREQINDEX_151_HZ  =0x46,
  EN_AMP_FREQINDEX_155_HZ  =0x47,
  EN_AMP_FREQINDEX_160_HZ  =0x48,
  EN_AMP_FREQINDEX_165_HZ  =0x49,
  EN_AMP_FREQINDEX_170_HZ  =0x4A,
  EN_AMP_FREQINDEX_174_HZ  =0x4B,
  EN_AMP_FREQINDEX_180_HZ  =0x4C,
  EN_AMP_FREQINDEX_185_HZ  =0x4D,
  EN_AMP_FREQINDEX_190_HZ  =0x4E,
  EN_AMP_FREQINDEX_196_HZ  =0x4F,
  EN_AMP_FREQINDEX_202_HZ  =0x50,
  EN_AMP_FREQINDEX_207_HZ  =0x51,
  EN_AMP_FREQINDEX_214_HZ  =0x52,
  EN_AMP_FREQINDEX_220_HZ  =0x53,
  EN_AMP_FREQINDEX_226_HZ  =0x54,
  EN_AMP_FREQINDEX_233_HZ  =0x55,
  EN_AMP_FREQINDEX_240_HZ  =0x56,
  EN_AMP_FREQINDEX_247_HZ  =0x57,
  EN_AMP_FREQINDEX_254_HZ  =0x58,
  EN_AMP_FREQINDEX_261_HZ  =0x59,
  EN_AMP_FREQINDEX_269_HZ  =0x5A,
  EN_AMP_FREQINDEX_277_HZ  =0x5B,
  EN_AMP_FREQINDEX_285_HZ  =0x5C,
  EN_AMP_FREQINDEX_293_HZ  =0x5D,
  EN_AMP_FREQINDEX_302_HZ  =0x5E,
  EN_AMP_FREQINDEX_311_HZ  =0x5F,
  EN_AMP_FREQINDEX_320_HZ  =0x60,
  EN_AMP_FREQINDEX_329_HZ  =0x61,
  EN_AMP_FREQINDEX_339_HZ  =0x62,
  EN_AMP_FREQINDEX_349_HZ  =0x63,
  EN_AMP_FREQINDEX_359_HZ  =0x64,
  EN_AMP_FREQINDEX_370_HZ  =0x65,
  EN_AMP_FREQINDEX_381_HZ  =0x66,
  EN_AMP_FREQINDEX_392_HZ  =0x67,
  EN_AMP_FREQINDEX_403_HZ  =0x68,
  EN_AMP_FREQINDEX_415_HZ  =0x69,
  EN_AMP_FREQINDEX_427_HZ  =0x6A,
  EN_AMP_FREQINDEX_440_HZ  =0x6B,
  EN_AMP_FREQINDEX_453_HZ  =0x6C,
  EN_AMP_FREQINDEX_466_HZ  =0x6D,
  EN_AMP_FREQINDEX_479_HZ  =0x6E,
  EN_AMP_FREQINDEX_494_HZ  =0x6F,
  EN_AMP_FREQINDEX_508_HZ  =0x70,
  EN_AMP_FREQINDEX_523_HZ  =0x71,
  EN_AMP_FREQINDEX_538_HZ  =0x72,
  EN_AMP_FREQINDEX_554_HZ  =0x73,
  EN_AMP_FREQINDEX_570_HZ  =0x74,
  EN_AMP_FREQINDEX_587_HZ  =0x75,
  EN_AMP_FREQINDEX_604_HZ  =0x76,
  EN_AMP_FREQINDEX_622_HZ  =0x77,
  EN_AMP_FREQINDEX_640_HZ  =0x78,
  EN_AMP_FREQINDEX_659_HZ  =0x79,
  EN_AMP_FREQINDEX_678_HZ  =0x7A,
  EN_AMP_FREQINDEX_698_HZ  =0x7B,
  EN_AMP_FREQINDEX_718_HZ  =0x7C,
  EN_AMP_FREQINDEX_739_HZ  =0x7D,
  EN_AMP_FREQINDEX_761_HZ  =0x7E,
  EN_AMP_FREQINDEX_783_HZ  =0x7F,
  EN_AMP_FREQINDEX_806_HZ  =0x80,
  EN_AMP_FREQINDEX_830_HZ  =0x81,
  EN_AMP_FREQINDEX_854_HZ  =0x82,
  EN_AMP_FREQINDEX_879_HZ  =0x83,
  EN_AMP_FREQINDEX_905_HZ  =0x84,
  EN_AMP_FREQINDEX_932_HZ  =0x85,
  EN_AMP_FREQINDEX_959_HZ  =0x86,
  EN_AMP_FREQINDEX_987_HZ  =0x87,
  EN_AMP_FREQINDEX_1016_HZ  =0x88,
  EN_AMP_FREQINDEX_1046_HZ  =0x89,
  EN_AMP_FREQINDEX_1076_HZ  =0x8A,
  EN_AMP_FREQINDEX_1108_HZ  =0x8B,
  EN_AMP_FREQINDEX_1140_HZ  =0x8C,
  EN_AMP_FREQINDEX_1174_HZ  =0x8D,
  EN_AMP_FREQINDEX_1208_HZ  =0x8E,
  EN_AMP_FREQINDEX_1244_HZ  =0x8F,
  EN_AMP_FREQINDEX_1280_HZ  =0x90,
  EN_AMP_FREQINDEX_1318_HZ  =0x91,
  EN_AMP_FREQINDEX_1356_HZ  =0x92,
  EN_AMP_FREQINDEX_1396_HZ  =0x93,
  EN_AMP_FREQINDEX_1437_HZ  =0x94,
  EN_AMP_FREQINDEX_1479_HZ  =0x95,
  EN_AMP_FREQINDEX_1522_HZ  =0x96,
  EN_AMP_FREQINDEX_1567_HZ  =0x97,
  EN_AMP_FREQINDEX_1613_HZ  =0x98,
  EN_AMP_FREQINDEX_1660_HZ  =0x99,
  EN_AMP_FREQINDEX_1709_HZ  =0x9A,
  EN_AMP_FREQINDEX_1759_HZ  =0x9B,
  EN_AMP_FREQINDEX_1810_HZ  =0x9C,
  EN_AMP_FREQINDEX_1863_HZ  =0x9D,
  EN_AMP_FREQINDEX_1918_HZ  =0x9E,
  EN_AMP_FREQINDEX_1974_HZ  =0x9F,
  EN_AMP_FREQINDEX_2032_HZ  =0xA0,
  EN_AMP_FREQINDEX_2091_HZ  =0xA1,
  EN_AMP_FREQINDEX_2153_HZ  =0xA2,
  EN_AMP_FREQINDEX_2216_HZ  =0xA3,
  EN_AMP_FREQINDEX_2281_HZ  =0xA4,
  EN_AMP_FREQINDEX_2348_HZ  =0xA5,
  EN_AMP_FREQINDEX_2416_HZ  =0xA6,
  EN_AMP_FREQINDEX_2487_HZ  =0xA7,
  EN_AMP_FREQINDEX_2560_HZ  =0xA8,
  EN_AMP_FREQINDEX_2635_HZ  =0xA9,
  EN_AMP_FREQINDEX_2712_HZ  =0xAA,
  EN_AMP_FREQINDEX_2792_HZ  =0xAB,
  EN_AMP_FREQINDEX_2874_HZ  =0xAC,
  EN_AMP_FREQINDEX_2958_HZ  =0xAD,
  EN_AMP_FREQINDEX_3044_HZ  =0xAE,
  EN_AMP_FREQINDEX_3134_HZ  =0xAF,
  EN_AMP_FREQINDEX_3225_HZ  =0xB0,
  EN_AMP_FREQINDEX_3320_HZ  =0xB1,
  EN_AMP_FREQINDEX_3417_HZ  =0xB2,
  EN_AMP_FREQINDEX_3517_HZ  =0xB3,
  EN_AMP_FREQINDEX_3620_HZ  =0xB4,
  EN_AMP_FREQINDEX_3726_HZ  =0xB5,
  EN_AMP_FREQINDEX_3836_HZ  =0xB6,
  EN_AMP_FREQINDEX_3948_HZ  =0xB7,
  EN_AMP_FREQINDEX_4064_HZ  =0xB8,
  EN_AMP_FREQINDEX_4183_HZ  =0xB9,
  EN_AMP_FREQINDEX_4305_HZ  =0xBA,
  EN_AMP_FREQINDEX_4432_HZ  =0xBB,
  EN_AMP_FREQINDEX_4561_HZ  =0xBC,
  EN_AMP_FREQINDEX_4695_HZ  =0xBD,
  EN_AMP_FREQINDEX_4833_HZ  =0xBE,
  EN_AMP_FREQINDEX_4974_HZ  =0xBF,
  EN_AMP_FREQINDEX_5120_HZ  =0xC0,
  EN_AMP_FREQINDEX_5270_HZ  =0xC1,
  EN_AMP_FREQINDEX_5424_HZ  =0xC2,
  EN_AMP_FREQINDEX_5583_HZ  =0xC3,
  EN_AMP_FREQINDEX_5747_HZ  =0xC4,
  EN_AMP_FREQINDEX_5915_HZ  =0xC5,
  EN_AMP_FREQINDEX_6089_HZ  =0xC6,
  EN_AMP_FREQINDEX_6267_HZ  =0xC7,
  EN_AMP_FREQINDEX_6451_HZ  =0xC8,
  EN_AMP_FREQINDEX_6640_HZ  =0xC9,
  EN_AMP_FREQINDEX_6834_HZ  =0xCA,
  EN_AMP_FREQINDEX_7035_HZ  =0xCB,
  EN_AMP_FREQINDEX_7241_HZ  =0xCC,
  EN_AMP_FREQINDEX_7453_HZ  =0xCD,
  EN_AMP_FREQINDEX_7671_HZ  =0xCE,
  EN_AMP_FREQINDEX_7896_HZ  =0xCF,
  EN_AMP_FREQINDEX_8127_HZ  =0xD0,
  EN_AMP_FREQINDEX_8366_HZ  =0xD1,
  EN_AMP_FREQINDEX_8611_HZ  =0xD2,
  EN_AMP_FREQINDEX_8863_HZ  =0xD3,
  EN_AMP_FREQINDEX_9123_HZ  =0xD4,
  EN_AMP_FREQINDEX_9390_HZ  =0xD5,
  EN_AMP_FREQINDEX_9665_HZ  =0xD6,
  EN_AMP_FREQINDEX_9948_HZ  =0xD7,
  EN_AMP_FREQINDEX_10240_HZ  =0xD8,
  EN_AMP_FREQINDEX_10540_HZ  =0xD9,
  EN_AMP_FREQINDEX_10849_HZ  =0xDA,
  EN_AMP_FREQINDEX_11167_HZ  =0xDB,
  EN_AMP_FREQINDEX_11494_HZ  =0xDC,
  EN_AMP_FREQINDEX_11831_HZ  =0xDD,
  EN_AMP_FREQINDEX_12177_HZ  =0xDE,
  EN_AMP_FREQINDEX_12534_HZ  =0xDF,
  EN_AMP_FREQINDEX_12902_HZ  =0xE0,
  EN_AMP_FREQINDEX_13280_HZ  =0xE1,
  EN_AMP_FREQINDEX_13669_HZ  =0xE2,
  EN_AMP_FREQINDEX_14069_HZ  =0xE3,
  EN_AMP_FREQINDEX_14482_HZ  =0xE4,
  EN_AMP_FREQINDEX_14906_HZ  =0xE5,
  EN_AMP_FREQINDEX_15343_HZ  =0xE6,
  EN_AMP_FREQINDEX_15792_HZ  =0xE7,
  EN_AMP_FREQINDEX_16255_HZ  =0xE8,
  EN_AMP_FREQINDEX_16731_HZ  =0xE9,
  EN_AMP_FREQINDEX_17222_HZ  =0xEA,
  EN_AMP_FREQINDEX_17726_HZ  =0xEB,
  EN_AMP_FREQINDEX_18246_HZ  =0xEC,
  EN_AMP_FREQINDEX_18780_HZ  =0xED,
  EN_AMP_FREQINDEX_19331_HZ  =0xEE,
  EN_AMP_FREQINDEX_19897_HZ  =0xEF
};


/**
\typedef uint16_t vdamp_pluginID_t
*/
typedef uint16_t vdamp_pluginID_t;

/**
 * \class vdamp_plugin_amplifierdata
 * \brief This class is used to hold the information about the connected amplifier.
 */
class vdamp_plugin_amplifierdata
{
public:
  vdamp_plugin_amplifierdata()
  :m_ampname(),m_u32Major(0),m_u32Minor(0){}
  ~vdamp_plugin_amplifierdata(){}
  std::string m_ampname;/*!< Name of the amplifier.*/
  uint32_t  m_u32Major;/*!< Major version.*/
  uint32_t  m_u32Minor;/*!< Minor Version.*/
};


// Values for SOUND_ITEM_TYPE_SOUNDSYSTEM
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1     ((tU8)0x01)  //internal amplifier
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM2     ((tU8)0x02)  //internal amplifier with SUB
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM3     ((tU8)0x03)  //analog amplifier1 [e.g. FOSGATE with special sound]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM4     ((tU8)0x04)  //analog amplifier 1 [e.g. BOSE with special sound]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM5     ((tU8)0x05)  //analog amplifier3 [no special sound handling]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM6     ((tU8)0x06)  //MOST amplifier [ audio settings done by amplifier]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM7     ((tU8)0x07)  //BAP amplifier [ audio settings done by amplifier]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM8     ((tU8)0x08)  //BOSE amplifier [special sound and level, audio settings done by amplifier]

// Values for SOUND_ITEM_TYPE_SPEAKER
#define SOUND_CONFIG_ITEM_VALUE_4SPEAKER         ((tU8)0x01)
#define SOUND_CONFIG_ITEM_VALUE_2SPEAKER_FRONT   ((tU8)0x02)
#define SOUND_CONFIG_ITEM_VALUE_2SPEAKER_REAR    ((tU8)0x03)

#endif /* VDAMP_PLUGIN_TYPES_H_ */
