/*
 * eamp-plugin-send.h
 *
 *  Created on: Nov 28, 2013
 *      Author: rjk2kor
 */

#ifndef EAMP_PLUGIN_SEND_H_
#define EAMP_PLUGIN_SEND_H_

#include "vdamp-plugin-send.h"
#include "vdamp-plugin-receive.h"


class eamp_plugin_management_interface : public vdamp_plugin_sender
{
private:
  vdamp_pluginID_t m_pluginID;
  vdamp_plugin_receiver* m_ptrReceiver;
  //Functional senders
  vdamp_plugin_sender_interfaces m_senderinterface;

public:
  eamp_plugin_management_interface();
  virtual ~eamp_plugin_management_interface();
  /**
   * Functions over ridden from base class
   */
  virtual bool bInitPlugin(vdamp_pluginID_t pluginID, vdamp_plugin_receiver* ptrReceiver);
  virtual void vDeInitPlugin();
  virtual vdamp_plugin_sender_interfaces oGetInterfaceData();
  virtual vdamp_plugin_amplifierdata oGetAmplifierInfo();
  virtual void vAmp_Rx_FromCCAThread (uint8_t* ptrStream , size_t length );
  /**
   * Additional functions
   */
  /**
   * Function to provide the pointer to receiver
   */
  vdamp_plugin_receiver* poGetReceiver()
  {
    return m_ptrReceiver;
  }
  /**
   * Functions to get the plugin ID
   */
  vdamp_pluginID_t tGetPluginID()
  {
    return m_pluginID;
  }
};




#endif /* EAMP_PLUGIN_SEND_H_ */
