/*
 * eamp-plugin-send.cpp
 *
 *  Created on: Nov 28, 2013
 *      Author: rjk2kor
 */

#include "eamp-plugin-send.h"

// Includes all header files for FI of DP-component
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_audio_if.h"

#include <iostream>

//using namespace std;
using namespace std;
/********************************
 * PLUGIN Entry function
 */
#ifdef __cplusplus
extern "C"
{
  vdamp_plugin_sender* getpluginpointer()
  {
    return new eamp_plugin_management_interface();
  }
}
#endif

eamp_plugin_management_interface::eamp_plugin_management_interface()
:m_pluginID(0),
 m_ptrReceiver(NULL),
 m_senderinterface()
{
  m_extAmpConfig = 0;//Doing nothing, will create instances in bOnInit
}

eamp_plugin_management_interface::~eamp_plugin_management_interface()
{
  m_ptrReceiver = NULL;
}

bool eamp_plugin_management_interface::bInitPlugin(vdamp_pluginID_t pluginID, vdamp_plugin_receiver* ptrReceiver)
{
  if(ptrReceiver != NULL)
  {
    //Copy plugin ID locally
    m_pluginID = pluginID;
    //Copy the receiver for local reference
    m_ptrReceiver = ptrReceiver;

    //reading the amplifier configuration from the KDS datapool
      tU8 ExtAmpConfig;
        if (DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation", &ExtAmpConfig, 1))
    {
      m_extAmpConfig = ExtAmpConfig;

      switch(m_extAmpConfig)
      {
        case 0://Internal Amplifier 2 channel
    case 9:// Internal Amplifier 4channel
  case 8:// Head Unit alone, ANC box Nissan
       m_ptrReceiver->vAmp_SetADRSoundConfigItem(SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1);
      //Just simply inform plugin detected, actual detection logic to be implemented later
      m_ptrReceiver->vPluginConnect(m_pluginID,false);
       break;
     case 2://BOse without MCAN
       m_ptrReceiver->vAmp_SetADRSoundConfigItem(SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM4);
      //Just simply inform plugin detected, actual detection logic to be implemented later
      m_ptrReceiver->vPluginConnect(m_pluginID,true);
         break;
    case 5://ANC to 'aivi_boseamp' plugin
    m_ptrReceiver->vAmp_SetADRSoundConfigItem(SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM5);
    m_ptrReceiver->vPluginConnect(m_pluginID,false);
      break;
  case 11: //Bose Personal Space
   m_ptrReceiver->vAmp_SetADRSoundConfigItem(SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM4);
      //Just simply inform plugin detected, actual detection logic to be implemented later
      m_ptrReceiver->vPluginConnect(m_pluginID,true);
  break;

    default:
      m_ptrReceiver->vPluginConnect(m_pluginID,false);
      break;
      }
    }
    return true;
  }
  return false;
}

void eamp_plugin_management_interface::vDeInitPlugin()
{
  //cout<<"vDeInitPlugin invoked for plugin : "<<m_pluginID<<endl;
  //Free all memory allocated, in general, disable any running threads first before deleting the resources

  m_ptrReceiver = NULL;
}

vdamp_plugin_sender_interfaces eamp_plugin_management_interface::oGetInterfaceData()
{
  //cout<<"Sending Interface data for plugin : "<<m_pluginID<<endl;
  return m_senderinterface;
}

vdamp_plugin_amplifierdata eamp_plugin_management_interface::oGetAmplifierInfo()
{
  //cout<<"Sending Amplifier info for plugin : "<<m_pluginID<<endl;
  vdamp_plugin_amplifierdata temp;
  temp.m_ampname = "BOSE amplifier";
  temp.m_u32Major = 1;
  temp.m_u32Minor = 0;

  return temp;
}

/**
 * Will take care of this later
 */
void eamp_plugin_management_interface::vAmp_Rx_FromCCAThread (uint8_t* /*ptrStream*/ , size_t /*length*/ )
{

}
