/*!
********************************************************************************
* \file              arl_tclStrClienthandler.cpp
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:
*  - COPYRIGHT:      &copy; 2010 - 2011 Robert Bosch Car Multimedia Gmbh
********************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 31.01.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "arl_tclStrClienthandler.h"
#include "arl_tclISourceVFsm.h"
#include "arl_Trace.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_FUNCTIONIDS
#include <midw_fi_if.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_BASE_CLIENT
#include "trcGenProj/Header/arl_tclStrClienthandler.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/


/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  arl_tclStrClienthandler::arl_tclStrClienthandler(ahl_tclBaseO..
******************************************************************************/

arl_tclStrClienthandler::arl_tclStrClienthandler
(
   ahl_tclBaseOneThreadApp* const cpoApp
   , arl_tclISourceVFsm* const cpoISourceVFsm
   , tU16 u16ServiceID
   , tU16 u16SrvMajVer
   , tU16 u16SrvMinVer
):arl_tclBaseClienthandler(cpoApp, cpoISourceVFsm, u16ServiceID, u16SrvMajVer, u16SrvMinVer)
{
   // Auto register for property - Routing state.
   vAddAutoRegisterForProperty(MIDW_STREAMROUTERFI_C_U16_ROUTINGSTATE);

} // arl_tclStrClienthandler::arl_tclStrClienthandler(ahl_tclBaseOneThreadA..

/******************************************************************************
** FUNCTION:  virtual arl_tclStrClienthandler::~arl_tclStrClienthandler()
******************************************************************************/

/*virtual*/
arl_tclStrClienthandler::~arl_tclStrClienthandler()
{

} // arl_tclStrClienthandler::~arl_tclStrClienthandler()

/******************************************************************************
** FUNCTION:  tVoid arl_tclStrClienthandler::vOnStatus(tU16 u16FID,am..
******************************************************************************/

/*virtual*/
tVoid arl_tclStrClienthandler::vOnStatus(tU16 u16FID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("vOnStatus message for service %d FID %d received from \
      ServerAppId: 0x%x(%d)>>>AppId: 0x%x(%d)"
      , ETG_ENUM(ail_u16ServiceId, (tU16)u16GetServiceID()), u16FID
      , poMessage->u16GetTargetAppID(), poMessage->u16GetTargetAppID()
      , poMessage->u16GetSourceAppID(), poMessage->u16GetSourceAppID()));

   if (OSAL_NULL != m_cpoISourceVFsm)
   {
      if (FALSE == m_cpoISourceVFsm->bOnMessage(poMessage))
      {
         vOnUnknownMessage(poMessage);

      }  // if (FALSE == m_cpoISourceVFsm->bOnMessage(poMessage))

   }  // if (OSAL_NULL != m_cpoISourceVFsm)

}  // tVoid arl_tclStrClienthandler::vOnStatus(tU16 u16FID, amt_tclServ..

////////////////////////////////////////////////////////////////////////////////

// <EOF>
