/*!
*******************************************************************************
* \file              arl_tclISource.cpp
*******************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    Implements the ISource interface.
*  - COPYRIGHT:      &copy; 2010 - 2012 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 25.08.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Removed the overriden eUpdateClients() from FWK.
*
* \date 28.04.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Bug fix for JIRA ticket GMNGA-9383: Correction for handling with property
* notification.
*
* \date 15.12.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include <generic_msgs_if.h>


#include "arl_tclISource.h"
#include "arl_tclISrcVFsm.h"
#include "arl_LookupTable.h"
#include "arl_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_ISOURCE
#include "trcGenProj/Header/arl_tclISource.cpp.trc.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_SERVICEINFO

#include "midw_fi_if.h"

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| Utilizing the Framework for message map abstraction.
|----------------------------------------------------------------------------*/

BEGIN_MSG_MAP(arl_tclISource, ahl_tclBaseWork)

   ON_MESSAGE_SVCDATA(ARL_EN_ALLOCATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)
   ON_MESSAGE_SVCDATA(ARL_EN_DEALLOCATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)
   ON_MESSAGE_SVCDATA(ARL_EN_SOURCEACTIVITY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)

   ON_MESSAGE_SVCDATA(ARL_EN_LOOPBACK, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)
   ON_MESSAGE_SVCDATA(ARL_EN_SRCACTTIMEREXPIRY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)

   ON_MESSAGE_SVCDATA(ARL_EN_MUTE_REQ, AMT_C_U8_CCAMSG_OPCODE_GET,   vCCA_OnUpRegMuteReq)
   ON_MESSAGE_SVCDATA(ARL_EN_MUTE_REQ, AMT_C_U8_CCAMSG_OPCODE_UPREG, vCCA_OnUpRegMuteReq)

   ON_MESSAGE_SVCDATA(ARL_EN_ROUTEREQUEST, AMT_C_U8_CCAMSG_OPCODE_GET,   vCCA_OnUpRegRouteReq)
   ON_MESSAGE_SVCDATA(ARL_EN_ROUTEREQUEST, AMT_C_U8_CCAMSG_OPCODE_UPREG, vCCA_OnUpRegRouteReq)

   ON_MESSAGE_SVCDATA(ARL_EN_MUTE_STATE, AMT_C_U8_CCAMSG_OPCODE_SET, vCCA_OnMuteState)

   // Loopback handler function.
   ON_MESSAGE_SVCDATA(ARL_EN_SOURCEACTIVITY, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vOnMrISource)

   ON_MESSAGE_SVCDATA(ARL_EN_AUDIOROUTEREQUESTREJECT, AMT_C_U8_CCAMSG_OPCODE_SET, vOnAudioRouteRequestReject)
END_MSG_MAP()

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  arl_tclISource::arl_tclISource(ahl_tclBaseOneThreadApp* co...
******************************************************************************/

arl_tclISource::arl_tclISource(  ahl_tclBaseOneThreadApp* /*const*/ cpoApp) :
   ahl_tclBaseOneThreadService(cpoApp, CCA_C_U16_SRV_AUD_SRC_ROUTE, 1, 0, 0)
   , arl_tclISourceIF(cpoApp, CCA_C_U16_SRV_AUD_SRC_ROUTE)
   , m_bSrcAvailable(FALSE)
{
   m_poISourceVFsm   =  OSAL_NEW arl_tclISrcVFsm(cpoApp, this);
   NORMAL_M_ASSERT(OSAL_NULL != m_poISourceVFsm);
   ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(FALSE);
} // arl_tclISource::arl_tclISource(ahl_tclBaseOneThreadApp *const cpoApp, t..

arl_tclISource::arl_tclISource(ahl_tclBaseOneThreadApp* const cpoApp, arl_tclStrClientHandler_ASF_IF* poAsfStrClh) :
   ahl_tclBaseOneThreadService(cpoApp, CCA_C_U16_SRV_AUD_SRC_ROUTE, 1, 0, 0)
   , arl_tclISourceIF(cpoApp, CCA_C_U16_SRV_AUD_SRC_ROUTE)
   , m_bSrcAvailable(FALSE)
{
   m_poISourceVFsm   =  OSAL_NEW arl_tclISrcVFsm(cpoApp, this, poAsfStrClh);
   NORMAL_M_ASSERT(OSAL_NULL != m_poISourceVFsm);
   ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(FALSE);
}

/******************************************************************************
** FUNCTION:  virtual arl_tclISource::~arl_tclISource()
******************************************************************************/

/*virtual*/
arl_tclISource::~arl_tclISource()
{
   try
   {
      OSAL_DELETE m_poISourceVFsm;
   }
   catch(...)
   {
   }

   m_poISourceVFsm   =  OSAL_NULL;

} // arl_tclISource::~arl_tclISource()


tVoid arl_tclISource::vOnNewAppStateNotify(tU32 u32OldAppState,tU32 u32AppState)
{
   arl_tclISourceIF::vOnNewAppStateNotify( u32OldAppState, u32AppState);
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bSendMessage( const amt_tclSe..
******************************************************************************/

tBool arl_tclISource::bSendMessage
(
   const amt_tclServiceData& rfcoServiceData
   , const fi_tclMessageBase& rfcoMsgBase
)
{
   tU16 u16ServMajVer   =  1;
   tU16 u16ServMinVer   =  0;
   tU16 u16ServPatchVer =  0;

   // Get the Fi Versions.
   (tVoid)bGetServiceVersion(ahl_tclBaseOneThreadObject::u16GetServiceID(), u16ServMajVer, u16ServMinVer
      , u16ServPatchVer);

   // Create the Visitor Message
   fi_tclVisitorMessage oOutVisitorMsg(rfcoMsgBase.corfoGetTypeBase(), u16ServMajVer);

   // Set the CCA message information
   vInitServiceData
   (
      oOutVisitorMsg                               // Visitor msg reference.
      , rfcoServiceData.u16GetSourceAppID()        // Dest. app-ID
      , rfcoServiceData.u16GetRegisterID()         // Register ID
      , rfcoServiceData.u16GetCmdCounter()         // Command counter
      , rfcoMsgBase.u16GetFunctionID()             // Function-ID
      , rfcoMsgBase.u8GetOpCode()                  // OpCode
   );

   ETG_TRACE_USR4(("%d: Sending message with Opcode: %d, Version: %d, ServiceId: %d, \
                   RegId: %d, FID: %x, SrcAppId: %d, TargAppId: %d, CmdCntr: %d"
                   , ETG_ENUM(ail_u16AppId, u16GetAppID())
                   , (tU8)oOutVisitorMsg.u8GetOpCode()
                   , oOutVisitorMsg.u16GetVersion(), oOutVisitorMsg.u16GetServiceID()
                   , oOutVisitorMsg.u16GetRegisterID()
                   , oOutVisitorMsg.u16GetFunctionID()
                   , ETG_ENUM(ail_u16AppId, oOutVisitorMsg.u16GetSourceAppID())
                   , ETG_ENUM(ail_u16AppId, oOutVisitorMsg.u16GetTargetAppID())
                   , oOutVisitorMsg.u16GetCmdCounter()
                   ));

   // Post the message to message Queue.
   tBool bRetVal     =  TRUE;

   if (FALSE != oOutVisitorMsg.bIsValid())
   {
      // Post the message to message queue
      ail_tenCommunicationError enCommError =
         _poMainAppl->enPostMessage(&oOutVisitorMsg, TRUE);

      if (AIL_EN_N_NO_ERROR != enCommError)
      {
         bRetVal  =  FALSE;
         ETG_TRACE_ERR(("%d: Communication Error : %d, could not post message"
            , ETG_ENUM(ail_u16AppId, u16GetAppID())
            , ETG_ENUM(AIL_ERROR, enCommError)));
      }  // if (AIL_EN_N_NO_ERROR != enCommError)

   }  //if( FALSE != oOutVisitorMsg.bIsValid())
   else
   {
      bRetVal  =  FALSE;
      ETG_TRACE_ERR(("Invalid message!!!"));
   }  //End of if-else; if (FALSE != oOutVisitorMsg.bIsValid())

   return bRetVal;

}  // tBool arl_tclISource::bSendMessage(const amt_tclServiceData &rf..

/******************************************************************************
** FUNCTION:    amt_tclServiceData* arl_tclISource::pStatusMessageFactory(t..
******************************************************************************/


/******************************************************************************
** FUNCTION:  virtual tBool arl_tclISource::bSrcAvailable() const
******************************************************************************/

/*virtual*/
tBool arl_tclISource::bSrcAvailable() const
{
   return m_bSrcAvailable;
}  // tBool arl_tclISource::bSrcAvailable() const

/******************************************************************************
** FUNCTION:  virtual tVoid arl_tclISource::vSetSrcAvailable(tBool bSrcAvail)
******************************************************************************/

/*virtual*/
tVoid arl_tclISource::vSetSrcAvailable(tBool bSrcAvail)
{
   // Check if Source availability has changed?
   if (m_bSrcAvailable != bSrcAvail)
   {
      ETG_TRACE_USR1(("Source availability set to: %d", bSrcAvail));

      m_bSrcAvailable   =  bSrcAvail;

      // Update the clients about Source availability change.
      if (AIL_EN_N_NO_ERROR != eUpdateClients((tU16)ARL_EN_SOURCEAVAILABLE))
      {
         ETG_TRACE_ERR(("%d Error: Updating Source availability info failed!!!"
               , ETG_ENUM(ail_u16AppId, u16GetAppID())));
      }  // if (AIL_EN_N_NO_ERROR != eUpdateClients(ARL_EN_SOURCEAVAILABLE))

      //Toggle ARL ServiceState
      vSetPrivateServiceAvailableAllowed(bSrcAvail);

   }  //if (m_bSrcAvailable != bSrcAvail)

}  // tVoid arl_tclISource::vSetSrcAvailable(tBool bSrcAvail)





amt_tclServiceData* arl_tclISource::pStatusMessageFactory(tU16 u16Target, tU16 u16FunctionId, tU16 u16RegisterID, tU16 u16CmdCounter)
{
   return arl_tclISourceIF::pStatusMessageFactory(u16Target, u16FunctionId, u16RegisterID, u16CmdCounter);
}



tVoid arl_tclISource::vOnAudioRouteRequestReject(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("%d Recieved vOnAudioRouteRequestReject message with Opcode: %d, \
    ServiceId: %d, RegId: %d, FID: %x, SrcAppId: %d, TargAppId: %d"
      , ETG_ENUM(ail_u16AppId, u16GetAppID())
      , ETG_ENUM(OP_CODES, poMessage->u8GetOpCode())
      , poMessage->u16GetServiceID(), poMessage->u16GetRegisterID()
      , poMessage->u16GetFunctionID(), ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID())
      , ETG_ENUM(ail_u16AppId, poMessage->u16GetTargetAppID())));

  //extract Source and SubSource and call Application
  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet oFiDataObject1;

  if(oVisitorMsg.s32GetData(oFiDataObject1) != OSAL_ERROR)
  {
    arl_tenSource enSource  = static_cast<arl_tenSource>(oFiDataObject1.u8Source.enType);
    tU16 u16SubSource = oFiDataObject1.u16SubSource;

    if(bOnAudioRouteRequestReject(enSource,u16SubSource))
    {
      ETG_TRACE_USR4(("bOnAudioRouteRequestReject() handled by App OK"));
    }
    else
    {
      ETG_TRACE_ERR(("Error: App does not handle bOnAudioRouteRequestReject ??"));
    }

  }
  else
  {
    ETG_TRACE_USR4(("Error extracting aud_src_route_mainfi_tclMsgAudioRouteRequestRejectMethodStart"));
  }
  //Do we need it ?
  oFiDataObject1.vDestroy();
}

/******************************************************************************
* FUNCTION:  tVoid arl_tclISource::vOnMsISource(amt_tclServiceData* poMessage)
******************************************************************************/

tVoid arl_tclISource::vOnMsISource(amt_tclServiceData* poMessage)
{
   if (OSAL_NULL != m_poISourceVFsm)
   {
      tBool bRetVal  =  m_poISourceVFsm->bOnMessage(poMessage);
      NORMAL_M_ASSERT(FALSE != bRetVal);

   }  // if (OSAL_NULL != m_poISourceVFsm)

}  // tVoid arl_tclISource::vOnMsISource(amt_tclServiceData* poMessage)

/******************************************************************************
* FUNCTION:  tVoid arl_tclISource::vOnMrISource(amt_tclServiceData* poMessage)
******************************************************************************/

tVoid arl_tclISource::vOnMrISource(amt_tclServiceData* poMessage)
{
   // Just print out the message information.
   ETG_TRACE_USR4(("%d Recieved a loopback result message with Opcode: %d, \
      ServiceId: %d, RegId: %d, FID: %x, SrcAppId: %d, TargAppId: %d"
      , ETG_ENUM(ail_u16AppId, u16GetAppID())
      , ETG_ENUM(OP_CODES, poMessage->u8GetOpCode())
      , poMessage->u16GetServiceID(), poMessage->u16GetRegisterID()
      , poMessage->u16GetFunctionID(), ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID())
      , ETG_ENUM(ail_u16AppId, poMessage->u16GetTargetAppID())));

}  //lint !e1762 !e818 Info 1762, Info 818

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bHandleLoopbackInThreadMismatch(arl_tenSource ..
******************************************************************************/
tBool arl_tclISource::bTriggerSrcActivityLoopback(arl_tenSource enSrc, arl_tenActivity enAct)
{
  tBool bRet = false;

  //Check for thread ID
  if(m_s32MyThreadID != OSAL_ThreadWhoAmI()) // check for calls with wrong thread context
  {
    tPU8 pu8DataCpy = new tU8[3];

    if ( OSAL_NULL != pu8DataCpy )
    {
      *(pu8DataCpy+0) = (tU8)ARL_EN_LOOPBACK_SRCACTRESULT;  //FunctionID for SrcActivity Result
      *(pu8DataCpy+1) = (tU8)enSrc;
      *(pu8DataCpy+2) = (tU8)enAct;

      vRxFromOtherThreads(3, pu8DataCpy);
      OSAL_DELETE []pu8DataCpy;
      bRet = true;
    }
  }
  return bRet;
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::vSourceActivityResult(arl_tenSource ..
******************************************************************************/
tVoid arl_tclISource::vSourceActivityResult(arl_tenSource enSrcNum, const arl_tSrcActivity& enActivityAck, tU16 SubSource)
{
   (void)SubSource; //LINT
  arl_tenActivity act = static_cast<arl_tenActivity>(enActivityAck.enType);

  if(false == bTriggerSrcActivityLoopback(enSrcNum, act))
  {
    m_poISourceVFsm->vOnSrcActResult(enSrcNum,  act);
  }
};

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::vSourceActivityResult(arl_tenSource ..
******************************************************************************/
tVoid arl_tclISource::vSourceActivityResult(arl_tenSource enSrcNum, arl_tenActivity enActivityAck, tU16 SubSource)
{
  (void)SubSource; //LINT
  if(false == bTriggerSrcActivityLoopback(enSrcNum, enActivityAck))
  {
    m_poISourceVFsm->vOnSrcActResult(enSrcNum,  enActivityAck);
  }
};

/******************************************************************************
** FUNCTION:  tVoid arl_tclISource::vOnFGGraphCmdResult(..
******************************************************************************/
tVoid arl_tclISource::vOnFGGraphCmdResult(arl_tenFGGraphCmd_Result enErrorCode)
{
   ETG_TRACE_USR1(("%d: ARL_AHL::vOnFGGraphCmdResult: DefaultImplementation, Result: 0x%d"
         , ETG_ENUM(ail_u16AppId, u16GetAppID())
         , ETG_ENUM(arl_tenFGGraphCmd_Result, enErrorCode)));
}

/******************************************************************************
** FUNCTION:  tVoid arl_tclISource::vOnLoopback(tU16 u16ServiceID, am..
******************************************************************************/

/*virtual*/
tVoid arl_tclISource::vOnLoopback
(
   tU16 u16ServiceID
   , amt_tclServiceData* poMessage
)
{
   ETG_TRACE_USR1(("vOnLoopback() Service entered."));

   if(FALSE == ahl_tclBaseOneThreadService::bDefaultSvcDataHandler(this, poMessage))
   {
      // No default handler found, check for get/upreg/relupreg messages.
      switch (poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            ail_tenCommunicationError enResult = eUpdateRequestingClient(poMessage);

            if (AIL_EN_N_NO_ERROR != enResult)
            {
               ETG_TRACE_ERR(("%d: GET with Function id:%d resulted in error"
                  , ETG_ENUM(ail_u16AppId, u16GetAppID())
                  , ETG_ENUM(AUDCU_FID, poMessage->u16GetFunctionID())));
            }
         }
         break;

         default:
         {
            // Trace: Nothing else to do since it is a loopback message.
            // Message will be deleted by the framework.
            // No error message to be sent back if loop back could not find a
            // mapping function - just perform the trace.
            ETG_TRACE_ERR(("%d: vOnLoopback() could not find a mapping function."
                  , ETG_ENUM(ail_u16AppId, u16GetAppID())));

         }
         break;
      }

   }  // if(FALSE == ahl_tclBaseOneThreadService::bDefaultSvcDataHandler(this,..

   // Avoid Lint - Parameter needs to be neglected without LINT objection.
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u16ServiceID);
}  // tVoid audcu_tclAudCueService::vOnLoopback(tU16 u16ServiceID, am..

////////////////////////////////////////////////////////////////////////////////

// <EOF>
