/*!
*******************************************************************************
* \file              arl_tclISrcVFsm.h
*******************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    Implements ISrc Virtual FSM
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 25.08.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Added routing state handling within the VFSM.
*
* \date 10.02.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef ARL_TCLISRCVFSM_H_
#define ARL_TCLISRCVFSM_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "arl_tclStrClientHandler_ASF_IF.h"

#include "arl_tclISourceVFsm.h"
#include "arl_tclStrClientHandler_AIL.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/
class arl_tclISource_AIL;

/*!
 * \class arl_tclISrcVFsm
 * \brief Derived class implementing the actual ISource VFSM
 *
 * \par
 * Features implemented:
 *
 *    - Message mapping to different states of the FSM.
 *    - Trigger basic triggers of the FSM on errors & on service availability
 *    change.
 *    - I/O for state changes of the FSM.
 *
 */

class arl_tclISrcVFsm : public arl_tclISourceVFsm
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  arl_tclISrcVFsm::arl_tclISrcVFsm(ahl_tclBaseOneThreadA..
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection
    *          Principle (DIP)
    * \param   [cpoApp]:      (->I) Main Application pointer.
    * \param   [cpoISource]:  (->I) ISource service pointer.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
  arl_tclISrcVFsm //ASF variant
  (
     ahl_tclBaseOneThreadApp* const cpoApp
     , arl_tclISource* const cpoISource
     , arl_tclStrClientHandler_ASF_IF* poAsfStrClh
  );

  arl_tclISrcVFsm //AHL
   (
      ahl_tclBaseOneThreadApp* const cpoApp
      , arl_tclISource* const cpoISource
   );


   arl_tclISrcVFsm //AIL
   (
      ail_tclAppInterfaceRestricted* const cpoApp
      , arl_tclISourceIF* const cpoISource
   );

   /***************************************************************************
   ** FUNCTION:  virtual arl_tclISrcVFsm::~arl_tclISrcVFsm()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~arl_tclISrcVFsm();

   /***************************************************************************
   ** FUNCTION:  virtual tBool arl_tclISrcVFsm::bServiceAvailability(tU16..
   ***************************************************************************/
   /*!
    * \brief   Signals the service availabiltiy/unavailability of service.
    * \param   [u16ServiceId]:      (I)   Service Id
    * \param   [bAvail]:            (I)   Availability
    * \retval  [tBool]: TRUE service availability was consumed, FALSE otherwise.
    * \date 10.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tBool bServiceAvailability(tU16 u16ServiceId, tBool bAvail = TRUE);

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnAllocStart(amt_tclService..
   ***************************************************************************/
   /*!
    * \brief   Function to handle Allocate.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnAllocStart(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnDeAllocStart(amt_tclServi..
   ***************************************************************************/
   /*!
    * \brief   Function to handle DeAllocate.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnDeAllocStart(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnSrcActStart(amt_tclServi..
   ***************************************************************************/
   /*!
    * \brief   Function to handle source activity.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnSrcActStart(amt_tclServiceData* poMessage);



   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnSourceInfo(amt_tclServi..
   ***************************************************************************/
   /*!
    * \brief   Function to handle source information.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 18.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnSourceInfo(amt_tclServiceData* poMessage);


   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnAllocRouteResult(amt_tclS..
   ***************************************************************************/
   /*!
    * \brief   Function to handle allocate route result.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnAllocRouteResult(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnDeAllocRouteResult(const amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to handle deallocate route result.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnDeAllocRouteResult(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnSetPlayResult(const amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to handle set play result.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnSetPlayResult(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnSetStopResult(const amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to handle set stop result.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnSetStopResult(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnFGCmdResult(const amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to handle set stop result.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 04.03.2013 \author Ruben Volkmer
    **************************************************************************/
   tVoid vOnFGGraphCmdResult(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnRouteState(const amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to handle Stream Router routing state.
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 12.08.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnRouteState(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclISrcVFsm::vOnStrRouError(const amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to handle Stream Router error
    * \param   [poMessage]:    (->I)   Pointer to incoming message.
    * \retval  NONE
    * \date 07.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnStrRouError(amt_tclServiceData* poMessage);

   tVoid vOnSrcActTimerExpiryStart(amt_tclServiceData* poMessage);

   tVoid vOnLoopbackStart(amt_tclServiceData* poMessage);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/
   tVoid vOnSrcActLoopbackStart(tPCUChar pcu8Data);
   tVoid vOnSetMuteStateLoopbackStart(tPCUChar pcu8Data);
   tVoid vOnSendFGGraphCommandLoopbackStart(tPCUChar pcu8Data);
   tVoid vOnSetAudioRouteRequestLoopbackStart(tPCUChar pcu8Data);
   tVoid vOnSetAudioPropertyLoopbackStart(tPCUChar pcu8Data);
   tVoid vOnSetSourceAvailabilityLoopbackStart(tPCUChar pcu8Data);

   /***************************************************************************
   * Declare Msg Map - Utilizing the Framework for message map abstraction.
   ***************************************************************************/
   DECLARE_MSG_MAP(arl_tclISrcVFsm)

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class arl_tclISrcVFsm : public arl_tclISourceVFsm

#endif   // #ifndef ARL_TCLISRCVFSM_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
