/*
 * arl_tclClientHandler_AILBase.h
 *
 *  Created on: Jul 6, 2012
 *      Author: vo84hi
 */

#ifndef ARL_TCLCLIENTHANDLER_AILBASE_H_
#define ARL_TCLCLIENTHANDLER_AILBASE_H_

/* Inclusion of OSAL Interface */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/* use AIL template */
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

/* use Application Help Library */
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"


//#include "ahl_ccaExtensionInternal.h"
//#include "ahl_BaseOneThreadApp.h"

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include "stl_pif.h"


#include <vector>


typedef std::vector<ahl_sAdminHelper> tsAdminHelper;

class arl_tclClientHandler_AILBase : public ahl_tclBaseWork
{
public:
   ahl_tclPairList _tclRegisterPair;
   ahl_tclPairList _tclUnregisterPair;

   /*---------------------------------------------------------------------*/
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);
   virtual tVoid vOnServiceState( tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8  u8ServiceState, tU16 u16SubId);
   /*---------------------------------------------------------------------*/

   tBool bRegisterForService();
   tBool bUnregisterForService();

   tVoid vAddAutoRegisterForProperty(tU16 u16FID);
   tVoid vRemoveAutoRegisterForProperty(tU16 u16FID);

   /*---------------------------------------------------------------------*/

   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   tBool bIfServiceAvailable() const;

   virtual tBool bRegisterForFID(tU16 u16FID);
   virtual tBool bUnregisterForFID(tU16 u16FID);

   virtual tVoid vMyDispatchMessage(amt_tclServiceData* pServiceDataMessage);

   virtual tVoid vOnError(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
   virtual tVoid vOnStatus(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
   virtual tVoid vOnMethodResult(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
   virtual tVoid vOnAbortResult(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
   virtual tVoid vOnMethodResultFirst(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
   virtual tVoid vOnMethodResultMiddle(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
   virtual tVoid vOnMethodResultLast(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
   virtual tVoid vRemoveRegistration();
   virtual tBool bUpRegMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg);
   virtual tBool bRelUpRegMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg);

   /*---------------------------------------------------------------------*/

   inline tU16 u16GetSubID() const { return _u16OwnSubID; };
   inline tU16 u16GetServerAppID() const { return _u16ServerAppID; };
   inline tU16 u16GetRegID() const { return _u16RegID; };

   virtual tVoid vOnAsyncRegisterConf (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId);
//   virtual tVoid vOnAsyncRegisterConfExt (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus);
//   virtual tVoid vOnAsyncRegisterConfFailure(tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus);

   tVoid vInitServiceData(amt_tclServiceData& rServiceDataMessage, tU16 u16CmdCounter, tU16 u16FunctionId, tU8 u8Opcode) const;
protected:
   ail_tclAppInterfaceRestricted* _poMainAppl;
    tU16                 _u16ServiceID;
    tsAdminHelper        _asAdminHelpers;
    tU32                 _nNumberOfFUIDs;
    tBool                _bServiceAvailable;

   /* constructor */
    arl_tclClientHandler_AILBase(
          ail_tclAppInterfaceRestricted*  poMainAppl,
         //ail_tclAppInterface* const cpoApp
         tU16            u16ServiceID,
         tU16            u16ServiceMajorVersion,
         tU16            u16ServiceMinorVersion,
         tU16            u16ServerAppID = AMT_C_U16_APPID_INVALID,
         tU16            u16OwnSubID = AMT_C_U16_SUBID_DEFAULT);

   /* destructor */
   virtual ~arl_tclClientHandler_AILBase();

   /* this function resets the flags and variables of the connection */
   virtual tVoid vAutoResetConnection();

   /* this function is a helper to filter trace from the specific app, clienthandler, service */
   virtual tBool bTraceClassFilter(tU16 u16Level) const;
   virtual tVoid vTraceInternalState(TR_tenTraceLevel enLevel) const;
   virtual tVoid vOnUnknownMessage(amt_tclBaseMessage* poMessage);
   virtual tBool bIsTargetFor(tU16 u16ServiceId, tU16 u16AppId, tU16 u16RegisterId, tU16 u16AppSubId) const;
   tBool bCheckIds() const;

private:
   tU16            _u16ServiceMajorVersion;
   tU16            _u16ServiceMinorVersion;

   /* to store the application ID of the server */
   tU16            _u16ServerAppID;
   tBool           _bDedicatedServer;
   tU16            _u16OwnAppID;
   tU16            _u16OwnSubID;

   /* to store the RegID of the service */
   tU16            _u16RegID;



   /* this function is called to register all necessary properties */
   tBool  bRegisterForAllFID();
   /* this function is called to unregister all registered properties */
   tBool  bUnRegisterForAllFID();

   ahl_sAdminHelper* sFindAdminHelper(tU32 nFunctionId);

   arl_tclClientHandler_AILBase();//lint !e1704 Info 1704 , eliminating lint warnings the way of Lars.
};

#endif /* ARL_TCLCLIENTHANDLER_AILBASE_H_ */
