/*
 * arl_tclBaseClienthandler_AIL.h
 *
 *  Created on: Jul 5, 2012
 *      Author: vo84hi
 */

#ifndef ARL_TCLBASECLIENTHANDLER_AIL_H_
#define ARL_TCLBASECLIENTHANDLER_AIL_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include <common_fi_if.h>

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "arl_tclClientHandler_AILBase.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/

class arl_tclISourceVFsm;


/*!
 * \class arl_tclBaseClienthandler
 * \brief Base client handler - based on eXtended CCA
 *
 */

class arl_tclBaseClienthandlerAIL  : public arl_tclClientHandler_AILBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  arl_tclBaseClienthandler::arl_tclBaseClienthandler(ahl_tclBa..
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection
    *          Principle (DIP)
    * \param   [cpoApp]:         (->I) Pointer to the main application
    * \param   [cpoISourceVFsm]: (->I) Pointer to ISource VFSM
    * \param   [u16ServiceID]:   (I) Service Id
    * \param   [u16SrvMajVer]:   (I) Service Major version
    * \param   [u16SrvMinVer]:   (I) Service Minor version
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclBaseClienthandlerAIL(ail_tclAppInterfaceRestricted* const cpoApp
                                 , arl_tclISourceVFsm* const cpoISourceVFsm
                                 , tU16 u16ServiceID
                                 , tU16 u16SrvMajVer
                                 , tU16 u16SrvMinVer
                                 , tU16 u16ServerAppID = AMT_C_U16_APPID_INVALID
                                 , tU16 u16OwnSubID    = AMT_C_U16_SUBID_DEFAULT);


   /***************************************************************************
   ** FUNCTION:  virtual arl_tclBaseClienthandler::~arl_tclBaseClienthandler()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~arl_tclBaseClienthandlerAIL();

   /***************************************************************************
   ** FUNCTION:  tBool arl_tclBaseClienthandler::bSendMessage(const fi_tclMess..
   ***************************************************************************/
   /*!
    * \brief   Interface to send messages to the stream router.
    * \param   [rfcoMsgBase]: (I) Message to be send.
    * \param   [cu16CmdCtr]:  (I) Command counter.
    * \retval  [tBool]: TRUE if message post was successful, FALSE otherwise.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tBool bSendMessage(const fi_tclMessageBase& rfcoMsgBase, tCU16 cu16CmdCtr = 0) const;
   tBool bIfServiceAvailable() const;
   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual tVoid arl_tclBaseClienthandler::vOnError(tU16 u16FID..
   ***************************************************************************/
   /*!
    * \brief   Overloaded function called by the "FWK"
    * \param   [u16FID]:         (I) Function Id
    * \param   [poMessage]:      (->I) Incoming message
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnError(tU16 u16FID, amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  virtual tVoid arl_tclBaseClienthandler::vOnMethodResult(tU16..
   ***************************************************************************/
   /*!
    * \brief   Overloaded function called by the "FWK"
    * \param   [u16FID]:         (I) Function Id
    * \param   [poMessage]:      (->I) Incoming message
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnMethodResult(tU16 u16FID, amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclBaseClienthandler::vOnServiceAvailable()
   ***************************************************************************/
   /*!
    * \brief   Overloaded function called by the "FWK"
    * \param   NONE
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnServiceAvailable();

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclBaseClienthandler::vOnServiceUnavailable()
   ***************************************************************************/
   /*!
    * \brief   Overloaded function called by the "FWK"
    * \param   NONE
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnServiceUnavailable();

   /***************************************************************************
   ** FUNCTION:  arl_tclBaseClienthandler::arl_tclBaseClienthandler()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable it. So
    *          that any attempt to create without parameter will be caught by
    *          the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclBaseClienthandlerAIL();    // No definition exists.

   /***************************************************************************
   ** FUNCTION:  arl_tclBaseClienthandler::arl_tclBaseClienthandler(con..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoBaseClient]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So
    *          that any attempt to copy will be caught by the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclBaseClienthandlerAIL(const arl_tclBaseClienthandlerAIL &rfcoBaseClient);

   /***************************************************************************
   ** FUNCTION:  arl_tclBaseClienthandler& arl_tclBaseClienthandler::operator..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoBaseClient]: (I) Const reference to object to be copied
    * \retval  [arl_tclBaseClienthandler&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So
    *          that any attempt for assignment will be caught by the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclBaseClienthandlerAIL& operator=(const arl_tclBaseClienthandlerAIL &rfcoBaseClient);

   /*!
    * \addtogroup tclMem
    */
   /*! @{*/

   /// Service Major Version.
   tU16 m_u16SrvMajVer;
   /// Pointer to ISource Virtual Finite State Machine.
   arl_tclISourceVFsm* const m_cpoISourceVFsm;
   tU16 _u16ServerAppID;
   /*! @}*/

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class arl_tclBaseClienthandler: public ahl_tclBaseOneThreadClientHandler

#endif /* ARL_TCLBASECLIENTHANDLER_AIL_H_ */
