/*!
*******************************************************************************
* \file              arl_tclFsmTransition.h
*******************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    Implements FSM Transitions
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 10.01.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef ARL_TCLFSMTRANSITION_H_
#define ARL_TCLFSMTRANSITION_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

/// OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#include "arl_FsmTypes.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/

/*!
 * \class arl_tclFsmTransition
 * \brief FSM Transition
 *
 */

class arl_tclFsmTransition
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  arl_tclFsmTransition::arl_tclFsmTransition(tS16 s16NextState..
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection
    *          Principle (DIP)
    * \param   [s16NextStateID]: (I) Next State ID
    * \param   [s16TriggerID]:   (I) Trigger ID
    * \retval  NONE
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclFsmTransition(tS16 s16NextStateID, tS16 s16TriggerID);

   /***************************************************************************
   ** FUNCTION:  virtual arl_tclFsmTransition::~arl_tclFsmTransition()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~arl_tclFsmTransition();

   /***************************************************************************
   ** FUNCTION:  tS16 arl_tclFsmTransition::s16GetNextStateID() const
   ***************************************************************************/
   /*!
    * \brief   Get next state id
    * \param   NONE
    * \retval  [tS16]: Next State Id
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tS16 s16GetNextStateID() const;

   /***************************************************************************
   ** FUNCTION:  tS16 arl_tclFsmTransition::s16GetTriggerID() const
   ***************************************************************************/
   /*!
    * \brief   Get trigger id
    * \param   NONE
    * \retval  [tS16]: Trigger Id
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tS16 s16GetTriggerID() const;

   /***************************************************************************
   ** FUNCTION:  tBool arl_tclFsmTransition::bActivated()
   ***************************************************************************/
   /*!
    * \brief   Whether transition is Active or not?
    * \param   NONE
    * \retval  [tBool]: TRUE if activated, FALSE otherwise.
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tBool bActivated();

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclFsmTransition::operator()()
   ***************************************************************************/
   /*!
    * \brief   Trigger transition.
    * \param   NONE
    * \retval  [tBool]: TRUE if activated, FALSE otherwise.
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid operator()();

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclFsmTransition::vAdd(arl_tFsmFunctor* const cpoF..
   ***************************************************************************/
   /*!
    * \brief   Function to add FSM funtors to be executed on State Transition.
    * \param   [cpoFsmFunctor]   (->I) FSM Functor
    * \retval  NONE
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vAdd(arl_tFsmFunctor* const cpoFsmFunctor);

   /***************************************************************************
   ** FUNCTION:  tVoid arl_tclFsmTransition::vAdd(arl_tFsmCondition* const cp..
   ***************************************************************************/
   /*!
    * \brief   Function to add FSM funtors to be executed on State Transition.
    * \param   [cpoFsmCondition]   (->I) FSM Condition functor
    * \retval  NONE
    * \date 10.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vAddCond(arl_tFsmCondition* const cpoFsmCondition);

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /*!
    * \addtogroup tclMem
    */
   /*! @{*/

   /// Next state ID
   tS16 m_s16NextStateID;
   /// Trigger ID
   tS16 m_s16TriggerID;
   /// Transition functions
   arl_tFunctorList m_oTransFuncs;
   /// Transition conditions
   arl_tCondList m_oConditions;

   /*! @}*/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class arl_tclFsmTransition

#endif   // #ifndef ARL_TCLFSMTRANSITION_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
