/*!
********************************************************************************
* \file              arl_FsmTypes.h
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    Finite State Machine (FSM) types
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
********************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 10.01.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifndef ARL_FSMTYPES_H_
#define ARL_FSMTYPES_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

// Includes to utilize the OSAL Interface
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

// Includes for for (removed_bpstl)
//#define SYSTEM_S_IMPORT_INTERFACE_EXH        ///< Import STL IF - Exception handler
//#define SYSTEM_S_IMPORT_INTERFACE_ITERATOR   ///< Import STL IF - Iterator
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR     ///< Import STL IF - Vector
//#include <stl_pif.h>


#include <exception>
#include<iterator>
#include<vector>





#include "arl_tclImplFunctor.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

//using namespace std;  // Use BP STL Namespace.

/******************************************************************************
| forward declarations (scope: global)
|----------------------------------------------------------------------------*/

class arl_tclFsmTransition;
class arl_tclFsmTrigger;
class arl_tclFsmState;

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*!
 * \typedef arl_tclFunctor arl_tFsmFunctor
 * \brief FSM functor
 */

typedef arl_tclFunctor arl_tFsmFunctor;

/*!
 * \typedef arl_tclFunctor arl_tFsmCondition
 * \brief FSM Conditional functor
 */

typedef arl_tclFunctor arl_tFsmCondition;


/*!
 * \typedef vector<arl_tFsmFunctor* > arl_tFunctorList
 * \brief Datatype Functor List
 */

typedef std::vector<arl_tFsmFunctor* > arl_tFunctorList;

/*!
 * \typedef typedef vector<arl_tFsmFunctor* >::iterator arl_tFunctorListIter
 * \brief Datatype Functor List iterator
 */

typedef std::vector<arl_tFsmFunctor*>::iterator arl_tFunctorListIter;

/*!
 * \typedef vector<arl_tFsmCondition* > arl_tCondList
 * \brief Datatype condition list
 */

typedef std::vector<arl_tFsmCondition*> arl_tCondList;

/*!
 * \typedef vector<arl_tFsmCondition* >::iterator arl_tCondListIter
 * \brief Datatype condition list iterator
 */
typedef std::vector<arl_tFsmCondition*>::iterator arl_tCondListIter;

/*!
 * \typedef vector<arl_tclFsmTransition*> arl_tTransitionList
 * \brief Datatype transition list
 */
typedef std::vector<arl_tclFsmTransition*> arl_tTransitionList;

/*!
 * \typedef vector<arl_tclFsmTransition* >::iterator arl_tTransitionListIter
 * \brief Datatype transition list iterator
 */
typedef std::vector<arl_tclFsmTransition* >::iterator arl_tTransitionListIter;

/*!
 * \typedef vector<arl_tclFsmState> arl_tclFsmStateList
 * \brief Datatype Fsm State list
 */
typedef std::vector<arl_tclFsmState> arl_tclFsmStateList;

/*!
 * \typedef vector<arl_tclFsmState>::iterator arl_tclFsmStateListIter
 * \brief Datatype Fsm State list iterator
 */
typedef std::vector<arl_tclFsmState>::iterator arl_tclFsmStateListIter;

/*!
 * \typedef vector<arl_tclFsmTrigger> arl_tclFsmTrigList
 * \brief Datatype Fsm Trigger list
 */
typedef std::vector<arl_tclFsmTrigger> arl_tclFsmTrigList;

/*!
 * \typedef vector<arl_tclFsmTrigger>::iterator arl_tclFsmTrigListIter
 * \brief Datatype Fsm Trigger list iterator
 */
typedef std::vector<arl_tclFsmTrigger>::iterator arl_tclFsmTrigListIter;


#endif   // #ifndef ARL_FSMTYPES_H_

// <EOF>
