/*!
********************************************************************************
* \file              arl_LookupTable.cpp
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    iSource Configuration Lookup Table
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
********************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 20.01.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include <cca_if.h>

#include "arl_Trace.h"
#include "FC_StreamRouter_ucid_defs.h"
#include "arl_LookupTable.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_LOOKUP_TABLE
#include "trcGenProj/Header/arl_LookupTable.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/*!
 * \typedef struct arl_tISourceEntry
 * \brief Datatype definition for a Local Source entry configuration.
 */












typedef struct
{
   /// Application Id
   tU16 m_u16AppId;
   /// Source Number
   tU8 m_u8SrcNum;
   /// ISource entry configuration
   arl_tISrcProp m_oISrcProp;




} arl_tISourceEntry;

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/*!
 * \brief Local definition for the ISource Entry Table.
 * \note The configuration is imported from autogenerated arl_ISource.cfg file.
 */

static arl_tISourceEntry sa_LookupTable[] =

#include "arl_ISource.config.h"







/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  tBool arl_bGetISrcProp(tCU16 cu16AppId, tCU8 cu8SrcNum, arl_I..
******************************************************************************/

/*extern*/
tBool arl_bGetISrcProp(tCU16 cu16AppId, tCU8 cu8SrcNum, arl_tISrcProp& rfoSrcProp)
{
   ETG_TRACE_COMP(("Getting Source Properties for AppId: %d, SrcNo: %d."
      , ETG_ENUM(ail_u16AppId, cu16AppId), cu8SrcNum));

   tBool bRetVal  = FALSE;

   for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u16AppId < OSAL_C_U16_MAX; ++u8Loop)
   {
      // Check if Appid & source number matches with what is requested.
      if ((cu16AppId == sa_LookupTable[u8Loop].m_u16AppId)
         && (cu8SrcNum == sa_LookupTable[u8Loop].m_u8SrcNum))
      {
         rfoSrcProp    =  sa_LookupTable[u8Loop].m_oISrcProp;
         bRetVal     =  TRUE;

         ETG_TRACE_USR1(("Source Properties found, UCID:0x%x (%d), SelfTrigged: %d, Source FBlock: 0x%x (%d), Source InstId: %d, Startup Alloc: %d"
             , rfoSrcProp.m_u16Ucid, rfoSrcProp.m_u16Ucid
             , ETG_ENUM(ARL_YESNO, rfoSrcProp.m_bIsSelfTrig)
             , rfoSrcProp.m_u8SourceFBlock, rfoSrcProp.m_u8SourceFBlock
             , rfoSrcProp.m_u8SourceInstID,rfoSrcProp.m_bAllocOnStartUp));

         // Break looping, if entry is found.
         break;
      }  // if ((cu16AppId == sa_LookupTable[u8Loop].m_u16AppId) && (cu8SrcN..

   }  // for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u16AppId < OSAL_C_U1..

   return bRetVal;
}  // tBool arl_bGetISrcProp(tCU16 cu16AppId, tCU8 cu8SrcNum, arl_tISrcProp..

/******************************************************************************
** FUNCTION:  tS16 arl_s16GetNumSrc(tCU16 cu16AppId)
******************************************************************************/

/*extern*/
tS16 arl_s16GetNumSrc(tCU16 cu16AppId, arl_tSourceList& oSourceList)
{
   tS16 s16RetVal =  0;

   for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u16AppId < OSAL_C_U16_MAX; ++u8Loop)
   {
      if (cu16AppId == sa_LookupTable[u8Loop].m_u16AppId)
      {
         // One source entry found, hence increment the counter.
         ++s16RetVal;
         // Fill the source list vector
         oSourceList.push_back(sa_LookupTable[u8Loop].m_u8SrcNum);
      }  // if (cu16AppId == sa_LookupTable[u8Loop].m_u16AppId)
   }  // for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u16AppId < OSAL_C_U16_M..

   ETG_TRACE_COMP(("Getting Number of sources for AppId: %d, NumSrc: %d."
      , ETG_ENUM(ail_u16AppId, cu16AppId), s16RetVal));

   return ((0 != s16RetVal)?s16RetVal:ARL_ERROR);

}  // tS16 arl_s16GetNumSrc(tCU16 cu16AppId)

/******************************************************************************
** FUNCTION:  tU16 arl_s16SrcUCID(arl_tenSource src)
******************************************************************************/
tU16 arl_s16SrcUCID(arl_tenSource src)
{
   for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u8SrcNum < OSAL_C_U8_MAX; ++u8Loop)
   {
      if (static_cast<tU8>(src) == sa_LookupTable[u8Loop].m_u8SrcNum)
      {
         // One source entry found, report the UCID
         return sa_LookupTable[u8Loop].m_oISrcProp.m_u16Ucid;

      }  // if (cu16AppId == sa_LookupTable[u8Loop].m_u16AppId)
   }  // for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u16AppId < OSAL_C_U16_M..
   return 0;
}  // tS16 arl_s16GetNumSrc(tCU16 cu16AppId)

/******************************************************************************
** FUNCTION:  tU16 arl_bGetISrcAppId(tCU8 cu8SrcNum)
******************************************************************************/
tU16 arl_bGetISrcAppId(arl_tenSource src)
{
   for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u8SrcNum < OSAL_C_U8_MAX; ++u8Loop)
   {
      if (static_cast<tU8>(src) == sa_LookupTable[u8Loop].m_u8SrcNum)
      {
         // One source entry found, report the AppID
         return sa_LookupTable[u8Loop].m_u16AppId;
      }  // if (cu16AppId == sa_LookupTable[u8Loop].m_u16AppId)
   }  // for (tU8 u8Loop = 0; sa_LookupTable[u8Loop].m_u16AppId < OSAL_C_U16_M..
   return 0;
}










////////////////////////////////////////////////////////////////////////////////
// <EOF>
