/*!
********************************************************************************
* \file              arl_LookupTable.h
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    iSource Configuration Lookup Table
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
********************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 20.01.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifndef ARL_LOOKUPTABLE_H_
#define ARL_LOOKUPTABLE_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

// Includes to utilize the OSAL Interface
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#include "arl_ISourceTypes.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/


/*******************************************************************************
** FUNCTION:  tBool arl_bGetISrcProp(tCU16 cu16AppId, tCU8 cu8SrcNum, arl_ISr..
*******************************************************************************/
/*!
 * \brief   Search the ISource Entry from the configuration table based on Appid
 *          & Source number.
 * \param   [cu16AppId]:      (I)   Application id.
 * \param   [cu8SrcNum]:      (I)   Source Number.
 * \param   [rfoSrcProp]:     (O)   Source Entry details.
 * \retval  [tBool]: TRUE if entry was found, FALSE otherwise.
 * \note    \code extern \endcode, but can be used only within ARL.
 * \date 20.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
 ******************************************************************************/

extern tBool arl_bGetISrcProp(tCU16 cu16AppId, tCU8 cu8SrcNum, arl_tISrcProp& rfoSrcProp);

/*******************************************************************************
** FUNCTION:  tS16 arl_s16GetNumSrc(tCU16 cu16AppId)
*******************************************************************************/
/*!
 * \brief   Get the number of sources supported by the application.
 * \param   [cu16AppId]:       (I)   Application id.
 * \retval  [tS16]
 * \li \c Number of sources in case of success
 * \li \c \b #ARL_ERROR on error
 * \note    \code extern \endcode, but can be used only within ARL.
 * \date 24.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
 ******************************************************************************/

extern tS16 arl_s16GetNumSrc(tCU16 cu16AppId, arl_tSourceList& oSourceList);

/*******************************************************************************
** FUNCTION:  tU16 arl_s16GetNumSrc(tCU16 cu16AppId)
*******************************************************************************/
/*!
 * \brief   Get the UCID of a given source
 * \param   [src]:       (I)  source.
 * \retval  [tS16] UCID or 0 if source not found
 * \note    \code extern \endcode, but can be used only within ARL.
 * \date 06.12.2012 \author Ruben Volkmer (mailto: R.Volkmer@ITB-Solutions.de)
 ******************************************************************************/
extern tU16 arl_s16SrcUCID(arl_tenSource src);

/*******************************************************************************
** FUNCTION:  tU16 arl_bGetISrcAppId(tCU16 cu16AppId)
*******************************************************************************/
/*!
 * \brief   Get the AppID that is assigned to given source
 * \param   [src]:       (I)  source.
 * \retval  [tS16] UCID or 0 if source not found
 * \note    \code extern \endcode, but can be used only within ARL.
 * \date 07.12.2012 \author Ruben Volkmer (mailto: R.Volkmer@ITB-Solutions.de)
 ******************************************************************************/
extern tU16 arl_bGetISrcAppId(arl_tenSource src);

#endif   // #ifndef ARL_LOOKUPTABLE_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
