/*!
********************************************************************************
* \file              arl_tclStrClienthandler_ASF.cpp
********************************************************************************
*  - PROJECT:        Gen3
*  - SW-COMPONENT:   Audio Routing Library (ARL) adapted to ASF
*  - DESCRIPTION:
*  - COPYRIGHT:      &copy; 2010 - 2011 Robert Bosch Car Multimedia Gmbh
********************************************************************************
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
//#include "../arl_asf_lib/include/arl_tclStrClientHandler_ASF_IF.h"
#include "arl_tclStrClienthandler_ASF.h"
#include "../audio_routing_lib/include/arl_tclStrClientHandler_ASF_IF.h"
#include "include/arl_tclISourceVFsm.h"

#include "asf/core/Proxy.h"
#include "../audio_routing_lib/include/arl_Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_ASF_CLIENT
#include "trcGenProj/Header/arl_tclStrClienthandler_ASF.cpp.trc.h"
#endif

//using namespace ::App::Core;
using namespace midw_streamrouter_fi;
using namespace midw_streamrouter_fi_types;

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/


/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/
class midw_fi_tcl_e8_streamrouter_routestate;

std::string arl_tclStrClienthandler_ASF::_appName = "unknown";

arl_tclStrClienthandler_ASF::arl_tclStrClienthandler_ASF(const char* appName
      , unsigned short u16ServiceID
      , unsigned short u16SrvMajVer
      , unsigned short u16SrvMinVer):
     m_cpoISourceVFsm(NULL)
   //, u8LastSrcNum(0),curAct(0)
   , u8LastSrcNumAlloc(0),curActAlloc(0)
   , u8LastSrcNumDeAlloc(0),curActDeAlloc(0)
   , u8LastSrcNumStop(0),curActStop(0)
   , u8LastSrcNumPlay(0),curActPlay(0)
{
   ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF constructor"));

   if ((appName != 0) && (strcmp(appName, "") != 0))
   {
      _appName = appName;
   }
   m_bAvailable = false;

   //m_cpoISourceVFsm = cpoISourceVFsm;
   m_u16ServiceID = u16ServiceID;
   m_u16SrvMajVer = u16SrvMajVer;
   m_u16SrvMinVer = u16SrvMinVer;

   // create the proxy object
   m_StrFiProxy = Midw_streamrouter_fiProxy::createProxy("strFiPort", *this);
   ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF constructor done"));

} // arl_tclStrClienthandler_ASF::arl_tclStrClienthandler_ASF(..



/*virtual*/
arl_tclStrClienthandler_ASF::~arl_tclStrClienthandler_ASF()
{
  //ToDo: check what needs to be destroyed
  m_cpoISourceVFsm = NULL;

} // arl_tclStrClienthandler_ASF::~arl_tclStrClienthandler_ASF()


void arl_tclStrClienthandler_ASF::setVFsm(arl_tclISourceVFsm* cpoISourceVFsm)
{
  m_cpoISourceVFsm = cpoISourceVFsm;
}

bool arl_tclStrClienthandler_ASF::bIfServiceAvailable(void)
{
  // ToDo: we can ask the proxy about availability and return the result
  if(ServiceState__Available == m_StrFiProxy->getServiceState())
  {
    return true;
  }
  else
  {
    return false;
  }
  //return m_bAvailable;
}

bool arl_tclStrClienthandler_ASF::bSendAllocateRoute(unsigned short ucid, int STM_MsgBufID, unsigned char u8SrcNum, tU16 u16Sink)
{
  // Warning: in CCA we have transported the SrcNum in the Command Counter
  // how to do it now?
  // AllocateRouteStart oAllocateRouteStart(ucid, STM_MsgBufID);

  //return m_StrMessages->bSendAllocateRouteStart(ucid, STM_MsgBufID,u8SrcNum);

  // do it directly here
  curActAlloc = m_StrFiProxy->sendAllocateRouteStart(*this,ucid, STM_MsgBufID, u16Sink);
  u8LastSrcNumAlloc = u8SrcNum;
  return true;
}

void arl_tclStrClienthandler_ASF::onAllocateRouteResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
                    const boost::shared_ptr< AllocateRouteResult >& result)
{
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onAllocateRouteResult"));
  if(m_cpoISourceVFsm != NULL)
  {

    //uint16 ucid = result->getU16UCID();
    act_t act   = result->getAct();
    unsigned char u8SrcNum = 0;

    if(curActAlloc == act) u8SrcNum = u8LastSrcNumAlloc;  //changed to have own variable for each activity

    //ALsa device list
    midw_streamrouter_fi_types::T_streamrouter_device_list in_AlsaList = result->getListInputDev();
    midw_streamrouter_fi_types::T_streamrouter_device_list out_AlsaList = result->getListOutputDev();

    // pass parameters, where to get the source number from ???
    // hard code src Number VRU = 0x12 (18)
    if(false == m_cpoISourceVFsm->bOnAllocRouteResult(
        result->getU16UCID(),
        midw_streamrouter_fi::SERVICE_ID,
        midw_streamrouter_fi::FID_AllocateRoute,
        u8SrcNum,
        in_AlsaList,
        out_AlsaList))
    {
      //ToDo need to send unknown message
    }

  }
}

bool arl_tclStrClienthandler_ASF::bSendDeAllocateRoute(unsigned short ucid, unsigned char u8SrcNum)
{
  // do it directly here
  curActDeAlloc = m_StrFiProxy->sendDeAllocateRouteStart(*this,ucid);
  u8LastSrcNumDeAlloc = u8SrcNum;
  return true;
}

void arl_tclStrClienthandler_ASF::onDeAllocateRouteResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
                      const boost::shared_ptr< DeAllocateRouteResult >& result)
{
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onDeAllocateRouteResult"));
  if(m_cpoISourceVFsm != NULL)
  {
    //uint16 ucid = result->getU16UCID();
    act_t act   = result->getAct();
    unsigned char u8SrcNum = 0;
    if(curActDeAlloc == act) u8SrcNum = u8LastSrcNumDeAlloc;

    // pass parameters, where to get the source number from ???
    if(false == m_cpoISourceVFsm->bOnDeAllocRouteResult(
        result->getU16UCID(),
        midw_streamrouter_fi::SERVICE_ID,
        midw_streamrouter_fi::FID_DeAllocateRoute,
        u8SrcNum))
    {
      //ToDo need to send vOnUnknownMessage see ahl_tclBaseOneThreadClientHandler::vOnUnknownMessage
    }
  }
}

// this is used from inside ARL
bool arl_tclStrClienthandler_ASF::bSendSetPlay(unsigned short ucid, unsigned char u8SrcNum)
{
  u8LastSrcNumPlay = u8SrcNum;
  // do it directly here
  // ramp type not used in G3G
  T_e8_streamrouter_ramptype eRampType = T_e8_streamrouter_ramptype__NO;
  curActPlay = m_StrFiProxy->sendSetPlayStart(*this,ucid,eRampType);
  return true;
}

void arl_tclStrClienthandler_ASF::onSetPlayResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
    const boost::shared_ptr< SetPlayResult >& result)
{
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onSetPlayResult"));
  if(m_cpoISourceVFsm != NULL)
  {

    //uint16 ucid = result->getU16UCID();
    act_t act   = result->getAct();
    unsigned char u8SrcNum = 0;
    if(curActPlay == act) u8SrcNum = u8LastSrcNumPlay;

    // pass parameters, where to get the source number from ???
    if(false == m_cpoISourceVFsm->bOnPlayResult(result->getU16UCID(),
        midw_streamrouter_fi::SERVICE_ID,
        midw_streamrouter_fi::FID_SetPlay,
        u8SrcNum))
    {
      //need to send vOnUnknownMessage. See ahl_tclBaseOneThreadClientHandler::vOnUnknownMessage
    }
  }

}

void arl_tclStrClienthandler_ASF::onSetPlayError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
    const boost::shared_ptr< SetPlayError >& error)
{
  int ccaErr = 0;
  if(error->hasCcaErrorCode())
    ccaErr = error->kCcaErrorCode;
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onSetPlayError Error = %d",ccaErr));
}

bool arl_tclStrClienthandler_ASF::bSendSetStop(unsigned short ucid, unsigned char u8SrcNum)
{
  u8LastSrcNumStop = u8SrcNum;
  // do it directly here
  // ramp type not used in G3G
  T_e8_streamrouter_ramptype eRampType = T_e8_streamrouter_ramptype__NO;
  curActStop = m_StrFiProxy->sendSetStopStart(*this,ucid,eRampType);
  return true;
}

void arl_tclStrClienthandler_ASF::onSetStopResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
    const boost::shared_ptr< SetStopResult >& result)
{
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onSetStopResult"));
  if(m_cpoISourceVFsm != NULL)
  {

    //uint16 ucid = result->getU16UCID();
    act_t act   = result->getAct();
    unsigned char u8SrcNum = 0;
    if(curActStop == act) u8SrcNum = u8LastSrcNumStop;

    // pass parameters, where to get the source number from ???
    if (false == m_cpoISourceVFsm->bOnStopResult(
        result->getU16UCID(),
        midw_streamrouter_fi::SERVICE_ID,
        midw_streamrouter_fi::FID_SetStop,
        u8SrcNum))
    {
      // ToDO send unknown message
    }

  }
}

void arl_tclStrClienthandler_ASF::onSetStopError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
    const boost::shared_ptr< SetStopError >& error)
{
  int ccaErr = 0;
  if(error->hasCcaErrorCode())
    ccaErr = error->kCcaErrorCode;
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onSetStopError Err = %d",ccaErr));
}

#if 0
void arl_tclStrClienthandler_ASF::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
  // Adapt to our needs
  //m_StrMessages->registerProperties(proxy, stateChange);
  ETG_TRACE_USR1(("ASF StrClh registerProperties not used here"));
}

void arl_tclStrClienthandler_ASF::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/)
{
  // Adapt to our needs
  //m_TunerInfo->deregisterProperties(proxy, stateChange);
  ETG_TRACE_USR1(("ASF StrClh registerProperties not used here"));
}
#endif

void arl_tclStrClienthandler_ASF::onAllocateRouteError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
                     const boost::shared_ptr< AllocateRouteError >& /* error */)
{
  // ToDo:
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onAllocateRouteError"));
}

void arl_tclStrClienthandler_ASF::onDeAllocateRouteError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
                     const boost::shared_ptr< DeAllocateRouteError >& /* error */)
{
  //ToDo
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onDeAllocateRouteError"));
}

void arl_tclStrClienthandler_ASF::onRoutingStateError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
                    const boost::shared_ptr< RoutingStateError >& /* error */)
{
  //ToDo
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onRoutingStateError"));
}

midw_fi_tcl_e8_streamrouter_routestate::tenType arl_tclStrClienthandler_ASF::mapAsfRouteStateToFiRouteState(T_e8_streamrouter_routestate e8Routestate) const
{
  if(e8Routestate == T_e8_streamrouter_routestate__INIT)
    return midw_fi_tcl_e8_streamrouter_routestate::FI_EN_INIT;
  else if(e8Routestate == T_e8_streamrouter_routestate__KILL)
    return midw_fi_tcl_e8_streamrouter_routestate::FI_EN_KILL;
  else if(e8Routestate == T_e8_streamrouter_routestate__PLAY)
    return midw_fi_tcl_e8_streamrouter_routestate::FI_EN_PLAY;
  else if(e8Routestate == T_e8_streamrouter_routestate__STOP)
    return midw_fi_tcl_e8_streamrouter_routestate::FI_EN_STOP;
  else
  {
    ETG_TRACE_ERR(("arl_tclStrClienthandler_ASF mapAsfRouteStateToFiRouteState no mapping"));
    return midw_fi_tcl_e8_streamrouter_routestate::FI_EN_INIT;
  }

}
void arl_tclStrClienthandler_ASF::onRoutingStateStatus(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /* proxy */,
                     const boost::shared_ptr< RoutingStateStatus >& status)
{
  //ToDo
  ETG_TRACE_USR1(("arl_tclStrClienthandler_ASF onRoutingStateStatus"));
  midw_streamrouter_fi_types::T_streamrouter_routing_list routingList = status->getRouting_list();


  midw_fi_tcl_streamrouter_route_entry fiRouteEntry;
  std::vector<midw_fi_tcl_streamrouter_route_entry> fiRouteEntryList;

  std::vector<T_streamrouter_route_entry>::iterator it;
  for(it=routingList.begin(); it!=routingList.end(); ++it)
  {
    fiRouteEntry.u32UCID = (*it).getU32UCID();
    fiRouteEntry.u16AppID = (*it).getU16AppID();
    fiRouteEntry.u16MLBChannelAddress = (*it).getU16MLBChannelAddress();
    fiRouteEntry.u8BlkWidth = (*it).getU8BlkWidth();
    fiRouteEntry.e8Routestate.enType = mapAsfRouteStateToFiRouteState((*it).getE8Routestate());

    fiRouteEntryList.push_back(fiRouteEntry);
  }

  if (NULL != m_cpoISourceVFsm)
  {
    if(false == m_cpoISourceVFsm->bOnRoutingStateStatus(fiRouteEntryList,midw_streamrouter_fi::SERVICE_ID,
        midw_streamrouter_fi::FID_RoutingState))
    {
      //ToDo need to send an unknown message. See ahl_tclBaseOneThreadClientHandler::vOnUnknownMessage

    }
  }  // if (OSAL_NULL != m_cpoISourceVFsm)

}

/******************************************************************************
** FUNCTION:  tVoid arl_tclStrClienthandler::vOnStatus(tU16 u16FID,am..
******************************************************************************/
void arl_tclStrClienthandler_ASF::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& /* proxy */,
    const asf::core::ServiceStateChange& /* stateChange */)
{
  //we have to inform ARL service aboute STR availability
  ETG_TRACE_USR1(("ASF StrClh onAvailable"));
  if (OSAL_NULL != m_cpoISourceVFsm)
  {
    // CCA_C_U16_SRV_STREAMROUTER 0x0261 (m_u16ServiceID)
    (tVoid)m_cpoISourceVFsm->bServiceAvailability(m_u16ServiceID);
  }  // if (OSAL_NULL != m_cpoISourceVFsm)

  m_bAvailable = true;
  //m_StrMessages->registerProperties(proxy, stateChange);
  // do it directly here
  if(m_StrFiProxy)
  {
    (void)m_StrFiProxy->sendRoutingStateUpReg(*this);
  }
  else
  {
    ETG_TRACE_FATAL(("ASF StrClh m_StrFiProxy is NULL"));
  }
}

void arl_tclStrClienthandler_ASF::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& /* proxy */,
    const asf::core::ServiceStateChange& /* stateChange */)
{
  //we have to inform ARL service about STR unavailability
  ETG_TRACE_USR1(("ASF StrClh onUnavailable"));
  m_bAvailable = false;
}

// <EOF>
