
#ifndef ARL_TCLSTRCLIENTHANDLER_ASF_H_
#define ARL_TCLSTRCLIENTHANDLER_ASF_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#define ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_STR_IF
#include "audio_routing_lib_if.h"

#include "midw_streamrouter_fiProxy.h"

using namespace ::asf::core;
using namespace midw_streamrouter_fi;
using namespace midw_streamrouter_fi_types;

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

#if __cplusplus < 201103L
#define NULLPTR NULL //C++03 or below
#define OVERRIDE  //C++03 or below
#define FINAL
#else
#define NULLPTR nullptr //C++11 or above
#define OVERRIDE override //C++11 or above
#define FINAL final
#endif

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/

//class arl_tclISourceVFsm;

/*!
 * \class arl_tclStrClienthandler_ASF
 * \brief Stream router client handler - based on ASF Proxy CCA
 *
 */

class arl_tclStrClienthandler_ASF: public arl_tclStrClientHandler_ASF_IF, // this is the IF that is used inside ARL
                                   public ServiceAvailableIF,
                                   public AllocateRouteCallbackIF,
                                 public DeAllocateRouteCallbackIF,
                         public RoutingStateCallbackIF,
                         public SendFGCommandCallbackIF,
                         public SetPlayCallbackIF,
                         public SetStopCallbackIF
{
public:

  arl_tclStrClienthandler_ASF(const char* appName
      , unsigned short u16ServiceID
      , unsigned short u16SrvMajVer
      , unsigned short u16SrvMinVer);
  ~arl_tclStrClienthandler_ASF();

  // ServiceAvailableIF implementation
  virtual void onAvailable  (const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange) OVERRIDE;
  virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange) OVERRIDE;

  // Callbacks
  virtual void onAllocateRouteError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< AllocateRouteError >& error) OVERRIDE;
  virtual void onAllocateRouteResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< AllocateRouteResult >& result) OVERRIDE;

  virtual void onDeAllocateRouteError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< DeAllocateRouteError >& error) OVERRIDE;
  virtual void onDeAllocateRouteResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< DeAllocateRouteResult >& result) OVERRIDE;

  virtual void onRoutingStateError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< RoutingStateError >& error) OVERRIDE;
  virtual void onRoutingStateStatus(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< RoutingStateStatus >& status) OVERRIDE;

  // These 2 are no more used
  virtual void onSendFGCommandError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /*proxy*/, const boost::shared_ptr< SendFGCommandError >& /*error*/) OVERRIDE {};
  virtual void onSendFGCommandResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& /*proxy*/, const boost::shared_ptr< SendFGCommandResult >& /*result*/) OVERRIDE {};

  virtual void onSetPlayError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< SetPlayError >& error) OVERRIDE;
  virtual void onSetPlayResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< SetPlayResult >& result) OVERRIDE;

  virtual void onSetStopError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< SetStopError >& error) OVERRIDE;
  virtual void onSetStopResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const boost::shared_ptr< SetStopResult >& result)OVERRIDE ;


  // virtual from IF
  virtual void setVFsm(arl_tclISourceVFsm* cpoISourceVFsm) OVERRIDE;

  virtual bool bIfServiceAvailable(void) OVERRIDE;

  // Send out to STR
  virtual bool bSendAllocateRoute(unsigned short ucid, int STM_MsgBufID, unsigned char u8SrcNum, tU16 u16Sink) OVERRIDE;
  virtual bool bSendDeAllocateRoute(unsigned short ucid, unsigned char u8SrcNum) OVERRIDE;

  virtual bool bSendSetPlay(unsigned short ucid, unsigned char u8SrcNum) OVERRIDE;
  virtual bool bSendSetStop(unsigned short ucid, unsigned char u8SrcNum) OVERRIDE;

  static const char* getAppName()
  {
    return _appName.c_str();
  }

private:
  midw_fi_tcl_e8_streamrouter_routestate::tenType mapAsfRouteStateToFiRouteState(T_e8_streamrouter_routestate e8Routestate) const;
  static std::string _appName;

  unsigned short m_u16ServiceID;
  unsigned short m_u16SrvMajVer;
  unsigned short m_u16SrvMinVer;
  ::boost::shared_ptr< Midw_streamrouter_fiProxy > m_StrFiProxy;
  arl_tclISourceVFsm* m_cpoISourceVFsm;

  //unsigned char u8LastSrcNum;
  //act_t curAct;

  //Need to introduce above variables for each activity to not overwrite if second activity started before ongoing one completed
  unsigned char u8LastSrcNumAlloc;
  act_t curActAlloc;

  unsigned char u8LastSrcNumDeAlloc;
  act_t curActDeAlloc;
  
  unsigned char u8LastSrcNumStop;
  act_t curActStop;

  unsigned char u8LastSrcNumPlay;
  act_t curActPlay;
  
  bool m_bAvailable;

}; // class arl_tclStrClienthandler: public ahl_tclBaseOneThreadClientHandler

#endif   // #ifndef ARL_TCLSTRCLIENTHANDLER_ASF_H_


////////////////////////////////////////////////////////////////////////////////
// <EOF>
