
#ifndef __POST_OFFICE__
#define __POST_OFFICE__
//#include <map>
//#include <list>

#include "Message.h"
#include "MessageMapItem.h"
#include "IF_MessageObserver.h"
//#include <stdio.h>
//#include <iostream>

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR


//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_LIST
//#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
//#include <stl_pif.h>


#include <map>
#include <algorithm>
#include <list>



//Trace defines
//#include <hmi_trace.h>
//#include "../../../../di_vag_hmi/products/hmi/hmicca_client/include/hmi_trace.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

//#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
//   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_POSTOFFICE
//   #include "trcGenProj/Header/PostOffice.hpp.trc.h"
//#endif


/**
 * @author Ruben Volkmer, vo84hi, mailto: External.Ruben.Volkmer@de.bosch.com
 * @date 11.01.2012
 *
 * @brief Static class that implements component internal communication, see details
 * @details
 * The strategy for communication via PostOffice is based on messages which are classified
 * by the MessageID of the Message class. The receiver has to register itself as an observer
 * for one or more Messages. This is done by calling the AddObserver() Method with the appropriate
 * parameters. As soon as some component will distribute a message, the component will call the
 * DeliverMsg() Method.
 * PostOffice will now inform the observers of the corresponding messageID according to the configuration
 * of this message. This configuration is found in the Message.conf file.
 * Now each observers MessageObserver::MessageNotification() method is called by the PostOffice, in advance
 * the observers have to collect the Messages by calling the QueryMessage() method of the PostOffice.
 * @attention
 * When MessageNotification of observer is called, the Message need to get fetched immediately (synchronously with notification)
 * Else the message got deleted by PostOffice
 */
template <typename msgIdent>
class PostOffice
{
   friend class Test_ObserverHandling;

protected:
   class MessageListItem{
   public:
      IF_MessageObserver<msgIdent>* m_lastNotifiedObserver;
      Message<msgIdent>*            m_message;

      MessageListItem(IF_MessageObserver<msgIdent>* Observer, Message<msgIdent>* message) :
         m_lastNotifiedObserver(Observer),
         m_message(message) {}

   } ;

private:
  PostOffice();

   /**
    *@brief Message Map stores observers, message configuration
    */
  map<msgIdent, MessageMapItem<msgIdent>*> m_MessageMap;

  /**
   * @brief The list items are pointing to Messages,
   * the item order is equivalent to the distribution order
   * @details The first item might be the actual distributed Message,
   * BUT if a Message arrives that interrupts actual distribution cause
   * of higher Priority it may not appear here.
   */
  list<MessageListItem*> m_MessageList;

  /**
   * @brief Flag that signals if a Message distribution is ongoing,
   * @details When this is true a Message is being distributed
   */
  tBool m_MsgDistributionActive;

  /**
   * @brief Contains the last OR active distributed Message ID
   */
 // msgIdent m_MsgDistributionID;  //rej1kor : not used right now.. commented for prio1 lint


  /**
   * Will delete all referenced items, is called by destructor
   */
   void CleanUp()
   {
     //@todo
     //for each message in m_MessageList call destructor

   }

public: 

   ~PostOffice()
   {
      //ETG_TRACE_USR4(("PostOffice Destructor"));
      CleanUp();
   }
  /**
   * Constructor to be used for PostOffice
   * usage in SW Component.
   * @param msgConf
   */
  PostOffice(MessageConfig<msgIdent>& msgConf) :
         m_MsgDistributionActive(false)
   {
      //ETG_TRACE_USR2(("PostOffice() Constructor"));

      // @todo replace
      //ETG_TRACE_USR4(("PostOffice Message configuration Version: %d", msgConf.m_Version));
      //ETG_TRACE_USR4(("PostOffice Message configuration Items: %d", msgConf.m_MessageConfig.capacity()));

      typename vector<MessageConfigItem<msgIdent>*>::iterator msgConfIterator;
      //Iterate through all config items
      for (msgConfIterator = msgConf.m_MessageConfig.begin();
            msgConfIterator != msgConf.m_MessageConfig.end();
            msgConfIterator++)
            {
         m_MessageMap[(*msgConfIterator)->ID] = new MessageMapItem<msgIdent>(
               (*msgConfIterator));
         m_MessageMap[(*msgConfIterator)->ID]->lastNotifiedObserver = NULL;
         //ETG_TRACE_USR4(("PostOffice() m_MessageConfig[%d] added", ETG_CENUM(msgIdent,(*msgConfIterator)->ID)));
      }
      //Init the List
      m_MessageList = list<MessageListItem*>();
   }



  /**
    * Calls the MessageNotification() Method of the observers
    * according to given ID
    * @param msgID
    */
   void InformObservers(msgIdent msgID)
   {
      //ETG_TRACE_USR2(("InformObservers() Start distribution MsgID: %d ",ETG_CENUM(msgIdent, msgID)));
      typename list<IF_MessageObserver<msgIdent>*>::iterator iteratorObserver;
      iteratorObserver = m_MessageMap[msgID]->observerList.begin();
      // Check if distribution starts at list.begin

      //------------------ MOVE TO OWN METHOD -------------------
      if ((*m_MessageList.begin())->m_lastNotifiedObserver != NULL)
      {
         //find the Observer we have to start with
         iteratorObserver = find(m_MessageMap[msgID]->observerList.begin(),
               m_MessageMap[msgID]->observerList.end(),
               (*m_MessageList.begin())->m_lastNotifiedObserver);
         //m_MessageMap[msgID]->lastNotifiedObserver);
         //check if we already notified the last observer
         if (iteratorObserver != m_MessageMap[msgID]->observerList.end())
         {
            //go one ahead
            ++iteratorObserver;
         }
      }
      //------------------ MOVE TO OWN METHOD -------------------

      // notify observers which wasn't informed yet
      while (iteratorObserver != m_MessageMap[msgID]->observerList.end())
      {
         if ((*iteratorObserver) != NULL)
         {
            //ETG_TRACE_USR4(("InformObservers() MsgID: %d Observer: %s ", ETG_CENUM(msgIdent, msgID), (*iteratorObserver)->getName()));
            // remember the last observer
            (*m_MessageList.begin())->m_lastNotifiedObserver =
                  (*iteratorObserver);
            (*iteratorObserver)->MessageNotification(msgID);
         }
         //------------------ MOVE TO OWN METHOD -------------------
         if ((*m_MessageList.begin())->m_lastNotifiedObserver != NULL)
         {
            //find the Observer we have to start with
            iteratorObserver = find(m_MessageMap[msgID]->observerList.begin(),
                  m_MessageMap[msgID]->observerList.end(),
                  (*m_MessageList.begin())->m_lastNotifiedObserver);
            //m_MessageMap[msgID]->lastNotifiedObserver);
            //check if we already notified the last observer
            if (iteratorObserver != m_MessageMap[msgID]->observerList.end())
            {
               //go one ahead
               ++iteratorObserver;
            }
         }
         //------------------ MOVE TO OWN METHOD -------------------
      }
   }

  /**
   * @brief Initializes the Message distribution to
   * all observers that are registered to this Message.
   *
   * Message registration is based on Message IDs, those
   * will be used for evaluating who needs to be informed of new Messages
   * @param messageForDistribution
   */
   template<typename customMessage>
   void DeliverMsg(customMessage* messageForDistribution)
   {
      Message<msgIdent> *msg =
            static_cast<Message<msgIdent>*>(messageForDistribution);
      if (msg == NULL)
      {
         //ETG_TRACE_FATAL(("DeliverMsg() incoming Message is NULL"));
    	  return;
      }
      //Get the Message ID
      msgIdent msgID = msg->GetMessageID();
      //ETG_TRACE_USR2(("DeliverMsg() incoming Message ID: %d",ETG_CENUM(msgIdent, msgID)));
      //Gather the configuration for this Message
      MessageConfigItem<msgIdent> *msgConf = GetMsgConfig(msgID);
      if (msgConf == NULL)
      {
         //ETG_TRACE_FATAL(("DeliverMsg() GetMsgConfig returns null, discarding delivery for MsgID: %d", ETG_CENUM(msgIdent, msgID)));
         return;
      }
      if (m_MessageMap[msgID] == NULL)
      {
         //ETG_TRACE_FATAL(("DeliverMsg() m_MessageMap is NULL for MsgID: %d", ETG_CENUM(msgIdent, msgID)));
         return;
      }

      // Check if Message has to be distributed immediately OR there is no active Message distribution
      if ((msgConf->distRule == MessageDistribution::immediately))
      {
         //Flag if this is intermediate incoming while already
         //distributing
         tBool msgDistributionWasActive = m_MsgDistributionActive;
         // START MESSAGE DISTRIBUTION
         m_MsgDistributionActive = true;
         //No need to clone cause we deliver directly
         m_MessageList.push_front(new MessageListItem(NULL, msg));
         //maybe we get recursive call
         msgID = msg->GetMessageID();
         // Distribute Message
         InformObservers(msgID);
         //delete MessageListItem created above
         delete (m_MessageList.front());
         //remove Pointer to MessageListItem, deleted above
         m_MessageList.pop_front();

         //Reset Flag only if distribution wasn't active prior
         if(!msgDistributionWasActive)
            m_MsgDistributionActive = false;

         //Check if in between we had incomings
         //(then the Message List contains items)
         //else we can return directly
         if(m_MessageList.size() <= 0)
            return;
      }

      if(!m_MsgDistributionActive)
      {
         // START MESSAGE DISTRIBUTION
         m_MsgDistributionActive = true;
         //add Message to distribution list

         //when initial Msg was immediately one,
         //exclude clone
         if(msgConf->distRule == MessageDistribution::buffered)
         {
            //we should NEVER come here if immediately msg was distributed
            //and this caused delivery of a buffered message
            //BUT when initial a buffered Message is being delivered we
            //clone
            Message<msgIdent>* clonedMsg = msg->clone();
            m_MessageList.push_front(new MessageListItem(NULL, clonedMsg));
         }
         //get iterator
         typename list<MessageListItem*>::iterator msgIterator;
         //distribute those that arrived meanwhile, or those whose distribution was interrupted
         msgIterator = m_MessageList.begin();
         while (msgIterator != m_MessageList.end())
         {
            if ((*msgIterator)->m_message == NULL)
            {
               //ETG_TRACE_FATAL(("DeliverMsg() While iterate m_MessageList: m_MessageList->message is NULL "));
               return;
            }
            msgID = (*msgIterator)->m_message->GetMessageID();
            // Distribute Message
            InformObservers(msgID);
            // Garbage Collection
            //ETG_TRACE_USR4(("DeliverMsg() Delete Message MsgID: %d", ETG_CENUM(msgIdent, msgID)));
            //eliminate the first occurance of this Message
            if(m_MessageList.size() > 0)
            {
               delete ((*msgIterator)->m_message);
//               delete (*msgIterator);
               m_MessageList.erase(msgIterator);
            }
            msgIterator = m_MessageList.begin();
         }
      }
      else
      {
         if (msgConf->distRule == MessageDistribution::buffered)
         {
            // QUEUE MESSAGE FOR LATER DISTRIBUTION
            // Collect Message and add to queue
            Message<msgIdent>* clonedMsg = msg->clone();
            m_MessageList.push_back(new MessageListItem ( NULL, clonedMsg ));
            //ETG_TRACE_USR4(("DeliverMsg() Message cloned and enqueued to messageList Position: %d MsgID: %d", m_MessageList.size(), ETG_CENUM(msgIdent, msgID)));
            if (m_MessageList.front() == NULL)
            {
               //ETG_TRACE_FATAL(("DeliverMsg() messageList.front() is NULL"))
               return;
            }
         }
      }
   }

  /**
   * Deregister Observer for given Message ID
   * @param obs Pointer to the Observer that is removed
   * @param observedMsgID Ident of Message the observer is not longer notified
   */
   template<typename observement>
   void RemoveObserver(observement *obs, msgIdent observedMsgID)
   {
      if (obs == NULL)
      {
         //ETG_TRACE_FATAL(("RemoveObserver() obs is NULL"));
      }
      IF_MessageObserver<msgIdent>* pObserver = (static_cast<IF_MessageObserver<
            msgIdent>*>(obs));
      //ETG_TRACE_USR2(("RemoveObserver() Removing for MsgID: %d Observer: %s", ETG_CENUM(msgIdent, observedMsgID), pObserver->getName()));
      if (m_MessageMap[observedMsgID] == NULL)
      {
         //ETG_TRACE_FATAL(("RemoveObserver() m_MessageMap[%d] is NULL", ETG_CENUM(msgIdent, observedMsgID)));
      }
      m_MessageMap[observedMsgID]->observerList.remove(pObserver);
      // @todo replace cout << "RemoveObserver: Observer registration is removed for Messages: " << observedMsgID << "\n";
   }

  /**
   * Deregister Observer. An observer is going out of scope, so remove the observer from the various messages it has registered to
   * @param obs Pointer to the Observer that is to be deregistered
   */
   template<typename observement>
   void DeRegisterObserver(observement *obs)
   {
      if (obs == NULL)
      {
         return;
      }
      IF_MessageObserver<msgIdent>* pObserver = (static_cast<IF_MessageObserver<
            msgIdent>*>(obs));

	  typename map<msgIdent, MessageMapItem<msgIdent>*>::iterator msgmapIter;
	  for(msgmapIter = m_MessageMap.begin(); msgmapIter != m_MessageMap.end();msgmapIter++)
	  {
		  if(msgmapIter->second != NULL)
		  {
			  msgmapIter->second->observerList.remove(pObserver);
		  }
	  }
   }

   /**
   * Register observer to PostOffice
   * @attention
   * 1. The observer should remove themself at least in the destructor
   * 2. If the observer has it's own thread, this Method must be called
   * within the threads' context
   * @param obs reference to the observer
   * @param observedMsgID the ID of the message that will be observed
   */
   template<typename observement>
   void AddObserver(observement *obs, msgIdent observedMsgID)
   {
      if (obs == NULL)
      {
         //ETG_TRACE_FATAL(("AddObserver() obs is NULL"));
      }
      // @todo replace printf("PostOffice Adding Observer\n");
      IF_MessageObserver<msgIdent>* pObserver = (static_cast<IF_MessageObserver<
            msgIdent>*>(obs));

      if (m_MessageMap[observedMsgID] == NULL)
      {
         //ETG_TRACE_FATAL(("AddObserver() observerList is NULL for MsgID: %d", ETG_CENUM(msgIdent, observedMsgID)));
      }
      //Need to first create a MessageMapItem
      //CreateMessageMapItem(observedMsgID);
      //Is the Observer already registered
      typename list<IF_MessageObserver<msgIdent>*>::iterator iteratorObserver;
      for (iteratorObserver = m_MessageMap[observedMsgID]->observerList.begin();
            iteratorObserver != m_MessageMap[observedMsgID]->observerList.end();
            iteratorObserver++)
            {
         if ((*iteratorObserver) != NULL)
         {
            if ((*iteratorObserver) == pObserver)
            {
               //ETG_TRACE_USR4(("AddObserver() Observer already registered for MsgID: %d", ETG_CENUM(msgIdent, observedMsgID)));
               // @todo replace cout << " Observer already registered for Messages: " << observedMsgID << "\n";
               return;
            }
         }
         else
         {
            //ETG_TRACE_FATAL(("AddObserver() iteratorObserver is NULL while iterating"));
         }
      }
      //Add Observer
      m_MessageMap[observedMsgID]->observerList.push_back(pObserver);
      //ETG_TRACE_USR2(("AddObserver() Added for MsgID: %d Observer: %s", ETG_CENUM(msgIdent, observedMsgID), pObserver->getName()));
      // @todo replace cout << " Observer has been registered to Messages: " << observedMsgID << "\n";
   }
  
  /**
   * Returns the Message configuration for given Message ID
   * @param msgID Identifier of the Message, that configuration is searched
   * @return configuration if available, else null
   */
   MessageConfigItem<msgIdent>* GetMsgConfig(msgIdent msgID)
   {
      if (m_MessageMap.find(msgID) == m_MessageMap.end())
      {
         // @todo replace cout << " GetMsgConfig: could not get Config for MessageID: " << msgID << "\n";
         //ETG_TRACE_USR1(("GetMsgConfig() No Config found for MsgID: %d", ETG_CENUM(msgIdent, msgID)));
         return NULL;
      }
      return m_MessageMap[msgID]->msgConf;
   }

  /**
   * Collect Message from PostOffice.
   *
   * @attention Messages are deleted by PostOffice immediately.
   * If you want to keep it you should clone the Message!
   *
   * @param msgID Message Ident that is fetched
   * @return Pointer to Message or NULL if there's no Message
   */
   template<typename TMsg>
   const TMsg* QueryMessage(msgIdent msgID)
   {
      //ETG_TRACE_USR2(("QueryMessage() QueryMessage for MsgID: %d", ETG_CENUM(msgIdent, msgID)));

      typename list<MessageListItem*>::iterator msgIterator;

      for (msgIterator = m_MessageList.begin();
            msgIterator != m_MessageList.end(); ++msgIterator)
            {
         if ((*msgIterator)->m_message == NULL)
         {
            //ETG_TRACE_FATAL(("QueryMessage(): message is NULL Pointer"));
         }
         Message<msgIdent> *msg = (*msgIterator)->m_message;
         if (msg->GetMessageID() == msgID)
         {
            return static_cast<TMsg*>(msg);
         }
      }
	  //ETG_TRACE_USR1(("QueryMessage() No Message available for MsgID: %d", ETG_CENUM(msgIdent, msgID)));
      return NULL;
   }
};

#endif
