#ifndef __POST_OFFICE_MESSAGE__
#define __POST_OFFICE_MESSAGE__

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include <osal_if.h>


//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
////#define SYSTEM_S_IMPORT_INTERFACE_MAP
////#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
//#include <stl_pif.h>
////#include <vector>



#include <vector>
#include <algorithm>




using namespace std;
/**
 * Definition of possible Message mechanisms
 */
class MessageMechanism
{
public:
   /**
    * Message mechanism enumeration
    */
   typedef enum {
     synchron, //!< receive and processing is invoked by deliver thread, message is not copied
     asynchron,//!< Message will be copied and collected by different thread
     invalid   //!< not to be used
   }enMechanism;
};

/**
 * Definition of possible Message distribution tactics
 */
class MessageDistribution
{
public:
   /**
    * Message mechanism enumeration
    */
   typedef enum {
       buffered,    //!< While Message distribution, new Messages are queued until predecessors have been delivered
       immediately, //!< While Message distribution, new Messages will be distributed before distribution will continue
       invalid      //!< not to be used
     }enDistribution;
};

/**
 * @brief For each Message that is to be distributed by PostOffice
 *        a configuration is mandatory. The message specific configurations
 *        are defined by this class.
 */
template <typename Ident>
class MessageConfigItem
{
public:
   /**
    * Commonly used constructor, needs all configuration Parameter
    * @param messageIdentifier Identifier of the Message that is configured
    * @param messageMechanism configures the distribution Mechanism,
    * see class description for details
    * @param distributionRule configures the distribution rule,
    * see class description for details
    */
    MessageConfigItem(Ident messageIdentifier,
                      MessageMechanism::enMechanism messageMechanism,
                      MessageDistribution::enDistribution distributionRule) :
                         ID(messageIdentifier),
                         msgMech(messageMechanism),
                         distRule(distributionRule){}

    //MessageConfigItem<Ident> & operator=(const MessageConfigItem<Ident> &rhs);


    Ident ID;
    /** The Message mechanism */
    MessageMechanism::enMechanism msgMech;
    /** Distribution tactics */
    MessageDistribution::enDistribution distRule;
    /** Clone Method */
    MessageConfigItem<Ident>* clone() const {return new MessageConfigItem<Ident>(ID,msgMech,distRule); }
 };

template<typename msgIdent>
class MessageConfig
{
   public:
      vector<MessageConfigItem<msgIdent>* > m_MessageConfig;
      static const int                          m_Version = 1;

      ~MessageConfig()
      {
         //Delete all vector items
      }
};


/**
 * @brief Abstract Base class for Messages that are delivered by PostOffice
 *
 */
template <typename ID>
class Message
{
private:
   tBool m_MessageValid;

public:
  virtual ~Message() { m_MessageValid = FALSE; }
  /**
   * @param msgID The Message ID which Observers will register by
   * PostOffice to receive the corresponding Messages
   */
  Message(ID msgID) : m_MessageValid(TRUE), m_MsgID(msgID) {}

  /**
   * Stores the Message ID
   */
  const ID m_MsgID;

  /**
   *
   * @return The MessageID of the Message object
   */
  ID GetMessageID() { return m_MsgID; };

  tBool IsValid() const { return m_MessageValid; };

  /**
   *
   * @return Should return a deep copy of the
   * object itself. Derived Classes with complex
   * members should take care of correct design and
   * implemention in respect to copy functionality
   */
  virtual Message *clone() const = 0;
};

#endif

