

/*******************************************************************************
* FILE:          FC_StreamRouter_trace_def.h
* SW-COMPONENT:  FC_StreamRouter application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   General class of diagnosis
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 12.04.11  | TMS Gaidatzi-Lken      | Inital version
*******************************************************************************/

#ifndef FC_STREAMROUTER_TRACE_DEF_H_
#define FC_STREAMROUTER_TRACE_DEF_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*
 * Trace Class Enumeration.
 */


enum tenTrcTraceClassFC_StreamRouter {
  TR_CLASS_FC_STREAMROUTER_APPLICATION        = TR_COMP_AUDIOMANAGEMENT + 32,
  TR_CLASS_FC_STREAMROUTER_CLIENTHANDLER_MOSTMIC  = TR_COMP_AUDIOMANAGEMENT + 32 + 1,
  TR_CLASS_FC_STREAMROUTER_SERVICE_STREAMROUTER    = TR_COMP_AUDIOMANAGEMENT + 32 + 2,
  TR_CLASS_FC_STREAMROUTER_DIAGLIB          = TR_COMP_AUDIOMANAGEMENT + 32 + 3,
  TR_CLASS_FC_STREAMROUTER_CLIENTHANDLER_DIAGLOG  = TR_COMP_AUDIOMANAGEMENT + 32 + 4,
  TR_CLASS_FC_STREAMROUTER_XML_DB                  = TR_COMP_AUDIOMANAGEMENT + 32 + 5,
  TR_CLASS_FC_STREAMROUTER_CLIENTHANDLER_AUDIOMGMT  = TR_COMP_AUDIOMANAGEMENT + 32 + 6
};


#define STR_EVENT_STM_LOAD_OK                 0x00000001
#define STR_EVENT_STM_LOAD_NOK                0x00000002
#define STR_EVENT_STM_LOADING                 0x00000004
#define STR_EVENT_ERRH                        0x00000008


#endif   // #ifndef FC_STREAMROUTER_TRACE_DEF_H_

// <EOF>
