

/*******************************************************************************
*
* FILE:          FC_StreamRouter_service_StreamRouter.h
*
* SW-COMPONENT:  FC_StreamRouter application
*
* PROJECT:
*
* DESCRIPTION:   CCA service StreamRouter.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_STREAMROUTER_SERVICE_STREAMROUTER_H_
#define _FC_STREAMROUTER_SERVICE_STREAMROUTER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

                                            // Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

                            // Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

                                  //Include public FI interface of this service.
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTER_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTER_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTER_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTER_SERVICEINFO
#include "midw_fi_if.h"

#define STR_DELAY_TIMER_DEFAULT_EXP 2000
#define STR_DELAY_TIMER_DEFAULT_INT 0
#define STR_INVALID_HANDLE 0

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

           // Loop back message defines to be processed by vOnLoopbackService().

            /* Definition of internal Function IDs (iFIDs) and message        */
            /* content IDs (MSGID) which are not public and therefore are     */
            /* not in the public FI of our service. Such internal function    */
            /* and message content IDs are necessary for 'loopback' messages, */
            /* i.e. messages the application sends itself. These internal     */
            /* function IDs must be different to the ones from the public FI. */
            /* The developer has to take care about that. To have a maximum   */
            /* separation of the public and the internal FIDs we start the    */
            /* definition for the internal ones nearly at the end of the      */
            /* possible range and then count downwards.*/

                                                // Internal function ID defines.
#define STREAMROUTER_C_U16_IFID_EXAMPLE_1     0xFFF0
#define STREAMROUTER_C_U16_IFID_ALLOCATE      0xFFF1
#define STREAMROUTER_C_U16_IFID_PLAY          0xFFF2
#define STREAMROUTER_C_U16_IFID_STOP          0xFFF3
#define STREAMROUTER_C_U16_IFID_DEALLOCATE    0xFFF4
#define STREAMROUTER_C_U16_IFID_GETSREAMPROP  0xFFF5
#define STREAMROUTER_C_U16_IFID_PRINTCONFSRT  0xFFF6
#define STREAMROUTER_C_U16_IFID_ROUTINGSTATE  0xFFF7

#define STREAMROUTER_C_U16_IFID_TEST          0xFFF8

                                                  // Message content ID defines.
#define STREAMROUTER_C_U32_MSGID_EXAMPLE_1 0x00000001


typedef struct
{
  midw_streamrouterfi_tclMsgAllocateRouteMethodResult* pMsg;
  tU16 SourceAppID;
  tU16 RegisterID;
  tU16 CmdCounter;
  tU16 FunctionID;
  tU16 UCID;
  tU32 handle;

}tMethodResultMessage;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadService;
class str_tclSedWrap;

class fc_streamrouter_tclService_StreamRouter : public ahl_tclBaseOneThreadService
{
  public:

    fc_streamrouter_tclService_StreamRouter();
    fc_streamrouter_tclService_StreamRouter(fc_streamrouter_tclApp* poMainAppl);
    virtual ~fc_streamrouter_tclService_StreamRouter();

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vOnLoopbackService(amt_tclServiceData* poMessage);
    tVoid vProcessTimer(tU16 u16TimerId);

    virtual tVoid vOnEvent(OSAL_tEventMask nEvent);

    tVoid vHandle_AllocateRoute_Start(amt_tclServiceData* poMessage);
    tVoid vHandle_DeAllocateRoute_Start(amt_tclServiceData* poMessage);
    tVoid vHandle_SetPlay_Start(amt_tclServiceData* poMessage);
    tVoid vHandle_SetStop_Start(amt_tclServiceData* poMessage);
    tVoid vHandle_RoutingState_Get(amt_tclServiceData* poMessage);

    tVoid fill_RoutingStateMsg(midw_streamrouterfi_tclMsgRoutingStateStatus* oMsgRoutingState);

    void sendRoutingStateProperty(void);

  tVoid vSendErrorMsg(amt_tclServiceData* poMessage, tU16 errorcode);

  tVoid vSendTestMessage(void);

   fc_streamrouter_tclApp* pMainApp;

  //tS32 TTFis_sendAllocate(tS32 appid, tS32 ucid);
  //tS32 TTFis_sendPlay(tS32 appid, tS32 ucid);
  //tS32 TTFis_sendStop(tS32 appid, tS32 ucid);
  //tS32 TTFis_sendDeallocate(tS32 appid, tS32 ucid);
  //tS32 TTFis_sendGetStreamProp(tS32 ucid);
  //tS32 TTFis_sendPrintSubroutes(tS32 ucid);
  tS32 TTFis_LoopbackCommand(tS32 appid, tS32 ucid, tU16 cmd);

#if 0
  tBool delay_retry();
  tBool delay_handle_request(amt_tclServiceData* poMessage);
  int delay_srvdata_getucid(amt_tclServiceData* poMessage);
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  tVoid SendLastResult(tU32 handle);
  midw_streamrouterfi_tclMsgAllocateRouteMethodResult* getLastResult(tU32 u32Handle);
  tU32 u32SetHandle();
  tU32 u32GetHandle();
#endif

  private:
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  tVoid addToMsgStore(tMethodResultMessage* pMsg);
  tMethodResultMessage* removeFromMsgStore(midw_streamrouterfi_tclMsgAllocateRouteMethodResult* pMsg);

  std::vector<tMethodResultMessage*> msgStore;
  tU32 m_u32Handle;
#endif
  protected:

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
    virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);

    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.

private:
   //str_tclSedWrap* m_poSedInterface;

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

    DECLARE_MSG_MAP(fc_streamrouter_tclService_StreamRouter)
};

#endif // _FC_STREAMROUTER_SERVICE_STREAMROUTER_H_

