

/*******************************************************************************
*
* FILE:          FC_StreamRouter_service_StreamRouter.cpp
*
* SW-COMPONENT:  FC_StreamRouter application
*
* PROJECT:
*
* DESCRIPTION:   CCA service StreamRouter.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include <vector>

#include "FC_StreamRouter_routingtable.h"

#include "FC_StreamRouter_main.h"
#include "FC_StreamRouter_service_StreamRouter.h"
//#include "FC_StreamRouter_sed.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "FC_StreamRouter_trace_def.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_SERVICE_STREAMROUTER
#include "trcGenProj/Header/FC_StreamRouter_service_StreamRouter.cpp.trc.h"
#endif

#define FC_STREAMROUTER_S_IMPORT_INTERFACE_MSG
#include "FC_StreamRouter_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTER_SERVICEINFO

#include "midw_fi_if.h"


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION  1
#define FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MINOR_VERSION  0
#define FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_PATCH_VERSION  0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_streamrouter_tclService_StreamRouter, ahl_tclBaseWork)
  ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_ALLOCATEROUTE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandle_AllocateRoute_Start)
  ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_DEALLOCATEROUTE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandle_DeAllocateRoute_Start)
  ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_SETPLAY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandle_SetPlay_Start)
  ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_SETSTOP, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandle_SetStop_Start)
  ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_ROUTINGSTATE, AMT_C_U8_CCAMSG_OPCODE_GET, vHandle_RoutingState_Get)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_streamrouter_tclService_StreamRouter::fc_streamrouter_tclService_StreamRouter(fc_streamrouter_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class ahl_tclBaseOneThreadService
*              with a pointer to this application, the service identifier,
*              the application identifier and the service version as parameters.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_streamrouter_tclService_StreamRouter::
  fc_streamrouter_tclService_StreamRouter(fc_streamrouter_tclApp* poMainAppl)
    :ahl_tclBaseOneThreadService(
      /* Application Pointer              */ poMainAppl,
      /* ID of offered Service            */ CCA_C_U16_SRV_STREAMROUTER,
      /* MajorVersion of offered Service  */ FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION,
      /* MinoreVersion of offered Service */ FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MINOR_VERSION,
      /* PatchVersion of offered Service  */ FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_PATCH_VERSION)
      /*, m_poSedInterface(OSAL_NULL)*/
{
  ETG_TRACE_USR4(("fc_streamrouter_tclService_StreamRouter() entered."));
  pMainApp = poMainAppl;
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  m_u32Handle = 0;
  #endif
}

/*******************************************************************************
*
* FUNCTION: fc_streamrouter_tclService_StreamRouter::~fc_streamrouter_tclService_StreamRouter(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_streamrouter_tclService_StreamRouter::~fc_streamrouter_tclService_StreamRouter(tVoid)
{
  ETG_TRACE_USR4(("~fc_streamrouter_tclService_StreamRouter() entered."));
  pMainApp = NULL;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclService_StreamRouter::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_streamrouter_tclService_StreamRouter::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclService_StreamRouter::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_streamrouter_tclService_StreamRouter::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tBool fc_streamrouter_tclService_StreamRouter
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool fc_streamrouter_tclService_StreamRouter
      ::bStatusMessageFactory(tU16 u16FunctionId,
                              amt_tclServiceData& roOutMsg,
                              amt_tclServiceData* poInMsg)
{
  (tVoid)poInMsg;
  (tVoid)roOutMsg;
  tBool bRetVal = TRUE;

  ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.", u16FunctionId));

  switch(u16FunctionId)
  {
    case MIDW_STREAMROUTERFI_C_U16_ROUTINGSTATE:
    {
       midw_streamrouterfi_tclMsgRoutingStateStatus oMsgRoutingState;

       fill_RoutingStateMsg(&oMsgRoutingState);

       fi_tclVisitorMessage oVisitor(oMsgRoutingState, FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION);
       // Always destroy the FI data object before leaving its creation scope
       oMsgRoutingState.vDestroy();

       bRetVal = oVisitor.bHandOver(&roOutMsg);
    }
    break;

    default:
    {
       ETG_TRACE_ERR(("ERROR: Function Id: 0x%x called from status factory", u16FunctionId));
       bRetVal = FALSE;
    }  // default:
    break;
  }
  return bRetVal;
}

/*******************************************************************************
*
* FUNCTION: tBool fc_streamrouter_tclService_StreamRouter
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool fc_streamrouter_tclService_StreamRouter
      ::bProcessSet(amt_tclServiceData* poMessage,
                    tBool& bPropertyChanged,
                    tU16& u16ErrorCode)
{
  (void)poMessage;
  (tVoid) bPropertyChanged; // These lines are added to avoid LINT warnings.
  (tVoid) u16ErrorCode;     // Please remove as soon as variables are used.

#if 0
  tBool bSuccess = FALSE;

  tU16 u16FunctionId = poMessage->u16GetFunctionID();

  ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

  fi_tclVisitorMessage oVisitorMsg(poMessage);

  switch(u16FunctionId)
  {
    // Handle property setting for this function ID ...
  }

  if (FALSE == bSuccess)
  {
    ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.",
                   u16FunctionId));

    NORMAL_M_ASSERT_ALWAYS();
  }

  return bSuccess;
#endif

  return TRUE;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclService_StreamRouter::vOnLoopbackService(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called from the vOnLoopback() function of this
*              CCA application if a message from one of this applications
*              services is received (so called self or loopback messages).
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*            [IN] poMessage = Message object.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_streamrouter_tclService_StreamRouter::vOnLoopbackService(amt_tclServiceData* poMessage)
{
  gm_tclU32Message oVisitorMsg(poMessage);

  tU16 u16FunctionId = poMessage->u16GetFunctionID();

  tU32 u32MsgContent = oVisitorMsg.u32GetDWord();

  ETG_TRACE_USR4(("vOnLoopbackService() entered. iFID = 0x%4x, u32MsgContent = %u.",
                  u16FunctionId,
                  u32MsgContent));

  switch(u16FunctionId)
  {
    case STREAMROUTER_C_U16_IFID_EXAMPLE_1 :
      {
        switch(u32MsgContent)
        {
          case STREAMROUTER_C_U32_MSGID_EXAMPLE_1 :
            {
          // Some Action.
            }
            break;

          default:
            {
              ETG_TRACE_ERR(("vOnLoopbackService(). Unknown u32MsgContent %u.",
                             u32MsgContent));
            }
        }
      }
      break;
    case STREAMROUTER_C_U16_IFID_ALLOCATE:
      {
        if((pMainApp->AllocateRoute(poMessage->u16GetSourceAppID(), (tU16)u32MsgContent, -1, NULL) & STR_ERR__MASK) == 0)
        {
          sendRoutingStateProperty();
        }
      }
      break;
    case STREAMROUTER_C_U16_IFID_PLAY:
      {
        if((pMainApp->SetPlay(poMessage->u16GetSourceAppID(), (tU16)u32MsgContent, 0) & STR_ERR__MASK) == 0)
        {
          sendRoutingStateProperty();
        }
      }
      break;
    case STREAMROUTER_C_U16_IFID_STOP:
      {
        if((pMainApp->SetStop(poMessage->u16GetSourceAppID(), (tU16)u32MsgContent, 0) & STR_ERR__MASK) == 0)
        {
          sendRoutingStateProperty();
        }
      }
      break;
    case STREAMROUTER_C_U16_IFID_DEALLOCATE:
      {
        if((pMainApp->DeAllocateRoute(poMessage->u16GetSourceAppID(), (tU16)u32MsgContent) & STR_ERR__MASK) == 0)
        {
          sendRoutingStateProperty();
        }
      }
      break;
    case STREAMROUTER_C_U16_IFID_GETSREAMPROP:
      {
        pMainApp->GetStreamProp(poMessage->u16GetSourceAppID(),(tU16)u32MsgContent);
      }
      break;
    case STREAMROUTER_C_U16_IFID_PRINTCONFSRT:
      {
        pMainApp->PrintSubroutes((int)u32MsgContent);
      }
      break;
    case STREAMROUTER_C_U16_IFID_ROUTINGSTATE:
      {
        vHandle_RoutingState_Get(poMessage);
      }
      break;
  case STREAMROUTER_C_U16_IFID_TEST:
    {
      ETG_TRACE_ERR(("vOnLoopbackService().test"));
      break;
    }
    default:
      {
        ETG_TRACE_ERR(("vOnLoopbackService(). Unknown iFID %u.", u16FunctionId));
      }
      break;
  }
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclService_StreamRouter::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the vOnTimer() function of this
*              CCA application on the expiration of a previously via function
*              bStartTimer() started timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_streamrouter_tclService_StreamRouter::vProcessTimer(tU16 u16TimerId)
{
  _poMainAppl->bStopTimer(u16TimerId);


#if 0
  //ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));
  (void)u16TimerId;
  gm_tclU32Message oServiceReadyMsg(_poMainAppl->u16GetAppId(),  // Source AppID
                                    _poMainAppl->u16GetAppId(),  // Target AppID
                                    0,                           // RegisterID
                                    0,                           // CmdCounter
                                    _u16ServiceID,               // ServiceID
                                    STREAMROUTER_C_U16_IFID_EXAMPLE_1,  // Function ID
                                    AMT_C_U8_CCAMSG_OPCODE_STATUS  // Opcode
                                   );

  oServiceReadyMsg.vSetDWord(STREAMROUTER_C_U32_MSGID_EXAMPLE_1);

  if ( oServiceReadyMsg.bIsValid() )
  {
    if (_poMainAppl->enPostMessage(&oServiceReadyMsg, TRUE) != AIL_EN_N_NO_ERROR)
    {
      NORMAL_M_ASSERT_ALWAYS();
    }
  }
  else
  {
    NORMAL_M_ASSERT_ALWAYS();
  }
#endif
}


tVoid fc_streamrouter_tclService_StreamRouter::vSendTestMessage(void)
{
  ETG_TRACE_USR4(("Sending test message..."));
#if 0
  midw_streamrouterfi_tclMsgAllocateRouteMethodStart msg;
  //midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart msg;
  msg.u16UCID = 0x0200;

  fi_tclVisitorMessage allocatemsg(msg);

  vInitServiceData(allocatemsg,                           // ServiceDataMsg
          _poMainAppl->u16GetAppId(),                   // Target AppID
          0,                                // RegisterID
          0,                                // CmdCounter,
          STREAMROUTER_C_U16_IFID_EXAMPLE_1,            // Function ID
          AMT_C_U8_CCAMSG_OPCODE_METHODSTART);      // Opcode

  //ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&allocatemsg, TRUE);
  vHandle_AllocateRoute_Start(&allocatemsg);
  //vHandle_DeAllocateRoute_Start(&allocatemsg);
  #endif

  #if 0
  if(enResult != AIL_EN_N_NO_ERROR)
  {
  ETG_TRACE_USR4(("ERR: not sent (%d)!", (int)enResult));
  }
  else
  {
  ETG_TRACE_USR4(("Sent successfully."));
  }
  #endif
}

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
tVoid fc_streamrouter_tclService_StreamRouter::SendLastResult(tU32 handle)
{
   midw_streamrouterfi_tclMsgAllocateRouteMethodResult* oldMsg = (midw_streamrouterfi_tclMsgAllocateRouteMethodResult*)getLastResult(handle);

   ETG_TRACE_USR4(("SendLastResult handle %d",handle));

   if(oldMsg == NULL)
     return;
   tMethodResultMessage* pMsg = removeFromMsgStore(oldMsg);

   if(pMsg != NULL)
   {
      // dump what we have
      for(int i = 0;i < pMsg->pMsg->listInputDev.strALSADev.size();++i)
      {
         ETG_TRACE_USR4(("we have oldMsg->listInputDev.strALSADev %s",pMsg->pMsg->listInputDev.strALSADev[i].szValue));
      }
      for(int i = 0;i < pMsg->pMsg->listOutputDev.strALSADev.size();++i)
      {
         ETG_TRACE_USR4(("we have oldMsg->listOutputDev.strALSADev %s",pMsg->pMsg->listOutputDev.strALSADev[i].szValue));
      }



      //do what was done outside
      fi_tclVisitorMessage oResultMsg(*oldMsg);
      vInitServiceData(oResultMsg,                          // ServiceDataMsg
            pMsg->SourceAppID,               // Target AppID
            pMsg->RegisterID,                // RegisterID
            pMsg->CmdCounter,                // CmdCounter,
            pMsg->FunctionID,                // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);     // Opcode
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oResultMsg, TRUE);

      sendRoutingStateProperty();

      if(enResult != AIL_EN_N_NO_ERROR)
      {
         ETG_TRACE_FATAL((">>> ! ERR: Answer not sent (%d) ! <<<", (int)enResult));
      }
      else
      {
         ETG_TRACE_USR4((">>> Answer sent successfully. <<<"));
      }

      ETG_TRACE_USR4(("SendLastResult deleting.."));
      delete pMsg->pMsg;
      pMsg->pMsg = 0;
      delete pMsg;
      pMsg=0;
   }
   else
   {
      ETG_TRACE_ERR(("SendLastResult ERROR"));
   }

}

tVoid fc_streamrouter_tclService_StreamRouter::vHandle_AllocateRoute_Start(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("Received AllocateRoute from appid 0x%x, regid 0x%x, fid 0x%x...", poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   midw_streamrouterfi_tclMsgAllocateRouteMethodStart inmsg;

   midw_streamrouterfi_tclMsgAllocateRouteMethodResult* poutmsg = new midw_streamrouterfi_tclMsgAllocateRouteMethodResult;
   tMethodResultMessage* poMethodResultMessage = new tMethodResultMessage;
   poMethodResultMessage->pMsg = poutmsg;

   //but we need to keep the result data
   poMethodResultMessage->SourceAppID = poMessage->u16GetSourceAppID();
   poMethodResultMessage->RegisterID = poMessage->u16GetRegisterID();
   poMethodResultMessage->CmdCounter = poMessage->u16GetCmdCounter();
   poMethodResultMessage->FunctionID= poMessage->u16GetFunctionID();
   poMethodResultMessage->UCID = inmsg.u16UCID;
   poMethodResultMessage->handle = u32SetHandle();


   ETG_TRACE_USR4(("Addr of new created out msg p= %p",poutmsg));
   ETG_TRACE_USR4(("Size of new created out msg %d",poutmsg->u32GetSize()));
   if(oVisitorMsg.s32GetData(inmsg, FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      ETG_TRACE_USR4(("Incoming UCID is 0x%x.", inmsg.u16UCID));
      tS32 ret = pMainApp->AllocateRoute(poMessage->u16GetSourceAppID(), inmsg.u16UCID, inmsg.s32STM_MsgBufID, poutmsg);
      ETG_TRACE_USR4(("Allocate returned %d.", (int)ret));
      ETG_TRACE_USR4(("Size of out msg after cca filling %d",poutmsg->u32GetSize()));

      if(ret==0)
      {
         ETG_TRACE_USR4(("stored SourceAppID %x, RegisterID %x, CmdCounter %x, FunctionID %x, UCID %x",poMethodResultMessage->SourceAppID,
               poMethodResultMessage->RegisterID, poMethodResultMessage->CmdCounter, poMethodResultMessage->FunctionID, poMethodResultMessage->UCID));

         addToMsgStore(poMethodResultMessage);

         for(int i = 0;i<poMethodResultMessage->pMsg->listInputDev.strALSADev.size();++i)
         {
            ETG_TRACE_USR4(("stored listInputDev AlsaDev %s",poMethodResultMessage->pMsg->listInputDev.strALSADev[i].szValue));
         }

         for(int i = 0;i<poMethodResultMessage->pMsg->listOutputDev.strALSADev.size();++i)
         {
            ETG_TRACE_USR4(("stored listOutputDev AlsaDev %s",poMethodResultMessage->pMsg->listOutputDev.strALSADev[i].szValue));
         }
      }
      else
      {
         ETG_TRACE_ERR(("AllocateRoute failed with Error %d. MethodResult not stored. Immediate Error Message sent instead",ret));
         vSendErrorMsg(poMessage, MIDW_STREAMROUTERFI_C_U16_ERROR_E_ALLOCATE_FAILED);
      }

   }
   inmsg.vDestroy();
}
#else
tVoid fc_streamrouter_tclService_StreamRouter::vHandle_AllocateRoute_Start(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Received AllocateRoute from appid 0x%x, regid 0x%x, fid 0x%x...", poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));

  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_streamrouterfi_tclMsgAllocateRouteMethodStart inmsg;
  midw_streamrouterfi_tclMsgAllocateRouteMethodResult outmsg;

  if(oVisitorMsg.s32GetData(inmsg, FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    ETG_TRACE_USR4(("Incoming UCID is 0x%x.", inmsg.u16UCID));
    tS32 ret = pMainApp->AllocateRoute(poMessage->u16GetSourceAppID(), inmsg.u16UCID, inmsg.u16Sink, inmsg.s32STM_MsgBufID, &(outmsg));
    ETG_TRACE_USR4(("Allocate returned %d.", (int)ret));

    if((ret & STR_ERR__MASK) == 0)
    {
      outmsg.u16UCID = inmsg.u16UCID;
      fi_tclVisitorMessage oResultMsg(outmsg);
      vInitServiceData(oResultMsg,                          // ServiceDataMsg
                       poMessage->u16GetSourceAppID(),               // Target AppID
                       poMessage->u16GetRegisterID(),                // RegisterID
                       poMessage->u16GetCmdCounter(),                // CmdCounter,
                       poMessage->u16GetFunctionID(),                // Function ID
                       AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);     // Opcode

      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oResultMsg, TRUE);
      sendRoutingStateProperty();

      if(enResult != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_FATAL((">>> ! ERR: Answer not sent (%d) ! <<<", (int)enResult));
      }
      else
      {
        ETG_TRACE_USR4((">>> Answer sent successfully. <<<"));
      }
    }
    else if(ret & STR_ERR__MSCM_CHANNEL_ALLOC)
    {
      vSendErrorMsg(poMessage, MIDW_STREAMROUTERFI_C_U16_ERROR_E_MOST_FAILURE_REQUIRED_CONNECTIONLABEL_NOT_ALLOCATED);
    }
    else
    {
      vSendErrorMsg(poMessage, MIDW_STREAMROUTERFI_C_U16_ERROR_E_ALLOCATE_FAILED);
    }
  }
  else
  {
    ETG_TRACE_ERR((">>> oVisitorMsg.s32GetData ERROR <<<"));
  }
  inmsg.vDestroy();
}
#endif



tVoid fc_streamrouter_tclService_StreamRouter::vHandle_DeAllocateRoute_Start(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Received DeAllocateRoute from appid 0x%x, regid 0x%x, fid 0x%x...", poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));

  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart  inmsg;
  midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult outmsg;

  if(oVisitorMsg.s32GetData(inmsg, FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    ETG_TRACE_USR4(("Incoming UCID is 0x%x.", (int)inmsg.u16UCID));
    outmsg.u16UCID = inmsg.u16UCID;

    tS32 ret = pMainApp->DeAllocateRoute(poMessage->u16GetSourceAppID(), inmsg.u16UCID);
    ETG_TRACE_USR4(("DeAllocate returned %d.", (int)ret));

    if((ret & STR_ERR__MASK) == 0)
    {
      outmsg.u16UCID = inmsg.u16UCID;
      fi_tclVisitorMessage oResultMsg(outmsg);
      vInitServiceData(oResultMsg,                         // ServiceDataMsg
              poMessage->u16GetSourceAppID(),               // Target AppID
              poMessage->u16GetRegisterID(),                // RegisterID
              poMessage->u16GetCmdCounter(),                // CmdCounter,
              poMessage->u16GetFunctionID(),                // Function ID
              AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);      // Opcode

      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oResultMsg, TRUE);
      sendRoutingStateProperty();

      if(enResult != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_FATAL((">>> ! ERR: Answer not sent (%d) ! <<<", (int)enResult));
      }
      else
      {
        ETG_TRACE_USR4((">>> Answer sent successfully. <<<"));
      }
    }
    else
    {
      vSendErrorMsg(poMessage, MIDW_STREAMROUTERFI_C_U16_ERROR_E_DEALLOCATE_FAILED);
    }
  }
  inmsg.vDestroy();
  outmsg.vDestroy();
}

tVoid fc_streamrouter_tclService_StreamRouter::vHandle_SetPlay_Start(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Received SetPlay from appid 0x%x, regid 0x%x, fid 0x%x...", poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));

  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_streamrouterfi_tclMsgSetPlayMethodStart  inmsg;
  midw_streamrouterfi_tclMsgSetPlayMethodResult outmsg;

  if(oVisitorMsg.s32GetData(inmsg, FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    ETG_TRACE_USR4(("UCID is 0x%x.", (int)inmsg.u16UCID));
    tS32 ret = pMainApp->SetPlay(poMessage->u16GetSourceAppID(), inmsg.u16UCID, (tU8)(inmsg.eRampType.enType));
    ETG_TRACE_USR4(("SetPlay returned %d.", (int)ret));

    if((ret & STR_ERR__MASK) == 0)
    {
      outmsg.u16UCID = inmsg.u16UCID;
      fi_tclVisitorMessage oResultMsg(outmsg);
      vInitServiceData(oResultMsg,                      // ServiceDataMsg
                       poMessage->u16GetSourceAppID(),               // Target AppID
                       poMessage->u16GetRegisterID(),                // RegisterID
                       poMessage->u16GetCmdCounter(),                // CmdCounter,
                       poMessage->u16GetFunctionID(),                // Function ID
                       AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);     // Opcode

      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oResultMsg, TRUE);
      sendRoutingStateProperty();

      if(enResult != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_FATAL((">>> ! ERR: Answer not sent (%d) ! <<<", (int)enResult));
      }
      else
      {
        ETG_TRACE_USR4((">>> Answer sent successfully. <<<"));
      }
    }
    else
    {
      vSendErrorMsg(poMessage, MIDW_STREAMROUTERFI_C_U16_ERROR_E_PLAY_FAILED);
    }
  }
  inmsg.vDestroy();
  outmsg.vDestroy();
}

tVoid fc_streamrouter_tclService_StreamRouter::vHandle_SetStop_Start(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Received SetStop from appid 0x%x, regid 0x%x, fid 0x%x...", poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));

  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_streamrouterfi_tclMsgSetStopMethodStart  inmsg;
  midw_streamrouterfi_tclMsgSetStopMethodResult outmsg;

  if(oVisitorMsg.s32GetData(inmsg, FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    ETG_TRACE_USR4(("UCID is 0x%x.", (int)inmsg.u16UCID));
    tS32 ret = pMainApp->SetStop(poMessage->u16GetSourceAppID(), inmsg.u16UCID, (tU8)(inmsg.eRampType.enType));
    ETG_TRACE_USR4(("SetStop returned %d.", (int)ret));

    if((ret & STR_ERR__MASK) == 0)
    {
      outmsg.u16UCID = inmsg.u16UCID;
      fi_tclVisitorMessage oResultMsg(outmsg);
      vInitServiceData(oResultMsg,                        // ServiceDataMsg
                       poMessage->u16GetSourceAppID(),               // Target AppID
                       poMessage->u16GetRegisterID(),                // RegisterID
                       poMessage->u16GetCmdCounter(),                // CmdCounter,
                       poMessage->u16GetFunctionID(),                // Function ID
                       AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);     // Opcode

      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oResultMsg, TRUE);
      sendRoutingStateProperty();

      if(enResult != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_USR4((">>> ! ERR: Answer not sent (%d) ! <<<", (int)enResult));
      }
      else
      {
        ETG_TRACE_USR4((">>> Answer sent successfully. <<<"));
      }
    }
    else
    {
      vSendErrorMsg(poMessage, MIDW_STREAMROUTERFI_C_U16_ERROR_E_STOP_FAILED);
    }
  }
  inmsg.vDestroy();
  outmsg.vDestroy();
}

tVoid fc_streamrouter_tclService_StreamRouter::vSendErrorMsg(amt_tclServiceData* poMessage, tU16 errorcode)
{
  ETG_TRACE_USR4(("Sending Error %u...", errorcode));

  amt_tclServiceDataError oErrorMsg(*poMessage, errorcode);
  if(_poMainAppl->enPostMessage(&oErrorMsg, TRUE) != AIL_EN_N_NO_ERROR)
  {
    ETG_TRACE_USR4(("Sending Failed:vSendErrorMsg"));
    NORMAL_M_ASSERT_ALWAYS();
  }
}

/*virtual*/
tVoid fc_streamrouter_tclService_StreamRouter::vOnEvent(OSAL_tEventMask nEvent)
{
  if(nEvent & STR_EVENT_STM_LOADING)
  {
    ETG_TRACE_USR4(("STM Loading..."));
  }  // if (nEvent & STR_EVENT_STM_LOADING)

  if(nEvent & STR_EVENT_STM_LOAD_NOK)
  {
    ETG_TRACE_ERR(("STM Load error, Stream router service will not be available"));
  }  // if (nEvent & STR_EVENT_STM_LOAD_NOK)

  if(nEvent & STR_EVENT_STM_LOAD_OK)
  {
    // Set the Private Service availability allowed to True
    vSetPrivateServiceAvailableAllowed(TRUE);
    ETG_TRACE_USR4(("STM Loading is successful, Stream router service is made available."));
  }  // if (nEvent & STR_EVENT_STM_LOAD_OK)

}  // tVoid fc_streamrouter_tclService_StreamRouter::vOnEvent(OSAL_tEventMask nEvent)


/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclService_StreamRouter::vHandle_RoutingState_Get(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called if a component call the Routing State Get Property
*
*
* PARAMETER:
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_streamrouter_tclService_StreamRouter::vHandle_RoutingState_Get(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandle_RoutingState_Get: entered"));
  midw_streamrouterfi_tclMsgRoutingStateStatus oMsgRoutingState;

  fill_RoutingStateMsg(&oMsgRoutingState);

     //put the oMsgRoutingState into Status message
  // Create FI VisitorMessage. (The FI data object will be streamed (each
  // parameter is copied individually) to shared memory.)
  fi_tclVisitorMessage oMsg(oMsgRoutingState, FC_STREAMROUTER_SERVICE_STREAMROUTER_FI_MAJOR_VERSION);

  // Always destroy the FI data object before leaving its creation scope
  oMsgRoutingState.vDestroy();

  // Here the message related header information is added and by this the
  // creation of the message is completed.

  vInitServiceData( oMsg,                  // ServiceDataMsg
                poMessage->u16GetSourceAppID(),             // Target AppID
                poMessage->u16GetRegisterID(),              // RegisterID
                poMessage->u16GetCmdCounter(),              // CmdCounter,
        MIDW_STREAMROUTERFI_C_U16_ROUTINGSTATE,      // Function ID
          AMT_C_U8_CCAMSG_OPCODE_STATUS        // Opcode
  );

  // Post message
  ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg, TRUE);

  if (enResult != AIL_EN_N_NO_ERROR)
  {
    // Posting of message has failed.
    ETG_TRACE_ERR(( "vHandle_RoutingState_Get(): enPostMessage() failed for 'ROUTINGSTATE - STATUS'"));
  }
}


/*******************************************************************************
*
* FUNCTION: fill_RoutingStateMsg(midw_streamrouterfi_tclMsgRoutingStateStatus* oMsgRoutingState)
*
* DESCRIPTION: This function fiil the RoutingState Msg with all the Routeinfos from the Routingtable
*
*
* PARAMETER:
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_streamrouter_tclService_StreamRouter::fill_RoutingStateMsg(midw_streamrouterfi_tclMsgRoutingStateStatus* oMsgRoutingState)
{
  midw_fi_tcl_streamrouter_route_entry oRouteE;
  if (oMsgRoutingState != NULL)
  {
    int ucid = pMainApp->rtable->get_next_ucid(0);
    while (ucid > 0)
    {
      tBool play, kill;

      oRouteE.u32UCID = (tU32)ucid;
      oRouteE.u16MLBChannelAddress = 0;
      oRouteE.u8BlkWidth = 0;
      pMainApp->rtable->get_ucid_mostcfg(ucid, &oRouteE.u16MLBChannelAddress, NULL, &oRouteE.u8BlkWidth);

      oRouteE.u16AppID = 0;
      play = 0;
      kill = 0;
      pMainApp->rtable->get_ucid_routecfg(ucid, NULL, &oRouteE.u16AppID, &play, &kill);

      if(kill == true)
      {
        oRouteE.e8Routestate.enType = midw_fi_tcl_e8_streamrouter_routestate::FI_EN_KILL;
      }
      else
      {
        if(play == true)
        {
          oRouteE.e8Routestate.enType = midw_fi_tcl_e8_streamrouter_routestate::FI_EN_PLAY;
        }
        else
        {
          oRouteE.e8Routestate.enType = midw_fi_tcl_e8_streamrouter_routestate::FI_EN_STOP;
        }
      }
      oMsgRoutingState->routing_list.sREntry.push_back(oRouteE);
      ETG_TRACE_USR4(("Routes state: UCID=0x%x, AppId=0x%x, ChannelAdr=0x%x, BlkWith=%d, Routestate=%d",
                      oRouteE.u32UCID, oRouteE.u16AppID, oRouteE.u16MLBChannelAddress, oRouteE.u8BlkWidth, oRouteE.e8Routestate.enType));

      ucid = pMainApp->rtable->get_next_ucid(ucid);
    }
  }
  else
  {
    ETG_TRACE_USR4(("fill_RoutingStateMsg()-> ERROR: oMsgRoutingState pointer is NULL"));
  }
}

tS32 fc_streamrouter_tclService_StreamRouter::TTFis_LoopbackCommand(tS32 appid, tS32 ucid, tU16 cmd)
{
  (void)appid;
  if(_poMainAppl == NULL)
  {
    NORMAL_M_ASSERT_ALWAYS();
    return 0;
  }
  gm_tclU32Message oServiceReadyMsg(_poMainAppl->u16GetAppId(),  // Source AppID
                                    _poMainAppl->u16GetAppId(),  // Target AppID
                                    0,                           // RegisterID
                                    0,                           // CmdCounter
                                    _u16ServiceID,               // ServiceID
                                    cmd,  // Function ID
                                    AMT_C_U8_CCAMSG_OPCODE_STATUS  // Opcode
                                   );

  oServiceReadyMsg.vSetDWord(ucid);

  if(oServiceReadyMsg.bIsValid())
  {
      if(_poMainAppl->enPostMessage(&oServiceReadyMsg, TRUE) != AIL_EN_N_NO_ERROR)
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
  }
  else
  {
    NORMAL_M_ASSERT_ALWAYS();
  }
  return 0;
}

void fc_streamrouter_tclService_StreamRouter::sendRoutingStateProperty(void)
{
  if(eUpdateClients(MIDW_STREAMROUTERFI_C_U16_ROUTINGSTATE) != AIL_EN_N_NO_ERROR){
    ETG_TRACE_ERR(("ERROR: eUpdateClients():-> Updating the clients for AllocateRoute failed"));
  }
  else{
    ETG_TRACE_USR4(("eUpdateClients():-> Updating the clients for AllocateRoute OK"));
  }
}

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
void fc_streamrouter_tclService_StreamRouter::addToMsgStore(tMethodResultMessage* pMsg)
{
  msgStore.push_back(pMsg);
  ETG_TRACE_USR4(("addToMsgStore we have now %d elements",msgStore.size()));
  return;
}

tMethodResultMessage* fc_streamrouter_tclService_StreamRouter::removeFromMsgStore(midw_streamrouterfi_tclMsgAllocateRouteMethodResult* pMsg)
{
  //serach if msg is present
  int i;
  tMethodResultMessage* pResultMsg = NULL;
  for(i=0;i<msgStore.size();i++)
  {
    //used has handle
    if(msgStore[i]->pMsg == pMsg)
    {
      //found
      ETG_TRACE_USR4(("removeFromMsgStore, found msgStore[%d] = %p",i,msgStore[i]));
      pResultMsg = msgStore[i];
      msgStore.erase(msgStore.begin()+i);
    }
  }
  ETG_TRACE_USR4(("removeFromMsgStore size now %d",msgStore.size()));
  return pResultMsg;
}
midw_streamrouterfi_tclMsgAllocateRouteMethodResult* fc_streamrouter_tclService_StreamRouter::getLastResult(tU32 u32Handle)
{
  ETG_TRACE_USR4(("fc_streamrouter_tclService_StreamRouter::getLastResult entered"));
  for(int i=0;i<msgStore.size();i++)
  {
    if(msgStore[i]->handle == u32Handle)
    {
    return msgStore[i]->pMsg;
    }
  }
  return NULL;
}
//Increment the handle value by one
tU32 fc_streamrouter_tclService_StreamRouter::u32SetHandle()
{
  ETG_TRACE_USR4(("fc_streamrouter_tclService_StreamRouter::u32SetHandle entered"));
  m_u32Handle = m_u32Handle + 1;

  if(m_u32Handle == STR_INVALID_HANDLE)
  {
    m_u32Handle = m_u32Handle + 1;
  }
  ETG_TRACE_USR4(("fc_streamrouter_tclService_StreamRouter::u32SetHandle Handle=%d",m_u32Handle));
  return m_u32Handle;
}
//Increment the handle value by one for every message
tU32 fc_streamrouter_tclService_StreamRouter::u32GetHandle()
{
  ETG_TRACE_USR4(("fc_streamrouter_tclService_StreamRouter::u32GetHandle Handle=%d",m_u32Handle));
  return m_u32Handle;
}
#endif
