

/*******************************************************************************
*
* FILE:          FC_StreamRouter_main.h
*
* SW-COMPONENT:  FC_StreamRouter application
*
* PROJECT:
*
* DESCRIPTION:   CCA Application.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_STREAMROUTER_MAIN_H_
#define _FC_STREAMROUTER_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#if 0
#define IHL_S_IMPORT_INTERFACE_TASK
#include <ihl_if.h>
using namespace ihl::task;
#endif

#define STREAMROUTER_TRACE_IN

#define STREAMROUTER_VERSION 10
#define STR_MAX_STATE_RETRIES 2
#define STREAMROUTER_TRACE_IN

#define STR_MOSTMIC_TIMEOUT 10000

/* ERROR CODES */
#define STR_ERR__OK                   0x000
#define STR_ERR__STM_ROUTE_REQ        0x001
#define STR_ERR__STM_ROUTE_FREE       0x002
#define STR_ERR__STM_SET_MLB          0x004
#define STR_ERR__STM_PLAY             0x008
#define STR_ERR__STM_STOP             0x010
#define STR_ERR__MSCM_CHANNEL_ALLOC   0x020
#define STR_ERR__MSCM_CHANNEL_DEALLOC 0x040
#define STR_ERR__INTERNAL             0x080
#define STR_ERR__RESOURCE_TABLE       0x100
#define STR_ERR__MOST_MIC_ALLOC       0x200
#define STR_ERR__MOST_MIC_DEALLOC     0x400
#define STR_ERR__RESOURCE_TABLE_DELAY 0x800

#define STR_WRN__STM_FLUSH            0x10000
#define STR_WRN__STM_STOP             0x20000
#define STR_WRN__ROUTE_STATE          0x40000

#define STR_ERR__MASK                 0xffff

#define STR_PATH_ERRH_DISABLE_MOST    "/dev/ffs2/str_no_mt_errh"
#define STR_PATH_ERRH_DISABLE_FG      "/dev/ffs2/str_no_fg_errh"
#define STR_PATH_ERRH_ENABLE_REC      "/dev/ffs2/str_en_rc_errh"

#define STR_EV_NETOFF         1
#define STR_EV_CRITICALUNLOCK 2
#define STR_EV_INICPROTECTED  4

#define ACTION_ALLOCTAE 1
#define ACTION_DEALLOCTAE 2

class FwdTable;
class routingtable;
class ahl_tclBaseOneThreadApp;
class fc_streamrouter_tclService_StreamRouter;
class fc_streamrouter_tclConfigMic;

class fc_streamrouter_mostwrp;
class fc_streamrouter_most_fastev;


#ifndef VARIANT_S_FTR_ENABLE_GM_STR
  class fc_streamrouter_tclClientHandler_audiomgmt;
#endif

#ifndef NO_DIAGNOSIS
  class fc_streamrouter_tclDiagnosis;
#endif

struct ROUTINGENTRY;

class fc_streamrouter_tclApp : public ahl_tclBaseOneThreadApp
{
  static fc_streamrouter_tclApp* m_poMainAppInstance;
#ifdef STREAMROUTER_TRACE_IN
  static void vTraceInput_CB(const tUChar* puchData);
#endif

  public:

    fc_streamrouter_tclApp(tVoid);
    virtual ~fc_streamrouter_tclApp(tVoid);

    static fc_streamrouter_tclApp* theServer();

    fc_streamrouter_tclService_StreamRouter* getStreamrouterService();

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_streamrouter_tclApp' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_streamrouter_tclApp& operator= (const fc_streamrouter_tclApp &oFC_StreamRouter);

    /**************************************************************************
    * Copy Constructor, will not be implemented.
    * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
    * 'fc_streamrouter_tclApp' which has no copy constructor.
    * NOTE: This is a technique to disable the copy constructor for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_streamrouter_tclApp(const fc_streamrouter_tclApp &oFC_StreamRouter);

    /**************************************************************************
    * Overriding ahl_tclBaseOneThreadApp methods.
    **************************************************************************/
    virtual tBool bOnInit();

    virtual tVoid vOnApplicationClose();

    virtual tVoid vOnTimer(tU16 nTimerId);

    virtual tVoid vOnLoadSettings();

    virtual tVoid vOnSaveSettings();

    using ahl_tclBaseOneThreadApp::vOnLoopback;

    virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

    virtual tVoid vOnEvent(OSAL_tEventMask nEvent);

  /****************************************************************************
    *             Specific Functions of this class
  ****************************************************************************/

    int AllocateRoute(tU16 appid, tU16 ucid, tS32 stm_msgbuf_id, void* ccainfo);
    int AllocateRoute(tU16 appid, tU16 ucid, tU16 sink, tS32 stm_msgbuf_id, void* ccainfo);

    int AddRoute(ROUTINGENTRY *rentry);

    int DeAllocateRoute(tU16 appid, tU16 ucid);

    int RemoveRoutesPerUCID(int ucid);

    int RemoveRoute(ROUTINGENTRY *rentry);

    int Play(ROUTINGENTRY* rentry);

    int SetPlay(tU16 appid, tU16 ucid, tU8 ramptype);

    int SetPlayPerUCID(tU16 ucid, tU8 ramptype);

    int Stop(ROUTINGENTRY* rentry);

    int SetStop(tU16 appid, tU16 ucid, tU8 ramptype);

    int SetStopPerUCID(tU16 ucid, tU8 ramptype);

    int fill_cca_info(int ucid, void* ccainfo);

    int GetStreamProp(tU16 appid, tU16 ucid);

    int PrintSubroutes(int ucid);

    FwdTable* pFwdTable;
    routingtable* rtable;

    fc_streamrouter_mostwrp *m_mostwrp;
    fc_streamrouter_most_fastev *m_most_fastev;

#ifdef VARIANT_S_FTR_ENABLE_GM_STR
    fc_streamrouter_tclConfigMic*  m_poConfigMic;
#endif

    tVoid mask_start_gstreamer(tS32 t32Variant);
    static tVoid vStartGstreamer(void* arg);
    tVoid mask_stop_gstreamer();

  private:
    tBool AllocateMostMic(void);
    tBool DeallocateMostMic(void);
    tBool GetMostMicParams(tU8 src_num, tU16* blk_width, tU16 *con_label, tU8 u8Instance = 1);

    tU16 getSTRID(int ucid);
    tCString getErrorString(int error_code) const;
    void remove_kill_marked_routes(void);
    void handle_error(void);

    fc_streamrouter_tclService_StreamRouter* m_poStreamRouter;

#ifndef VARIANT_S_FTR_ENABLE_GM_STR
    fc_streamrouter_tclClientHandler_audiomgmt* m_poClientHandlerAudioMgmt;
#endif

#ifndef NO_DIAGNOSIS
    fc_streamrouter_tclDiagnosis* m_poDiagnosis;
#endif

    int mask_btclk_init(void);
    int mask_btclk_deinit(void);
    void *sndcard_handle;
};

#endif //_FC_STREAMROUTER_MAIN_H_

