
#ifndef FWDTABLE_HEADER_INCLUDE
#define FWDTABLE_HEADER_INCLUDE

#define STRID_MAXCFG 8

typedef struct
{
  int ucid;
  int strid;
}FWDENTRY;

typedef struct{
  bool active;
  const char* adrsrc;
  int adrsrcnr;
  const char* adrstream;
  int adrstreamnr;
  const char* audprocAdev;
}ADRCFG;

typedef struct
{
  int strid;
  const char* name;
  ADRCFG adr;
  int configid[STRID_MAXCFG];
}STRIDENTRY;

typedef struct{
  bool active;
  int bwidth;
  int direction;
  int mcfgid; // defined by cetitec
}MOSTCFG;

typedef struct
{
  int configid;
  const char* name;
  MOSTCFG most;
  bool direction;
  const char* alsadev;
  unsigned int mask;
}CONFIGENTRY;


class FwdTable
{
public:
  FwdTable();
  ~FwdTable();

   int get_strid(int ucid);
  STRIDENTRY* get_strid_entry(int strid);
  int get_configid(int strid, int idx);
  CONFIGENTRY* get_cfg_entry(int cfgid);


private:
  static FWDENTRY fwdtable[];
  static STRIDENTRY stridtable[];
  static CONFIGENTRY configtable[];
};

#endif

