
#include "FC_StreamRouter_fwdtable.h"

#define STR_STR_STR
#include "FC_StreamRouter_ucid_defs.h"
#include "FC_StreamRouter_ucidsub_defs.h"

#include "FC_StreamRouter_route_config.h"

#include "FC_StreamRouter_trace_def.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_APPLICATION
#include "trcGenProj/Header/FC_StreamRouter_fwdtable.cpp.trc.h"
#endif

#if 0
FWDENTRY FwdTable::fwdtable[] =
{
  {UCID_CUESTOMOST,                 STRID_CUESTOMOST},
  {UCID_CUESTOMOSTMONO,             STRID_INVALID},
  {UCID_CUESAUDIBLEFEEDBACK,        STRID_CUESAUDIBLEFEEDBACK},
  {UCID_CUESBEEPALERT,              STRID_CUESAUDIBLEFEEDBACK},
  {UCID_CUESJINGLETOINTAMP,         STRID_INVALID},
  {UCID_CUESJINGLEMONOTOINTAMP,     STRID_INVALID},
  {UCID_CUESFEEDBACKTOINTAMP,       STRID_INVALID},
  {UCID_CUESJINGLETOINTAMP,         STRID_INVALID},
  {UCID_CUESBEEPALERTTOINTAMP,      STRID_INVALID},

  {UCID_MP1TOMOST,                  STRID_MP1TOINT},
  {UCID_MP2TOMOST,                  STRID_MP1TOINT},
  {UCID_MPTESTTOMOST,               STRID_INVALID},
  {UCID_MP1AUDIOWITHVIDEO,          STRID_MP1TOINT},
  {UCID_MP1VIDEOONLY,               STRID_INVALID},
  {UCID_MP1TOAMP,                   STRID_INVALID},
  {UCID_CDDADRIVETOAMP,             STRID_INVALID},

  {UCID_INTBRTOMOST,                STRID_MP1TOINT},
  {UCID_INTBRAUDIOWITHVIDEO,        STRID_MP1TOINT},
  {UCID_INTBRVIDEOONLY,             STRID_GENERICUSB},
  {UCID_INTAPPMIXEDMSG,             STRID_INTAPPMIXEDMSG},
  {UCID_INTAPPTOAMP,                STRID_INVALID},
  {UCID_INTAPPMIXEDMSGTOAMP,        STRID_INVALID},

  {UCID_INTRADTOMOST,               STRID_INTRADTOMOST},
  {UCID_XMRADTOAMP,                 STRID_INVALID},
  {UCID_AMFMRADTOAMP,               STRID_INVALID},
  {UCID_DABRADTOAMP,                STRID_INVALID},
  {UCID_DCMRADTOAMP,                STRID_INVALID},
  {UCID_HDRADTOAMP,                 STRID_INVALID},

  {UCID_SDSTOMOST,                  STRID_SPEECHMONO},
  {UCID_SDSTOAMP,                   STRID_INVALID},

  {UCID_RECMSGTOMOST,               STRID_INVALID},
  {UCID_INMSGALERTTONETOMOST,       STRID_INMSGALERTTONETOMOST},
  {UCID_BEEPRECMSGTOMOST,           STRID_INVALID},
  {UCID_MICTOMSGREC,                STRID_INVALID},
  {UCID_ATTACHAUDIOFILETOMOST,      STRID_INVALID},
  {UCID_MEMORYFULLALERTTOMOST,      STRID_MEMORYFULLALERTTOMOST},

  {UCID_MICTOVOICEREC,              STRID_MICTOVOICEREC},
  {UCID_MICTOVOICERECWITHECNR,      STRID_INVALID},

  {UCID_BTPHONE,                    STRID_BTPHONE1},
  {UCID_TESTMICINTOMOST,            STRID_TESTMICINTOMOST},
  {UCID_CALLONHOLDALERTTONETOMOST,  STRID_CALLONHOLDALERTTONETOMOST},
  {UCID_BOTHAMICROONONESTREAM,      STRID_BOTHAMICROONONESTREAM},
  {UCID_DEVTESTBTAUDIOTX,           STRID_DEVTESTBTAUDIOTX},
  {UCID_DEVTESTBTAUDIORX,           STRID_DEVTESTBTAUDIORX},
  {UCID_DEVTESTUSB2OUT,             STRID_DEVTESTUSB2OUT},
  {UCID_DTMFTONETOMOST,             STRID_INVALID},
  {UCID_DEVTESTUSBONLY,             STRID_INVALID},
  {UCID_VRFROMBTPHONE,              STRID_BTPHONE1},
  {UCID_VADPHONEFROMAUXMONO,        STRID_INVALID},
  {UCID_ECALLPHONEFROMAUXMONO,      STRID_INVALID},
  {UCID_BTPHONEMIC12REF,            STRID_INVALID},
  {UCID_BTPHONEMIC12,               STRID_INVALID},
  {UCID_BTPHONEMIC1REF,             STRID_INVALID},
  {UCID_BTPHONEMIC1,                STRID_INVALID},

  {UCID_RINGTONETOMOST,             STRID_RINGTONETOMOST},
  {UCID_BTAUDTOMOST,                STRID_MP1TOINT},
  {UCID_STEREORINGTONETOMOST,       STRID_INVALID},
  {UCID_BTAUDIOTOAMP,               STRID_INVALID},
  {UCID_BTAUDIOSTANDALONETOAMP,     STRID_INVALID},

  {UCID_TTSTOMOST,                  STRID_SPEECHMONO},
  {UCID_READMSGTOMOST,              STRID_SPEECHMONO},
  {UCID_TTSNAVTOAMP,                STRID_INVALID},
  {UCID_READMSGTOAMP,               STRID_INVALID},

  {UCID_VIDEOANIMATION,             STRID_GENERICUSB},

  {UCID_AUX1TOAMP,                  STRID_INVALID},
  {UCID_AUX2TOAMP,                  STRID_INVALID},

  {UCID_INVALID,                    STRID_INVALID}
};

STRIDENTRY FwdTable::stridtable[] =
{
  // STR-ID,                    Name,               active    ADRSrc,     ADRSrcNr, ADRStream,  ADRStreamNr,    Configurations
  {STRID_GENERICUSB,            "USBOUT",           {false,   "Media",    4,        "Main",     0x01},          {STRCFG_01, STRCFG_INVALID}},
  {STRID_MP1TOINT,              "MP1TOMOST",        {false,   "",         0,        "",         0x00},          {STRCFG_02, STRCFG_INVALID}},
  {STRID_SPEECHMONO,            "SPEECHMONO",       {false,   "",         0,        "",         0x00},          {STRCFG_05, STRCFG_INVALID}},
  {STRID_RINGTONETOMOST,        "RINGMONO",         {false,   "",         0,        "",         0x00},          {STRCFG_03, STRCFG_INVALID}},
  {STRID_MICTOVOICEREC,         "VOICEREC",         {false,   "",         0,        "",         0x00},          {STRCFG_06, STRCFG_INVALID}},
  {STRID_BTPHONE1,              "PHONE1",           {false,   "",         0,        "",         0x00},          {STRCFG_07, STRCFG_08, STRCFG_09, STRCFG_10, STRCFG_INVALID}},
  {STRID_BOTHAMICROONONESTREAM, "AMICTOSTREAM",     {false,   "",         0,        "",         0x00},          {STRCFG_11, STRCFG_01, STRCFG_INVALID}},
  {STRID_TESTMICINTOMOST,       "TESTMIC2MOST",     {false,   "",         0,        "",         0x00},          {STRCFG_11, STRCFG_12, STRCFG_INVALID}},
  {STRID_DEVTESTBTAUDIOTX,      "DEVTESTBTTX",      {false,   "",         0,        "",         0x00},          {STRCFG_10, STRCFG_INVALID}},
  {STRID_DEVTESTBTAUDIORX,      "DEVTESTBTRX",      {false,   "",         0,        "",         0x00},          {STRCFG_09, STRCFG_INVALID}},
  {STRID_DEVTESTUSB2OUT,        "DEVTESTUSB2OUT",   {false,   "",         0,        "",         0x00},          {STRCFG_13, STRCFG_INVALID}},
  {STRID_CUESTOMOST,            "CUESTOMOST",       {false,   "",         0,        "",         0x00},          {STRCFG_14, STRCFG_INVALID}},
  {STRID_CUESAUDIBLEFEEDBACK,   "CUESFEEDBACK",     {false,   "",         0,        "",         0x00},          {STRCFG_15, STRCFG_INVALID}},
  {STRID_CALLONHOLDALERTTONETOMOST,   "CALLONHOLDALERT",     {false,   "",         0,        "",         0x00},          {STRCFG_15, STRCFG_INVALID}},
  {STRID_INMSGALERTTONETOMOST,  "MSGALERT",         {false,   "",         0,        "",         0x00},          {STRCFG_15, STRCFG_INVALID}},
  {STRID_INTRADTOMOST,          "INTRAD",           {false,   "",         0,        "",         0x00},          {STRCFG_02, STRCFG_INVALID}},
  {STRID_MEMORYFULLALERTTOMOST, "MEMFULL",          {false,   "",         0,        "",         0x00},          {STRCFG_15, STRCFG_INVALID}},

  {STRID_INTAPPMIXEDMSG,        "INTAPPMIX",        {false,   "",         0,        "",         0x00},          {STRCFG_16, STRCFG_INVALID}},

  {STRID_INVALID,               "INVALID",          {false,   "",         0,        "",         0x00},          {STRCFG_INVALID}}
};

CONFIGENTRY FwdTable::configtable[] =
{
  // CFG-ID,        Name,         active  MOST-blockwidth,  I/O-direction,  MOST cfgid, I/O-direction,  ALSA-Dev-Out,             Bitmask
  //                                                        (0=out, 1=in)               (0=out)                                   (1=do flush)
  {STRCFG_01,       "USB",        {false, 4,                0,              5},         0,              "AdevUSB1Out",            0},
  {STRCFG_02,       "STMOST",     {true,  4,                0,              0},         0,              "AdevEnt1Out",            0},
  {STRCFG_03,       "MOMOST1",    {true,  2,                0,              1},         0,              "AdevAudioSampler1Out",   0},
  {STRCFG_04,       "MOMOST2",    {false, 2,                0,              2},         0,              "invalid",                0},
  {STRCFG_05,       "MOMOST3",    {true,  2,                0,              3},         0,              "AdevAcousticoutSpeech",  0},
  {STRCFG_06,       "AMIC1IN",    {false, 4,                0,              4},         1,              "AdevAcousticinSpeech",   0},
  {STRCFG_07,       "VOICEOUT",   {true,  2,                0,              1},         0,              "AdevVoiceOut",           0},
  {STRCFG_08,       "PHONEAMICIN",{false, 2,                0,              1},         1,              "AdevMicro1In",           0},
  {STRCFG_09,       "BTPHONERX",  {false, 2,                0,              1},         1,              "AdevBTPhoneRxIn",        0},
  {STRCFG_10,       "BTPHONETX",  {false, 2,                0,              1},         0,              "AdevBTPhoneTxOut",       0},
  {STRCFG_11,       "MICINSTEREO",{false, 2,                0,              1},         1,              "AdevMicroInStereo",      0},
  {STRCFG_12,       "MICOUTSTER", {true,  4,                0,              0},         0,              "AdevMicroOutStereo",     4},
  {STRCFG_13,       "ADEVUSB2OUT",{false, 4,                0,              0},         0,              "AdevUSB2Out",            0},
  {STRCFG_14,       "CUESOUTST",  {true,  4,                0,              0},         0,              "AdevAudioCuesOut",       0},
  {STRCFG_15,       "CUESOUTFBK", {true,  2,                0,              2},         0,              "AdevAudioSampler2Out",   0},
  {STRCFG_16,       "CUESOUTFBK", {true,  2,                0,              4},         0,              "AdevAudioSampler3Out",   0},
  {STRCFG_INVALID,  "INVALID",    {false, 0,                0,              0},         0,              "invalid",                0}
};
#endif

FwdTable::FwdTable()
{
}

FwdTable::~FwdTable()
{
}

int FwdTable::get_strid(int ucid)
{
  for(int i = 0; fwdtable[i].ucid != UCID_INVALID; ++i)
  {
    if(fwdtable[i].ucid == ucid)
    {
      return fwdtable[i].strid;
    }
  }

  return STRID_INVALID;
}

STRIDENTRY* FwdTable::get_strid_entry(int strid)
{
  if(strid != STRID_INVALID)
  {
    for(int i = 0; stridtable[i].strid != STRID_INVALID; ++i)
    {
      if(stridtable[i].strid == strid)
      {
        return &(stridtable[i]);
      }
    }
  }
  return NULL;
}

CONFIGENTRY* FwdTable::get_cfg_entry(int cfgid)
{
  if(cfgid != STRCFG_INVALID)
  {
    for(int i = 0; configtable[i].configid != STRCFG_INVALID; ++i)
    {
      if(configtable[i].configid == cfgid)
      {
        return &(configtable[i]);
      }
    }
  }
  return NULL;
}

int FwdTable::get_configid(int strid, int idx)
{
  if(strid != STRID_INVALID)
  {
    for(int i = 0; stridtable[i].strid != STRID_INVALID; ++i)
    {
      if(stridtable[i].strid == strid)
      {
        int n = 0;
        while(stridtable[i].configid[n] != STRCFG_INVALID)
        {
          if(n == idx)
          {
            return stridtable[i].configid[n];
          }
          ++n;
        }
      }
    }
  }
  return STRCFG_INVALID;
}

