
#ifndef VARIANT_S_FTR_ENABLE_GM_STR
/*******************************************************************************
*
* FILE:          FC_StreamRouter_clienthandler_AudioMgmt.cpp
*
* SW-COMPONENT:  FC_StreamRouter application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service AudioMgmt.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "FC_StreamRouter_main.h"
#include "FC_StreamRouter_clienthandler_AudioMgmt.h"
#include "FC_StreamRouter_service_StreamRouter.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_DBGVISITORS

#include "midw_fi_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "FC_StreamRouter_trace_def.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_CLIENTHANDLER_AUDIOMGMT
#include "trcGenProj/Header/FC_StreamRouter_clienthandler_AudioMgmt.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// Version defines for used service
#define STREAMROUTER_AUDIOMGMT_FI_MAJOR_VERSION  1
#define STREAMROUTER_AUDIOMGMT_FI_MINOR_VERSION  0

const tU16 fc_streamrouter_tclClientHandler_audiomgmt::_au16FIDs[] =
{
   MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE
   //MIDW_MASCFFI_C_U16_MUTE_STATUS
};
/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_streamrouter_tclClientHandler_audiomgmt, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.
  ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleAmpDevAudioRoute_MethodResult)

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_streamrouter_tclClientHandler_audiomgmt::
*             fc_streamrouter_tclClientHandler_audiomgmt(fc_streamrouter_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_streamrouter_tclClientHandler_audiomgmt::
  fc_streamrouter_tclClientHandler_audiomgmt(fc_streamrouter_tclApp* poMainAppl)
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_AUDIOFUNC,
      /* MajorVersion of used Service */ STREAMROUTER_AUDIOMGMT_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ STREAMROUTER_AUDIOMGMT_FI_MINOR_VERSION )
{
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_audiomgmt() entered."));
  m_poMainAppl = poMainAppl;
}

/*******************************************************************************
*
* FUNCTION: fc_streamrouter_tclClientHandler_audiomgmt::
*             ~fc_streamrouter_tclClientHandler_audiomgmt(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_streamrouter_tclClientHandler_audiomgmt::
  ~fc_streamrouter_tclClientHandler_audiomgmt(tVoid)
{
  ETG_TRACE_USR4(("~fc_streamrouter_tclClientHandler_audiomgmt() entered."));
  m_poMainAppl=NULL;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclClientHandler_audiomgmt::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_streamrouter_tclClientHandler_audiomgmt::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",
                  u16GetServerAppID()));

  this->vRegisterForAllFIDs();
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclClientHandler_audiomgmt::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_streamrouter_tclClientHandler_audiomgmt::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
                  u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_streamrouter_tclClientHandler_audiomgmt::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_streamrouter_tclClientHandler_audiomgmt::vProcessTimer(tU16 u16TimerId) const
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

  if(TRUE == bIfServiceAvailable())
  {
    // Create message for used service.
  }
}

#if 0 //not defined here
tVoid fc_streamrouter_tclClientHandler_audiomgmt::vTraceRx(tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("vTraceRx() entered."));

   if(pcu8Data==0) return;
   // pu8Data[0] == length of bytes following
   // pu8Data[1] == my file number
   // pu8Data[2] == the command
   // pu8Data[3] == the 1. parameter
   // rest is defined here
   ETG_TRACE_USR4(("vTraceRx() pcu8Data[0]=%u",(tU16)pcu8Data[0]));
   if (pcu8Data[0] > 1)
   {
    ETG_TRACE_USR4(("vTraceRx() pcu8Data[1] [2] =%u %u",(tU16)pcu8Data[1],(tU16)pcu8Data[2]));
      switch ( pcu8Data[2] )
      {
      case 1:
         ETG_TRACE_USR4(("Received 1"));
         break;

      default:
        ETG_TRACE_USR4(("default"));
         break;
      }
   }
}
#endif


// This need to be changed to send a ADR3 source switch command. Currently not available in midwfi. This is just a skeleton to check general functionality.
tBool fc_streamrouter_tclClientHandler_audiomgmt::bSendAmpDevAudioRoute(tU8 u8SrcNr, tU32 adrStreamNr, const char* audProcAdev, void* ccainfo, tU8 action)
{
  ETG_TRACE_USR4(("AmpDevAudioRoute(SrcNr=%d, adrStreamNr=%d, audProcAdev=%s) enter ",u8SrcNr, adrStreamNr, audProcAdev));
   ETG_TRACE_USR4(("Called without Sink, sill use default Sink 1"));
   return bSendAmpDevAudioRoute(u8SrcNr, (tU16)1, adrStreamNr, audProcAdev, ccainfo, action);
}


tBool fc_streamrouter_tclClientHandler_audiomgmt::bSendAmpDevAudioRoute(tU8 u8SrcNr, tU16 u16Sink, tU32 adrStreamNr, const char* audProcAdev, void* ccainfo, tU8 action)
{
  ETG_TRACE_USR4(("AmpDevAudioRoute(SrcNr=%d, Sink %d, adrStreamNr=%d, audProcAdev=%s) enter ",u8SrcNr, u16Sink, adrStreamNr, audProcAdev));

  (tVoid)ccainfo;
  tU16 u16ErrCode = AIL_EN_N_NO_ERROR;
  midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart oAmpDevAudioRoute;

  //oAmpDevAudioRoute.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
  oAmpDevAudioRoute.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)u16Sink;
  oAmpDevAudioRoute.Source.enType   = (midw_fi_tcl_e8_RouteNo::tenType)u8SrcNr;
  oAmpDevAudioRoute.Channel.enType  = (midw_fi_tcl_e8_AudioChannel::tenType)adrStreamNr;
  oAmpDevAudioRoute.Action.enType = (midw_fi_tcl_e8_OnGoingAction::tenType)action;
  //New
  oAmpDevAudioRoute.AudProcAdev = (midw_fi_tclString(audProcAdev));

  // ToDo: What about INF4CV? Needs to be checked, if same as AIVI
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  oAmpDevAudioRoute.MsgHandle = m_poMainAppl->getStreamrouterService()->u32GetHandle();
  #else
  oAmpDevAudioRoute.MsgHandle = 0;
  #endif

  fi_tclVisitorMessage oCCaMsg(oAmpDevAudioRoute);
  oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),  // Source AppID
                           CCA_C_U16_APP_AUDIO,       // Target AppID
                           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                           0,
                           u16GetRegID(),
                           0,
                           CCA_C_U16_SRV_AUDIOFUNC,
                           MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE,
                           AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                          );
  ETG_TRACE_USR4(("Sending  AmpDevAudioRoute to CCA_C_U16_APP_AUDIO(%x)", CCA_C_U16_APP_AUDIO))
  u16ErrCode = _poMainAppl->enPostMessage(&oCCaMsg);

  if(u16ErrCode == AIL_EN_N_NO_ERROR)
  {
    ETG_TRACE_USR4(("Sending Successfull"));
    return TRUE;
  }
  else
  {
    ETG_TRACE_USR4(("Sending ERROR !!!!"));
    return FALSE;
  }
}


tVoid fc_streamrouter_tclClientHandler_audiomgmt::vRegisterForAllFIDs(tVoid)
{
   ETG_TRACE_USR4(("vRegisterForAllFIDs() entered."));

   // auto-register for notification of any change for all properties
   for(tU32 i=0; i<ARRAY_COUNT(_au16FIDs); ++i)
   {
      #if 0
      if(TRUE == _abUpRegDone[i])
      {
         ETG_TRACE_USR4(("Already registered for FID %d", _au16FIDs[i]));
         //skip this FID, it is already registered
         continue;
      }
    #endif

      vAddAutoRegisterForProperty(_au16FIDs[i]);
      vAddAutoRegisterForProperty(_au16FIDs[i]);
   }
}
tVoid fc_streamrouter_tclClientHandler_audiomgmt::vHandleAmpDevAudioRoute_MethodResult(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR4(("vHandleAmpDevAudioRoute_MethodResult() entered."));
   (void)poMessage;  //LINT

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   fi_tclVisitorMessage oVisitorMsg(poMessage);
   //midw_mascffi_tclMsgMuteMethodResult  oMethodResult;
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult oMethodResult;

   if (oVisitorMsg.s32GetData(oMethodResult, STREAMROUTER_AUDIOMGMT_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
    //ETG_TRACE_USR4(("received oMethodResult.State.enType = %x",oMethodResult.State.enType));
      ETG_TRACE_USR4(("received oMethodResult.ServiceStatus.enType = 0x%x", oMethodResult.ServiceStatus.enType));
      ETG_TRACE_USR4(("received oMethodResult.MsgHandle = %d",oMethodResult.MsgHandle));

   }
   // here we need the Method Result towards ARM or ARL for the AllocateRoute
   // fetch info from main app
   if((_poMainAppl != NULL) && (m_poMainAppl != NULL))
   {
     // FC_AudioManager became available
     m_poMainAppl->getStreamrouterService()->SendLastResult(oMethodResult.MsgHandle);
   }
#endif
}
#endif


