

#ifdef VARIANT_S_FTR_ENABLE_GM_STR
/*******************************************************************************
* FILE:          FC_StreamRouter_clienthandler_DiaglogMic.cpp
* PROJECT:
* SW-COMPONENT:  FC_StreamRouter application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   ClientHandler for the service of the Diagnosic (Diaglog)
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 22.03.11  | TMS Gaidatzi-Lken      | Inital version
*******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/
/* Include message framework (AMT, msgfw) */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#include "../FC_StreamRouter_main.h"

#include "../FC_StreamRouter_configMic.h"

#include "FC_StreamRouter_clienthandler_DiaglogMic.h"

#include "../FC_StreamRouter_trace_def.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_CLIENTHANDLER_DIAGLOG
#include "trcGenProj/Header/FC_StreamRouter_clienthandler_DiaglogMic.cpp.trc.h"
#endif


/*******************************************************************************
                  Specific defines for this component
*******************************************************************************/
// Local defines for the wanted version of the CCX_DMSVR_FI
#define DIAGLOG_FI_MAJOR_VERSION  1 //MIDW_CCX_DMSRVFI_C_U16_SERVICE_MAJORVERSION
#define DIAGLOG_FI_MINOR_VERSION  0 //MIDW_CCX_DMSRVFI_C_U16_SERVICE_MINORVERSION

#define WAIT_AFTER_GPIO_SET     50  //Wait 50 mSec after set the GPIOs and before read the next ADC Value



/*******************************************************************************
                  Message map for FunctionIDs to be handled
*******************************************************************************/

/* Message map for FunctionIds (FIDs) which are handled by this clienthandler */
BEGIN_MSG_MAP(fc_streamrouter_tclClientHandler_diaglogMic, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA( MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT          , AMT_C_U8_CCAMSG_OPCODE_METHODRESULT     , vHandle_savetestresult_methodresult )
   ON_MESSAGE_SVCDATA( MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT      , AMT_C_U8_CCAMSG_OPCODE_STATUS           , vHandle_sendnexttestresult_status  )
END_MSG_MAP()


/*******************************************************************************
                  Methods of class
*******************************************************************************/

/*******************************************************************************
**  FUNCTION:
*   fc_streamrouter_tclClientHandler_diaglogMic(fc_streamrouter_tclApp* pMainAppl);
*   Constructor
*******************************************************************************/
fc_streamrouter_tclClientHandler_diaglogMic::fc_streamrouter_tclClientHandler_diaglogMic(
   fc_streamrouter_tclApp* pMainAppl)
   : ahl_tclBaseOneThreadClientHandler( pMainAppl      // Main App Pointer
              , CCA_C_U16_SRV_DIAGLOG         // Service Id
              , DIAGLOG_FI_MAJOR_VERSION      // MajorVersion of Service
              , DIAGLOG_FI_MINOR_VERSION )    // MinorVersion of Service
{
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): ENTERED"));

  /* Add automated Upreg/RelUpreg handling for dedicated properties */
  vAddAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);

  // Note: A single 'GET' request works without 'vAddAutoRegisterForProperty(.)'
  // Initialization of member variables
  if (pMainAppl != NULL)
  {
    m_pConfigMic = pMainAppl->m_poConfigMic;
  }else
  {
    m_pConfigMic = NULL;
    ETG_TRACE_ERR(("fc_streamrouter_tclClientHandler_diaglogMic => ERROR: fc_streamrouter Config Mic pointer is NULL"));
  }

  bExecuteDiagnosticTestMic1 = FALSE;
  bExecuteDiagnosticTestMic2 = FALSE;
  bExistTestDataToSend = FALSE;

  bStart = TRUE;

    bMic1GpiosSetBack = TRUE;
    bMic2GpiosSetBack = TRUE;

#ifdef READ_ADC_REFVOL_FROM_KDS
  tU32 u32MicADCrefV = u32ReadADCRefVfromKDS(); //Read ADC Reference Voltage from KDS
#else
  tU32 u32MicADCrefV = MIC_ADC_REFVOL_DEFAULT;
#endif

  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => ADC reference Voltage = %d mV", u32MicADCrefV));

  //u32MicShortGroundPlusMin    =  0;
  u32MicShortGroundPlusMax  =  (tU32)(500.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicShortGroundMinusMin  =  (tU32)(1870.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicShortGroundMinusMax  =  (tU32)(2400.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicNormalMin          =  (tU32)(2100.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicNormalMax          =  (tU32)(2540.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicOpenCircuitMin    =  (tU32)(2790.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicOpenCircuitMax    =  (tU32)(3120.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicShortUBATMin      =  (tU32)(3130.0 / u32MicADCrefV * MAX_ADC_VALUE);
  u32MicShortUBATMax      =  (tU32)(MAX_ADC_VALUE);

  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_ground_plus_max = %d ADC Steps", u32MicShortGroundPlusMax));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_ground_minus_min = %d ADC Steps", u32MicShortGroundMinusMin));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_ground_minus_max = %d ADC Steps", u32MicShortGroundMinusMax));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_normal_min = %d ADC Steps", u32MicNormalMin));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_normal_max = %d ADC Steps", u32MicNormalMax));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_open_circuit_min = %d ADC Steps", u32MicOpenCircuitMin));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_open_circuit_max = %d ADC Steps", u32MicOpenCircuitMax));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_UBAT_min = %d ADC Steps", u32MicShortUBATMin));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_UBAT_max = %d ADC Steps", u32MicShortUBATMax));

}

/*******************************************************************************
** FUNCTION:   virtual ~fc_streamrouter_tclClientHandler_diaglogMic();
*  Destructor
*******************************************************************************/
fc_streamrouter_tclClientHandler_diaglogMic
      ::~fc_streamrouter_tclClientHandler_diaglogMic(tVoid)
{
  m_pConfigMic = NULL;

}


/*******************************************************************************
** FUNCTION:   virtual tVoid vOnServiceAvailable();
*******************************************************************************/
/* virtual */
// Overrides 'tVoid ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable()'
tVoid fc_streamrouter_tclClientHandler_diaglogMic::vOnServiceAvailable()
{
     //only at the beginning of the application if the service is available has to send the TestResult to the diagnosis
   if (bStart)
   {
     ETG_TRACE_USR1(( "vOnServiceAvailable: Service of AppID= %u became available.",
            u16GetServerAppID() ));

     //only if the mic1 EOL configuration is Phantom Voltage has to make the diagnostic test for Mic1
     if (  m_pConfigMic != NULL)
     {
       if (m_pConfigMic->u8GetMic1cfg() != STR_EOL_MIC_ANALOG_BALANCED_PHANTOMVOLTAGE)
       {
           ETG_TRACE_USR4(("MICROPHONE_1_CONFIG is not Phantom Voltage => No test is runing"));
         bExecuteDiagnosticTestMic1 = FALSE;
       }
       else
       {

        bExecuteDiagnosticTestMic1 = TRUE;
        //calculate the testresult for Mic1 diagnostic
        vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC1_SHORT_2_GND);
                vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC1_OPEN_CIRC);

                //GPIOS set back appropriate the EOL Values
                if (bMic1GpiosSetBack)
                {
                    ETG_TRACE_USR4(("Set the GPIOs for Mic1 back after the Diagnostic test (only if Mic1 is NOT OPEN or UBAT)"));

                    if(m_pConfigMic->bConfigureMic1(m_pConfigMic->mic1cfg, m_pConfigMic->mic2cfg) != true)
                    {
                        ETG_TRACE_ERR(("DiaglogMic ERR: Unable to set EOL gpio configuration for Mic1!"));
                    }
                }
                else
                {
                    ETG_TRACE_USR4(("Not set the GPIOs for Mic1 back after the Diagnostic test because Mic1 is OPEN or UBAT"));
                    bMic1GpiosSetBack = TRUE;
                }
       }

      //only if the mic2 EOL configuration is Phantom Voltage has to make the diagnostic test for Mic2
       if (m_pConfigMic->u8GetMic2cfg() != STR_EOL_MIC_ANALOG_BALANCED_PHANTOMVOLTAGE)
       {
         ETG_TRACE_USR4(("MICROPHONE_2_CONFIG is not Phantom Voltage => No test is runing"));
         bExecuteDiagnosticTestMic2 = FALSE;
       }
       else
       {
        bExecuteDiagnosticTestMic2 = TRUE;
        //calculate the testresult for Mic2 diagnostic
                vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC2_SHORT_2_GND);
                vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC2_OPEN_CIRC);

                //GPIOS set back appropriate the EOL Values
                if (bMic2GpiosSetBack)
                {
                    ETG_TRACE_USR4(("Set the GPIOs for Mic2 back after the Diagnostic test (only if Mic2 is NOT OPEN or UBAT)"));

                    if(m_pConfigMic->bConfigureMic2(m_pConfigMic->mic2cfg, m_pConfigMic->mic1cfg) != true)
                    {
                        ETG_TRACE_ERR(("DiaglogMic ERR: Unable to set EOL gpio configuration for Mic2!"));
                    }
                }
                else
                {
                    ETG_TRACE_USR4(("Not set the GPIOs for Mic2 back after the Diagnostic test because Mic2 is OPEN or UBAT"));
                    bMic2GpiosSetBack = TRUE;
                }
        }
     }

     if (bExecuteDiagnosticTestMic1 || bExecuteDiagnosticTestMic2)
     {
      //send all testresult to diaglog (only one cca message for all the results)
      vSendTestResultToDiaglog();
     }

     bStart = FALSE;
   }
}


/*******************************************************************************
** FUNCTION:   virtual tVoid vOnServiceUnavailable();
*******************************************************************************/
/* virtual */
// Overrides 'tVoid ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable()'
tVoid fc_streamrouter_tclClientHandler_diaglogMic::vOnServiceUnavailable()
{
   ETG_TRACE_USR1(( "vOnServiceUnavailable: Service of AppID= %u became unavailable.",
                    u16GetServerAppID() ));
}


/*******************************************************************************
                  Handler functions for FI messages
*******************************************************************************/

/*******************************************************************************
** FUNCTION:   vHandle_savetestresult_methodresult(amt_tclServiceData* poMessage)
*******************************************************************************/

tVoid fc_streamrouter_tclClientHandler_diaglogMic
      ::vHandle_savetestresult_methodresult(amt_tclServiceData* poMessage)
{
   // Create a FI visitor message for the received CCA message
   fi_tclVisitorMessage oResultMsg( poMessage );

   // Create the (message related) FI data object
   midw_diaglogfi_tclMsgSaveTestResultMethodResult oResultData;

   if (oResultMsg.s32GetData(oResultData) != OSAL_ERROR)
   {

     // if control setting accepted, composing positive response
     if (oResultData.Status.enType == midw_fi_tcl_e8_MethodResultReply::FI_EN_ACCEPTED)
     {
       ETG_TRACE_USR4(("vHandle_savetestresult_methodresult(): Accepted"));
     }
     else // test result rejected, composing negative response
     {
       ETG_TRACE_USR4(("vHandle_savetestresult_methodresult(): Rejected"));
     }
   }

   // Always destroy the FI data object before leaving its creation scope
   oResultData.vDestroy();
}


/*******************************************************************************
** FUNCTION:   vHandle_sendnexttestresult_status(..) property
*******************************************************************************/

tVoid fc_streamrouter_tclClientHandler_diaglogMic
      ::vHandle_sendnexttestresult_status(amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_ground_plus_max = %d ADC Steps", u32MicShortGroundPlusMax));
    ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_ground_minus_min = %d ADC Steps", u32MicShortGroundMinusMin));
    ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_ground_minus_max = %d ADC Steps", u32MicShortGroundMinusMax));
    ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_normal_min = %d ADC Steps", u32MicNormalMin));
    ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_normal_max = %d ADC Steps", u32MicNormalMax));
    ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_open_circuit_min = %d ADC Steps", u32MicOpenCircuitMin));
    ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_open_circuit_max = %d ADC Steps", u32MicOpenCircuitMax));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_UBAT_min = %d ADC Steps", u32MicShortUBATMin));
  ETG_TRACE_USR4(("fc_streamrouter_tclClientHandler_diaglogMic(): => mic_short_UBAT_max = %d ADC Steps", u32MicShortUBATMax));
  /* Die obere Traces knnen auch spter weg */

    if(m_pConfigMic == NULL)
    {
      ETG_TRACE_FATAL(("fc_streamrouter_tclClientHandler_diaglogMic(): m_pConfigMic == NULL"));
      return;
    }
   // Create a FI visitor message for the received CCA message
   fi_tclVisitorMessage oVisitorMsg( poMessage );

   // Create the (message related) FI data object
   midw_diaglogfi_tclMsgSendNextTestResultStatus oFiDataObject;

   // Unmarshal the FI visitor message to the given FI data object. (The para-
   // meters are copied individually from shared memory to the FI data object.)
   if (oVisitorMsg.s32GetData(oFiDataObject) != OSAL_ERROR)
   {
      // Extract details from the FI data object
    //midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct;
    /*
    NextTestResultStruct.Status = True if
    client is required to send next test result to DiagLog.
    NextTestResultStruct.ITCList: This is the list of the
    DTCs for which the next test result has to be sent. if the
    List is empty and "NextTestResultStruct.Status == True"
    then the client should report all the DTCs for which he is
    reponsible.
    */

    if (oFiDataObject.NextTestResultStruct.Status == TRUE)
    {
      if (oFiDataObject.NextTestResultStruct.ITCList.empty())
      {
        //calculate the testresult for Mic1 diagnostic
        vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC1_SHORT_2_GND);
        vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC1_OPEN_CIRC);

        //calculate the testresult for Mic2 diagnostic
        vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC2_SHORT_2_GND);
        vCalculateTestResult(VDL_ITC_GMG2_FC_STREAMROUTER_MIC2_OPEN_CIRC);

        //send all testresult to diaglog (only one cca message for all the results)
        vSendTestResultToDiaglog();
      }
      else
      {
        for(tU16 i=0; i < oFiDataObject.NextTestResultStruct.ITCList.size(); i++)
        {
          vCalculateTestResult(oFiDataObject.NextTestResultStruct.ITCList[i]);
        }
        if (oFiDataObject.NextTestResultStruct.ITCList.size() != 0)
        {


          //send all testresult to diaglog (only one cca message for all the results)
          vSendTestResultToDiaglog();
        }
      }

            //GPIOS for Mic1 set back appropriate the EOL Values
            if (bMic1GpiosSetBack)
            {
                ETG_TRACE_USR4(("Set the GPIOs for Mic1 back after the Diagnostic test (only if Mic1 is NOT OPEN or UBAT)"));

                if(m_pConfigMic->bConfigureMic1(m_pConfigMic->mic1cfg, m_pConfigMic->mic2cfg) != true)
                {
                    ETG_TRACE_ERR(("DiaglogMic ERR: Unable to set EOL gpio configuration for Mic1!"));
                }
            }
            else
            {
                ETG_TRACE_USR4(("Not set the GPIOs for Mic1 back after the Diagnostic test because Mic1 is OPEN or UBAT"));
                bMic1GpiosSetBack = TRUE;
            }

            //GPIOS for Mic2 set back appropriate the EOL Values
            if (bMic2GpiosSetBack)
            {
                ETG_TRACE_USR4(("Set the GPIOs for Mic2 back after the Diagnostic test (only if Mic2 is NOT OPEN or UBAT)"));

                if(m_pConfigMic->bConfigureMic2(m_pConfigMic->mic2cfg, m_pConfigMic->mic1cfg) != true)
                {
                    ETG_TRACE_ERR(("DiaglogMic ERR: Unable to set EOL gpio configuration for Mic2!"));
                }
            }
            else
            {
                ETG_TRACE_USR4(("Not set the GPIOs for Mic2 back after the Diagnostic test because Mic2 is OPEN or UBAT"));
                bMic2GpiosSetBack = TRUE;
            }


    }// Status = false if this is a confirmation message from the Diaglog that the
     //UpReg has been succesful -> Do nothing


   }
   else
   {
      ETG_TRACE_ERR(( "vHandle_SetElapsedTimerRunmode_MethodResultLast: Received message invalid." ));
   }

   // Always destroy the FI data object before leaving its creation scope
   oFiDataObject.vDestroy();

}

/*******************************************************************************
                  Specific functions of this application
*******************************************************************************/


/*******************************************************************************
** FUNCTION:   tVoid vCalculateTestResult();
* Calculate the result of Mic and call the vCallSaveTestResult function
*******************************************************************************/

tVoid fc_streamrouter_tclClientHandler_diaglogMic::vCalculateTestResult(tU16 tU16Mic)
{
  tBool bResult = TRUE, bRet = TRUE;
  tBool bSave = FALSE;
  tU32 u32ADCValue;


  switch (tU16Mic)
  {
    //****************** MIC 1 SHORT TO GND TEST ****************************//
    case VDL_ITC_GMG2_FC_STREAMROUTER_MIC1_SHORT_2_GND:
    {
      if (bExecuteDiagnosticTestMic1)
      {
        ETG_TRACE_USR4(("MICROPHONE_1_CONFIG = Analog Balanced Phantom Voltage => test is runing"));
        ETG_TRACE_USR4(("Diagnosis Test for MIC1 Short to Ground+"));

        //For Short to Ground+
        //Set GPIOs like the "Micro Diagnose Zustnde.xls" Table
        if (m_pConfigMic != NULL)
        {
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_SELECT_CTRL);
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_DIAG1_ENABLE);
        }
                //Wait after set the GPIOs and before read the next ADC Value (otherwise is the value not ok)
                OSAL_s32ThreadWait(WAIT_AFTER_GPIO_SET);

                // Read ADCValue
        bRet = bReadMicADCMidValue(MIC1, &u32ADCValue);
        if (bRet)
        {
          if (u32ADCValue <= u32MicShortGroundPlusMax) //Short to Ground+
          {
            bResult = FALSE;
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC1 is Short to Ground+"));
            //if short to Ground+ => no seting of GPIOs is needed
          }
          else //NOT Short to Ground+
          {
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC1 is not Short to Ground+"));
            if ( (u32ADCValue >= u32MicOpenCircuitMin) && (u32ADCValue <= u32MicOpenCircuitMax) ) //Open Circuit
            {

                            ETG_TRACE_USR4(("Diagnosis Test: MIC1 is open => Set GPIOs"));
              //Hier muss ich eigentlich im Fall dass der Zustand "open" oder "short to UBAT" ist, wegen Schnung der Eigangsschaltung
              //das GPIO auf LOW setzen, mache ich aber nicht, da ich sofort hiernach die Prfung auf
              //"Short to Ground-" mache und dafr als erstes sowieso das GPIO auf LOW setze.

              //OPEN => GPIO auf LOW setzen
              /*
              if (m_pConfigMic != NULL)
              {
                m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG1_ENABLE);
              }
              */
              bMic1GpiosSetBack = FALSE;
            }
                        if ( (u32ADCValue >= u32MicShortUBATMin) && (u32ADCValue <= u32MicShortUBATMax) ) //Short to UBAT
                        {
                            ETG_TRACE_USR4(("Diagnosis Test: MIC1 is Short to UBAT => Set GPIOs"));
              //Short to UBAT => GPIO auf LOW setzen
              /*
              if (m_pConfigMic != NULL)
              {
                m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG1_ENABLE);
              }
              */
              bMic1GpiosSetBack = FALSE;
            }
          }
          //Save the Results
          bSave = TRUE;
        }
        else
        {
          //ETG_TRACE_USR4(("bCalculateTestResult(): Cant detect Microphone ADCvalue"));
                    ;//TODO Test wiederholen bis es klappt???
        }

        //For "Short to Ground-" checking
        if (bResult) //this means that the Mic is not "Short to Ground+" therefore check if it is "Short to Ground-"
        {
          ETG_TRACE_USR4(("Mic1 is not Short to Ground+ therefore Diagnosis Test for Short to Ground-"));
          //Set GPIOs like the "Micro Diagnose Zustnde.xls" Table
          if (m_pConfigMic != NULL)
          {
            m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_SELECT_CTRL); //this is not necessary, because is seting before.
            m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG1_ENABLE);
          }

                    //Wait after set the GPIOs and before read the next ADC Value (otherwise is the value not ok)
                    OSAL_s32ThreadWait(WAIT_AFTER_GPIO_SET);

                    // Read ADCValue
          bRet = bReadMicADCMidValue(MIC1, &u32ADCValue);
          if (bRet)
          {
            if ( (u32ADCValue >= u32MicShortGroundMinusMin) && (u32ADCValue <= u32MicShortGroundMinusMax) ) //Short to Ground-
            {
              bResult = FALSE;
              ETG_TRACE_USR4(("Diagnosis Test Result: MIC1 is Short to Ground-"));
              //if short to Ground- => no seting of GPIOs is needed
            }
            else //NOT Short to Ground-
            {
              ETG_TRACE_USR4(("Diagnosis Test Result: MIC1 is not Short to Ground-"));
            }
            //Save the Results
            bSave = TRUE;
          }
          else
          {
            //ETG_TRACE_USR4(("bCalculateTestResult(): Cant detect Microphone ADCvalue"));
                        ;//TODO Test wiederholen bis es klappt???
          }
        }//if (bResult)
      }//(bExecuteDiagnosticTestMic1)
      else
      {
        ETG_TRACE_USR4(("MICROPHONE_1_CONFIG is not Phantom Voltage => No test is runing"));
      }
    }
    break;

        //****************** MIC 1 OPEN CIRCUIT TEST ****************************//
    case VDL_ITC_GMG2_FC_STREAMROUTER_MIC1_OPEN_CIRC:
    {
      if (bExecuteDiagnosticTestMic1)
      {
        ETG_TRACE_USR4(("MICROPHONE_1_CONFIG = Analog Balanced Phantom Voltage => test is runing"));
        ETG_TRACE_USR4(("Diagnosis Test for MIC1 Open Circuit"));

        //Set GPIOs like the "Micro Diagnose Zustnde.xls" Table
        if (m_pConfigMic != NULL)
        {
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_SELECT_CTRL);
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_DIAG1_ENABLE);
        }

                //Wait after set the GPIOs and before read the next ADC Value (otherwise is the value not ok)
                OSAL_s32ThreadWait(WAIT_AFTER_GPIO_SET);

        // Read ADCValue
        bRet = bReadMicADCMidValue(MIC1, &u32ADCValue);
        if (bRet)
        {
          if ( (u32ADCValue >= u32MicOpenCircuitMin) && (u32ADCValue <= u32MicOpenCircuitMax) ) //Open Circuit
          {
            bResult = FALSE;
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC1 is Open Circuit => Set GPIOs"));
            //if OpenCircuit => Set GPIOs like the "Micro Diagnose Zustnde.xls" Table,
            //for the protection of the circuit
            if (m_pConfigMic != NULL)
            {
              m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG1_ENABLE);
            }
              bMic1GpiosSetBack = FALSE;

          }
          else //NOT Open Circuit
          {
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC1 is not Open Circuit"));
                        //Ich prfe ob der MIC Zustand auf "Short to UBAT" ist und setze das GPIO auf Low
                        //nur wegen der Schonung der Eingangsschaltung.
                        if ( (u32ADCValue >= u32MicShortUBATMin) && (u32ADCValue <= u32MicShortUBATMax) ) //Short to UBAT
                        {
                            ETG_TRACE_USR4(("Diagnosis Test: MIC1 is Short to UBAT => Set GPIOs"));
                            //if "Short to UBAT" => Set GPIOs like the "Micro Diagnose Zustnde.xls" Table,
                            //for the protection of the circuit
                            if (m_pConfigMic != NULL)
                            {
                                m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG1_ENABLE);
                            }
              bMic1GpiosSetBack = FALSE;
                        }

          }
          //Save the Results
          bSave = TRUE;
        }
        else
        {
          //ETG_TRACE_USR4(("bCalculateTestResult(): Cant detect Microphone ADCvalue"));
                    ;//TODO Test wiederholen bis es klappt???
        }
      }
      else
      {
        ETG_TRACE_USR4(("MICROPHONE_1_CONFIG is not Phantom Voltage => No test is runing"));
      }
    }
    break;

        //****************** MIC 2 SHORT TO GND TEST ****************************//
    case VDL_ITC_GMG2_FC_STREAMROUTER_MIC2_SHORT_2_GND:
    {
      if (bExecuteDiagnosticTestMic2)
      {
        ETG_TRACE_USR4(("MICROPHONE_2_CONFIG = Analog Balanced Phantom Voltage => test is runing"));
        ETG_TRACE_USR4(("Diagnosis Test for MIC2 Short to Ground+"));

        //For Short to Ground+
        //Set GPIOs like the "Micro Diagnose Zustnde.xls" Table
        if (m_pConfigMic != NULL)
        {
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_SELECT_CTRL);
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_DIAG2_ENABLE);
        }

                //Wait after set the GPIOs and before read the next ADC Value (otherwise is the value not ok)
                OSAL_s32ThreadWait(WAIT_AFTER_GPIO_SET);

        // Read ADCValue
        bRet = bReadMicADCMidValue(MIC2, &u32ADCValue);
        if (bRet)
        {
          if (u32ADCValue <= u32MicShortGroundPlusMax) //Short to Ground+
          {
            bResult = FALSE;
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC2 is Short to Ground+"));
            //if short to Ground+ => no seting of GPIOs is needed
          }
          else //NOT Short to Ground+
          {
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC2 is not Short to Ground+"));
            if ( (u32ADCValue >= u32MicOpenCircuitMin) && (u32ADCValue <= u32MicOpenCircuitMax) ) //Open Circuit
            {
                            ETG_TRACE_USR4(("Diagnosis Test: MIC2 is Open => Set GPIOs"));
              //Hier muss ich eigentlich im Fall dass der Zustand "open" oder "short to UBAT" ist, wegen Schnung der Eigangsschaltung
              //das GPIO auf LOW setzen, mache ich aber nicht, da ich sofort hiernach die Prfung auf
              //"Short to Ground-" mache und dafr als erstes sowieso das GPIO auf LOW setze.

              //OPEN => GPIO auf LOW setzen
              /*
              if (m_pConfigMic != NULL)
              {
                m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG2_ENABLE);
              }
              */
              bMic2GpiosSetBack = FALSE;
            }
                        if ( (u32ADCValue >= u32MicShortUBATMin) && (u32ADCValue <= u32MicShortUBATMax) ) //Short to UBAT
                        {
                            ETG_TRACE_USR4(("Diagnosis Test: MIC2 is Short to UBAT => Set GPIOs"));
              //Short to UBAT => GPIO auf LOW setzen
              /*
              if (m_pConfigMic != NULL)
              {
                m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG2_ENABLE);
              }
              */
              bMic2GpiosSetBack = FALSE;
            }
          }
          //Save the Results
          bSave = TRUE;
        }
        else
        {
          //ETG_TRACE_USR4(("bCalculateTestResult(): Cant detect Microphone ADCvalue"));
          ;//TODO Test wiederholen bis es klappt???
        }

        //For "Short to Ground-" checking
        if (bResult) //this means that the Mic is not "Short to Ground+" therefore check if it is "Short to Ground-"
        {
          ETG_TRACE_USR4(("Mic2 is not Short to Ground+ therefore Diagnosis Test for Short to Ground-"));
          //Set GPIOs like the "Micro Diagnose Zustnde.xls" Table
          if (m_pConfigMic != NULL)
          {
            m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_SELECT_CTRL); //this is not necessary, because is seting before.
            m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG2_ENABLE);
          }

                    //Wait after set the GPIOs and before read the next ADC Value (otherwise is the value not ok)
                    OSAL_s32ThreadWait(WAIT_AFTER_GPIO_SET);

          // Read ADCValue
          bRet = bReadMicADCMidValue(MIC2, &u32ADCValue);
          if (bRet)
          {
            if ( (u32ADCValue >= u32MicShortGroundMinusMin) && (u32ADCValue <= u32MicShortGroundMinusMax) ) //Short to Ground-
            {
              bResult = FALSE;
              ETG_TRACE_USR4(("Diagnosis Test Result: MIC2 is Short to Ground-"));
              //if short to Ground- => no seting of GPIOs is needed
            }
            else
            {
              ETG_TRACE_USR4(("Diagnosis Test Result: MIC2 is not Short to Ground-"));
            }
            //Save the Results
            bSave = TRUE;
          }
          else //NOT Short to Ground-
          {
            //ETG_TRACE_USR4(("bCalculateTestResult(): Cant detect Microphone ADCvalue"));
            ;//TODO Test wiederholen bis es klappt???
          }
        }//if (bResult)
      }//(bExecuteDiagnosticTestMic1)
      else
      {
        ETG_TRACE_USR4(("MICROPHONE_2_CONFIG is not Phantom Voltage => No test is runing"));
      }
    }
    break;

        //****************** MIC 2 OPEN CIRCUIT TEST ****************************//
    case VDL_ITC_GMG2_FC_STREAMROUTER_MIC2_OPEN_CIRC:
    {
      if (bExecuteDiagnosticTestMic2)
      {
        ETG_TRACE_USR4(("MICROPHONE_2_CONFIG = Analog Balanced Phantom Voltage => test is runing"));
        ETG_TRACE_USR4(("Diagnosis Test for MIC2 Open Circuit"));

        //Set GPIOs like the "Micro Diagnose Zustnde.xls" Table
        if (m_pConfigMic != NULL)
        {
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_SELECT_CTRL);
          m_pConfigMic->vSetGPIO((tBool)(TRUE),OSAL_EN_MIC_DIAG2_ENABLE);
        }
                //Wait after set the GPIOs and before read the next ADC Value (otherwise is the value not ok)
                OSAL_s32ThreadWait(WAIT_AFTER_GPIO_SET);

        // Read ADCValue
        bRet = bReadMicADCMidValue(MIC2, &u32ADCValue);
        if (bRet)
        {
          if ( (u32ADCValue >= u32MicOpenCircuitMin) && (u32ADCValue <= u32MicOpenCircuitMax) ) //Open Circuit
          {
            bResult = FALSE;
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC2 is Open Circuit => Set GPIOs"));
            //if OpenCircuit => Set GPIOs like the "Micro Diagnose Zustnde.xls" Table,
            //for the protection of the circuit
            if (m_pConfigMic != NULL)
            {
              m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG2_ENABLE);
            }
            bMic2GpiosSetBack = FALSE;
          }
          else //NOT Open Circuit
          {
            ETG_TRACE_USR4(("Diagnosis Test Result: MIC2 is not Open Circuit"));
                       //Ich prfe ob der MIC Zustand auf "Short to UBAT" ist und setze das GPIO auf Low
                        //nur wegen der Schonung der Eingangsschaltung.
                        if ( (u32ADCValue >= u32MicShortUBATMin) && (u32ADCValue <= u32MicShortUBATMax) ) //Short to UBAT
                        {
                            ETG_TRACE_USR4(("Diagnosis Test: MIC2 is Short to UBAT => Set GPIOs"));
                            //if "Short to UBAT" => Set GPIOs like the "Micro Diagnose Zustnde.xls" Table,
                            //for the protection of the circuit
                            if (m_pConfigMic != NULL)
                            {
                                m_pConfigMic->vSetGPIO((tBool)(FALSE),OSAL_EN_MIC_DIAG2_ENABLE);
                            }
              bMic2GpiosSetBack = FALSE;
                        }
          }
          //Save the Results
          bSave = TRUE;
        }
        else
        {
          //ETG_TRACE_USR4(("bCalculateTestResult(): Cant detect Microphone ADCvalue"));
          ;//TODO Test wiederholen bis es klappt???
        }
      }
      else
      {
        ETG_TRACE_USR4(("MICROPHONE_2_CONFIG is not Phantom Voltage => No test is runing"));
      }
    }
    break;

    default:
    {
      ETG_TRACE_ERR(("bCalculateTestResult():=> unknow TroubleCode = %d", tU16Mic ));
    }
    break;

  }


  if (bSave)
  {
    vSaveTestResult(tU16Mic, bResult);
  }

    return;

}



/*******************************************************************************
** FUNCTION:   tVoid vSaveTestResult();
* Save the Test Results to the CCA Msg for later sending to Diaglog
*******************************************************************************/

tVoid fc_streamrouter_tclClientHandler_diaglogMic::vSaveTestResult(tU16 u16TroubleCode, tBool bResult)
{
  midw_fi_tcl_TestResult oTestData;
  // Set the parameters of the FI data object

  oTestData.TroubleCode = u16TroubleCode;

  if (bResult)
  {
    oTestData.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
    ETG_TRACE_USR4(("vSaveTestResult():=> Diagnosis Test Result = PASSED"));

  }
  else
  {
        oTestData.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
    ETG_TRACE_USR4(("vSaveTestResult():=> Diagnosis Test Result = FAILED"));
  }

  //add the testData to the TestResultList
  oFiTestResultObject.TestResultList.TestResultList.push_back(oTestData);
  bExistTestDataToSend = TRUE;
}


/*******************************************************************************
** FUNCTION:   tVoid vSendTestResultToDiaglog();
* Send all the Test Results to Diaglog (1 CCA Msg for all results together)  (Method of this application)
*******************************************************************************/

tVoid fc_streamrouter_tclClientHandler_diaglogMic::vSendTestResultToDiaglog(tVoid)
{
  if (bExistTestDataToSend)
  {
    ETG_TRACE_USR4(("vSendTestResultToDiaglog(): => exist Testresult to send to diaglog"));
    // Check if Service of server is available
    if( bIfServiceAvailable() )
    {
      // ------------ SAVETESTRESULT - METHODSTART: begin ---------------
      bExistTestDataToSend = FALSE;

         //put the oFiDataObject into MethodStart message
      // Create FI VisitorMessage. (The FI data object will be streamed (each
      // parameter is copied individually) to shared memory.)
      fi_tclVisitorMessage oMsg(oFiTestResultObject);

      // Always destroy the FI data object before leaving its creation scope
      oFiTestResultObject.vDestroy();

      // Here the message related header information is added and by this the
      // creation of the message is completed.
      vInitServiceData( oMsg,                             // ServiceDataMsg
        0,                                             // CmdCounter
        MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT,           // Function ID
        AMT_C_U8_CCAMSG_OPCODE_METHODSTART             // Opcode
      );

      // Post message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR)
      {
        // Posting of message has failed.
        // NOTE:  It is NOT necessary to call 'oMsg2.bDelete()' here as the
        // parameter 'TRUE' in "enPostMessage(&oMsg, TRUE)" will take care that
        // the message is deleted in a case of an error.
        ETG_TRACE_ERR(( "vCallSaveTestResult(): enPostMessage() failed for 'SAVETESTRESULT - METHODSTART'"));
      }

      // ------------ SAVETESTRESULT - METHODSTART: end -----------------

      bExistTestDataToSend = FALSE;

      ETG_TRACE_USR4(("vSendTestResultToDiaglog(): => SAVETESTRESULT Methodstart message is sended"));

    }  // end: if( bIfServiceAvailable() )
    else
    {
      // Always destroy the FI data object before leaving its creation scope
      oFiTestResultObject.vDestroy();
      ETG_TRACE_USR4(("vSendTestResultToDiaglog(): => No Service available (not send SAVETESTRESULT Methodstart message)"));
    }
  }
  else
  {
    ETG_TRACE_USR4(("vSendTestResultToDiaglog(): => NO exist Testresult to send to diaglog"));
  }


}

/*******************************************************************************
** FUNCTION:   tVoid vCallSaveTestResult();
* Send the Test Results to Diaglog , for each result one CCA Msg.
* Diese Funktion ist als erste entstanden und ist nur fr Testzwecke da
*******************************************************************************/
/*
tVoid fc_streamrouter_tclClientHandler_diaglogMic::vCallSaveTestResult(tU16 u16TroubleCode, tBool bResult)
{

   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
    // ------------ SAVETESTRESULT - METHODSTART: begin ---------------
    // Create the (message related) FI data object
    midw_diaglogfi_tclMsgSaveTestResultMethodStart oFiDataObject;
    midw_fi_tcl_TestResult oTestData;
    // Set the parameters of the FI data object

    oTestData.TroubleCode = u16TroubleCode;

    if (bResult)
    {
      oTestData.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
    }
    else
    {
          oTestData.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
    }

    //add the testData to the TestResultList
    oFiDataObject.TestResultList.TestResultList.push_back(oTestData);

       //put the oFiDataObject into MethodStart message
    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg(oFiDataObject);

    // Always destroy the FI data object before leaving its creation scope
    oFiDataObject.vDestroy();

    // Here the message related header information is added and by this the
    // creation of the message is completed.
    vInitServiceData( oMsg,                             // ServiceDataMsg
            0,                                             // CmdCounter
            MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT,           // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART             // Opcode
    );

    // Post message
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg, TRUE);

    if (enResult != AIL_EN_N_NO_ERROR)
    {
      // Posting of message has failed.
      // NOTE:  It is NOT necessary to call 'oMsg2.bDelete()' here as the
      // parameter 'TRUE' in "enPostMessage(&oMsg, TRUE)" will take care that
      // the message is deleted in a case of an error.
      ETG_TRACE_ERR(( "vCallSaveTestResult(): enPostMessage() failed for 'SAVETESTRESULT - METHODSTART'"));
    }

    // ------------ SAVETESTRESULT - METHODSTART: end -----------------

  }  // end: if( bIfServiceAvailable() )

}
*/
#endif

