/******************************************************************************
 * FILE        : ecnr-sse-handler.h
 * PROJECT     : Gen3 and Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2013 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 20.08.2013  | Patrick Rey            | initial version
 *             |                        | SSE 3.X engine feature handling
 * 08.03.2019  | Ranjit Susal(RBEI/ECO) | SSE 4.X engine feature handling
 *****************************************************************************/

#ifndef __ECNR_SSE_HANDLER_H__
#define __ECNR_SSE_HANDLER_H__

#include "ecnr-types.h"
#include "ecnr-configuration.h"

#define BUFFER_LENGTH                      8000 //2048
#define iRX_SOCKET_BUFFER_MAXSIZE          4000 //1792
#define iRX_RINGBUFFER_SIZE                (4 * iRX_SOCKET_BUFFER_MAXSIZE)
#define iTX_SOCKET_BUFFER_MAXSIZE          4000 //1792
#define iTX_RINGBUFFER_SIZE                (8 * iTX_SOCKET_BUFFER_MAXSIZE)
#define iINVALID_SOCKET                    -1
#define iIPPORT                            2012
#define iALLOW_ONLY_ONE_SOCKET_CONNECTION  1


extern      int ecnr_sse_handler_process_audio                  (   stecnr_alsa_state* pstate);
extern      int ecnr_sse_handler_process_audio_with_debug_data  (   stecnr_alsa_state* pstate);
extern      int ecnr_sse_handler_create                         (                 int  memOptLevel);

extern      int ecnr_sse_handler_get_data                       (const unsigned   int  DataID,
                                                                 const unsigned   int  iChannel,
                                                                       unsigned   int* pSize,
                                                                                 void* pData);

extern      int ecnr_sse_handler_set_data                        (const unsigned   int  DataID,
                                                                  const unsigned   int  iChannel,
                                                                        unsigned   int  iSize,
                                                                                  void* pData);

extern      int ecnr_sse_handler_create_session                  (      unsigned short  ConfigId);
extern      int ecnr_sse_handler_sse_create_instance             (void);
extern      int ecnr_sse_handler_reset                           (void);
extern      int ecnr_sse_handler_destroy                         (void);
extern      int ecnr_sse_handler_check_operating_mode            (void);

extern      int ecnr_sse_handler_initialize                      (const tecnrConfigData* pConfigData,
                                                                        unsigned  short  ConfigId);

extern      int ecnr_sse_handler_set_configuration                     (unsigned  short  ConfigId,
                                                                               gboolean  test);

extern gboolean ecnr_sse_handler_compare_version                   (int* version);
extern      int ecnr_sse_process_pending_req                       (void);


/* debug interface function definitions */
extern      int ecnr_sse_enable_debug_interface                    (void);
extern      int ecnr_sse_enable_debug_interface_auto               (void);
extern      int ecnr_sse_disable_debug_interface                   (void);
extern      int ecnr_sse_debug_interface_start_session             (void);
extern      int ecnr_sse_debug_interface_end_session               (void);
extern gboolean ecnr_sse_ist_debug_interface_Active                (void);

extern     void ecnr_sse_get_version                               (      unsigned   int*   pArrayLen,
                                                                    const            int**  pVersionArray,
                                                                    const           char**  pVersionString,
                                                                    const           char**  pVersionComment );


extern void* ecnr_sse_read_Debug_data(void);
extern int ecnr_sse_write_Debug_data(void* pTuneData);

extern gboolean ecnr_sse_set_debug_trigger_file                      (void);
extern gboolean ecnr_sse_remove_debug_trigger_file                   (void);
extern unsigned short ecnr_sse_get_current_config_id                 (void);




/* log, diagnose functions */
extern void ecnr_sse_handler_log_new_data_pool_info  (unsigned short  data_set_id,
                                                      const struct EcnrConfig *pdata);
extern void ecnr_sse_handler_performance_enable      (      gboolean  state);


extern gint ecnr_sse_handler_get_micin_count          (        guint* sse_mic_in_cnt);
extern gint ecnr_sse_handler_get_mic_proc_count       (        guint* sse_mic_proc_cnt);
extern gint ecnr_sse_handler_get_refin_count          (        guint* sse_ref_in_cnt);
extern gint ecnr_sse_handler_get_recvin_count         (        guint* sse_recv_in_cnt);
extern gint ecnr_sse_handler_get_frame_shift_in       (        guint* sse_frame_shift_in);
extern gint ecnr_sse_handler_get_frame_shift_out      (        guint* sse_frame_shift_out);
extern gint ecnr_sse_handler_get_recv_frame_shift_in  (        guint* sse_recv_frame_shift_in);
extern gint ecnr_sse_handler_get_recv_frame_shift_out (        guint* sse_recv_frame_shift_out);
extern gint ecnr_sse_handler_get_ref_frame_shift_in   (        guint* sse_ref_frame_shift_in);
extern gint ecnr_sse_handler_get_sample_rate_in       (        guint* sse_sample_rate_in);
extern gint ecnr_sse_handler_get_sample_rate_out      (        guint* sse_sample_rate_out);
extern gint ecnr_sse_handler_get_recv_sample_rate_in  (        guint* sse_recv_sample_rate_in);
extern gint ecnr_sse_handler_get_recv_sample_rate_out (        guint* sse_recv_sample_rate_out);
extern gint ecnr_sse_handler_get_ref_sample_rate_in   (        guint* sse_ref_sample_rate_in);
extern gint ecnr_sse_handler_get_audio_type_for_asr   (      guint32* psize,
                                                               gchar** pdata);
extern gint ecnr_sse_handler_get_op_mode              (       gint32* sse_op_mode);
extern gint ecnr_sse_handler_get_asr_mode             (        guint* sse_asr_mode);
extern int  ecnr_sse_handler_get_status_message       (         char* status_message);

extern int  ecnr_sse_handler_get_clip_stats           (          int  Channel
                                                       ,unsigned int  DataID
                                                       ,unsigned int* ClipFrames
                                                       ,unsigned int* ClipCount
                                                                ,int* MaxAmp
                                                                ,int* MinAmp);

extern int  ecnr_sse_handler_get_mic_in_clip_stats    (          int  Channel
                                                       ,unsigned int* ClipFrames
                                                       ,unsigned int* ClipCount
                                                                ,int* MaxAmp
                                                                ,int* MinAmp);

extern int  ecnr_sse_handler_get_ref_in_clip_stats    (          int  Channel
                                                       ,unsigned int* ClipFrames
                                                       ,unsigned int* ClipCount
                                                                ,int* MaxAmp
                                                                ,int* MinAmp);

extern int  ecnr_sse_handler_get_rcv_in_clip_stats    (          int  Channel
                                                       ,unsigned int* ClipFrames
                                                       ,unsigned int* ClipCount
                                                                ,int* MaxAmp
                                                                ,int* MinAmp);

extern int  ecnr_sse_handler_get_mic_out_clip_stats   (          int  Channel
                                                       ,unsigned int* ClipFrames
                                                       ,unsigned int* ClipCount
                                                                ,int* MaxAmp
                                                                ,int* MinAmp);

extern int  ecnr_sse_handler_get_rcv_out_clip_stats   (          int  Channel
                                                       ,unsigned int* ClipFrames
                                                       ,unsigned int* ClipCount
                                                                ,int* MaxAmp
                                                                ,int* MinAmp);

extern int  ecnr_sse_handler_get_config_data_crc      (          tI32* sse_config_data_crc);

extern int  ecnr_sse_handler_set_send_mute_switch     (       guchar  sse_send_mute_switch);
extern int  ecnr_sse_handler_set_send_gain_delta      (          int  sse_send_gain_delta_lvl);
extern int  ecnr_sse_handler_set_pass_through_mode    (       guchar  sse_pass_through_mode);
extern int  ecnr_sse_handler_set_nr_comb_floor        (          int  sse_nr_comb_floor);
extern int  ecnr_sse_handler_set_echo_cancellation    (       guchar  sse_aec_state);
extern int  ecnr_sse_handler_set_noise_reduction      (       guchar  sse_nr_state);

/* functional interface for engine configuration parameter set
 * for AA VOICE WB feature(actual hardware)
 */

extern int ecnr_sse_handler_set_config_aa_voice_wb_pre        (void);
extern int ecnr_sse_handler_set_config_aa_voice_wb_post       (void);

/* functional interface for SSE configuration parameter set for LSIM */

extern int ecnr_sse_handler_set_config_bt_phone_nb_lsim_pre   (void);
extern int ecnr_sse_handler_set_config_bt_phone_nb_lsim_post  (void);
extern int ecnr_sse_handler_set_config_bt_phone_wb_lsim_pre   (void);
extern int ecnr_sse_handler_set_config_bt_phone_wb_lsim_post  (void);
extern int ecnr_sse_handler_set_config_cp_phone_nb_lsim_pre   (void);
extern int ecnr_sse_handler_set_config_cp_phone_nb_lsim_post  (void);
extern int ecnr_sse_handler_set_config_cp_phone_wb_lsim_pre   (void);
extern int ecnr_sse_handler_set_config_cp_phone_wb_lsim_post  (void);
extern int ecnr_sse_handler_set_config_cp_voice_wb_lsim_pre   (void);
extern int ecnr_sse_handler_set_config_cp_voice_wb_lsim_post  (void);
extern int ecnr_sse_handler_set_config_aa_voice_wb_lsim_pre   (void);
extern int ecnr_sse_handler_set_config_aa_voice_wb_lsim_post  (void);
extern int ecnr_sse_handler_set_config_int_voice_wb_lsim_pre  (void);
extern int ecnr_sse_handler_set_config_int_voice_wb_lsim_post (void);



#endif /* __ECNR_SSE_HANDLER_H__ */

