/******************************************************************************
 * FILE        : ecnr-ringbuffer.h
 * PROJECT     : Gen3 and Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2013 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 14.10.2013  | Patrick Rey            | initial version
 *             |                        | ring buffer feature handling
 *****************************************************************************/



#ifndef __ECNR_RINGBUFFER_H__
#define __ECNR_RINGBUFFER_H__


typedef struct _sRingBuffer
{
   int iLength;
   int iReadIndex;
   int iWriteIndex;
   char * pcHead;
   //sem_t ring_sem;
}tsRingbuffer;


 int ecnr_ring_buffer_create       (tsRingbuffer ** ppsRingbuffer, unsigned int uiSize);

 int ecnr_ring_buffer_destroy      (tsRingbuffer ** ppsRingbuffer);

/* returns number of actually written bytes or ECNR_ERR_ALLOC for a failure */
 int ecnr_ring_buffer_data_insert  (tsRingbuffer * psRingbuffer, const char * pcData, int uiSize);

/* returns number of actually extracted bytes or ECNR_ERR_ALLOC for a failure */
 int ecnr_ring_buffer_data_extract (tsRingbuffer * psRingbuffer, char * pcData, int uiSize );



#endif /* __ECNR_RINGBUFFER_H__ */
