/******************************************************************************
 * FILE        : ecnr-qwa-rcs-handler.h
 * PROJECT     : Gen3
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2014 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 04.03.2014  | Patrick Rey            | initial version
 *             |                        | QWA RCS engine feature handling
 *****************************************************************************/

#ifndef __ECNR_QWA_RCS_HANDLER_H__
#define __ECNR_QWA_RCS_HANDLER_H__



extern      int    ecnr_qwa_rcs_handler_session_destroy                (void);
extern      int    ecnr_qwa_rcs_handler_session_create                 (void);
extern gboolean    ecnr_qwa_rcs_get_active_state                       (void);


/**** QWA RCS API  WRAPPER  *****************/

extern      int    ecnr_qwa_rcs_handler_audio_inject_create            (void);
extern      int    ecnr_qwa_rcs_handler_create                         (void);
extern      int    ecnr_qwa_rcs_handler_destroy                        (void);
extern      int    ecnr_qwa_rcs_handler_initialize                     (void);
extern     void    ecnr_qwa_rcs_handler_finalize                       (void);
extern      int    ecnr_qwa_rcs_handler_process_init                   (void);
extern      int    ecnr_qwa_rcs_handler_audio_inject_destroy           (void);
extern      int    ecnr_qwa_rcs_handler_process_audio_inject           (void);

extern      int    ecnr_qwa_rcs_handler_get_binary                     (            int  buffType
                                                                        ,unsigned  char* data
                                                                        ,unsigned short* pusBufSize);

extern      int    ecnr_qwa_rcs_handler_transfert_out_stream           (void);
extern      int    ecnr_qwa_rcs_handler_process_audio_with_debug_data  (int* restart);




#endif /* __ECNR_QWA_RCS_HANDLER_H__ */

